/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class UncaughtExceptionHandlers {
    private UncaughtExceptionHandlers() {
    }

    public static Thread.UncaughtExceptionHandler systemExit() {
        return new Exiter(Runtime.getRuntime());
    }

    @VisibleForTesting
    static final class Exiter
    implements Thread.UncaughtExceptionHandler {
        private static final Logger logger = Logger.getLogger(Exiter.class.getName());
        private final Runtime runtime;

        /*
         * WARNING - void declaration
         */
        Exiter(Runtime runtime) {
            void var1_1;
            this.runtime = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void uncaughtException(Thread t, Throwable e) {
            try {
                logger.log(Level.SEVERE, String.format(Locale.ROOT, "Caught an exception in %s.  Shutting down.", t), e);
                return;
            }
            catch (Throwable errorInLogging) {
                void var1_2;
                void var2_4;
                System.err.println(var2_4.getMessage());
                System.err.println(var1_2.getMessage());
                return;
            }
            finally {
                this.runtime.exit(1);
            }
        }
    }
}

