/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.InterruptibleTask;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ParametricNullness;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.RunnableFuture;

@ElementTypesAreNonnullByDefault
@GwtCompatible
class TrustedListenableFutureTask<V>
extends FluentFuture.TrustedFuture<V>
implements RunnableFuture<V> {
    private volatile InterruptibleTask<?> task;

    static <V> TrustedListenableFutureTask<V> create(AsyncCallable<V> callable) {
        AsyncCallable<V> asyncCallable;
        return new TrustedListenableFutureTask<V>(asyncCallable);
    }

    static <V> TrustedListenableFutureTask<V> create(Callable<V> callable) {
        Callable<V> callable2;
        return new TrustedListenableFutureTask<V>(callable2);
    }

    /*
     * WARNING - void declaration
     */
    static <V> TrustedListenableFutureTask<V> create(Runnable runnable, @ParametricNullness V result) {
        void var1_1;
        Runnable runnable2;
        return new TrustedListenableFutureTask<void>(Executors.callable(runnable2, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    TrustedListenableFutureTask(Callable<V> callable) {
        void var1_1;
        this.task = new TrustedFutureInterruptibleTask(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    TrustedListenableFutureTask(AsyncCallable<V> callable) {
        void var1_1;
        this.task = new TrustedFutureInterruptibleAsyncTask(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        InterruptibleTask<?> localTask = this.task;
        if (localTask != null) {
            void var1_1;
            var1_1.run();
        }
        this.task = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void afterDone() {
        InterruptibleTask<?> localTask;
        super.afterDone();
        if (this.wasInterrupted() && (localTask = this.task) != null) {
            void var1_1;
            var1_1.interruptTask();
        }
        this.task = null;
    }

    @Override
    protected String pendingToString() {
        InterruptibleTask<?> localTask = this.task;
        if (localTask != null) {
            String string;
            string = String.valueOf(string);
            return new StringBuilder(7 + String.valueOf(string).length()).append("task=[").append(string).append("]").toString();
        }
        return super.pendingToString();
    }

    private final class TrustedFutureInterruptibleAsyncTask
    extends InterruptibleTask<ListenableFuture<V>> {
        private final AsyncCallable<V> callable;

        /*
         * WARNING - void declaration
         */
        TrustedFutureInterruptibleAsyncTask(AsyncCallable<V> callable) {
            void var2_2;
            this.callable = (AsyncCallable)Preconditions.checkNotNull(var2_2);
        }

        @Override
        final boolean isDone() {
            return ((AbstractFuture)TrustedListenableFutureTask.this).isDone();
        }

        @Override
        final ListenableFuture<V> runInterruptibly() throws Exception {
            return Preconditions.checkNotNull(this.callable.call(), "AsyncCallable.call returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", this.callable);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void afterRanInterruptiblySuccess(ListenableFuture<V> result) {
            void var1_1;
            TrustedListenableFutureTask.this.setFuture(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void afterRanInterruptiblyFailure(Throwable error) {
            void var1_1;
            TrustedListenableFutureTask.this.setException((Throwable)var1_1);
        }

        @Override
        final String toPendingString() {
            return this.callable.toString();
        }
    }

    private final class TrustedFutureInterruptibleTask
    extends InterruptibleTask<V> {
        private final Callable<V> callable;

        /*
         * WARNING - void declaration
         */
        TrustedFutureInterruptibleTask(Callable<V> callable) {
            void var2_2;
            this.callable = (Callable)Preconditions.checkNotNull(var2_2);
        }

        @Override
        final boolean isDone() {
            return ((AbstractFuture)TrustedListenableFutureTask.this).isDone();
        }

        @Override
        @ParametricNullness
        final V runInterruptibly() throws Exception {
            return this.callable.call();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void afterRanInterruptiblySuccess(@ParametricNullness V result) {
            void var1_1;
            TrustedListenableFutureTask.this.set(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void afterRanInterruptiblyFailure(Throwable error) {
            void var1_1;
            TrustedListenableFutureTask.this.setException((Throwable)var1_1);
        }

        @Override
        final String toPendingString() {
            return this.callable.toString();
        }
    }
}

