/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class TimeoutFuture<V>
extends FluentFuture.TrustedFuture<V> {
    private ListenableFuture<V> delegateRef;
    private ScheduledFuture<?> timer;

    /*
     * WARNING - void declaration
     */
    static <V> ListenableFuture<V> create(ListenableFuture<V> delegate, long time, TimeUnit unit, ScheduledExecutorService scheduledExecutor) {
        ListenableFuture<V> listenableFuture;
        void var3_2;
        void var1_1;
        TimeoutFuture<V> result = new TimeoutFuture<V>(delegate);
        Fire<V> fire = new Fire<V>(result);
        result.timer = scheduledExecutor.schedule(fire, (long)var1_1, (TimeUnit)var3_2);
        listenableFuture.addListener(fire, MoreExecutors.directExecutor());
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private TimeoutFuture(ListenableFuture<V> delegate) {
        void var1_1;
        this.delegateRef = (ListenableFuture)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final String pendingToString() {
        ListenableFuture<V> localInputFuture = this.delegateRef;
        ScheduledFuture<?> localTimer = this.timer;
        if (localInputFuture != null) {
            void var1_1;
            void var2_2;
            long delay;
            String string = String.valueOf(localInputFuture);
            String message = new StringBuilder(14 + String.valueOf(string).length()).append("inputFuture=[").append(string).append("]").toString();
            if (localTimer != null && (delay = var2_2.getDelay(TimeUnit.MILLISECONDS)) > 0L) {
                message = String.valueOf(message);
                message = new StringBuilder(43 + String.valueOf(message).length()).append(message).append(", remaining delay=[").append(delay).append(" ms]").toString();
            }
            return var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void afterDone() {
        TimeoutFuture timeoutFuture = this;
        timeoutFuture.maybePropagateCancellationTo(timeoutFuture.delegateRef);
        ScheduledFuture<?> localTimer = this.timer;
        if (localTimer != null) {
            void var1_1;
            var1_1.cancel(false);
        }
        this.delegateRef = null;
        this.timer = null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ScheduledFuture access$102(TimeoutFuture x0, ScheduledFuture x1) {
        void var1_1;
        x0.timer = var1_1;
        return x0.timer;
    }

    private static final class TimeoutFutureException
    extends TimeoutException {
        /*
         * WARNING - void declaration
         */
        private TimeoutFutureException(String message) {
            super((String)var1_1);
            void var1_1;
        }

        @Override
        public final synchronized Throwable fillInStackTrace() {
            this.setStackTrace(new StackTraceElement[0]);
            return this;
        }
    }

    private static final class Fire<V>
    implements Runnable {
        TimeoutFuture<V> timeoutFutureRef;

        /*
         * WARNING - void declaration
         */
        Fire(TimeoutFuture<V> timeoutFuture) {
            void var1_1;
            this.timeoutFutureRef = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            TimeoutFuture<V> timeoutFuture = this.timeoutFutureRef;
            if (timeoutFuture == null) {
                return;
            }
            ListenableFuture delegate = ((TimeoutFuture)timeoutFuture).delegateRef;
            if (delegate == null) {
                return;
            }
            this.timeoutFutureRef = null;
            if (delegate.isDone()) {
                timeoutFuture.setFuture(delegate);
                return;
            }
            try {
                ScheduledFuture timer = ((TimeoutFuture)timeoutFuture).timer;
                TimeoutFuture.access$102(timeoutFuture, null);
                String message = "Timed out";
                try {
                    String string;
                    long overDelayMs;
                    if (timer != null && (overDelayMs = Math.abs(string.getDelay(TimeUnit.MILLISECONDS))) > 10L) {
                        string = String.valueOf(message);
                        message = new StringBuilder(66 + String.valueOf(string).length()).append(string).append(" (timeout delayed by ").append(overDelayMs).append(" ms after scheduled time)").toString();
                    }
                    String string2 = String.valueOf(message);
                    String string3 = String.valueOf(delegate);
                    message = new StringBuilder(2 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(": ").append(string3).toString();
                }
                catch (Throwable throwable) {
                    void var1_1;
                    var1_1.setException(new TimeoutFutureException(message));
                    throw throwable;
                }
                timeoutFuture.setException(new TimeoutFutureException(message));
            }
            catch (Throwable throwable) {
                void var2_3;
                var2_3.cancel(true);
                throw throwable;
            }
            delegate.cancel(true);
        }
    }
}

