/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class ThreadFactoryBuilder {
    private String nameFormat = null;
    private Boolean daemon = null;
    private Integer priority = null;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    private ThreadFactory backingThreadFactory = null;

    /*
     * WARNING - void declaration
     */
    public final ThreadFactoryBuilder setNameFormat(String nameFormat) {
        void var1_1;
        ThreadFactoryBuilder.format(nameFormat, 0);
        this.nameFormat = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ThreadFactoryBuilder setDaemon(boolean daemon) {
        void var1_1;
        this.daemon = (boolean)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ThreadFactoryBuilder setPriority(int priority) {
        void var1_1;
        Preconditions.checkArgument(priority > 0, "Thread priority (%s) must be >= %s", priority, 1);
        Preconditions.checkArgument(priority <= 10, "Thread priority (%s) must be <= %s", priority, 10);
        this.priority = (int)var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ThreadFactoryBuilder setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        void var1_1;
        this.uncaughtExceptionHandler = (Thread.UncaughtExceptionHandler)Preconditions.checkNotNull(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final ThreadFactoryBuilder setThreadFactory(ThreadFactory backingThreadFactory) {
        void var1_1;
        this.backingThreadFactory = (ThreadFactory)Preconditions.checkNotNull(var1_1);
        return this;
    }

    public final ThreadFactory build() {
        return ThreadFactoryBuilder.doBuild(this);
    }

    /*
     * WARNING - void declaration
     */
    private static ThreadFactory doBuild(ThreadFactoryBuilder builder) {
        void var3_3;
        void var2_2;
        void var1_1;
        ThreadFactory threadFactory;
        String nameFormat = builder.nameFormat;
        Boolean daemon = builder.daemon;
        Integer priority = builder.priority;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = builder.uncaughtExceptionHandler;
        ThreadFactory backingThreadFactory = builder.backingThreadFactory != null ? builder.backingThreadFactory : Executors.defaultThreadFactory();
        AtomicLong count = nameFormat != null ? new AtomicLong(0L) : null;
        return new ThreadFactory((String)var1_1, count, (Boolean)var2_2, (Integer)var3_3, uncaughtExceptionHandler){
            final /* synthetic */ String val$nameFormat;
            final /* synthetic */ AtomicLong val$count;
            final /* synthetic */ Boolean val$daemon;
            final /* synthetic */ Integer val$priority;
            final /* synthetic */ Thread.UncaughtExceptionHandler val$uncaughtExceptionHandler;
            {
                this.val$nameFormat = string;
                this.val$count = atomicLong;
                this.val$daemon = bl;
                this.val$priority = n;
                this.val$uncaughtExceptionHandler = uncaughtExceptionHandler;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Thread newThread(Runnable runnable) {
                void var1_1;
                Thread thread = threadFactory.newThread(runnable);
                if (this.val$nameFormat != null) {
                    thread.setName(ThreadFactoryBuilder.access$000(this.val$nameFormat, new Object[]{Objects.requireNonNull(this.val$count).getAndIncrement()}));
                }
                if (this.val$daemon != null) {
                    thread.setDaemon(this.val$daemon);
                }
                if (this.val$priority != null) {
                    thread.setPriority(this.val$priority);
                }
                if (this.val$uncaughtExceptionHandler != null) {
                    thread.setUncaughtExceptionHandler(this.val$uncaughtExceptionHandler);
                }
                return var1_1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static String format(String format, Object ... args) {
        void var1_1;
        String string;
        return String.format(Locale.ROOT, string, (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$000(String x0, Object[] x1) {
        void var1_1;
        return ThreadFactoryBuilder.format(x0, (Object[])var1_1);
    }
}

