/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.math.IntMath;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ForwardingCondition;
import com.google.common.util.concurrent.ForwardingLock;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public abstract class Striped<L> {
    private static final int LARGE_LAZY_CUTOFF = 1024;
    private static final int ALL_SET = -1;

    private Striped() {
    }

    public abstract L get(Object var1);

    public abstract L getAt(int var1);

    abstract int indexFor(Object var1);

    public abstract int size();

    /*
     * WARNING - void declaration
     */
    public Iterable<L> bulkGet(Iterable<? extends Object> keys) {
        void var1_1;
        ArrayList<? extends Object> result = Lists.newArrayList(keys);
        if (result.isEmpty()) {
            return ImmutableList.of();
        }
        int[] stripes = new int[result.size()];
        for (int i = 0; i < result.size(); ++i) {
            stripes[i] = this.indexFor(result.get(i));
        }
        Arrays.sort(stripes);
        int previousStripe = stripes[0];
        result.set(0, this.getAt(previousStripe));
        for (int i = 1; i < result.size(); ++i) {
            int currentStripe = stripes[i];
            if (currentStripe == previousStripe) {
                result.set(i, result.get(i - 1));
                continue;
            }
            result.set(i, this.getAt(currentStripe));
            previousStripe = currentStripe;
        }
        void var4_5 = var1_1;
        return Collections.unmodifiableList(var4_5);
    }

    /*
     * WARNING - void declaration
     */
    static <L> Striped<L> custom(int stripes, Supplier<L> supplier) {
        void var1_1;
        int n;
        return new CompactStriped(n, (Supplier)var1_1);
    }

    public static Striped<Lock> lock(int stripes) {
        return Striped.custom(stripes, PaddedLock::new);
    }

    public static Striped<Lock> lazyWeakLock(int stripes) {
        return Striped.lazy(stripes, () -> new ReentrantLock(false));
    }

    /*
     * WARNING - void declaration
     */
    private static <L> Striped<L> lazy(int stripes, Supplier<L> supplier) {
        void var1_1;
        int n;
        if (stripes < 1024) {
            return new SmallLazyStriped<L>(stripes, supplier);
        }
        return new LargeLazyStriped(n, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Striped<Semaphore> semaphore(int stripes, int permits) {
        void var1_1;
        return Striped.custom(stripes, () -> Striped.lambda$semaphore$1((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static Striped<Semaphore> lazyWeakSemaphore(int stripes, int permits) {
        void var1_1;
        return Striped.lazy(stripes, () -> Striped.lambda$lazyWeakSemaphore$2((int)var1_1));
    }

    public static Striped<ReadWriteLock> readWriteLock(int stripes) {
        return Striped.custom(stripes, ReentrantReadWriteLock::new);
    }

    public static Striped<ReadWriteLock> lazyWeakReadWriteLock(int stripes) {
        return Striped.lazy(stripes, WeakSafeReadWriteLock::new);
    }

    private static int ceilToPowerOfTwo(int x) {
        int n;
        return 1 << IntMath.log2(n, RoundingMode.CEILING);
    }

    private static int smear(int hashCode) {
        int n;
        int n2 = hashCode;
        hashCode = n2 ^ (n2 >>> 20 ^ hashCode >>> 12);
        return hashCode ^ hashCode >>> 7 ^ n >>> 4;
    }

    private static /* synthetic */ Semaphore lambda$lazyWeakSemaphore$2(int permits) {
        int n;
        return new Semaphore(n, false);
    }

    private static /* synthetic */ Semaphore lambda$semaphore$1(int permits) {
        int n;
        return new PaddedSemaphore(n);
    }

    private static class PaddedSemaphore
    extends Semaphore {
        long unused1;
        long unused2;
        long unused3;

        /*
         * WARNING - void declaration
         */
        PaddedSemaphore(int permits) {
            super((int)var1_1, false);
            void var1_1;
        }
    }

    private static class PaddedLock
    extends ReentrantLock {
        long unused1;
        long unused2;
        long unused3;

        PaddedLock() {
            super(false);
        }
    }

    @VisibleForTesting
    static class LargeLazyStriped<L>
    extends PowerOfTwoStriped<L> {
        final ConcurrentMap<Integer, L> locks;
        final Supplier<L> supplier;
        final int size;

        /*
         * WARNING - void declaration
         */
        LargeLazyStriped(int stripes, Supplier<L> supplier) {
            super((int)var1_1);
            void var2_2;
            void var1_1;
            this.size = this.mask == -1 ? Integer.MAX_VALUE : this.mask + 1;
            this.supplier = var2_2;
            this.locks = new MapMaker().weakValues().makeMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public L getAt(int index) {
            void var3_3;
            void var1_1;
            L l;
            Object existing;
            if (this.size != Integer.MAX_VALUE) {
                Preconditions.checkElementIndex(index, ((Striped)this).size());
            }
            if ((existing = this.locks.get(index)) != null) {
                return l;
            }
            L created = this.supplier.get();
            l = this.locks.putIfAbsent((int)var1_1, created);
            return MoreObjects.firstNonNull(l, var3_3);
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    @VisibleForTesting
    static class SmallLazyStriped<L>
    extends PowerOfTwoStriped<L> {
        final AtomicReferenceArray<ArrayReference<? extends L>> locks;
        final Supplier<L> supplier;
        final int size;
        final ReferenceQueue<L> queue = new ReferenceQueue();

        /*
         * WARNING - void declaration
         */
        SmallLazyStriped(int stripes, Supplier<L> supplier) {
            super((int)var1_1);
            void var2_2;
            void var1_1;
            this.size = this.mask == -1 ? Integer.MAX_VALUE : this.mask + 1;
            this.locks = new AtomicReferenceArray(this.size);
            this.supplier = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public L getAt(int index) {
            ArrayReference<? extends L> existingRef;
            Object existing;
            if (this.size != Integer.MAX_VALUE) {
                Preconditions.checkElementIndex(index, ((Striped)this).size());
            }
            if ((existing = (existingRef = this.locks.get(index)) == null ? null : existingRef.get()) != null) {
                return existing;
            }
            L created = this.supplier.get();
            ArrayReference<L> newRef = new ArrayReference<L>(created, index, this.queue);
            while (!this.locks.compareAndSet(index, existingRef, newRef)) {
                void var3_3;
                existingRef = this.locks.get(index);
                existing = existingRef == null ? null : existingRef.get();
                if (existing == null) continue;
                return var3_3;
            }
            this.drainQueue();
            return created;
        }

        /*
         * WARNING - void declaration
         */
        private void drainQueue() {
            Reference<L> ref;
            while ((ref = this.queue.poll()) != null) {
                void var1_1;
                ArrayReference arrayRef = (ArrayReference)ref;
                this.locks.compareAndSet(arrayRef.index, (ArrayReference<L>)var1_1, (ArrayReference<L>)null);
            }
        }

        @Override
        public int size() {
            return this.size;
        }

        private static final class ArrayReference<L>
        extends WeakReference<L> {
            final int index;

            /*
             * WARNING - void declaration
             */
            ArrayReference(L referent, int index, ReferenceQueue<L> queue) {
                super(var1_1, var3_3);
                void var2_2;
                void var3_3;
                void var1_1;
                this.index = var2_2;
            }
        }
    }

    private static class CompactStriped<L>
    extends PowerOfTwoStriped<L> {
        private final Object[] array;

        private CompactStriped(int stripes, Supplier<L> supplier) {
            super(stripes);
            Preconditions.checkArgument(stripes <= 0x40000000, "Stripes must be <= 2^30)");
            this.array = new Object[this.mask + 1];
            for (int i = 0; i < this.array.length; ++i) {
                this.array[i] = supplier.get();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public L getAt(int index) {
            void var1_1;
            return (L)this.array[var1_1];
        }

        @Override
        public int size() {
            return this.array.length;
        }
    }

    private static abstract class PowerOfTwoStriped<L>
    extends Striped<L> {
        final int mask;

        /*
         * WARNING - void declaration
         */
        PowerOfTwoStriped(int stripes) {
            void var1_1;
            Preconditions.checkArgument(stripes > 0, "Stripes must be positive");
            this.mask = stripes > 0x40000000 ? -1 : Striped.ceilToPowerOfTwo((int)var1_1) - 1;
        }

        @Override
        final int indexFor(Object key) {
            int n = Striped.smear(key.hashCode());
            return n & this.mask;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final L get(Object key) {
            void var1_1;
            PowerOfTwoStriped powerOfTwoStriped = this;
            return powerOfTwoStriped.getAt(powerOfTwoStriped.indexFor(var1_1));
        }
    }

    private static final class WeakSafeCondition
    extends ForwardingCondition {
        private final Condition delegate;
        private final WeakSafeReadWriteLock strongReference;

        /*
         * WARNING - void declaration
         */
        WeakSafeCondition(Condition delegate, WeakSafeReadWriteLock strongReference) {
            void var2_2;
            void var1_1;
            this.delegate = var1_1;
            this.strongReference = var2_2;
        }

        @Override
        final Condition delegate() {
            return this.delegate;
        }
    }

    private static final class WeakSafeLock
    extends ForwardingLock {
        private final Lock delegate;
        private final WeakSafeReadWriteLock strongReference;

        /*
         * WARNING - void declaration
         */
        WeakSafeLock(Lock delegate, WeakSafeReadWriteLock strongReference) {
            void var2_2;
            void var1_1;
            this.delegate = var1_1;
            this.strongReference = var2_2;
        }

        @Override
        final Lock delegate() {
            return this.delegate;
        }

        @Override
        public final Condition newCondition() {
            return new WeakSafeCondition(this.delegate.newCondition(), this.strongReference);
        }
    }

    private static final class WeakSafeReadWriteLock
    implements ReadWriteLock {
        private final ReadWriteLock delegate = new ReentrantReadWriteLock();

        WeakSafeReadWriteLock() {
        }

        @Override
        public final Lock readLock() {
            return new WeakSafeLock(this.delegate.readLock(), this);
        }

        @Override
        public final Lock writeLock() {
            return new WeakSafeLock(this.delegate.writeLock(), this);
        }
    }
}

