/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.math.LongMath;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.RateLimiter;
import java.util.concurrent.TimeUnit;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
abstract class SmoothRateLimiter
extends RateLimiter {
    double storedPermits;
    double maxPermits;
    double stableIntervalMicros;
    private long nextFreeTicketMicros = 0L;

    /*
     * WARNING - void declaration
     */
    private SmoothRateLimiter(RateLimiter.SleepingStopwatch stopwatch) {
        super((RateLimiter.SleepingStopwatch)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void doSetRate(double permitsPerSecond, long nowMicros) {
        void var1_1;
        double stableIntervalMicros;
        void var3_2;
        this.resync((long)var3_2);
        this.stableIntervalMicros = stableIntervalMicros = (double)TimeUnit.SECONDS.toMicros(1L) / permitsPerSecond;
        this.doSetRate((double)var1_1, stableIntervalMicros);
    }

    abstract void doSetRate(double var1, double var3);

    @Override
    final double doGetRate() {
        return (double)TimeUnit.SECONDS.toMicros(1L) / this.stableIntervalMicros;
    }

    @Override
    final long queryEarliestAvailable(long nowMicros) {
        return this.nextFreeTicketMicros;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final long reserveEarliestAvailable(int requiredPermits, long nowMicros) {
        void var1_1;
        void var2_2;
        this.resync((long)var2_2);
        long returnValue = this.nextFreeTicketMicros;
        double storedPermitsToSpend = Math.min((double)requiredPermits, this.storedPermits);
        double freshPermits = (double)var1_1 - storedPermitsToSpend;
        SmoothRateLimiter smoothRateLimiter = this;
        long waitMicros = smoothRateLimiter.storedPermitsToWaitTime(smoothRateLimiter.storedPermits, storedPermitsToSpend) + (long)(freshPermits * this.stableIntervalMicros);
        this.nextFreeTicketMicros = LongMath.saturatedAdd(this.nextFreeTicketMicros, waitMicros);
        this.storedPermits -= storedPermitsToSpend;
        return returnValue;
    }

    abstract long storedPermitsToWaitTime(double var1, double var3);

    abstract double coolDownIntervalMicros();

    /*
     * WARNING - void declaration
     */
    void resync(long nowMicros) {
        if (nowMicros > this.nextFreeTicketMicros) {
            void var1_1;
            void var3_2;
            double newPermits = (double)(nowMicros - this.nextFreeTicketMicros) / this.coolDownIntervalMicros();
            this.storedPermits = Math.min(this.maxPermits, this.storedPermits + var3_2);
            this.nextFreeTicketMicros = var1_1;
        }
    }

    static final class SmoothBursty
    extends SmoothRateLimiter {
        final double maxBurstSeconds;

        /*
         * WARNING - void declaration
         */
        SmoothBursty(RateLimiter.SleepingStopwatch stopwatch, double maxBurstSeconds) {
            super((RateLimiter.SleepingStopwatch)var1_1);
            void var2_2;
            void var1_1;
            this.maxBurstSeconds = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void doSetRate(double permitsPerSecond, double stableIntervalMicros) {
            double d;
            SmoothBursty smoothBursty;
            void var1_1;
            double oldMaxPermits = this.maxPermits;
            this.maxPermits = this.maxBurstSeconds * var1_1;
            if (oldMaxPermits == Double.POSITIVE_INFINITY) {
                SmoothBursty smoothBursty2 = this;
                smoothBursty = smoothBursty2;
                d = smoothBursty2.maxPermits;
            } else {
                smoothBursty = this;
                d = oldMaxPermits == 0.0 ? 0.0 : this.storedPermits * this.maxPermits / oldMaxPermits;
            }
            smoothBursty.storedPermits = d;
        }

        @Override
        final long storedPermitsToWaitTime(double storedPermits, double permitsToTake) {
            return 0L;
        }

        @Override
        final double coolDownIntervalMicros() {
            return this.stableIntervalMicros;
        }
    }

    static final class SmoothWarmingUp
    extends SmoothRateLimiter {
        private final long warmupPeriodMicros;
        private double slope;
        private double thresholdPermits;
        private double coldFactor;

        /*
         * WARNING - void declaration
         */
        SmoothWarmingUp(RateLimiter.SleepingStopwatch stopwatch, long warmupPeriod, TimeUnit timeUnit, double coldFactor) {
            super((RateLimiter.SleepingStopwatch)var1_1);
            void var2_2;
            void var1_1;
            this.warmupPeriodMicros = timeUnit.toMicros((long)var2_2);
            this.coldFactor = coldFactor;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void doSetRate(double permitsPerSecond, double stableIntervalMicros) {
            double d;
            SmoothWarmingUp smoothWarmingUp;
            void var3_2;
            double oldMaxPermits = this.maxPermits;
            double coldIntervalMicros = stableIntervalMicros * this.coldFactor;
            this.thresholdPermits = 0.5 * (double)this.warmupPeriodMicros / stableIntervalMicros;
            this.maxPermits = this.thresholdPermits + 2.0 * (double)this.warmupPeriodMicros / (stableIntervalMicros + coldIntervalMicros);
            this.slope = (coldIntervalMicros - var3_2) / (this.maxPermits - this.thresholdPermits);
            if (oldMaxPermits == Double.POSITIVE_INFINITY) {
                smoothWarmingUp = this;
                d = 0.0;
            } else {
                smoothWarmingUp = this;
                d = oldMaxPermits == 0.0 ? this.maxPermits : this.storedPermits * this.maxPermits / oldMaxPermits;
            }
            smoothWarmingUp.storedPermits = d;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final long storedPermitsToWaitTime(double storedPermits, double permitsToTake) {
            void var3_2;
            double availablePermitsAboveThreshold = storedPermits - this.thresholdPermits;
            long micros = 0L;
            if (availablePermitsAboveThreshold > 0.0) {
                double permitsAboveThresholdToTake = Math.min(availablePermitsAboveThreshold, permitsToTake);
                double length = this.permitsToTime(availablePermitsAboveThreshold) + this.permitsToTime(availablePermitsAboveThreshold - permitsAboveThresholdToTake);
                micros = (long)(permitsAboveThresholdToTake * length / 2.0);
                permitsToTake -= permitsAboveThresholdToTake;
            }
            long l = micros + (long)(this.stableIntervalMicros * var3_2);
            return l;
        }

        /*
         * WARNING - void declaration
         */
        private double permitsToTime(double permits) {
            void var1_1;
            return this.stableIntervalMicros + var1_1 * this.slope;
        }

        @Override
        final double coolDownIntervalMicros() {
            return (double)this.warmupPeriodMicros / this.maxPermits;
        }
    }
}

