/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class SimpleTimeLimiter
implements TimeLimiter {
    private final ExecutorService executor;

    /*
     * WARNING - void declaration
     */
    private SimpleTimeLimiter(ExecutorService executor) {
        void var1_1;
        this.executor = (ExecutorService)Preconditions.checkNotNull(var1_1);
    }

    public static SimpleTimeLimiter create(ExecutorService executor) {
        ExecutorService executorService;
        return new SimpleTimeLimiter(executorService);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T newProxy(T target, Class<T> interfaceType, long timeoutDuration, TimeUnit timeoutUnit) {
        void var1_1;
        void var2_2;
        void var3_3;
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(interfaceType);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Preconditions.checkArgument(interfaceType.isInterface(), "interfaceType must be an interface type");
        Set<Method> interruptibleMethods = SimpleTimeLimiter.findInterruptibleMethods(interfaceType);
        InvocationHandler handler = new InvocationHandler(this, target, (long)var3_3, timeoutUnit, interruptibleMethods){
            final /* synthetic */ Object val$target;
            final /* synthetic */ long val$timeoutDuration;
            final /* synthetic */ TimeUnit val$timeoutUnit;
            final /* synthetic */ Set val$interruptibleMethods;
            final /* synthetic */ SimpleTimeLimiter this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$target = object;
                this.val$timeoutDuration = l;
                this.val$timeoutUnit = timeUnit;
                this.val$interruptibleMethods = set;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
                void var2_2;
                void var1_1;
                void var3_3;
                Callable<Object> callable = () -> 1.lambda$invoke$0(method, this.val$target, (Object[])var3_3);
                return SimpleTimeLimiter.access$000(this.this$0, (Callable)var1_1, this.val$timeoutDuration, this.val$timeoutUnit, this.val$interruptibleMethods.contains(var2_2));
            }

            /*
             * WARNING - void declaration
             */
            private static /* synthetic */ Object lambda$invoke$0(Method method, Object target, Object[] args) throws Exception {
                try {
                    void var2_2;
                    void var1_1;
                    return method.invoke((Object)var1_1, (Object[])var2_2);
                }
                catch (InvocationTargetException invocationTargetException) {
                    InvocationTargetException invocationTargetException2 = invocationTargetException;
                    throw SimpleTimeLimiter.access$100(invocationTargetException, false);
                }
            }
        };
        return SimpleTimeLimiter.newProxy(var2_2, (InvocationHandler)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> T newProxy(Class<T> interfaceType, InvocationHandler handler) {
        void var1_1;
        Class<T> clazz;
        Object object = Proxy.newProxyInstance(interfaceType.getClassLoader(), new Class[]{interfaceType}, handler);
        return clazz.cast(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private <T> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit, boolean amInterruptible) throws Exception {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future<T> future = this.executor.submit(callable);
        try {
            void e2;
            if (amInterruptible) {
                try {
                    return future.get(timeoutDuration, timeoutUnit);
                }
                catch (InterruptedException e2) {
                    future.cancel(true);
                    throw e2;
                }
            }
            return Uninterruptibles.getUninterruptibly(future, (long)e2, timeoutUnit);
        }
        catch (ExecutionException executionException) {
            ExecutionException e2 = executionException;
            throw SimpleTimeLimiter.throwCause(executionException, true);
        }
        catch (TimeoutException e) {
            void var2_5;
            void var1_1;
            var1_1.cancel(true);
            throw new UncheckedTimeoutException((Throwable)var2_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException, ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future<T> future = this.executor.submit(callable);
        try {
            return future.get(timeoutDuration, timeoutUnit);
        }
        catch (InterruptedException | TimeoutException e) {
            void var1_1;
            var1_1.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            void var2_4;
            this.wrapAndThrowExecutionExceptionOrError(var2_4.getCause());
            throw new AssertionError();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T callUninterruptiblyWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future<T> future = this.executor.submit(callable);
        try {
            return Uninterruptibles.getUninterruptibly(future, timeoutDuration, timeoutUnit);
        }
        catch (TimeoutException e) {
            void var1_1;
            var1_1.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            void var2_4;
            this.wrapAndThrowExecutionExceptionOrError(var2_4.getCause());
            throw new AssertionError();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void runWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException, InterruptedException {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future<?> future = this.executor.submit(runnable);
        try {
            future.get(timeoutDuration, timeoutUnit);
            return;
        }
        catch (InterruptedException | TimeoutException e) {
            void var1_1;
            var1_1.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            void var2_4;
            this.wrapAndThrowRuntimeExecutionExceptionOrError(var2_4.getCause());
            throw new AssertionError();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void runUninterruptiblyWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) throws TimeoutException {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeoutUnit);
        SimpleTimeLimiter.checkPositiveTimeout(timeoutDuration);
        Future<?> future = this.executor.submit(runnable);
        try {
            Uninterruptibles.getUninterruptibly(future, timeoutDuration, timeoutUnit);
            return;
        }
        catch (TimeoutException e) {
            void var1_1;
            var1_1.cancel(true);
            throw e;
        }
        catch (ExecutionException e) {
            void var2_4;
            this.wrapAndThrowRuntimeExecutionExceptionOrError(var2_4.getCause());
            throw new AssertionError();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Exception throwCause(Exception e, boolean combineStackTraces) throws Exception {
        Exception exception;
        Throwable cause = e.getCause();
        if (cause == null) {
            throw e;
        }
        if (combineStackTraces) {
            void var1_2;
            StackTraceElement[] combined = ObjectArrays.concat(cause.getStackTrace(), e.getStackTrace(), StackTraceElement.class);
            cause.setStackTrace((StackTraceElement[])var1_2);
        }
        if (cause instanceof Exception) {
            throw (Exception)cause;
        }
        if (cause instanceof Error) {
            void var2_3;
            throw (Error)var2_3;
        }
        throw exception;
    }

    /*
     * WARNING - void declaration
     */
    private static Set<Method> findInterruptibleMethods(Class<?> interfaceType) {
        void var1_1;
        Method[] methodArray;
        HashSet<Method> set = Sets.newHashSet();
        for (Method m : methodArray.getMethods()) {
            if (!SimpleTimeLimiter.declaresInterruptedEx(m)) continue;
            set.add(m);
        }
        return var1_1;
    }

    private static boolean declaresInterruptedEx(Method method) {
        for (Class<?> clazz : method.getExceptionTypes()) {
            if (clazz != InterruptedException.class) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void wrapAndThrowExecutionExceptionOrError(Throwable cause) throws ExecutionException {
        void var1_1;
        if (cause instanceof Error) {
            throw new ExecutionError((Error)cause);
        }
        if (cause instanceof RuntimeException) {
            throw new UncheckedExecutionException(cause);
        }
        throw new ExecutionException((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void wrapAndThrowRuntimeExecutionExceptionOrError(Throwable cause) {
        void var1_1;
        if (cause instanceof Error) {
            throw new ExecutionError((Error)cause);
        }
        throw new UncheckedExecutionException((Throwable)var1_1);
    }

    private static void checkPositiveTimeout(long timeoutDuration) {
        long l;
        Preconditions.checkArgument(timeoutDuration > 0L, "timeout must be positive: %s", l);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$000(SimpleTimeLimiter x0, Callable x1, long x2, TimeUnit x3, boolean x4) throws Exception {
        void var2_2;
        void var1_1;
        return x0.callWithTimeout((Callable)var1_1, (long)var2_2, x3, x4);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Exception access$100(Exception x0, boolean x1) throws Exception {
        void var1_1;
        return SimpleTimeLimiter.throwCause(x0, (boolean)var1_1);
    }
}

