/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.ListenerCallQueue;
import com.google.common.util.concurrent.Monitor;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import com.google.common.util.concurrent.ServiceManagerBridge;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class ServiceManager
implements ServiceManagerBridge {
    private static final Logger logger = Logger.getLogger(ServiceManager.class.getName());
    private static final ListenerCallQueue.Event<Listener> HEALTHY_EVENT = new ListenerCallQueue.Event<Listener>(){

        @Override
        public void call(Listener listener) {
            listener.healthy();
        }

        public String toString() {
            return "healthy()";
        }
    };
    private static final ListenerCallQueue.Event<Listener> STOPPED_EVENT = new ListenerCallQueue.Event<Listener>(){

        @Override
        public void call(Listener listener) {
            listener.stopped();
        }

        public String toString() {
            return "stopped()";
        }
    };
    private final ServiceManagerState state;
    private final ImmutableList<Service> services;

    /*
     * WARNING - void declaration
     */
    public ServiceManager(Iterable<? extends Service> services) {
        Iterator iterator;
        ImmutableList<Service> copy = ImmutableList.copyOf(services);
        if (copy.isEmpty()) {
            logger.log(Level.WARNING, "ServiceManager configured with no services.  Is your application configured properly?", new EmptyServiceManagerWarning());
            copy = ImmutableList.of(new NoOpService());
        }
        this.state = new ServiceManagerState(copy);
        this.services = copy;
        WeakReference<ServiceManagerState> stateReference = new WeakReference<ServiceManagerState>(this.state);
        iterator = ((ImmutableCollection)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Service service = (Service)iterator.next();
            service.addListener(new ServiceListener(service, stateReference), MoreExecutors.directExecutor());
            Preconditions.checkArgument(service.state() == Service.State.NEW, "Can only manage NEW services, %s", (Object)var3_3);
        }
        this.state.markReady();
    }

    /*
     * WARNING - void declaration
     */
    public final void addListener(Listener listener, Executor executor) {
        void var2_2;
        void var1_1;
        this.state.addListener((Listener)var1_1, (Executor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final ServiceManager startAsync() {
        for (Service object : this.services) {
            Preconditions.checkState(object.state() == Service.State.NEW, "Not all services are NEW, cannot start %s", (Object)this);
        }
        for (Service service : this.services) {
            try {
                this.state.tryStartTiming(service);
                service.startAsync();
            }
            catch (IllegalStateException e) {
                void var3_6;
                String string = String.valueOf(service);
                logger.log(Level.WARNING, new StringBuilder(24 + String.valueOf(string).length()).append("Unable to start Service ").append(string).toString(), (Throwable)var3_6);
            }
        }
        return this;
    }

    public final void awaitHealthy() {
        this.state.awaitHealthy();
    }

    /*
     * WARNING - void declaration
     */
    public final void awaitHealthy(Duration timeout) throws TimeoutException {
        void var1_1;
        this.awaitHealthy(Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public final void awaitHealthy(long timeout, TimeUnit unit) throws TimeoutException {
        void var3_2;
        void var1_1;
        this.state.awaitHealthy((long)var1_1, (TimeUnit)var3_2);
    }

    public final ServiceManager stopAsync() {
        for (Service service : this.services) {
            service.stopAsync();
        }
        return this;
    }

    public final void awaitStopped() {
        this.state.awaitStopped();
    }

    /*
     * WARNING - void declaration
     */
    public final void awaitStopped(Duration timeout) throws TimeoutException {
        void var1_1;
        this.awaitStopped(Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public final void awaitStopped(long timeout, TimeUnit unit) throws TimeoutException {
        void var3_2;
        void var1_1;
        this.state.awaitStopped((long)var1_1, (TimeUnit)var3_2);
    }

    public final boolean isHealthy() {
        for (Service service : this.services) {
            if (service.isRunning()) continue;
            return false;
        }
        return true;
    }

    public final ImmutableSetMultimap<Service.State, Service> servicesByState() {
        return this.state.servicesByState();
    }

    public final ImmutableMap<Service, Long> startupTimes() {
        return this.state.startupTimes();
    }

    public final ImmutableMap<Service, Duration> startupDurations() {
        return ImmutableMap.copyOf(Maps.transformValues(this.startupTimes(), Duration::ofMillis));
    }

    public final String toString() {
        return MoreObjects.toStringHelper(ServiceManager.class).add("services", Collections2.filter(this.services, Predicates.not(Predicates.instanceOf(NoOpService.class)))).toString();
    }

    private static final class FailedService
    extends Throwable {
        /*
         * WARNING - void declaration
         */
        FailedService(Service service) {
            super(service.toString(), var1_1.failureCause(), false, false);
            void var1_1;
        }
    }

    private static final class EmptyServiceManagerWarning
    extends Throwable {
        private EmptyServiceManagerWarning() {
        }
    }

    private static final class NoOpService
    extends AbstractService {
        private NoOpService() {
        }

        @Override
        protected final void doStart() {
            this.notifyStarted();
        }

        @Override
        protected final void doStop() {
            this.notifyStopped();
        }
    }

    private static final class ServiceListener
    extends Service.Listener {
        final Service service;
        final WeakReference<ServiceManagerState> state;

        /*
         * WARNING - void declaration
         */
        ServiceListener(Service service, WeakReference<ServiceManagerState> state) {
            void var2_2;
            void var1_1;
            this.service = var1_1;
            this.state = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void starting() {
            ServiceManagerState state = (ServiceManagerState)this.state.get();
            if (state != null) {
                void var1_1;
                var1_1.transitionService(this.service, Service.State.NEW, Service.State.STARTING);
                if (!(this.service instanceof NoOpService)) {
                    logger.log(Level.FINE, "Starting {0}.", this.service);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void running() {
            ServiceManagerState state = (ServiceManagerState)this.state.get();
            if (state != null) {
                void var1_1;
                var1_1.transitionService(this.service, Service.State.STARTING, Service.State.RUNNING);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void stopping(Service.State from) {
            ServiceManagerState state = (ServiceManagerState)this.state.get();
            if (state != null) {
                void var1_1;
                void var2_2;
                var2_2.transitionService(this.service, (Service.State)var1_1, Service.State.STOPPING);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void terminated(Service.State from) {
            ServiceManagerState state = (ServiceManagerState)this.state.get();
            if (state != null) {
                void var1_1;
                void var2_2;
                if (!(this.service instanceof NoOpService)) {
                    logger.log(Level.FINE, "Service {0} has terminated. Previous state was: {1}", new Object[]{this.service, from});
                }
                var2_2.transitionService(this.service, (Service.State)var1_1, Service.State.TERMINATED);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void failed(Service.State from, Throwable failure) {
            ServiceManagerState state = (ServiceManagerState)this.state.get();
            if (state != null) {
                void var1_1;
                void var3_3;
                boolean bl = !(this.service instanceof NoOpService);
                if (bl = bl & from != Service.State.STARTING) {
                    void var2_2;
                    String string = String.valueOf(this.service);
                    String string2 = String.valueOf((Object)from);
                    logger.log(Level.SEVERE, new StringBuilder(34 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Service ").append(string).append(" has failed in the ").append(string2).append(" state.").toString(), (Throwable)var2_2);
                }
                var3_3.transitionService(this.service, (Service.State)var1_1, Service.State.FAILED);
            }
        }
    }

    private static final class ServiceManagerState {
        final Monitor monitor = new Monitor();
        final SetMultimap<Service.State, Service> servicesByState = MultimapBuilder.enumKeys(Service.State.class).linkedHashSetValues().build();
        final Multiset<Service.State> states = this.servicesByState.keys();
        final Map<Service, Stopwatch> startupTimers = Maps.newIdentityHashMap();
        boolean ready;
        boolean transitioned;
        final int numberOfServices;
        final Monitor.Guard awaitHealthGuard = new AwaitHealthGuard();
        final Monitor.Guard stoppedGuard = new StoppedGuard();
        final ListenerCallQueue<Listener> listeners = new ListenerCallQueue();

        /*
         * WARNING - void declaration
         */
        ServiceManagerState(ImmutableCollection<Service> services) {
            void var1_1;
            this.numberOfServices = services.size();
            this.servicesByState.putAll(Service.State.NEW, (Iterable<Service>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void tryStartTiming(Service service) {
            this.monitor.enter();
            try {
                Stopwatch stopwatch = this.startupTimers.get(service);
                if (stopwatch == null) {
                    void var1_1;
                    this.startupTimers.put((Service)var1_1, Stopwatch.createStarted());
                }
                return;
            }
            finally {
                this.monitor.leave();
            }
        }

        /*
         * WARNING - void declaration
         */
        final void markReady() {
            this.monitor.enter();
            try {
                if (!this.transitioned) {
                    this.ready = true;
                } else {
                    void var1_1;
                    ArrayList<void> servicesInBadStates = Lists.newArrayList();
                    for (Service service : this.servicesByState().values()) {
                        void var3_4;
                        if (service.state() == Service.State.NEW) continue;
                        servicesInBadStates.add(var3_4);
                    }
                    String string = String.valueOf(var1_1);
                    throw new IllegalArgumentException(new StringBuilder(89 + String.valueOf(string).length()).append("Services started transitioning asynchronously before the ServiceManager was constructed: ").append(string).toString());
                }
                return;
            }
            finally {
                this.monitor.leave();
            }
        }

        /*
         * WARNING - void declaration
         */
        final void addListener(Listener listener, Executor executor) {
            void var2_2;
            void var1_1;
            this.listeners.addListener((Listener)var1_1, (Executor)var2_2);
        }

        final void awaitHealthy() {
            this.monitor.enterWhenUninterruptibly(this.awaitHealthGuard);
            try {
                this.checkHealthy();
                return;
            }
            finally {
                this.monitor.leave();
            }
        }

        /*
         * WARNING - void declaration
         */
        final void awaitHealthy(long timeout, TimeUnit unit) throws TimeoutException {
            this.monitor.enter();
            try {
                void var3_4;
                void var1_1;
                if (!this.monitor.waitForUninterruptibly(this.awaitHealthGuard, (long)var1_1, (TimeUnit)var3_4)) {
                    String string = String.valueOf(Multimaps.filterKeys(this.servicesByState, Predicates.in(ImmutableSet.of(Service.State.NEW, Service.State.STARTING))));
                    throw new TimeoutException(new StringBuilder(93 + String.valueOf(string).length()).append("Timeout waiting for the services to become healthy. The following services have not started: ").append(string).toString());
                }
                this.checkHealthy();
                return;
            }
            finally {
                this.monitor.leave();
            }
        }

        final void awaitStopped() {
            this.monitor.enterWhenUninterruptibly(this.stoppedGuard);
            this.monitor.leave();
        }

        /*
         * WARNING - void declaration
         */
        final void awaitStopped(long timeout, TimeUnit unit) throws TimeoutException {
            this.monitor.enter();
            try {
                void var3_4;
                void var1_1;
                if (!this.monitor.waitForUninterruptibly(this.stoppedGuard, (long)var1_1, (TimeUnit)var3_4)) {
                    String string = String.valueOf(Multimaps.filterKeys(this.servicesByState, Predicates.not(Predicates.in(EnumSet.of(Service.State.TERMINATED, Service.State.FAILED)))));
                    throw new TimeoutException(new StringBuilder(83 + String.valueOf(string).length()).append("Timeout waiting for the services to stop. The following services have not stopped: ").append(string).toString());
                }
                return;
            }
            finally {
                this.monitor.leave();
            }
        }

        /*
         * WARNING - void declaration
         */
        final ImmutableSetMultimap<Service.State, Service> servicesByState() {
            void var1_1;
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            this.monitor.enter();
            try {
                for (Map.Entry entry : this.servicesByState.entries()) {
                    void var3_4;
                    if (entry.getValue() instanceof NoOpService) continue;
                    builder.put((Map.Entry)var3_4);
                }
            }
            finally {
                this.monitor.leave();
            }
            return var1_1.build();
        }

        /*
         * WARNING - void declaration
         */
        final ImmutableMap<Service, Long> startupTimes() {
            void var1_1;
            ArrayList<Map.Entry<Service, Long>> loadTimes;
            this.monitor.enter();
            try {
                loadTimes = Lists.newArrayListWithCapacity(this.startupTimers.size());
                for (Map.Entry<Service, Stopwatch> entry : this.startupTimers.entrySet()) {
                    void var3_4;
                    Service service = entry.getKey();
                    Stopwatch stopwatch = entry.getValue();
                    if (stopwatch.isRunning() || service instanceof NoOpService) continue;
                    loadTimes.add(Maps.immutableEntry(service, var3_4.elapsed(TimeUnit.MILLISECONDS)));
                }
            }
            finally {
                this.monitor.leave();
            }
            Collections.sort(loadTimes, Ordering.natural().onResultOf(new Function<Map.Entry<Service, Long>, Long>(this){

                @Override
                public Long apply(Map.Entry<Service, Long> input) {
                    return input.getValue();
                }
            }));
            return ImmutableMap.copyOf(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void transitionService(Service service, Service.State from, Service.State to) {
            Preconditions.checkNotNull(service);
            Preconditions.checkArgument(from != to);
            this.monitor.enter();
            try {
                void var3_4;
                this.transitioned = true;
                if (!this.ready) {
                    return;
                }
                Preconditions.checkState(this.servicesByState.remove((Object)from, service), "Service %s not at the expected location in the state map %s", (Object)service, (Object)from);
                Preconditions.checkState(this.servicesByState.put(to, service), "Service %s in the state map unexpectedly at %s", (Object)service, (Object)to);
                Stopwatch stopwatch = this.startupTimers.get(service);
                if (stopwatch == null) {
                    stopwatch = Stopwatch.createStarted();
                    this.startupTimers.put(service, stopwatch);
                }
                if (to.compareTo(Service.State.RUNNING) >= 0 && stopwatch.isRunning()) {
                    stopwatch.stop();
                    if (!(service instanceof NoOpService)) {
                        void var2_3;
                        logger.log(Level.FINE, "Started {0} in {1}.", new Object[]{service, var2_3});
                    }
                }
                if (var3_4 == Service.State.FAILED) {
                    void var1_1;
                    this.enqueueFailedEvent((Service)var1_1);
                }
                if (this.states.count((Object)Service.State.RUNNING) == this.numberOfServices) {
                    this.enqueueHealthyEvent();
                } else if (this.states.count((Object)Service.State.TERMINATED) + this.states.count((Object)Service.State.FAILED) == this.numberOfServices) {
                    this.enqueueStoppedEvent();
                }
                return;
            }
            finally {
                this.monitor.leave();
                this.dispatchListenerEvents();
            }
        }

        final void enqueueStoppedEvent() {
            this.listeners.enqueue(STOPPED_EVENT);
        }

        final void enqueueHealthyEvent() {
            this.listeners.enqueue(HEALTHY_EVENT);
        }

        /*
         * WARNING - void declaration
         */
        final void enqueueFailedEvent(Service service) {
            void var1_1;
            this.listeners.enqueue(new ListenerCallQueue.Event<Listener>(this, (Service)var1_1){
                final /* synthetic */ Service val$service;
                {
                    this.val$service = service;
                }

                @Override
                public void call(Listener listener) {
                    listener.failure(this.val$service);
                }

                public String toString() {
                    String string = String.valueOf(this.val$service);
                    return new StringBuilder(18 + String.valueOf(string).length()).append("failed({service=").append(string).append("})").toString();
                }
            });
        }

        final void dispatchListenerEvents() {
            Preconditions.checkState(!this.monitor.isOccupiedByCurrentThread(), "It is incorrect to execute listeners with the monitor held.");
            this.listeners.dispatch();
        }

        /*
         * WARNING - void declaration
         */
        final void checkHealthy() {
            if (this.states.count((Object)Service.State.RUNNING) != this.numberOfServices) {
                void var1_2;
                String string = String.valueOf(Multimaps.filterKeys(this.servicesByState, Predicates.not(Predicates.equalTo(Service.State.RUNNING))));
                IllegalStateException exception = new IllegalStateException(new StringBuilder(79 + String.valueOf(string).length()).append("Expected to be healthy after starting. The following services are not running: ").append(string).toString());
                for (Service service : this.servicesByState.get((Object)Service.State.FAILED)) {
                    void var3_3;
                    exception.addSuppressed(new FailedService((Service)var3_3));
                }
                throw var1_2;
            }
        }

        final class StoppedGuard
        extends Monitor.Guard {
            /*
             * WARNING - void declaration
             */
            StoppedGuard() {
                void var1_1;
                super(var1_1.monitor);
            }

            @Override
            public final boolean isSatisfied() {
                return ServiceManagerState.this.states.count((Object)Service.State.TERMINATED) + ServiceManagerState.this.states.count((Object)Service.State.FAILED) == ServiceManagerState.this.numberOfServices;
            }
        }

        final class AwaitHealthGuard
        extends Monitor.Guard {
            /*
             * WARNING - void declaration
             */
            AwaitHealthGuard() {
                void var1_1;
                super(var1_1.monitor);
            }

            @Override
            public final boolean isSatisfied() {
                return ServiceManagerState.this.states.count((Object)Service.State.RUNNING) == ServiceManagerState.this.numberOfServices || ServiceManagerState.this.states.contains((Object)Service.State.STOPPING) || ServiceManagerState.this.states.contains((Object)Service.State.TERMINATED) || ServiceManagerState.this.states.contains((Object)Service.State.FAILED);
            }
        }
    }

    public static abstract class Listener {
        public void healthy() {
        }

        public void stopped() {
        }

        public void failure(Service service) {
        }
    }
}

