/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class SequentialExecutor
implements Executor {
    private static final Logger log = Logger.getLogger(SequentialExecutor.class.getName());
    private final Executor executor;
    private final Deque<Runnable> queue = new ArrayDeque<Runnable>();
    private WorkerRunningState workerRunningState = WorkerRunningState.IDLE;
    private long workerRunCount = 0L;
    private final QueueWorker worker = new QueueWorker();

    /*
     * WARNING - void declaration
     */
    SequentialExecutor(Executor executor) {
        void var1_1;
        this.executor = (Executor)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void execute(final Runnable task) {
        Runnable submittedTask;
        Preconditions.checkNotNull(task);
        Deque<Runnable> deque = this.queue;
        synchronized (deque) {
            if (this.workerRunningState == WorkerRunningState.RUNNING || this.workerRunningState == WorkerRunningState.QUEUED) {
                this.queue.add(task);
                return;
            }
            long oldRunCount = this.workerRunCount;
            submittedTask = new Runnable(this){

                @Override
                public void run() {
                    task.run();
                }

                public String toString() {
                    return task.toString();
                }
            };
            this.queue.add(submittedTask);
            this.workerRunningState = WorkerRunningState.QUEUING;
        }
        try {
            this.executor.execute(this.worker);
        }
        catch (Error | RuntimeException t) {
            Deque<Runnable> deque2 = this.queue;
            synchronized (deque2) {
                void var1_2;
                boolean removed;
                boolean bl = removed = (this.workerRunningState == WorkerRunningState.IDLE || this.workerRunningState == WorkerRunningState.QUEUING) && this.queue.removeLastOccurrence(submittedTask);
                if (!(t instanceof RejectedExecutionException) || var1_2 != false) {
                    void var2_6;
                    throw var2_6;
                }
                return;
            }
        }
        boolean bl = this.workerRunningState != WorkerRunningState.QUEUING;
        if (bl) {
            return;
        }
        Deque<Runnable> deque3 = this.queue;
        synchronized (deque3) {
            void var3_8;
            if (this.workerRunCount == var3_8 && this.workerRunningState == WorkerRunningState.QUEUING) {
                this.workerRunningState = WorkerRunningState.QUEUED;
            }
            return;
        }
    }

    public final String toString() {
        int n = System.identityHashCode(this);
        String string = String.valueOf(this.executor);
        return new StringBuilder(32 + String.valueOf(string).length()).append("SequentialExecutor@").append(n).append("{").append(string).append("}").toString();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ WorkerRunningState access$202(SequentialExecutor x0, WorkerRunningState x1) {
        void var1_1;
        x0.workerRunningState = var1_1;
        return x0.workerRunningState;
    }

    private final class QueueWorker
    implements Runnable {
        Runnable task;

        private QueueWorker() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            try {
                this.workOnQueue();
                return;
            }
            catch (Error e) {
                void var1_1;
                Deque deque = SequentialExecutor.this.queue;
                synchronized (deque) {
                    SequentialExecutor.access$202(SequentialExecutor.this, WorkerRunningState.IDLE);
                }
                throw var1_1;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void workOnQueue() {
            boolean interruptedDuringTask = false;
            boolean hasSetRunning = false;
            while (true) {
                block13: {
                    block14: {
                        try {
                            Deque deque = SequentialExecutor.this.queue;
                            // MONITORENTER : deque
                            if (hasSetRunning) break block13;
                            if (SequentialExecutor.this.workerRunningState != WorkerRunningState.RUNNING) break block14;
                            // MONITOREXIT : deque
                            if (!interruptedDuringTask) return;
                            Thread.currentThread().interrupt();
                            return;
                        }
                        catch (Throwable throwable) {
                            void var1_1;
                            if (var1_1 == false) throw throwable;
                            Thread.currentThread().interrupt();
                            throw throwable;
                        }
                    }
                    SequentialExecutor.this.workerRunCount++;
                    SequentialExecutor.access$202(SequentialExecutor.this, WorkerRunningState.RUNNING);
                    hasSetRunning = true;
                }
                this.task = (Runnable)SequentialExecutor.this.queue.poll();
                if (this.task == null) {
                    SequentialExecutor.access$202(SequentialExecutor.this, WorkerRunningState.IDLE);
                    // MONITOREXIT : deque
                    if (!interruptedDuringTask) return;
                    Thread.currentThread().interrupt();
                    return;
                }
                // MONITOREXIT : deque
                interruptedDuringTask |= Thread.interrupted();
                try {
                    this.task.run();
                    continue;
                }
                catch (RuntimeException e) {
                    void var3_6;
                    String string = String.valueOf(this.task);
                    log.log(Level.SEVERE, new StringBuilder(35 + String.valueOf(string).length()).append("Exception while executing runnable ").append(string).toString(), (Throwable)var3_6);
                    continue;
                }
                finally {
                    this.task = null;
                    continue;
                }
                break;
            }
        }

        public final String toString() {
            String string;
            Runnable currentlyRunning = this.task;
            if (currentlyRunning != null) {
                string = String.valueOf(string);
                return new StringBuilder(34 + String.valueOf(string).length()).append("SequentialExecutorWorker{running=").append(string).append("}").toString();
            }
            string = String.valueOf((Object)SequentialExecutor.this.workerRunningState);
            return new StringBuilder(32 + String.valueOf(string).length()).append("SequentialExecutorWorker{state=").append(string).append("}").toString();
        }
    }

    static enum WorkerRunningState {
        IDLE,
        QUEUING,
        QUEUED,
        RUNNING;

    }
}

