/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.SmoothRateLimiter;
import com.google.common.util.concurrent.Uninterruptibles;
import java.time.Duration;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public abstract class RateLimiter {
    private final SleepingStopwatch stopwatch;
    private volatile Object mutexDoNotUseDirectly;

    public static RateLimiter create(double permitsPerSecond) {
        return RateLimiter.create(permitsPerSecond, SleepingStopwatch.createFromSystemTimer());
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static RateLimiter create(double permitsPerSecond, SleepingStopwatch stopwatch) {
        void var2_1;
        double d;
        SmoothRateLimiter.SmoothBursty rateLimiter = new SmoothRateLimiter.SmoothBursty(stopwatch, 1.0);
        rateLimiter.setRate(d);
        return var2_1;
    }

    /*
     * WARNING - void declaration
     */
    public static RateLimiter create(double permitsPerSecond, Duration warmupPeriod) {
        void var2_1;
        return RateLimiter.create(permitsPerSecond, Internal.toNanosSaturated((Duration)var2_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public static RateLimiter create(double permitsPerSecond, long warmupPeriod, TimeUnit unit) {
        void var2_2;
        double d;
        Preconditions.checkArgument(warmupPeriod >= 0L, "warmupPeriod must not be negative: %s", warmupPeriod);
        return RateLimiter.create(d, (long)var2_2, unit, 3.0, SleepingStopwatch.createFromSystemTimer());
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static RateLimiter create(double permitsPerSecond, long warmupPeriod, TimeUnit unit, double coldFactor, SleepingStopwatch stopwatch) {
        void var2_2;
        double d;
        SmoothRateLimiter.SmoothWarmingUp rateLimiter = new SmoothRateLimiter.SmoothWarmingUp(stopwatch, warmupPeriod, unit, coldFactor);
        rateLimiter.setRate(d);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Object mutex() {
        void var1_1;
        Object mutex = this.mutexDoNotUseDirectly;
        if (mutex == null) {
            RateLimiter rateLimiter = this;
            synchronized (rateLimiter) {
                mutex = this.mutexDoNotUseDirectly;
                if (mutex == null) {
                    this.mutexDoNotUseDirectly = mutex = new Object();
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    RateLimiter(SleepingStopwatch stopwatch) {
        void var1_1;
        this.stopwatch = (SleepingStopwatch)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setRate(double permitsPerSecond) {
        Preconditions.checkArgument(permitsPerSecond > 0.0 && !Double.isNaN(permitsPerSecond), "rate must be positive");
        Object object = this.mutex();
        synchronized (object) {
            void var1_1;
            this.doSetRate((double)var1_1, this.stopwatch.readMicros());
            return;
        }
    }

    abstract void doSetRate(double var1, long var3);

    public final double getRate() {
        Object object = this.mutex();
        synchronized (object) {
            return this.doGetRate();
        }
    }

    abstract double doGetRate();

    public double acquire() {
        return this.acquire(1);
    }

    /*
     * WARNING - void declaration
     */
    public double acquire(int permits) {
        void var2_2;
        void var1_1;
        long microsToWait = this.reserve((int)var1_1);
        this.stopwatch.sleepMicrosUninterruptibly(microsToWait);
        return 1.0 * (double)var2_2 / (double)TimeUnit.SECONDS.toMicros(1L);
    }

    /*
     * WARNING - void declaration
     */
    final long reserve(int permits) {
        RateLimiter.checkPermits(permits);
        Object object = this.mutex();
        synchronized (object) {
            void var1_1;
            return this.reserveAndGetWaitLength((int)var1_1, this.stopwatch.readMicros());
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean tryAcquire(Duration timeout) {
        void var1_1;
        return this.tryAcquire(1, Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public boolean tryAcquire(long timeout, TimeUnit unit) {
        void var3_2;
        void var1_1;
        return this.tryAcquire(1, (long)var1_1, (TimeUnit)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public boolean tryAcquire(int permits) {
        void var1_1;
        return this.tryAcquire((int)var1_1, 0L, TimeUnit.MICROSECONDS);
    }

    public boolean tryAcquire() {
        return this.tryAcquire(1, 0L, TimeUnit.MICROSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public boolean tryAcquire(int permits, Duration timeout) {
        void var2_2;
        void var1_1;
        return this.tryAcquire((int)var1_1, Internal.toNanosSaturated((Duration)var2_2), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) {
        long microsToWait;
        void var2_3;
        long timeoutMicros = Math.max(unit.toMicros((long)var2_3), 0L);
        RateLimiter.checkPermits(permits);
        Object object = this.mutex();
        synchronized (object) {
            void var1_1;
            long nowMicros = this.stopwatch.readMicros();
            if (!this.canAcquire(nowMicros, timeoutMicros)) {
                return false;
            }
            microsToWait = this.reserveAndGetWaitLength((int)var1_1, nowMicros);
        }
        this.stopwatch.sleepMicrosUninterruptibly(microsToWait);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean canAcquire(long nowMicros, long timeoutMicros) {
        void var1_1;
        void var3_2;
        return this.queryEarliestAvailable(nowMicros) - var3_2 <= var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final long reserveAndGetWaitLength(int permits, long nowMicros) {
        void var2_2;
        void var1_1;
        long l = this.reserveEarliestAvailable((int)var1_1, nowMicros);
        return Math.max(l - var2_2, 0L);
    }

    abstract long queryEarliestAvailable(long var1);

    abstract long reserveEarliestAvailable(int var1, long var2);

    public String toString() {
        return String.format(Locale.ROOT, "RateLimiter[stableRate=%3.1fqps]", this.getRate());
    }

    private static void checkPermits(int permits) {
        int n;
        Preconditions.checkArgument(permits > 0, "Requested permits (%s) must be positive", n);
    }

    static abstract class SleepingStopwatch {
        protected SleepingStopwatch() {
        }

        protected abstract long readMicros();

        protected abstract void sleepMicrosUninterruptibly(long var1);

        public static SleepingStopwatch createFromSystemTimer() {
            return new SleepingStopwatch(){
                final Stopwatch stopwatch = Stopwatch.createStarted();

                @Override
                protected long readMicros() {
                    return this.stopwatch.elapsed(TimeUnit.MICROSECONDS);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected void sleepMicrosUninterruptibly(long micros) {
                    if (micros > 0L) {
                        void var1_1;
                        Uninterruptibles.sleepUninterruptibly((long)var1_1, TimeUnit.MICROSECONDS);
                    }
                }
            };
        }
    }
}

