/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AbstractListeningExecutorService;
import com.google.common.util.concurrent.Callables;
import com.google.common.util.concurrent.DirectExecutor;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.SequentialExecutor;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.TrustedListenableFutureTask;
import com.google.common.util.concurrent.WrappingExecutorService;
import com.google.common.util.concurrent.WrappingScheduledExecutorService;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class MoreExecutors {
    private MoreExecutors() {
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static ExecutorService getExitingExecutorService(ThreadPoolExecutor executor, Duration terminationTimeout) {
        void var1_1;
        return MoreExecutors.getExitingExecutorService(executor, Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static ExecutorService getExitingExecutorService(ThreadPoolExecutor executor, long terminationTimeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        ThreadPoolExecutor threadPoolExecutor;
        return new Application().getExitingExecutorService(threadPoolExecutor, (long)var1_1, (TimeUnit)var3_2);
    }

    @Beta
    @GwtIncompatible
    public static ExecutorService getExitingExecutorService(ThreadPoolExecutor executor) {
        ThreadPoolExecutor threadPoolExecutor;
        return new Application().getExitingExecutorService(threadPoolExecutor);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor executor, Duration terminationTimeout) {
        void var1_1;
        return MoreExecutors.getExitingScheduledExecutorService(executor, Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor executor, long terminationTimeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
        return new Application().getExitingScheduledExecutorService(scheduledThreadPoolExecutor, (long)var1_1, (TimeUnit)var3_2);
    }

    @Beta
    @GwtIncompatible
    public static ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor executor) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
        return new Application().getExitingScheduledExecutorService(scheduledThreadPoolExecutor);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static void addDelayedShutdownHook(ExecutorService service, Duration terminationTimeout) {
        void var1_1;
        MoreExecutors.addDelayedShutdownHook(service, Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static void addDelayedShutdownHook(ExecutorService service, long terminationTimeout, TimeUnit timeUnit) {
        void var3_2;
        void var1_1;
        ExecutorService executorService;
        new Application().addDelayedShutdownHook(executorService, (long)var1_1, (TimeUnit)var3_2);
    }

    @GwtIncompatible
    private static void useDaemonThreadFactory(ThreadPoolExecutor executor) {
        ThreadPoolExecutor threadPoolExecutor;
        executor.setThreadFactory(new ThreadFactoryBuilder().setDaemon(true).setThreadFactory(threadPoolExecutor.getThreadFactory()).build());
    }

    @GwtIncompatible
    public static ListeningExecutorService newDirectExecutorService() {
        return new DirectExecutorService();
    }

    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    @GwtIncompatible
    public static Executor newSequentialExecutor(Executor delegate) {
        Executor executor;
        return new SequentialExecutor(executor);
    }

    @GwtIncompatible
    public static ListeningExecutorService listeningDecorator(ExecutorService delegate) {
        ExecutorService executorService;
        if (delegate instanceof ListeningExecutorService) {
            return (ListeningExecutorService)delegate;
        }
        if (delegate instanceof ScheduledExecutorService) {
            return new ScheduledListeningDecorator((ScheduledExecutorService)delegate);
        }
        return new ListeningDecorator(executorService);
    }

    @GwtIncompatible
    public static ListeningScheduledExecutorService listeningDecorator(ScheduledExecutorService delegate) {
        ScheduledExecutorService scheduledExecutorService;
        if (delegate instanceof ListeningScheduledExecutorService) {
            return (ListeningScheduledExecutorService)delegate;
        }
        return new ScheduledListeningDecorator(scheduledExecutorService);
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    @GwtIncompatible
    static <T> T invokeAnyImpl(ListeningExecutorService executorService, Collection<? extends Callable<T>> tasks, boolean timed, Duration timeout) throws InterruptedException, ExecutionException, TimeoutException {
        void var3_3;
        void var2_2;
        void var1_1;
        return MoreExecutors.invokeAnyImpl(executorService, var1_1, (boolean)var2_2, Internal.toNanosSaturated((Duration)var3_3), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    @GwtIncompatible
    static <T> T invokeAnyImpl(ListeningExecutorService executorService22, Collection<? extends Callable<T>> tasks, boolean timed, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        void var3_8;
        ArrayList<ListenableFuture<T>> futures;
        block15: {
            Preconditions.checkNotNull(executorService22);
            Preconditions.checkNotNull(unit);
            int ntasks = tasks.size();
            Preconditions.checkArgument(ntasks > 0);
            futures = Lists.newArrayListWithCapacity(ntasks);
            LinkedBlockingQueue<Future<T>> futureQueue = Queues.newLinkedBlockingQueue();
            long timeoutNanos = unit.toNanos((long)timeout);
            ExecutionException ee = null;
            long lastTime = timed != false ? System.nanoTime() : 0L;
            Iterator it = tasks.iterator();
            futures.add(MoreExecutors.submitAndAddQueueListener((ListeningExecutorService)executorService22, (Callable)it.next(), futureQueue));
            --ntasks;
            int active = 1;
            while (true) {
                Object now22;
                Future f;
                if ((f = (Future)futureQueue.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(MoreExecutors.submitAndAddQueueListener((ListeningExecutorService)executorService22, (Callable)it.next(), futureQueue));
                        ++active;
                    } else {
                        if (active == 0) break;
                        if (timed != false) {
                            f = (Future)futureQueue.poll(timeoutNanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            long now22 = System.nanoTime();
                            timeoutNanos -= now22 - lastTime;
                            lastTime = now22;
                        } else {
                            f = (Future)futureQueue.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    now22 = f.get();
                }
                catch (ExecutionException executionException) {
                    ExecutionException now22 = executionException;
                    ee = executionException;
                    continue;
                }
                catch (RuntimeException rex) {
                    ee = new ExecutionException(rex);
                    continue;
                }
                return (T)now22;
                break;
            }
            if (ee != null) break block15;
            ee = new ExecutionException(null);
        }
        throw var3_8;
        finally {
            for (Future executorService22 : futures) {
                executorService22.cancel(true);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private static <T> ListenableFuture<T> submitAndAddQueueListener(ListeningExecutorService executorService, Callable<T> task, BlockingQueue<Future<T>> queue) {
        Future future;
        void var2_2;
        void var1_1;
        Future future2 = executorService.submit((Callable)var1_1);
        future2.addListener(new Runnable((BlockingQueue)var2_2, (ListenableFuture)future2){
            final /* synthetic */ BlockingQueue val$queue;
            final /* synthetic */ ListenableFuture val$future;
            {
                this.val$queue = blockingQueue;
                this.val$future = listenableFuture;
            }

            @Override
            public void run() {
                this.val$queue.add(this.val$future);
            }
        }, MoreExecutors.directExecutor());
        return future;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static ThreadFactory platformThreadFactory() {
        if (!MoreExecutors.isAppEngineWithApiClasses()) {
            return Executors.defaultThreadFactory();
        }
        try {
            return (ThreadFactory)Class.forName("com.google.appengine.api.ThreadManager").getMethod("currentRequestThreadFactory", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Couldn't invoke ThreadManager.currentRequestThreadFactory", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Couldn't invoke ThreadManager.currentRequestThreadFactory", e);
        }
        catch (NoSuchMethodException e) {
            void var0_2;
            throw new RuntimeException("Couldn't invoke ThreadManager.currentRequestThreadFactory", (Throwable)var0_2);
        }
        catch (InvocationTargetException invocationTargetException) {
            InvocationTargetException invocationTargetException2 = invocationTargetException;
            throw Throwables.propagate(invocationTargetException.getCause());
        }
    }

    @GwtIncompatible
    private static boolean isAppEngineWithApiClasses() {
        if (System.getProperty("com.google.appengine.runtime.environment") == null) {
            return false;
        }
        try {
            Class.forName("com.google.appengine.api.utils.SystemProperty");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        try {
            return Class.forName("com.google.apphosting.api.ApiProxy").getMethod("getCurrentEnvironment", new Class[0]).invoke(null, new Object[0]) != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    static Thread newThread(String name, Runnable runnable) {
        void var1_1;
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(runnable);
        Thread result = MoreExecutors.platformThreadFactory().newThread(runnable);
        try {
            String string;
            result.setName(string);
        }
        catch (SecurityException securityException) {}
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    static Executor renamingDecorator(Executor executor, Supplier<String> nameSupplier) {
        void var1_1;
        Executor executor2;
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(nameSupplier);
        return new Executor((Supplier)var1_1){
            final /* synthetic */ Supplier val$nameSupplier;
            {
                this.val$nameSupplier = supplier;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void execute(Runnable command) {
                void var1_1;
                executor2.execute(Callables.threadRenaming((Runnable)var1_1, (Supplier<String>)this.val$nameSupplier));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    static ExecutorService renamingDecorator(ExecutorService service, Supplier<String> nameSupplier) {
        void var1_1;
        ExecutorService executorService;
        Preconditions.checkNotNull(service);
        Preconditions.checkNotNull(nameSupplier);
        return new WrappingExecutorService(executorService, (Supplier)var1_1){
            final /* synthetic */ Supplier val$nameSupplier;
            {
                void var1_1;
                this.val$nameSupplier = supplier;
                super((ExecutorService)var1_1);
            }

            @Override
            protected <T> Callable<T> wrapTask(Callable<T> callable) {
                return Callables.threadRenaming(callable, (Supplier<String>)this.val$nameSupplier);
            }

            @Override
            protected Runnable wrapTask(Runnable command) {
                return Callables.threadRenaming(command, (Supplier<String>)this.val$nameSupplier);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    static ScheduledExecutorService renamingDecorator(ScheduledExecutorService service, Supplier<String> nameSupplier) {
        void var1_1;
        ScheduledExecutorService scheduledExecutorService;
        Preconditions.checkNotNull(service);
        Preconditions.checkNotNull(nameSupplier);
        return new WrappingScheduledExecutorService(scheduledExecutorService, (Supplier)var1_1){
            final /* synthetic */ Supplier val$nameSupplier;
            {
                void var1_1;
                this.val$nameSupplier = supplier;
                super((ScheduledExecutorService)var1_1);
            }

            @Override
            protected <T> Callable<T> wrapTask(Callable<T> callable) {
                return Callables.threadRenaming(callable, (Supplier<String>)this.val$nameSupplier);
            }

            @Override
            protected Runnable wrapTask(Runnable command) {
                return Callables.threadRenaming(command, (Supplier<String>)this.val$nameSupplier);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static boolean shutdownAndAwaitTermination(ExecutorService service, Duration timeout) {
        void var1_1;
        return MoreExecutors.shutdownAndAwaitTermination(service, Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static boolean shutdownAndAwaitTermination(ExecutorService service, long timeout, TimeUnit unit) {
        ExecutorService executorService;
        void var1_1;
        long halfTimeoutNanos = unit.toNanos((long)var1_1) / 2L;
        service.shutdown();
        try {
            if (!service.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS)) {
                service.shutdownNow();
                service.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            service.shutdownNow();
        }
        return executorService.isTerminated();
    }

    /*
     * WARNING - void declaration
     */
    static Executor rejectionPropagatingExecutor(Executor delegate, AbstractFuture<?> future) {
        void var1_1;
        Executor executor;
        Preconditions.checkNotNull(delegate);
        Preconditions.checkNotNull(future);
        if (delegate == MoreExecutors.directExecutor()) {
            return delegate;
        }
        return new Executor((AbstractFuture)var1_1){
            final /* synthetic */ AbstractFuture val$future;
            {
                this.val$future = abstractFuture;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void execute(Runnable command) {
                try {
                    executor.execute(command);
                    return;
                }
                catch (RejectedExecutionException e) {
                    void var1_2;
                    this.val$future.setException((Throwable)var1_2);
                    return;
                }
            }
        };
    }

    @GwtIncompatible
    private static final class ScheduledListeningDecorator
    extends ListeningDecorator
    implements ListeningScheduledExecutorService {
        final ScheduledExecutorService delegate;

        /*
         * WARNING - void declaration
         */
        ScheduledListeningDecorator(ScheduledExecutorService delegate) {
            super(delegate);
            void var1_1;
            this.delegate = (ScheduledExecutorService)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ListenableScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
            void var2_3;
            void var1_1;
            TrustedListenableFutureTask<Object> task = TrustedListenableFutureTask.create(command, null);
            ScheduledFuture<?> scheduled = this.delegate.schedule(task, delay, unit);
            return new ListenableScheduledTask(var1_1, (ScheduledFuture<?>)var2_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
            void var2_3;
            void var1_1;
            TrustedListenableFutureTask<V> task = TrustedListenableFutureTask.create(callable);
            ScheduledFuture<?> scheduled = this.delegate.schedule(task, delay, unit);
            return new ListenableScheduledTask(var1_1, (ScheduledFuture<?>)var2_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
            void var2_3;
            void var1_1;
            NeverSuccessfulListenableFutureTask task = new NeverSuccessfulListenableFutureTask(command);
            ScheduledFuture<?> scheduled = this.delegate.scheduleAtFixedRate(task, initialDelay, period, unit);
            return new ListenableScheduledTask(var1_1, (ScheduledFuture<?>)var2_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
            void var2_3;
            void var1_1;
            NeverSuccessfulListenableFutureTask task = new NeverSuccessfulListenableFutureTask(command);
            ScheduledFuture<?> scheduled = this.delegate.scheduleWithFixedDelay(task, initialDelay, delay, unit);
            return new ListenableScheduledTask(var1_1, (ScheduledFuture<?>)var2_3);
        }

        @GwtIncompatible
        private static final class NeverSuccessfulListenableFutureTask
        extends AbstractFuture.TrustedFuture<Void>
        implements Runnable {
            private final Runnable delegate;

            /*
             * WARNING - void declaration
             */
            public NeverSuccessfulListenableFutureTask(Runnable delegate) {
                void var1_1;
                this.delegate = (Runnable)Preconditions.checkNotNull(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void run() {
                try {
                    this.delegate.run();
                    return;
                }
                catch (Throwable t) {
                    void var1_1;
                    this.setException(t);
                    throw Throwables.propagate((Throwable)var1_1);
                }
            }

            @Override
            protected final String pendingToString() {
                String string = String.valueOf(this.delegate);
                return new StringBuilder(7 + String.valueOf(string).length()).append("task=[").append(string).append("]").toString();
            }
        }

        private static final class ListenableScheduledTask<V>
        extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V>
        implements ListenableScheduledFuture<V> {
            private final ScheduledFuture<?> scheduledDelegate;

            /*
             * WARNING - void declaration
             */
            public ListenableScheduledTask(ListenableFuture<V> listenableDelegate, ScheduledFuture<?> scheduledDelegate) {
                super(var1_1);
                void var2_2;
                void var1_1;
                this.scheduledDelegate = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean cancel(boolean mayInterruptIfRunning) {
                void var2_2;
                boolean cancelled = super.cancel(mayInterruptIfRunning);
                if (cancelled) {
                    void var1_1;
                    this.scheduledDelegate.cancel((boolean)var1_1);
                }
                return (boolean)var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final long getDelay(TimeUnit unit) {
                void var1_1;
                return this.scheduledDelegate.getDelay((TimeUnit)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final int compareTo(Delayed other) {
                void var1_1;
                return this.scheduledDelegate.compareTo(var1_1);
            }
        }
    }

    @GwtIncompatible
    private static class ListeningDecorator
    extends AbstractListeningExecutorService {
        private final ExecutorService delegate;

        /*
         * WARNING - void declaration
         */
        ListeningDecorator(ExecutorService delegate) {
            void var1_1;
            this.delegate = (ExecutorService)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            void var3_2;
            void var1_1;
            return this.delegate.awaitTermination((long)var1_1, (TimeUnit)var3_2);
        }

        @Override
        public final boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public final boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public final void shutdown() {
            this.delegate.shutdown();
        }

        @Override
        public final List<Runnable> shutdownNow() {
            return this.delegate.shutdownNow();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void execute(Runnable command) {
            void var1_1;
            this.delegate.execute((Runnable)var1_1);
        }

        public final String toString() {
            String string = super.toString();
            String string2 = String.valueOf(this.delegate);
            return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("[").append(string2).append("]").toString();
        }
    }

    @GwtIncompatible
    private static final class DirectExecutorService
    extends AbstractListeningExecutorService {
        private final Object lock = new Object();
        private int runningTasks = 0;
        private boolean shutdown = false;

        private DirectExecutorService() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void execute(Runnable command) {
            this.startTask();
            try {
                void var1_1;
                var1_1.run();
                return;
            }
            finally {
                this.endTask();
            }
        }

        @Override
        public final boolean isShutdown() {
            Object object = this.lock;
            synchronized (object) {
                return this.shutdown;
            }
        }

        @Override
        public final void shutdown() {
            Object object = this.lock;
            synchronized (object) {
                this.shutdown = true;
                if (this.runningTasks == 0) {
                    this.lock.notifyAll();
                }
                return;
            }
        }

        @Override
        public final List<Runnable> shutdownNow() {
            this.shutdown();
            return Collections.emptyList();
        }

        @Override
        public final boolean isTerminated() {
            Object object = this.lock;
            synchronized (object) {
                return this.shutdown && this.runningTasks == 0;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            void var1_1;
            long nanos = unit.toNanos((long)var1_1);
            Object object = this.lock;
            synchronized (object) {
                while (!this.shutdown || this.runningTasks != 0) {
                    if (nanos <= 0L) {
                        return false;
                    }
                    long now = System.nanoTime();
                    TimeUnit.NANOSECONDS.timedWait(this.lock, nanos);
                    nanos -= System.nanoTime() - now;
                }
                return true;
            }
        }

        private void startTask() {
            Object object = this.lock;
            synchronized (object) {
                if (this.shutdown) {
                    throw new RejectedExecutionException("Executor already shutdown");
                }
                ++this.runningTasks;
                return;
            }
        }

        private void endTask() {
            Object object = this.lock;
            synchronized (object) {
                int n = --this.runningTasks;
                if (this.runningTasks == 0) {
                    this.lock.notifyAll();
                }
                return;
            }
        }
    }

    @GwtIncompatible
    @VisibleForTesting
    static class Application {
        Application() {
        }

        /*
         * WARNING - void declaration
         */
        final ExecutorService getExitingExecutorService(ThreadPoolExecutor executor, long terminationTimeout, TimeUnit timeUnit) {
            void var2_2;
            void var1_1;
            MoreExecutors.useDaemonThreadFactory(executor);
            ExecutorService service = Executors.unconfigurableExecutorService(executor);
            this.addDelayedShutdownHook((ExecutorService)var1_1, (long)var2_2, timeUnit);
            return service;
        }

        /*
         * WARNING - void declaration
         */
        final ExecutorService getExitingExecutorService(ThreadPoolExecutor executor) {
            void var1_1;
            return this.getExitingExecutorService((ThreadPoolExecutor)var1_1, 120L, TimeUnit.SECONDS);
        }

        /*
         * WARNING - void declaration
         */
        final ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor executor, long terminationTimeout, TimeUnit timeUnit) {
            void var2_2;
            void var1_1;
            MoreExecutors.useDaemonThreadFactory(executor);
            ScheduledExecutorService service = Executors.unconfigurableScheduledExecutorService(executor);
            this.addDelayedShutdownHook((ExecutorService)var1_1, (long)var2_2, timeUnit);
            return service;
        }

        /*
         * WARNING - void declaration
         */
        final ScheduledExecutorService getExitingScheduledExecutorService(ScheduledThreadPoolExecutor executor) {
            void var1_1;
            return this.getExitingScheduledExecutorService((ScheduledThreadPoolExecutor)var1_1, 120L, TimeUnit.SECONDS);
        }

        /*
         * WARNING - void declaration
         */
        final void addDelayedShutdownHook(ExecutorService service, long terminationTimeout, TimeUnit timeUnit) {
            void var2_2;
            void var1_1;
            Preconditions.checkNotNull(service);
            Preconditions.checkNotNull(timeUnit);
            String string = String.valueOf(service);
            this.addShutdownHook(MoreExecutors.newThread(new StringBuilder(24 + String.valueOf(string).length()).append("DelayedShutdownHook-for-").append(string).toString(), new Runnable(this, (ExecutorService)var1_1, (long)var2_2, timeUnit){
                final /* synthetic */ ExecutorService val$service;
                final /* synthetic */ long val$terminationTimeout;
                final /* synthetic */ TimeUnit val$timeUnit;
                {
                    this.val$service = executorService;
                    this.val$terminationTimeout = l;
                    this.val$timeUnit = timeUnit;
                }

                @Override
                public void run() {
                    try {
                        this.val$service.shutdown();
                        this.val$service.awaitTermination(this.val$terminationTimeout, this.val$timeUnit);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        void addShutdownHook(Thread hook) {
            void var1_1;
            Runtime.getRuntime().addShutdownHook((Thread)var1_1);
        }
    }
}

