/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.Internal;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class Monitor {
    private final boolean fair;
    private final ReentrantLock lock;
    private Guard activeGuards = null;

    public Monitor() {
        this(false);
    }

    /*
     * WARNING - void declaration
     */
    public Monitor(boolean fair) {
        void var1_1;
        this.fair = fair;
        this.lock = new ReentrantLock((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Guard newGuard(BooleanSupplier isSatisfied) {
        void var1_1;
        Preconditions.checkNotNull(isSatisfied, "isSatisfied");
        Monitor monitor = this;
        return new Guard(monitor, monitor, (BooleanSupplier)var1_1){
            final /* synthetic */ BooleanSupplier val$isSatisfied;
            {
                void var2_2;
                this.val$isSatisfied = booleanSupplier;
                super((Monitor)var2_2);
            }

            @Override
            public boolean isSatisfied() {
                return this.val$isSatisfied.getAsBoolean();
            }
        };
    }

    public final void enter() {
        this.lock.lock();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enter(Duration time) {
        void var1_1;
        return this.enter(Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enter(long time, TimeUnit unit) {
        void var3_4;
        long timeoutNanos = Monitor.toSafeNanos(time, (TimeUnit)var3_4);
        ReentrantLock lock = this.lock;
        if (!this.fair && lock.tryLock()) {
            return true;
        }
        boolean interrupted = Thread.interrupted();
        try {
            long startTime = System.nanoTime();
            long remainingNanos = timeoutNanos;
            while (true) {
                try {
                    boolean bl = lock.tryLock(remainingNanos, TimeUnit.NANOSECONDS);
                    return bl;
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                    remainingNanos = Monitor.remainingNanos(startTime, timeoutNanos);
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public final void enterInterruptibly() throws InterruptedException {
        this.lock.lockInterruptibly();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterInterruptibly(Duration time) throws InterruptedException {
        void var1_1;
        return this.enterInterruptibly(Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterInterruptibly(long time, TimeUnit unit) throws InterruptedException {
        void var3_2;
        void var1_1;
        return this.lock.tryLock((long)var1_1, (TimeUnit)var3_2);
    }

    public final boolean tryEnter() {
        return this.lock.tryLock();
    }

    /*
     * WARNING - void declaration
     */
    public final void enterWhen(Guard guard) throws InterruptedException {
        void var2_3;
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock lock = this.lock;
        boolean signalBeforeWaiting = lock.isHeldByCurrentThread();
        var2_3.lockInterruptibly();
        try {
            if (!guard.isSatisfied()) {
                void var3_4;
                void var1_1;
                this.await((Guard)var1_1, (boolean)var3_4);
            }
            return;
        }
        catch (Throwable throwable) {
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterWhen(Guard guard, Duration time) throws InterruptedException {
        void var2_2;
        void var1_1;
        return this.enterWhen((Guard)var1_1, Internal.toNanosSaturated((Duration)var2_2), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterWhen(Guard guard, long time, TimeUnit unit) throws InterruptedException {
        long startTime;
        boolean reentrant;
        ReentrantLock lock;
        long timeoutNanos;
        block17: {
            block16: {
                timeoutNanos = Monitor.toSafeNanos(time, unit);
                if (guard.monitor != this) {
                    throw new IllegalMonitorStateException();
                }
                lock = this.lock;
                reentrant = lock.isHeldByCurrentThread();
                startTime = 0L;
                if (this.fair) break block16;
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                if (lock.tryLock()) break block17;
            }
            startTime = Monitor.initNanoTime(timeoutNanos);
            if (!lock.tryLock(time, unit)) {
                return false;
            }
        }
        boolean satisfied = false;
        boolean threw = true;
        try {
            void var1_1;
            satisfied = guard.isSatisfied() || this.awaitNanos((Guard)var1_1, startTime == 0L ? timeoutNanos : Monitor.remainingNanos(startTime, timeoutNanos), reentrant);
            threw = false;
            boolean bl = satisfied;
            if (!satisfied) {
                lock.unlock();
            }
            return bl;
        }
        catch (Throwable throwable) {
            void var2_6;
            if (var2_6 == false) {
                try {
                    void var3_12;
                    if (var3_12 != false && !reentrant) {
                        this.signalNextWaiter();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void enterWhenUninterruptibly(Guard guard) {
        void var2_3;
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock lock = this.lock;
        boolean signalBeforeWaiting = lock.isHeldByCurrentThread();
        var2_3.lock();
        try {
            if (!guard.isSatisfied()) {
                void var3_4;
                void var1_1;
                this.awaitUninterruptibly((Guard)var1_1, (boolean)var3_4);
            }
            return;
        }
        catch (Throwable throwable) {
            this.leave();
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterWhenUninterruptibly(Guard guard, Duration time) {
        void var2_2;
        void var1_1;
        return this.enterWhenUninterruptibly((Guard)var1_1, Internal.toNanosSaturated((Duration)var2_2), TimeUnit.NANOSECONDS);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean enterWhenUninterruptibly(Guard guard, long time, TimeUnit unit) {
        boolean satisfied;
        long timeoutNanos = Monitor.toSafeNanos(time, unit);
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock lock = this.lock;
        long startTime = 0L;
        boolean signalBeforeWaiting = lock.isHeldByCurrentThread();
        boolean interrupted = Thread.interrupted();
        try {
            if (this.fair || !lock.tryLock()) {
                startTime = Monitor.initNanoTime(timeoutNanos);
                long remainingNanos = timeoutNanos;
                while (true) {
                    try {
                        if (!lock.tryLock(remainingNanos, TimeUnit.NANOSECONDS)) return false;
                    }
                    catch (InterruptedException interruptedException) {
                        interrupted = true;
                        remainingNanos = Monitor.remainingNanos(startTime, timeoutNanos);
                        continue;
                    }
                    break;
                }
            }
            satisfied = false;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        while (true) {
            try {
                if (guard.isSatisfied()) {
                    satisfied = true;
                } else {
                    long remainingNanos;
                    if (startTime == 0L) {
                        startTime = Monitor.initNanoTime(timeoutNanos);
                        remainingNanos = timeoutNanos;
                    } else {
                        remainingNanos = Monitor.remainingNanos(startTime, timeoutNanos);
                    }
                    satisfied = this.awaitNanos(guard, remainingNanos, signalBeforeWaiting);
                }
                boolean bl = satisfied;
                if (satisfied) return bl;
                lock.unlock();
                return bl;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
                signalBeforeWaiting = false;
                continue;
                catch (Throwable throwable) {
                    void var2_5;
                    if (satisfied) throw throwable;
                    var2_5.unlock();
                    throw throwable;
                }
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterIf(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock lock = this.lock;
        lock.lock();
        boolean satisfied = false;
        try {
            void var1_1;
            boolean bl = satisfied = var1_1.isSatisfied();
            if (!satisfied) {
                lock.unlock();
            }
            return bl;
        }
        catch (Throwable throwable) {
            void var3_5;
            if (var3_5 == false) {
                void var2_4;
                var2_4.unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterIf(Guard guard, Duration time) {
        void var2_2;
        void var1_1;
        return this.enterIf((Guard)var1_1, Internal.toNanosSaturated((Duration)var2_2), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterIf(Guard guard, long time, TimeUnit unit) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        if (!this.enter(time, unit)) {
            return false;
        }
        boolean satisfied = false;
        try {
            void var1_1;
            boolean bl = satisfied = var1_1.isSatisfied();
            return bl;
        }
        finally {
            if (!satisfied) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterIfInterruptibly(Guard guard) throws InterruptedException {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        boolean satisfied = false;
        try {
            void var1_1;
            boolean bl = satisfied = var1_1.isSatisfied();
            if (!satisfied) {
                lock.unlock();
            }
            return bl;
        }
        catch (Throwable throwable) {
            void var3_5;
            if (var3_5 == false) {
                void var2_4;
                var2_4.unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterIfInterruptibly(Guard guard, Duration time) throws InterruptedException {
        void var2_2;
        void var1_1;
        return this.enterIfInterruptibly((Guard)var1_1, Internal.toNanosSaturated((Duration)var2_2), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean enterIfInterruptibly(Guard guard, long time, TimeUnit unit) throws InterruptedException {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock lock = this.lock;
        if (!lock.tryLock(time, unit)) {
            return false;
        }
        boolean satisfied = false;
        try {
            void var1_1;
            boolean bl = satisfied = var1_1.isSatisfied();
            return bl;
        }
        finally {
            if (!satisfied) {
                lock.unlock();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryEnterIf(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        ReentrantLock lock = this.lock;
        if (!lock.tryLock()) {
            return false;
        }
        boolean satisfied = false;
        try {
            void var1_1;
            boolean bl = satisfied = var1_1.isSatisfied();
            if (!satisfied) {
                lock.unlock();
            }
            return bl;
        }
        catch (Throwable throwable) {
            void var3_5;
            if (var3_5 == false) {
                void var2_4;
                var2_4.unlock();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void waitFor(Guard guard) throws InterruptedException {
        if (guard.monitor != this || !this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (!guard.isSatisfied()) {
            void var1_1;
            this.await((Guard)var1_1, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean waitFor(Guard guard, Duration time) throws InterruptedException {
        void var2_2;
        void var1_1;
        return this.waitFor((Guard)var1_1, Internal.toNanosSaturated((Duration)var2_2), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean waitFor(Guard guard, long time, TimeUnit unit) throws InterruptedException {
        void var1_1;
        long timeoutNanos = Monitor.toSafeNanos(time, unit);
        if (guard.monitor != this || !this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (guard.isSatisfied()) {
            return true;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        return this.awaitNanos((Guard)var1_1, timeoutNanos, true);
    }

    /*
     * WARNING - void declaration
     */
    public final void waitForUninterruptibly(Guard guard) {
        if (guard.monitor != this || !this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (!guard.isSatisfied()) {
            void var1_1;
            this.awaitUninterruptibly((Guard)var1_1, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean waitForUninterruptibly(Guard guard, Duration time) {
        void var2_2;
        void var1_1;
        return this.waitForUninterruptibly((Guard)var1_1, Internal.toNanosSaturated((Duration)var2_2), TimeUnit.NANOSECONDS);
    }

    public final boolean waitForUninterruptibly(Guard guard, long time, TimeUnit unit) {
        long timeoutNanos = Monitor.toSafeNanos(time, unit);
        if (guard.monitor != this || !this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (guard.isSatisfied()) {
            return true;
        }
        boolean signalBeforeWaiting = true;
        long startTime = Monitor.initNanoTime(timeoutNanos);
        boolean interrupted = Thread.interrupted();
        try {
            long remainingNanos = timeoutNanos;
            while (true) {
                try {
                    signalBeforeWaiting = this.awaitNanos(guard, remainingNanos, signalBeforeWaiting);
                    return signalBeforeWaiting;
                }
                catch (InterruptedException interruptedException) {
                    block11: {
                        interrupted = true;
                        if (!guard.isSatisfied()) break block11;
                        Thread.currentThread().interrupt();
                        return true;
                    }
                    signalBeforeWaiting = false;
                    remainingNanos = Monitor.remainingNanos(startTime, timeoutNanos);
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void leave() {
        ReentrantLock lock = this.lock;
        try {
            if (lock.getHoldCount() == 1) {
                this.signalNextWaiter();
            }
            lock.unlock();
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.unlock();
            throw throwable;
        }
    }

    public final boolean isFair() {
        return this.fair;
    }

    public final boolean isOccupied() {
        return this.lock.isLocked();
    }

    public final boolean isOccupiedByCurrentThread() {
        return this.lock.isHeldByCurrentThread();
    }

    public final int getOccupiedDepth() {
        return this.lock.getHoldCount();
    }

    public final int getQueueLength() {
        return this.lock.getQueueLength();
    }

    public final boolean hasQueuedThreads() {
        return this.lock.hasQueuedThreads();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasQueuedThread(Thread thread) {
        void var1_1;
        return this.lock.hasQueuedThread((Thread)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasWaiters(Guard guard) {
        void var1_1;
        return this.getWaitQueueLength((Guard)var1_1) > 0;
    }

    /*
     * WARNING - void declaration
     */
    public final int getWaitQueueLength(Guard guard) {
        if (guard.monitor != this) {
            throw new IllegalMonitorStateException();
        }
        this.lock.lock();
        try {
            void var1_1;
            int n = var1_1.waiterCount;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static long toSafeNanos(long time, TimeUnit unit) {
        long l;
        long l2 = unit.toNanos(l);
        return Longs.constrainToRange(l2, 0L, 0x5FFFFFFFFFFFFFFDL);
    }

    /*
     * WARNING - void declaration
     */
    private static long initNanoTime(long timeoutNanos) {
        void var2_1;
        if (timeoutNanos <= 0L) {
            return 0L;
        }
        long startTime = System.nanoTime();
        if (startTime == 0L) {
            return 1L;
        }
        return (long)var2_1;
    }

    /*
     * WARNING - void declaration
     */
    private static long remainingNanos(long startTime, long timeoutNanos) {
        long l;
        void var2_1;
        if (timeoutNanos <= 0L) {
            return 0L;
        }
        return (long)(var2_1 - (System.nanoTime() - l));
    }

    private void signalNextWaiter() {
        Guard guard = this.activeGuards;
        while (guard != null) {
            if (this.isSatisfied(guard)) {
                guard.condition.signal();
                return;
            }
            guard = guard.next;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSatisfied(Guard guard) {
        try {
            return guard.isSatisfied();
        }
        catch (Throwable throwable) {
            void var1_2;
            this.signalAllWaiters();
            throw var1_2;
        }
    }

    private void signalAllWaiters() {
        Guard guard = this.activeGuards;
        while (guard != null) {
            guard.condition.signalAll();
            guard = guard.next;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void beginWaitingFor(Guard guard) {
        int n;
        if ((n = guard.waiterCount++) == 0) {
            void var1_1;
            guard.next = this.activeGuards;
            this.activeGuards = var1_1;
        }
    }

    private void endWaitingFor(Guard guard) {
        int n = --guard.waiterCount;
        if (guard.waiterCount == 0) {
            Guard p = this.activeGuards;
            Guard pred = null;
            while (true) {
                if (p == guard) {
                    if (pred == null) {
                        this.activeGuards = p.next;
                    } else {
                        pred.next = p.next;
                    }
                    p.next = null;
                    return;
                }
                pred = p;
                p = p.next;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void await(Guard guard, boolean signalBeforeWaiting) throws InterruptedException {
        if (signalBeforeWaiting) {
            this.signalNextWaiter();
        }
        this.beginWaitingFor(guard);
        try {
            do {
                guard.condition.await();
            } while (!guard.isSatisfied());
            this.endWaitingFor(guard);
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            this.endWaitingFor((Guard)var1_1);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void awaitUninterruptibly(Guard guard, boolean signalBeforeWaiting) {
        if (signalBeforeWaiting) {
            this.signalNextWaiter();
        }
        this.beginWaitingFor(guard);
        try {
            do {
                guard.condition.awaitUninterruptibly();
            } while (!guard.isSatisfied());
            this.endWaitingFor(guard);
            return;
        }
        catch (Throwable throwable) {
            void var1_1;
            this.endWaitingFor((Guard)var1_1);
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    private boolean awaitNanos(Guard guard, long nanos, boolean signalBeforeWaiting) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static abstract class Guard {
        final Monitor monitor;
        final Condition condition;
        int waiterCount = 0;
        Guard next;

        /*
         * WARNING - void declaration
         */
        protected Guard(Monitor monitor) {
            void var1_1;
            this.monitor = Preconditions.checkNotNull(monitor, "monitor");
            this.condition = ((Monitor)var1_1).lock.newCondition();
        }

        public abstract boolean isSatisfied();
    }
}

