/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class ListenerCallQueue<L> {
    private static final Logger logger = Logger.getLogger(ListenerCallQueue.class.getName());
    private final List<PerListenerQueue<L>> listeners = Collections.synchronizedList(new ArrayList());

    ListenerCallQueue() {
    }

    /*
     * WARNING - void declaration
     */
    public final void addListener(L listener, Executor executor) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(listener, "listener");
        Preconditions.checkNotNull(executor, "executor");
        this.listeners.add(new PerListenerQueue<void>(var1_1, (Executor)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final void enqueue(Event<L> event) {
        void var1_1;
        void v0 = var1_1;
        this.enqueueHelper((Event<L>)v0, v0);
    }

    /*
     * WARNING - void declaration
     */
    public final void enqueue(Event<L> event, String label) {
        void var2_2;
        void var1_1;
        this.enqueueHelper((Event<L>)var1_1, var2_2);
    }

    private void enqueueHelper(Event<L> event, Object label) {
        Preconditions.checkNotNull(event, "event");
        Preconditions.checkNotNull(label, "label");
        List<PerListenerQueue<L>> list = this.listeners;
        synchronized (list) {
            for (PerListenerQueue<L> perListenerQueue : this.listeners) {
                perListenerQueue.add(event, label);
            }
            return;
        }
    }

    public final void dispatch() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).dispatch();
        }
    }

    private static final class PerListenerQueue<L>
    implements Runnable {
        final L listener;
        final Executor executor;
        final Queue<Event<L>> waitQueue = Queues.newArrayDeque();
        final Queue<Object> labelQueue = Queues.newArrayDeque();
        boolean isThreadScheduled;

        /*
         * WARNING - void declaration
         */
        PerListenerQueue(L listener, Executor executor) {
            void var2_2;
            void var1_1;
            this.listener = Preconditions.checkNotNull(var1_1);
            this.executor = (Executor)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        final synchronized void add(Event<L> event, Object label) {
            void var2_2;
            void var1_1;
            this.waitQueue.add((Event<L>)var1_1);
            this.labelQueue.add(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        final void dispatch() {
            void var1_1;
            boolean scheduleEventRunner = false;
            PerListenerQueue perListenerQueue = this;
            synchronized (perListenerQueue) {
                if (!this.isThreadScheduled) {
                    this.isThreadScheduled = true;
                    scheduleEventRunner = true;
                }
            }
            if (var1_1 != false) {
                try {
                    this.executor.execute(this);
                    return;
                }
                catch (RuntimeException e) {
                    void var2_5;
                    Object object = this;
                    synchronized (object) {
                        this.isThreadScheduled = false;
                    }
                    object = String.valueOf(this.listener);
                    String string = String.valueOf(this.executor);
                    logger.log(Level.SEVERE, new StringBuilder(42 + String.valueOf(object).length() + String.valueOf(string).length()).append("Exception while running callbacks for ").append((String)object).append(" on ").append(string).toString(), e);
                    throw var2_5;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            boolean stillRunning = true;
            try {
                while (true) {
                    String string;
                    PerListenerQueue perListenerQueue = this;
                    synchronized (perListenerQueue) {
                        Preconditions.checkState(this.isThreadScheduled);
                        Event<L> nextToRun = this.waitQueue.poll();
                        Object nextLabel = this.labelQueue.poll();
                        if (nextToRun == null) {
                            this.isThreadScheduled = false;
                            stillRunning = false;
                            break;
                        }
                    }
                    try {
                        string.call(this.listener);
                    }
                    catch (RuntimeException e) {
                        String string2;
                        string = String.valueOf(this.listener);
                        string2 = String.valueOf(string2);
                        logger.log(Level.SEVERE, new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Exception while executing callback: ").append(string).append(" ").append(string2).toString(), e);
                    }
                }
            }
            catch (Throwable throwable) {
                void var1_1;
                if (var1_1 != false) {
                    PerListenerQueue perListenerQueue = this;
                    synchronized (perListenerQueue) {
                        this.isThreadScheduled = false;
                    }
                }
                throw throwable;
            }
        }
    }

    static interface Event<L> {
        public void call(L var1);
    }
}

