/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ParametricNullness;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public class ListenableFutureTask<V>
extends FutureTask<V>
implements ListenableFuture<V> {
    private final ExecutionList executionList = new ExecutionList();

    public static <V> ListenableFutureTask<V> create(Callable<V> callable) {
        Callable<V> callable2;
        return new ListenableFutureTask<V>(callable2);
    }

    /*
     * WARNING - void declaration
     */
    public static <V> ListenableFutureTask<V> create(Runnable runnable, @ParametricNullness V result) {
        void var1_1;
        Runnable runnable2;
        return new ListenableFutureTask<void>(runnable2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    ListenableFutureTask(Callable<V> callable) {
        super(var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    ListenableFutureTask(Runnable runnable, @ParametricNullness V result) {
        super((Runnable)var1_1, var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addListener(Runnable listener, Executor exec) {
        void var2_2;
        void var1_1;
        this.executionList.add((Runnable)var1_1, (Executor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ParametricNullness
    public V get(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException, ExecutionException {
        long timeoutNanos = unit.toNanos(timeout);
        if (timeoutNanos <= 2147483647999999999L) {
            void var3_2;
            void var1_1;
            return super.get((long)var1_1, (TimeUnit)var3_2);
        }
        return super.get(Math.min(timeoutNanos, 2147483647999999999L), TimeUnit.NANOSECONDS);
    }

    @Override
    protected void done() {
        this.executionList.execute();
    }
}

