/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ForwardingFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class JdkFutureAdapters {
    public static <V> ListenableFuture<V> listenInPoolThread(Future<V> future) {
        Future<V> future2;
        if (future instanceof ListenableFuture) {
            return (ListenableFuture)future;
        }
        return new ListenableFutureAdapter<V>(future2);
    }

    /*
     * WARNING - void declaration
     */
    public static <V> ListenableFuture<V> listenInPoolThread(Future<V> future, Executor executor) {
        void var1_1;
        Future<V> future2;
        Preconditions.checkNotNull(executor);
        if (future instanceof ListenableFuture) {
            return (ListenableFuture)future;
        }
        return new ListenableFutureAdapter<V>(future2, (Executor)var1_1);
    }

    private JdkFutureAdapters() {
    }

    private static class ListenableFutureAdapter<V>
    extends ForwardingFuture<V>
    implements ListenableFuture<V> {
        private static final ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ListenableFutureAdapter-thread-%d").build();
        private static final Executor defaultAdapterExecutor = Executors.newCachedThreadPool(threadFactory);
        private final Executor adapterExecutor;
        private final ExecutionList executionList = new ExecutionList();
        private final AtomicBoolean hasListeners = new AtomicBoolean(false);
        private final Future<V> delegate;

        /*
         * WARNING - void declaration
         */
        ListenableFutureAdapter(Future<V> delegate) {
            this((Future<V>)var1_1, defaultAdapterExecutor);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        ListenableFutureAdapter(Future<V> delegate, Executor adapterExecutor) {
            void var2_2;
            void var1_1;
            this.delegate = (Future)Preconditions.checkNotNull(var1_1);
            this.adapterExecutor = (Executor)Preconditions.checkNotNull(var2_2);
        }

        @Override
        protected Future<V> delegate() {
            return this.delegate;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void addListener(Runnable listener, Executor exec) {
            void var2_2;
            void var1_1;
            this.executionList.add((Runnable)var1_1, (Executor)var2_2);
            if (this.hasListeners.compareAndSet(false, true)) {
                if (this.delegate.isDone()) {
                    this.executionList.execute();
                    return;
                }
                this.adapterExecutor.execute(() -> {
                    try {
                        Uninterruptibles.getUninterruptibly(this.delegate);
                    }
                    catch (Throwable throwable) {}
                    this.executionList.execute();
                });
            }
        }
    }
}

