/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.NullnessCasts;
import com.google.common.util.concurrent.ParametricNullness;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractOwnableSynchronizer;
import java.util.concurrent.locks.LockSupport;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class InterruptibleTask<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable DONE = new DoNothingRunnable();
    private static final Runnable PARKED = new DoNothingRunnable();
    private static final int MAX_BUSY_WAIT_SPINS = 1000;

    InterruptibleTask() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void run() {
        Object result;
        boolean run;
        Thread currentThread;
        block10: {
            currentThread = Thread.currentThread();
            if (!this.compareAndSet(null, currentThread)) {
                return;
            }
            run = !this.isDone();
            result = null;
            try {
                if (!run) break block10;
                result = this.runInterruptibly();
            }
            catch (Throwable throwable) {
                Throwable error = throwable;
                error = throwable;
                if (!this.compareAndSet(currentThread, DONE)) {
                    this.waitForInterrupt(currentThread);
                }
                if (run) {
                    void var3_3;
                    this.afterRanInterruptiblyFailure((Throwable)var3_3);
                    return;
                }
            }
            catch (Throwable throwable) {
                void var2_2;
                if (!this.compareAndSet(currentThread, DONE)) {
                    void var1_1;
                    this.waitForInterrupt((Thread)var1_1);
                }
                if (var2_2 != false) {
                    this.afterRanInterruptiblySuccess(NullnessCasts.uncheckedCastNullableTToT(null));
                }
                throw throwable;
            }
        }
        if (!this.compareAndSet(currentThread, DONE)) {
            this.waitForInterrupt(currentThread);
        }
        if (run) {
            this.afterRanInterruptiblySuccess(NullnessCasts.uncheckedCastNullableTToT(result));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitForInterrupt(Thread currentThread) {
        void var2_2;
        boolean restoreInterruptedBit = false;
        int spinCount = 0;
        Runnable state = (Runnable)this.get();
        Blocker blocker = null;
        while (state instanceof Blocker || state == PARKED) {
            if (state instanceof Blocker) {
                blocker = (Blocker)state;
            }
            if (++spinCount > 1000) {
                if (state == PARKED || this.compareAndSet(state, PARKED)) {
                    restoreInterruptedBit = Thread.interrupted() || restoreInterruptedBit;
                    LockSupport.park(blocker);
                }
            } else {
                Thread.yield();
            }
            state = (Runnable)this.get();
        }
        if (var2_2 != false) {
            void var1_1;
            var1_1.interrupt();
        }
    }

    abstract boolean isDone();

    @ParametricNullness
    abstract T runInterruptibly() throws Exception;

    abstract void afterRanInterruptiblySuccess(@ParametricNullness T var1);

    abstract void afterRanInterruptiblyFailure(Throwable var1);

    /*
     * WARNING - void declaration
     */
    final void interruptTask() {
        Runnable currentRunner = (Runnable)this.get();
        if (currentRunner instanceof Thread) {
            Runnable runnable;
            Blocker blocker = new Blocker(this);
            Blocker.access$200(blocker, Thread.currentThread());
            if (this.compareAndSet(currentRunner, runnable)) {
                try {
                    ((Thread)currentRunner).interrupt();
                }
                catch (Throwable throwable) {
                    Runnable runnable2 = this.getAndSet(DONE);
                    if (runnable2 == PARKED) {
                        void var1_1;
                        LockSupport.unpark((Thread)var1_1);
                    }
                    throw throwable;
                }
                runnable = this.getAndSet(DONE);
                if (runnable == PARKED) {
                    LockSupport.unpark((Thread)currentRunner);
                }
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        String string;
        String result;
        Runnable state = (Runnable)this.get();
        if (state == DONE) {
            result = "running=[DONE]";
        } else if (result instanceof Blocker) {
            result = "running=[INTERRUPTED]";
        } else if (result instanceof Thread) {
            string = ((Thread)((Object)result)).getName();
            result = new StringBuilder(21 + String.valueOf(string).length()).append("running=[RUNNING ON ").append(string).append("]").toString();
        } else {
            result = "running=[NOT STARTED YET]";
        }
        string = this.toPendingString();
        return new StringBuilder(2 + String.valueOf(result).length() + String.valueOf(string).length()).append((String)var1_1).append(", ").append(string).toString();
    }

    abstract String toPendingString();

    @VisibleForTesting
    static final class Blocker
    extends AbstractOwnableSynchronizer
    implements Runnable {
        private final InterruptibleTask<?> task;

        /*
         * WARNING - void declaration
         */
        private Blocker(InterruptibleTask<?> task) {
            void var1_1;
            this.task = var1_1;
        }

        @Override
        public final void run() {
        }

        /*
         * WARNING - void declaration
         */
        private void setOwner(Thread thread) {
            void var1_1;
            super.setExclusiveOwnerThread((Thread)var1_1);
        }

        public final String toString() {
            return this.task.toString();
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$200(Blocker x0, Thread x1) {
            void var1_1;
            x0.setOwner((Thread)var1_1);
        }
    }

    private static final class DoNothingRunnable
    implements Runnable {
        private DoNothingRunnable() {
        }

        @Override
        public final void run() {
        }
    }
}

