/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
final class FuturesGetChecked {
    private static final Ordering<Constructor<?>> WITH_STRING_PARAM_FIRST = Ordering.natural().onResultOf(new Function<Constructor<?>, Boolean>(){

        @Override
        public Boolean apply(Constructor<?> input) {
            return Arrays.asList(input.getParameterTypes()).contains(String.class);
        }
    }).reverse();

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    static <V, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass) throws X {
        void var1_1;
        Future<V> future2;
        return FuturesGetChecked.getChecked(FuturesGetChecked.bestGetCheckedTypeValidator(), future2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    @VisibleForTesting
    static <V, X extends Exception> V getChecked(GetCheckedTypeValidator validator, Future<V> future, Class<X> exceptionClass) throws X {
        validator.validateClass(exceptionClass);
        try {
            void var1_2;
            return var1_2.get();
        }
        catch (InterruptedException e) {
            void var0_1;
            Thread.currentThread().interrupt();
            throw FuturesGetChecked.newWithCause(exceptionClass, (Throwable)var0_1);
        }
        catch (ExecutionException executionException) {
            void var2_3;
            ExecutionException executionException2 = executionException;
            FuturesGetChecked.wrapAndThrowExceptionOrError(executionException.getCause(), var2_3);
            throw new AssertionError();
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    static <V, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass, long timeout, TimeUnit unit) throws X {
        FuturesGetChecked.bestGetCheckedTypeValidator().validateClass(exceptionClass);
        try {
            void var2_4;
            return future.get((long)var2_4, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw FuturesGetChecked.newWithCause(exceptionClass, e);
        }
        catch (TimeoutException e) {
            void var0_2;
            throw FuturesGetChecked.newWithCause(exceptionClass, (Throwable)var0_2);
        }
        catch (ExecutionException executionException) {
            void var1_3;
            ExecutionException executionException2 = executionException;
            FuturesGetChecked.wrapAndThrowExceptionOrError(executionException.getCause(), var1_3);
            throw new AssertionError();
        }
    }

    private static GetCheckedTypeValidator bestGetCheckedTypeValidator() {
        return GetCheckedTypeValidatorHolder.BEST_VALIDATOR;
    }

    @VisibleForTesting
    static GetCheckedTypeValidator weakSetValidator() {
        return GetCheckedTypeValidatorHolder.WeakSetValidator.INSTANCE;
    }

    @VisibleForTesting
    static GetCheckedTypeValidator classValueValidator() {
        return GetCheckedTypeValidatorHolder.ClassValueValidator.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static <X extends Exception> void wrapAndThrowExceptionOrError(Throwable cause, Class<X> exceptionClass) throws X {
        Throwable throwable;
        void var1_1;
        if (cause instanceof Error) {
            throw new ExecutionError((Error)cause);
        }
        if (cause instanceof RuntimeException) {
            throw new UncheckedExecutionException(cause);
        }
        throw FuturesGetChecked.newWithCause(var1_1, throwable);
    }

    private static boolean hasConstructorUsableByGetChecked(Class<? extends Exception> exceptionClass) {
        try {
            FuturesGetChecked.newWithCause(exceptionClass, new Exception());
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static <X extends Exception> X newWithCause(Class<X> exceptionClass, Throwable cause) {
        void var1_1;
        Class<X> clazz;
        Object object = Arrays.asList(exceptionClass.getConstructors());
        for (Constructor constructor : FuturesGetChecked.preferringStrings(object)) {
            Exception constructor2 = (Exception)FuturesGetChecked.newFromConstructor(constructor, cause);
            if (constructor2 == null) continue;
            if (constructor2.getCause() == null) {
                constructor2.initCause(cause);
            }
            return (X)constructor2;
        }
        object = String.valueOf(clazz);
        throw new IllegalArgumentException(new StringBuilder(82 + String.valueOf(object).length()).append("No appropriate constructor for exception of type ").append((String)object).append(" in response to chained exception").toString(), (Throwable)var1_1);
    }

    private static <X extends Exception> List<Constructor<X>> preferringStrings(List<Constructor<X>> constructors) {
        List<Constructor<X>> list;
        return WITH_STRING_PARAM_FIRST.sortedCopy(list);
    }

    /*
     * WARNING - void declaration
     */
    private static <X> X newFromConstructor(Constructor<X> constructor, Throwable cause) {
        Class<?>[] paramTypes = constructor.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> paramType = paramTypes[i];
            if (paramType.equals(String.class)) {
                params[i] = cause.toString();
                continue;
            }
            if (paramType.equals(Throwable.class)) {
                params[i] = cause;
                continue;
            }
            return null;
        }
        try {
            void var3_3;
            Constructor<X> constructor2;
            return constructor2.newInstance((Object[])var3_3);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            return null;
        }
    }

    @VisibleForTesting
    static boolean isCheckedException(Class<? extends Exception> type) {
        Class<? extends Exception> clazz;
        return !RuntimeException.class.isAssignableFrom(clazz);
    }

    @VisibleForTesting
    static void checkExceptionClassValidity(Class<? extends Exception> exceptionClass) {
        Class<? extends Exception> clazz;
        Preconditions.checkArgument(FuturesGetChecked.isCheckedException(exceptionClass), "Futures.getChecked exception type (%s) must not be a RuntimeException", exceptionClass);
        Preconditions.checkArgument(FuturesGetChecked.hasConstructorUsableByGetChecked(exceptionClass), "Futures.getChecked exception type (%s) must be an accessible class with an accessible constructor whose parameters (if any) must be of type String and/or Throwable", clazz);
    }

    private FuturesGetChecked() {
    }

    @VisibleForTesting
    static class GetCheckedTypeValidatorHolder {
        static final String CLASS_VALUE_VALIDATOR_NAME = String.valueOf(GetCheckedTypeValidatorHolder.class.getName()).concat("$ClassValueValidator");
        static final GetCheckedTypeValidator BEST_VALIDATOR = GetCheckedTypeValidatorHolder.getBestValidator();

        GetCheckedTypeValidatorHolder() {
        }

        static GetCheckedTypeValidator getBestValidator() {
            try {
                Class<Enum> clazz = Class.forName(CLASS_VALUE_VALIDATOR_NAME).asSubclass(Enum.class);
                return (GetCheckedTypeValidator)((Object)clazz.getEnumConstants()[0]);
            }
            catch (Throwable throwable) {
                return FuturesGetChecked.weakSetValidator();
            }
        }

        static enum WeakSetValidator implements GetCheckedTypeValidator
        {
            INSTANCE;

            private static final Set<WeakReference<Class<? extends Exception>>> validClasses;

            /*
             * WARNING - void declaration
             */
            @Override
            public final void validateClass(Class<? extends Exception> exceptionClass) {
                void var1_1;
                for (WeakReference<Class<? extends Exception>> knownGood : validClasses) {
                    void var3_3;
                    if (!exceptionClass.equals(var3_3.get())) continue;
                    return;
                }
                FuturesGetChecked.checkExceptionClassValidity(exceptionClass);
                if (validClasses.size() > 1000) {
                    validClasses.clear();
                }
                validClasses.add(new WeakReference<void>(var1_1));
            }

            static {
                validClasses = new CopyOnWriteArraySet<WeakReference<Class<? extends Exception>>>();
            }
        }

        static enum ClassValueValidator implements GetCheckedTypeValidator
        {
            INSTANCE;

            private static final ClassValue<Boolean> isValidClass;

            /*
             * WARNING - void declaration
             */
            @Override
            public final void validateClass(Class<? extends Exception> exceptionClass) {
                void var1_1;
                isValidClass.get((Class<?>)var1_1);
            }

            static {
                isValidClass = new ClassValue<Boolean>(){

                    @Override
                    protected Boolean computeValue(Class<?> type) {
                        FuturesGetChecked.checkExceptionClassValidity(type.asSubclass(Exception.class));
                        return Boolean.TRUE;
                    }
                };
            }
        }
    }

    @VisibleForTesting
    static interface GetCheckedTypeValidator {
        public void validateClass(Class<? extends Exception> var1);
    }
}

