/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.AbstractCatchingFuture;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AbstractTransformFuture;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.CollectionFuture;
import com.google.common.util.concurrent.CombinedFuture;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.FuturesGetChecked;
import com.google.common.util.concurrent.GwtFuturesCatchingSpecialization;
import com.google.common.util.concurrent.ImmediateFuture;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.Partially;
import com.google.common.util.concurrent.TimeoutFuture;
import com.google.common.util.concurrent.TrustedListenableFutureTask;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.common.util.concurrent.internal.InternalFutureFailureAccess;
import com.google.common.util.concurrent.internal.InternalFutures;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Futures
extends GwtFuturesCatchingSpecialization {
    private Futures() {
    }

    public static <V> ListenableFuture<V> immediateFuture(@ParametricNullness V value) {
        V v;
        if (value == null) {
            value = ImmediateFuture.NULL;
            return value;
        }
        return new ImmediateFuture<V>(v);
    }

    public static ListenableFuture<Void> immediateVoidFuture() {
        return ImmediateFuture.NULL;
    }

    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Throwable throwable2;
        Preconditions.checkNotNull(throwable);
        return new ImmediateFuture.ImmediateFailedFuture(throwable2);
    }

    /*
     * WARNING - void declaration
     */
    public static <V> ListenableFuture<V> immediateCancelledFuture() {
        ImmediateFuture.ImmediateCancelledFuture<Object> instance = ImmediateFuture.ImmediateCancelledFuture.INSTANCE;
        if (instance != null) {
            void var0;
            return var0;
        }
        return new ImmediateFuture.ImmediateCancelledFuture();
    }

    /*
     * WARNING - void declaration
     */
    public static <O> ListenableFuture<O> submit(Callable<O> callable, Executor executor) {
        TrustedListenableFutureTask<O> trustedListenableFutureTask;
        void var1_1;
        TrustedListenableFutureTask<O> task = TrustedListenableFutureTask.create(callable);
        var1_1.execute(task);
        return trustedListenableFutureTask;
    }

    /*
     * WARNING - void declaration
     */
    public static ListenableFuture<Void> submit(Runnable runnable, Executor executor) {
        TrustedListenableFutureTask<Object> trustedListenableFutureTask;
        void var1_1;
        TrustedListenableFutureTask<Object> task = TrustedListenableFutureTask.create(runnable, null);
        var1_1.execute(task);
        return trustedListenableFutureTask;
    }

    /*
     * WARNING - void declaration
     */
    public static <O> ListenableFuture<O> submitAsync(AsyncCallable<O> callable, Executor executor) {
        TrustedListenableFutureTask<O> trustedListenableFutureTask;
        void var1_1;
        TrustedListenableFutureTask<O> task = TrustedListenableFutureTask.create(callable);
        var1_1.execute(task);
        return trustedListenableFutureTask;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <O> ListenableFuture<O> scheduleAsync(AsyncCallable<O> callable, Duration delay, ScheduledExecutorService executorService) {
        void var2_2;
        void var1_1;
        return Futures.scheduleAsync(callable, Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS, (ScheduledExecutorService)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <O> ListenableFuture<O> scheduleAsync(AsyncCallable<O> callable, long delay, TimeUnit timeUnit, ScheduledExecutorService executorService) {
        TrustedListenableFutureTask<O> trustedListenableFutureTask;
        void var1_2;
        void var3_3;
        TrustedListenableFutureTask<O> task = TrustedListenableFutureTask.create(callable);
        ScheduledFuture<?> scheduled = executorService.schedule(task, delay, (TimeUnit)var3_3);
        ((AbstractFuture)task).addListener(new Runnable((Future)var1_2){
            final /* synthetic */ Future val$scheduled;
            {
                this.val$scheduled = future;
            }

            @Override
            public void run() {
                this.val$scheduled.cancel(false);
            }
        }, MoreExecutors.directExecutor());
        return trustedListenableFutureTask;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @Partially.GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catching(ListenableFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> fallback, Executor executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return AbstractCatchingFuture.create(input, var1_1, var2_2, (Executor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @Partially.GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    public static <V, X extends Throwable> ListenableFuture<V> catchingAsync(ListenableFuture<? extends V> input, Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback, Executor executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return AbstractCatchingFuture.create(input, var1_1, var2_2, (Executor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static <V> ListenableFuture<V> withTimeout(ListenableFuture<V> delegate, Duration time, ScheduledExecutorService scheduledExecutor) {
        void var2_2;
        void var1_1;
        return Futures.withTimeout(delegate, Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS, (ScheduledExecutorService)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static <V> ListenableFuture<V> withTimeout(ListenableFuture<V> delegate, long time, TimeUnit unit, ScheduledExecutorService scheduledExecutor) {
        void var3_2;
        void var1_1;
        ListenableFuture<V> listenableFuture;
        if (delegate.isDone()) {
            return delegate;
        }
        return TimeoutFuture.create(listenableFuture, (long)var1_1, (TimeUnit)var3_2, scheduledExecutor);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function, Executor executor) {
        void var2_2;
        void var1_1;
        return AbstractTransformFuture.create(input, var1_1, (Executor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> input, Function<? super I, ? extends O> function, Executor executor) {
        void var2_2;
        void var1_1;
        return AbstractTransformFuture.create(input, var1_1, (Executor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static <I, O> Future<O> lazyTransform(Future<I> input, Function<? super I, ? extends O> function) {
        void var1_1;
        Future<I> future;
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(function);
        return new Future<O>((Function)var1_1){
            final /* synthetic */ Function val$function;
            {
                this.val$function = function;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                void var1_1;
                return future.cancel((boolean)var1_1);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public O get() throws InterruptedException, ExecutionException {
                2 v0 = this;
                return v0.applyTransformation(v0.future.get());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public O get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                void var3_2;
                void var1_1;
                2 v0 = this;
                return v0.applyTransformation(v0.future.get((long)var1_1, (TimeUnit)var3_2));
            }

            /*
             * WARNING - void declaration
             */
            private O applyTransformation(I input) throws ExecutionException {
                try {
                    return this.val$function.apply(input);
                }
                catch (Throwable t) {
                    void var1_2;
                    throw new ExecutionException((Throwable)var1_2);
                }
            }
        };
    }

    @SafeVarargs
    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(ListenableFuture<? extends V> ... futures) {
        Object object;
        CollectionFuture.ListFuture<? extends V> listFuture = new CollectionFuture.ListFuture<V>(ImmutableList.copyOf(object), true);
        object = listFuture;
        object = listFuture;
        return listFuture;
    }

    @Beta
    public static <V> ListenableFuture<List<V>> allAsList(Iterable<? extends ListenableFuture<? extends V>> futures) {
        CollectionFuture.ListFuture listFuture;
        CollectionFuture.ListFuture listFuture2 = new CollectionFuture.ListFuture(ImmutableList.copyOf(listFuture), true);
        listFuture = listFuture2;
        listFuture = listFuture2;
        return listFuture2;
    }

    @SafeVarargs
    @Beta
    public static <V> FutureCombiner<V> whenAllComplete(ListenableFuture<? extends V> ... futures) {
        ListenableFuture<? extends V>[] listenableFutureArray;
        return new FutureCombiner(false, ImmutableList.copyOf(listenableFutureArray));
    }

    @Beta
    public static <V> FutureCombiner<V> whenAllComplete(Iterable<? extends ListenableFuture<? extends V>> futures) {
        Iterable<? extends ListenableFuture<? extends V>> iterable;
        return new FutureCombiner(false, ImmutableList.copyOf(iterable));
    }

    @SafeVarargs
    @Beta
    public static <V> FutureCombiner<V> whenAllSucceed(ListenableFuture<? extends V> ... futures) {
        ListenableFuture<? extends V>[] listenableFutureArray;
        return new FutureCombiner(true, ImmutableList.copyOf(listenableFutureArray));
    }

    @Beta
    public static <V> FutureCombiner<V> whenAllSucceed(Iterable<? extends ListenableFuture<? extends V>> futures) {
        Iterable<? extends ListenableFuture<? extends V>> iterable;
        return new FutureCombiner(true, ImmutableList.copyOf(iterable));
    }

    /*
     * WARNING - void declaration
     */
    public static <V> ListenableFuture<V> nonCancellationPropagating(ListenableFuture<V> future) {
        void var1_1;
        ListenableFuture<V> listenableFuture;
        if (future.isDone()) {
            return future;
        }
        NonCancellationPropagatingFuture<V> output = new NonCancellationPropagatingFuture<V>(future);
        listenableFuture.addListener(output, MoreExecutors.directExecutor());
        return var1_1;
    }

    @SafeVarargs
    @Beta
    public static <V> ListenableFuture<List<V>> successfulAsList(ListenableFuture<? extends V> ... futures) {
        ListenableFuture<? extends V>[] listenableFutureArray;
        return new CollectionFuture.ListFuture<V>(ImmutableList.copyOf(listenableFutureArray), false);
    }

    @Beta
    public static <V> ListenableFuture<List<V>> successfulAsList(Iterable<? extends ListenableFuture<? extends V>> futures) {
        Iterable<? extends ListenableFuture<? extends V>> iterable;
        return new CollectionFuture.ListFuture(ImmutableList.copyOf(iterable), false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> ImmutableList<ListenableFuture<T>> inCompletionOrder(Iterable<? extends ListenableFuture<? extends T>> futures) {
        void var3_6;
        ListenableFuture[] copy = Futures.gwtCompatibleToArray(futures);
        final InCompletionOrderState state = new InCompletionOrderState(copy);
        ImmutableList.Builder delegatesBuilder = ImmutableList.builderWithExpectedSize(copy.length);
        for (int i = 0; i < copy.length; ++i) {
            delegatesBuilder.add(new InCompletionOrderFuture(state));
        }
        ImmutableCollection delegates = delegatesBuilder.build();
        for (int i = 0; i < copy.length; ++i) {
            int localI = i;
            copy[i].addListener(new Runnable((ImmutableList)delegates, localI){
                final /* synthetic */ ImmutableList val$delegates;
                final /* synthetic */ int val$localI;
                {
                    this.val$delegates = immutableList;
                    this.val$localI = n;
                }

                @Override
                public void run() {
                    InCompletionOrderState.access$300(state, this.val$delegates, this.val$localI);
                }
            }, MoreExecutors.directExecutor());
        }
        void var2_4 = var3_6;
        return var2_4;
    }

    private static <T> ListenableFuture<? extends T>[] gwtCompatibleToArray(Iterable<? extends ListenableFuture<? extends T>> futures) {
        ImmutableList<ListenableFuture<ListenableFuture>> immutableList;
        ImmutableList<ListenableFuture<ListenableFuture>> collection;
        collection = futures instanceof Collection ? (ImmutableList<ListenableFuture<ListenableFuture>>)futures : ImmutableList.copyOf(collection);
        return immutableList.toArray(new ListenableFuture[0]);
    }

    /*
     * WARNING - void declaration
     */
    public static <V> void addCallback(ListenableFuture<V> future, FutureCallback<? super V> callback, Executor executor) {
        void var2_2;
        void var1_1;
        ListenableFuture<V> listenableFuture;
        Preconditions.checkNotNull(callback);
        future.addListener(new CallbackListener<V>(listenableFuture, var1_1), (Executor)var2_2);
    }

    @ParametricNullness
    public static <V> V getDone(Future<V> future) throws ExecutionException {
        Future<V> future2;
        Preconditions.checkState(future.isDone(), "Future was expected to be done: %s", future);
        return Uninterruptibles.getUninterruptibly(future2);
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    @Beta
    @GwtIncompatible
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass) throws X {
        void var1_1;
        return FuturesGetChecked.getChecked(future, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    @Beta
    @GwtIncompatible
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass, Duration timeout) throws X {
        void var2_2;
        void var1_1;
        return Futures.getChecked(future, var1_1, Internal.toNanosSaturated((Duration)var2_2), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    @Beta
    @GwtIncompatible
    public static <V, X extends Exception> V getChecked(Future<V> future, Class<X> exceptionClass, long timeout, TimeUnit unit) throws X {
        void var2_2;
        void var1_1;
        return FuturesGetChecked.getChecked(future, var1_1, (long)var2_2, unit);
    }

    @ParametricNullness
    public static <V> V getUnchecked(Future<V> future) {
        ExecutionException executionException;
        Preconditions.checkNotNull(future);
        try {
            return Uninterruptibles.getUninterruptibly(executionException);
        }
        catch (ExecutionException executionException2) {
            executionException = executionException2;
            Futures.wrapAndThrowUnchecked(executionException2.getCause());
            throw new AssertionError();
        }
    }

    private static void wrapAndThrowUnchecked(Throwable cause) {
        Throwable throwable;
        if (cause instanceof Error) {
            throw new ExecutionError((Error)cause);
        }
        throw new UncheckedExecutionException(throwable);
    }

    private static final class CallbackListener<V>
    implements Runnable {
        final Future<V> future;
        final FutureCallback<? super V> callback;

        /*
         * WARNING - void declaration
         */
        CallbackListener(Future<V> future, FutureCallback<? super V> callback) {
            void var2_2;
            void var1_1;
            this.future = var1_1;
            this.callback = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            void var1_1;
            Throwable failure;
            if (this.future instanceof InternalFutureFailureAccess && (failure = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)((InternalFutureFailureAccess)this.future))) != null) {
                this.callback.onFailure(failure);
                return;
            }
            try {
                V value = Futures.getDone(this.future);
            }
            catch (ExecutionException e) {
                this.callback.onFailure(e.getCause());
                return;
            }
            catch (Error | RuntimeException e) {
                this.callback.onFailure(e);
                return;
            }
            this.callback.onSuccess(var1_1);
        }

        public final String toString() {
            return MoreObjects.toStringHelper(this).addValue(this.callback).toString();
        }
    }

    private static final class InCompletionOrderState<T> {
        private boolean wasCancelled = false;
        private boolean shouldInterrupt = true;
        private final AtomicInteger incompleteOutputCount;
        private final ListenableFuture<? extends T>[] inputFutures;
        private volatile int delegateIndex = 0;

        /*
         * WARNING - void declaration
         */
        private InCompletionOrderState(ListenableFuture<? extends T>[] inputFutures) {
            void var1_1;
            this.inputFutures = inputFutures;
            this.incompleteOutputCount = new AtomicInteger(((void)var1_1).length);
        }

        /*
         * WARNING - void declaration
         */
        private void recordOutputCancellation(boolean interruptIfRunning) {
            void var1_1;
            this.wasCancelled = true;
            if (var1_1 == false) {
                this.shouldInterrupt = false;
            }
            this.recordCompletion();
        }

        /*
         * WARNING - void declaration
         */
        private void recordInputCompletion(ImmutableList<AbstractFuture<T>> delegates, int inputFutureIndex) {
            void var1_1;
            ListenableFuture<? extends T> inputFuture = Objects.requireNonNull(this.inputFutures[inputFutureIndex]);
            this.inputFutures[inputFutureIndex] = null;
            for (int i = this.delegateIndex; i < delegates.size(); ++i) {
                if (!((AbstractFuture)delegates.get(i)).setFuture(inputFuture)) continue;
                this.recordCompletion();
                this.delegateIndex = i + 1;
                return;
            }
            this.delegateIndex = var1_1.size();
        }

        private void recordCompletion() {
            if (this.incompleteOutputCount.decrementAndGet() == 0 && this.wasCancelled) {
                ListenableFuture<? extends T>[] listenableFutureArray = this.inputFutures;
                int n = this.inputFutures.length;
                for (int i = 0; i < n; ++i) {
                    ListenableFuture<T> toCancel = listenableFutureArray[i];
                    if (toCancel == null) continue;
                    toCancel.cancel(this.shouldInterrupt);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$300(InCompletionOrderState x0, ImmutableList x1, int x2) {
            void var2_2;
            void var1_1;
            x0.recordInputCompletion((ImmutableList)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$400(InCompletionOrderState x0, boolean x1) {
            void var1_1;
            x0.recordOutputCancellation((boolean)var1_1);
        }
    }

    private static final class InCompletionOrderFuture<T>
    extends AbstractFuture<T> {
        private InCompletionOrderState<T> state;

        /*
         * WARNING - void declaration
         */
        private InCompletionOrderFuture(InCompletionOrderState<T> state) {
            void var1_1;
            this.state = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean cancel(boolean interruptIfRunning) {
            InCompletionOrderState<T> localState = this.state;
            if (super.cancel(interruptIfRunning)) {
                void var1_1;
                void var2_2;
                InCompletionOrderState.access$400((InCompletionOrderState)Objects.requireNonNull(var2_2), (boolean)var1_1);
                return true;
            }
            return false;
        }

        @Override
        protected final void afterDone() {
            this.state = null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final String pendingToString() {
            InCompletionOrderState<T> localState = this.state;
            if (localState != null) {
                void var1_1;
                int n = ((InCompletionOrderState)localState).inputFutures.length;
                int n2 = ((InCompletionOrderState)var1_1).incompleteOutputCount.get();
                return new StringBuilder(49).append("inputCount=[").append(n).append("], remaining=[").append(n2).append("]").toString();
            }
            return null;
        }
    }

    private static final class NonCancellationPropagatingFuture<V>
    extends AbstractFuture.TrustedFuture<V>
    implements Runnable {
        private ListenableFuture<V> delegate;

        /*
         * WARNING - void declaration
         */
        NonCancellationPropagatingFuture(ListenableFuture<V> delegate) {
            void var1_1;
            this.delegate = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            ListenableFuture<V> localDelegate = this.delegate;
            if (localDelegate != null) {
                void var1_1;
                this.setFuture(var1_1);
            }
        }

        @Override
        protected final String pendingToString() {
            ListenableFuture<V> localDelegate = this.delegate;
            if (localDelegate != null) {
                String string;
                string = String.valueOf(string);
                return new StringBuilder(11 + String.valueOf(string).length()).append("delegate=[").append(string).append("]").toString();
            }
            return null;
        }

        @Override
        protected final void afterDone() {
            this.delegate = null;
        }
    }

    @Beta
    @GwtCompatible
    public static final class FutureCombiner<V> {
        private final boolean allMustSucceed;
        private final ImmutableList<ListenableFuture<? extends V>> futures;

        /*
         * WARNING - void declaration
         */
        private FutureCombiner(boolean allMustSucceed, ImmutableList<ListenableFuture<? extends V>> futures) {
            void var2_2;
            void var1_1;
            this.allMustSucceed = var1_1;
            this.futures = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final <C> ListenableFuture<C> callAsync(AsyncCallable<C> combiner, Executor executor) {
            void var1_1;
            void var2_2;
            return new CombinedFuture((ImmutableCollection<? extends ListenableFuture<?>>)((ImmutableCollection<ListenableFuture<?>>)this.futures), this.allMustSucceed, (Executor)var2_2, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final <C> ListenableFuture<C> call(Callable<C> combiner, Executor executor) {
            void var1_1;
            void var2_2;
            return new CombinedFuture((ImmutableCollection<? extends ListenableFuture<?>>)((ImmutableCollection<ListenableFuture<?>>)this.futures), this.allMustSucceed, (Executor)var2_2, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final ListenableFuture<?> run(Runnable combiner, Executor executor) {
            void var2_2;
            void var1_1;
            return this.call(new Callable<Void>(this, (Runnable)var1_1){
                final /* synthetic */ Runnable val$combiner;
                {
                    this.val$combiner = runnable;
                }

                @Override
                public Void call() throws Exception {
                    this.val$combiner.run();
                    return null;
                }
            }, (Executor)var2_2);
        }
    }
}

