/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingObject;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ParametricNullness;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingFuture<V>
extends ForwardingObject
implements Future<V> {
    protected ForwardingFuture() {
    }

    @Override
    protected abstract Future<? extends V> delegate();

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        void var1_1;
        return this.delegate().cancel((boolean)var1_1);
    }

    @Override
    public boolean isCancelled() {
        return this.delegate().isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.delegate().isDone();
    }

    @Override
    @ParametricNullness
    public V get() throws InterruptedException, ExecutionException {
        return this.delegate().get();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ParametricNullness
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        void var3_2;
        void var1_1;
        return this.delegate().get((long)var1_1, (TimeUnit)var3_2);
    }

    public static abstract class SimpleForwardingFuture<V>
    extends ForwardingFuture<V> {
        private final Future<V> delegate;

        /*
         * WARNING - void declaration
         */
        protected SimpleForwardingFuture(Future<V> delegate) {
            void var1_1;
            this.delegate = (Future)Preconditions.checkNotNull(var1_1);
        }

        @Override
        protected final Future<V> delegate() {
            return this.delegate;
        }
    }
}

