/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ForwardingFluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.GwtFluentFutureCatchingSpecialization;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.Partially;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class FluentFuture<V>
extends GwtFluentFutureCatchingSpecialization<V> {
    FluentFuture() {
    }

    public static <V> FluentFuture<V> from(ListenableFuture<V> future) {
        ListenableFuture<V> listenableFuture;
        if (future instanceof FluentFuture) {
            return (FluentFuture)future;
        }
        return new ForwardingFluentFuture<V>(listenableFuture);
    }

    @Deprecated
    public static <V> FluentFuture<V> from(FluentFuture<V> future) {
        return Preconditions.checkNotNull(future);
    }

    /*
     * WARNING - void declaration
     */
    @Partially.GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    @Beta
    public final <X extends Throwable> FluentFuture<V> catching(Class<X> exceptionType, Function<? super X, ? extends V> fallback, Executor executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return (FluentFuture)Futures.catching(this, var1_1, var2_2, (Executor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Partially.GwtIncompatible(value="AVAILABLE but requires exceptionType to be Throwable.class")
    @Beta
    public final <X extends Throwable> FluentFuture<V> catchingAsync(Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback, Executor executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return (FluentFuture)Futures.catchingAsync(this, var1_1, var2_2, (Executor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    @Beta
    public final FluentFuture<V> withTimeout(Duration timeout, ScheduledExecutorService scheduledExecutor) {
        void var2_2;
        void var1_1;
        return this.withTimeout(Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS, (ScheduledExecutorService)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    @Beta
    public final FluentFuture<V> withTimeout(long timeout, TimeUnit unit, ScheduledExecutorService scheduledExecutor) {
        void var3_2;
        void var1_1;
        return (FluentFuture)Futures.withTimeout(this, (long)var1_1, (TimeUnit)var3_2, scheduledExecutor);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public final <T> FluentFuture<T> transformAsync(AsyncFunction<? super V, T> function, Executor executor) {
        void var2_2;
        void var1_1;
        return (FluentFuture)Futures.transformAsync(this, var1_1, (Executor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public final <T> FluentFuture<T> transform(Function<? super V, T> function, Executor executor) {
        void var2_2;
        void var1_1;
        return (FluentFuture)Futures.transform(this, var1_1, (Executor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void addCallback(FutureCallback<? super V> callback, Executor executor) {
        void var2_2;
        void var1_1;
        Futures.addCallback(this, var1_1, (Executor)var2_2);
    }

    static abstract class TrustedFuture<V>
    extends FluentFuture<V>
    implements AbstractFuture.Trusted<V> {
        TrustedFuture() {
        }

        @Override
        @ParametricNullness
        public final V get() throws InterruptedException, ExecutionException {
            return super.get();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            void var3_2;
            void var1_1;
            return super.get((long)var1_1, (TimeUnit)var3_2);
        }

        @Override
        public final boolean isDone() {
            return super.isDone();
        }

        @Override
        public final boolean isCancelled() {
            return super.isCancelled();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void addListener(Runnable listener, Executor executor) {
            void var2_2;
            void var1_1;
            super.addListener((Runnable)var1_1, (Executor)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean cancel(boolean mayInterruptIfRunning) {
            void var1_1;
            return super.cancel((boolean)var1_1);
        }
    }
}

