/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.TimeLimiter;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class FakeTimeLimiter
implements TimeLimiter {
    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T newProxy(T target, Class<T> interfaceType, long timeoutDuration, TimeUnit timeoutUnit) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(target);
        Preconditions.checkNotNull(var2_2);
        Preconditions.checkNotNull(timeoutUnit);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ParametricNullness
    public final <T> T callWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            return callable.call();
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
        catch (Throwable e) {
            void var1_5;
            throw new ExecutionException((Throwable)var1_5);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ParametricNullness
    public final <T> T callUninterruptiblyWithTimeout(Callable<T> callable, long timeoutDuration, TimeUnit timeoutUnit) throws ExecutionException {
        void var2_2;
        void var1_1;
        return this.callWithTimeout((Callable<T>)var1_1, (long)var2_2, timeoutUnit);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void runWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) {
        Preconditions.checkNotNull(runnable);
        Preconditions.checkNotNull(timeoutUnit);
        try {
            runnable.run();
            return;
        }
        catch (RuntimeException e) {
            throw new UncheckedExecutionException(e);
        }
        catch (Error e) {
            throw new ExecutionError(e);
        }
        catch (Throwable e) {
            void var1_4;
            throw new UncheckedExecutionException((Throwable)var1_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void runUninterruptiblyWithTimeout(Runnable runnable, long timeoutDuration, TimeUnit timeoutUnit) {
        void var2_2;
        void var1_1;
        this.runWithTimeout((Runnable)var1_1, (long)var2_2, timeoutUnit);
    }
}

