/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.TrustedListenableFutureTask;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;

@ElementTypesAreNonnullByDefault
public final class ExecutionSequencer {
    private final AtomicReference<ListenableFuture<Void>> ref = new AtomicReference<ListenableFuture<Void>>(Futures.immediateVoidFuture());
    private ThreadConfinedTaskQueue latestTaskQueue = new ThreadConfinedTaskQueue();

    private ExecutionSequencer() {
    }

    public static ExecutionSequencer create() {
        return new ExecutionSequencer();
    }

    /*
     * WARNING - void declaration
     */
    public final <T> ListenableFuture<T> submit(Callable<T> callable, Executor executor) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(executor);
        return this.submitAsync(new AsyncCallable<T>(this, (Callable)var1_1){
            final /* synthetic */ Callable val$callable;
            {
                this.val$callable = callable;
            }

            @Override
            public ListenableFuture<T> call() throws Exception {
                return Futures.immediateFuture(this.val$callable.call());
            }

            public String toString() {
                return this.val$callable.toString();
            }
        }, (Executor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> ListenableFuture<T> submitAsync(final AsyncCallable<T> callable, Executor executor) {
        void var2_2;
        void var1_1;
        void var3_3;
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(executor);
        final TaskNonReentrantExecutor taskExecutor = new TaskNonReentrantExecutor(executor, this);
        AsyncCallable task = new AsyncCallable<T>(this){

            @Override
            public ListenableFuture<T> call() throws Exception {
                if (!taskExecutor.trySetStarted()) {
                    return Futures.immediateCancelledFuture();
                }
                return callable.call();
            }

            public String toString() {
                return callable.toString();
            }
        };
        SettableFuture newFuture = SettableFuture.create();
        ListenableFuture oldFuture = this.ref.getAndSet(newFuture);
        TrustedListenableFutureTask taskFuture = TrustedListenableFutureTask.create(task);
        oldFuture.addListener(taskFuture, taskExecutor);
        ListenableFuture outputFuture = Futures.nonCancellationPropagating(taskFuture);
        Runnable listener = () -> ExecutionSequencer.lambda$submitAsync$0(taskFuture, (SettableFuture)var3_3, oldFuture, outputFuture, taskExecutor);
        outputFuture.addListener(listener, MoreExecutors.directExecutor());
        var1_1.addListener((Runnable)var2_2, MoreExecutors.directExecutor());
        return outputFuture;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$submitAsync$0(TrustedListenableFutureTask taskFuture, SettableFuture newFuture, ListenableFuture oldFuture, ListenableFuture outputFuture, TaskNonReentrantExecutor taskExecutor) {
        void var3_3;
        if (((AbstractFuture)taskFuture).isDone()) {
            void var2_2;
            void var1_1;
            var1_1.setFuture(var2_2);
            return;
        }
        if (var3_3.isCancelled() && taskExecutor.trySetCancelled()) {
            TrustedListenableFutureTask trustedListenableFutureTask;
            ((AbstractFuture)trustedListenableFutureTask).cancel(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ThreadConfinedTaskQueue access$302(ExecutionSequencer x0, ThreadConfinedTaskQueue x1) {
        void var1_1;
        x0.latestTaskQueue = var1_1;
        return x0.latestTaskQueue;
    }

    private static final class TaskNonReentrantExecutor
    extends AtomicReference<RunningState>
    implements Runnable,
    Executor {
        ExecutionSequencer sequencer;
        Executor delegate;
        Runnable task;
        Thread submitting;

        /*
         * WARNING - void declaration
         */
        private TaskNonReentrantExecutor(Executor delegate, ExecutionSequencer sequencer) {
            super(RunningState.NOT_RUN);
            void var2_2;
            void var1_1;
            this.delegate = var1_1;
            this.sequencer = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void execute(Runnable task) {
            if (this.get() == RunningState.CANCELLED) {
                this.delegate = null;
                this.sequencer = null;
                return;
            }
            this.submitting = Thread.currentThread();
            try {
                ThreadConfinedTaskQueue submittingTaskQueue = Objects.requireNonNull(this.sequencer).latestTaskQueue;
                if (submittingTaskQueue.thread == this.submitting) {
                    this.sequencer = null;
                    Preconditions.checkState(submittingTaskQueue.nextTask == null);
                    submittingTaskQueue.nextTask = task;
                    submittingTaskQueue.nextExecutor = Objects.requireNonNull(this.delegate);
                    this.delegate = null;
                } else {
                    void var2_3;
                    void var1_1;
                    Executor localDelegate = Objects.requireNonNull(this.delegate);
                    this.delegate = null;
                    this.task = var1_1;
                    var2_3.execute(this);
                }
                return;
            }
            finally {
                this.submitting = null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            Thread currentThread = Thread.currentThread();
            if (currentThread != this.submitting) {
                Runnable localTask = Objects.requireNonNull(this.task);
                this.task = null;
                localTask.run();
                return;
            }
            ThreadConfinedTaskQueue executingTaskQueue = new ThreadConfinedTaskQueue();
            new ThreadConfinedTaskQueue().thread = currentThread;
            ExecutionSequencer.access$302(Objects.requireNonNull(this.sequencer), executingTaskQueue);
            this.sequencer = null;
            try {
                Executor queuedExecutor;
                Runnable queuedTask;
                Runnable localTask = Objects.requireNonNull(this.task);
                this.task = null;
                localTask.run();
                while ((queuedTask = executingTaskQueue.nextTask) != null && (queuedExecutor = executingTaskQueue.nextExecutor) != null) {
                    void var1_1;
                    void var3_5;
                    executingTaskQueue.nextTask = null;
                    executingTaskQueue.nextExecutor = null;
                    var3_5.execute((Runnable)var1_1);
                }
                executingTaskQueue.thread = null;
                return;
            }
            catch (Throwable throwable) {
                var2_4.thread = null;
                throw throwable;
            }
        }

        private boolean trySetStarted() {
            return this.compareAndSet(RunningState.NOT_RUN, RunningState.STARTED);
        }

        private boolean trySetCancelled() {
            return this.compareAndSet(RunningState.NOT_RUN, RunningState.CANCELLED);
        }
    }

    static enum RunningState {
        NOT_RUN,
        CANCELLED,
        STARTED;

    }

    private static final class ThreadConfinedTaskQueue {
        Thread thread;
        Runnable nextTask;
        Executor nextExecutor;

        private ThreadConfinedTaskQueue() {
        }
    }
}

