/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class ExecutionList {
    private static final Logger log = Logger.getLogger(ExecutionList.class.getName());
    private RunnableExecutorPair runnables;
    private boolean executed;

    /*
     * WARNING - void declaration
     */
    public final void add(Runnable runnable, Executor executor) {
        void var2_3;
        void var1_1;
        Preconditions.checkNotNull(runnable, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        ExecutionList executionList = this;
        synchronized (executionList) {
            if (!this.executed) {
                this.runnables = new RunnableExecutorPair(runnable, executor, this.runnables);
                return;
            }
        }
        ExecutionList.executeListener((Runnable)var1_1, (Executor)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    public final void execute() {
        RunnableExecutorPair list;
        ExecutionList executionList = this;
        synchronized (executionList) {
            if (this.executed) {
                return;
            }
            this.executed = true;
            list = this.runnables;
            this.runnables = null;
        }
        RunnableExecutorPair reversedList = null;
        while (list != null) {
            void var3_4;
            RunnableExecutorPair tmp = list;
            list = list.next;
            tmp.next = reversedList;
            reversedList = var3_4;
        }
        while (reversedList != null) {
            ExecutionList.executeListener(reversedList.runnable, reversedList.executor);
            reversedList = reversedList.next;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void executeListener(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
            return;
        }
        catch (RuntimeException e) {
            void var2_2;
            String string;
            String string2;
            string2 = String.valueOf(string2);
            string = String.valueOf(string);
            log.log(Level.SEVERE, new StringBuilder(57 + String.valueOf(string2).length() + String.valueOf(string).length()).append("RuntimeException while executing runnable ").append(string2).append(" with executor ").append(string).toString(), (Throwable)var2_2);
            return;
        }
    }

    private static final class RunnableExecutorPair {
        final Runnable runnable;
        final Executor executor;
        RunnableExecutorPair next;

        /*
         * WARNING - void declaration
         */
        RunnableExecutorPair(Runnable runnable, Executor executor, RunnableExecutorPair next) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.runnable = var1_1;
            this.executor = var2_2;
            this.next = var3_3;
        }
    }
}

