/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public class CycleDetectingLockFactory {
    private static final ConcurrentMap<Class<? extends Enum<?>>, Map<? extends Enum<?>, LockGraphNode>> lockGraphNodesPerType = new MapMaker().weakKeys().makeMap();
    private static final Logger logger = Logger.getLogger(CycleDetectingLockFactory.class.getName());
    final Policy policy;
    private static final ThreadLocal<ArrayList<LockGraphNode>> acquiredLocks = new ThreadLocal<ArrayList<LockGraphNode>>(){

        @Override
        protected ArrayList<LockGraphNode> initialValue() {
            return Lists.newArrayListWithCapacity(3);
        }
    };

    public static CycleDetectingLockFactory newInstance(Policy policy) {
        Policy policy2;
        return new CycleDetectingLockFactory(policy2);
    }

    /*
     * WARNING - void declaration
     */
    public ReentrantLock newReentrantLock(String lockName) {
        void var1_1;
        return this.newReentrantLock((String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public ReentrantLock newReentrantLock(String lockName, boolean fair) {
        void var2_2;
        void var1_1;
        if (this.policy == Policies.DISABLED) {
            return new ReentrantLock(fair);
        }
        return new CycleDetectingReentrantLock(this, new LockGraphNode((String)var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ReentrantReadWriteLock newReentrantReadWriteLock(String lockName) {
        void var1_1;
        return this.newReentrantReadWriteLock((String)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public ReentrantReadWriteLock newReentrantReadWriteLock(String lockName, boolean fair) {
        void var2_2;
        void var1_1;
        if (this.policy == Policies.DISABLED) {
            return new ReentrantReadWriteLock(fair);
        }
        return new CycleDetectingReentrantReadWriteLock(this, new LockGraphNode((String)var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Enum<E>> WithExplicitOrdering<E> newInstanceWithExplicitOrdering(Class<E> enumClass, Policy policy) {
        Map<E, LockGraphNode> map;
        void var1_1;
        Preconditions.checkNotNull(enumClass);
        Preconditions.checkNotNull(policy);
        Map<E, LockGraphNode> lockGraphNodes = CycleDetectingLockFactory.getOrCreateNodes(enumClass);
        return new WithExplicitOrdering((Policy)var1_1, map);
    }

    /*
     * WARNING - void declaration
     */
    private static <E extends Enum<E>> Map<? extends E, LockGraphNode> getOrCreateNodes(Class<E> clazz) {
        void var2_2;
        Class<E> clazz2;
        Map<E, LockGraphNode> map;
        Map existing = (Map)lockGraphNodesPerType.get(clazz);
        if (existing != null) {
            return map;
        }
        Map<E, LockGraphNode> created = CycleDetectingLockFactory.createNodes(clazz);
        map = lockGraphNodesPerType.putIfAbsent(clazz2, created);
        return (Map)MoreObjects.firstNonNull(map, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static <E extends Enum<E>> Map<E, LockGraphNode> createNodes(Class<E> clazz) {
        void var1_2;
        int i;
        EnumMap<E, LockGraphNode> map = Maps.newEnumMap(clazz);
        Enum[] keys = (Enum[])clazz.getEnumConstants();
        int numKeys = keys.length;
        ArrayList<LockGraphNode> nodes = Lists.newArrayListWithCapacity(numKeys);
        for (Enum key : keys) {
            LockGraphNode node = new LockGraphNode(CycleDetectingLockFactory.getLockName(key));
            nodes.add(node);
            map.put(key, node);
        }
        for (i = 1; i < numKeys; ++i) {
            ((LockGraphNode)nodes.get(i)).checkAcquiredLocks(Policies.THROW, nodes.subList(0, i));
        }
        for (i = 0; i < numKeys - 1; ++i) {
            ((LockGraphNode)nodes.get(i)).checkAcquiredLocks(Policies.DISABLED, nodes.subList(i + 1, numKeys));
        }
        return Collections.unmodifiableMap(var1_2);
    }

    private static String getLockName(Enum<?> rank) {
        String string;
        String string2 = rank.getDeclaringClass().getSimpleName();
        string = ((Enum)((Object)string)).name();
        return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(".").append(string).toString();
    }

    /*
     * WARNING - void declaration
     */
    private CycleDetectingLockFactory(Policy policy) {
        void var1_1;
        this.policy = (Policy)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void aboutToAcquire(CycleDetectingLock lock) {
        if (!lock.isAcquiredByCurrentThread()) {
            void var1_1;
            void var2_2;
            ArrayList<LockGraphNode> acquiredLockList = acquiredLocks.get();
            LockGraphNode node = lock.getLockGraphNode();
            node.checkAcquiredLocks(this.policy, acquiredLockList);
            var2_2.add(var1_1);
        }
    }

    private static void lockStateChanged(CycleDetectingLock lock) {
        if (!lock.isAcquiredByCurrentThread()) {
            ArrayList<LockGraphNode> acquiredLockList = acquiredLocks.get();
            LockGraphNode node = lock.getLockGraphNode();
            for (int i = acquiredLockList.size() - 1; i >= 0; --i) {
                if (acquiredLockList.get(i) != node) continue;
                acquiredLockList.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$600(CycleDetectingLockFactory x0, CycleDetectingLock x1) {
        void var1_1;
        x0.aboutToAcquire((CycleDetectingLock)var1_1);
    }

    private class CycleDetectingReentrantWriteLock
    extends ReentrantReadWriteLock.WriteLock {
        final CycleDetectingReentrantReadWriteLock readWriteLock;

        /*
         * WARNING - void declaration
         */
        CycleDetectingReentrantWriteLock(CycleDetectingReentrantReadWriteLock readWriteLock) {
            void var2_2;
            super(readWriteLock);
            this.readWriteLock = var2_2;
        }

        @Override
        public void lock() {
            CycleDetectingLockFactory.access$600(CycleDetectingLockFactory.this, this.readWriteLock);
            try {
                super.lock();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            CycleDetectingLockFactory.access$600(CycleDetectingLockFactory.this, this.readWriteLock);
            try {
                super.lockInterruptibly();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public boolean tryLock() {
            CycleDetectingLockFactory.access$600(CycleDetectingLockFactory.this, this.readWriteLock);
            try {
                boolean bl = super.tryLock();
                return bl;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            CycleDetectingLockFactory.access$600(CycleDetectingLockFactory.this, this.readWriteLock);
            try {
                void var3_4;
                void var1_1;
                boolean bl = super.tryLock((long)var1_1, (TimeUnit)var3_4);
                return bl;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public void unlock() {
            try {
                super.unlock();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }
    }

    private class CycleDetectingReentrantReadLock
    extends ReentrantReadWriteLock.ReadLock {
        final CycleDetectingReentrantReadWriteLock readWriteLock;

        /*
         * WARNING - void declaration
         */
        CycleDetectingReentrantReadLock(CycleDetectingReentrantReadWriteLock readWriteLock) {
            void var2_2;
            super(readWriteLock);
            this.readWriteLock = var2_2;
        }

        @Override
        public void lock() {
            CycleDetectingLockFactory.access$600(CycleDetectingLockFactory.this, this.readWriteLock);
            try {
                super.lock();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            CycleDetectingLockFactory.access$600(CycleDetectingLockFactory.this, this.readWriteLock);
            try {
                super.lockInterruptibly();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public boolean tryLock() {
            CycleDetectingLockFactory.access$600(CycleDetectingLockFactory.this, this.readWriteLock);
            try {
                boolean bl = super.tryLock();
                return bl;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            CycleDetectingLockFactory.access$600(CycleDetectingLockFactory.this, this.readWriteLock);
            try {
                void var3_4;
                void var1_1;
                boolean bl = super.tryLock((long)var1_1, (TimeUnit)var3_4);
                return bl;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }

        @Override
        public void unlock() {
            try {
                super.unlock();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this.readWriteLock);
            }
        }
    }

    final class CycleDetectingReentrantReadWriteLock
    extends ReentrantReadWriteLock
    implements CycleDetectingLock {
        private final CycleDetectingReentrantReadLock readLock;
        private final CycleDetectingReentrantWriteLock writeLock;
        private final LockGraphNode lockGraphNode;

        /*
         * WARNING - void declaration
         */
        private CycleDetectingReentrantReadWriteLock(CycleDetectingLockFactory this$0, LockGraphNode lockGraphNode, boolean fair) {
            super((boolean)var3_3);
            void var2_2;
            void var1_1;
            void var3_3;
            this.readLock = this$0.new CycleDetectingReentrantReadLock(this);
            this.writeLock = (CycleDetectingLockFactory)var1_1.new CycleDetectingReentrantWriteLock(this);
            this.lockGraphNode = (LockGraphNode)Preconditions.checkNotNull(var2_2);
        }

        @Override
        public final ReentrantReadWriteLock.ReadLock readLock() {
            return this.readLock;
        }

        @Override
        public final ReentrantReadWriteLock.WriteLock writeLock() {
            return this.writeLock;
        }

        @Override
        public final LockGraphNode getLockGraphNode() {
            return this.lockGraphNode;
        }

        @Override
        public final boolean isAcquiredByCurrentThread() {
            return this.isWriteLockedByCurrentThread() || this.getReadHoldCount() > 0;
        }
    }

    final class CycleDetectingReentrantLock
    extends ReentrantLock
    implements CycleDetectingLock {
        private final LockGraphNode lockGraphNode;
        final /* synthetic */ CycleDetectingLockFactory this$0;

        /*
         * WARNING - void declaration
         */
        private CycleDetectingReentrantLock(CycleDetectingLockFactory this$0, LockGraphNode lockGraphNode, boolean fair) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.this$0 = var1_1;
            super((boolean)var3_3);
            this.lockGraphNode = (LockGraphNode)Preconditions.checkNotNull(var2_2);
        }

        @Override
        public final LockGraphNode getLockGraphNode() {
            return this.lockGraphNode;
        }

        @Override
        public final boolean isAcquiredByCurrentThread() {
            return this.isHeldByCurrentThread();
        }

        @Override
        public final void lock() {
            CycleDetectingLockFactory.access$600(this.this$0, this);
            try {
                super.lock();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this);
            }
        }

        @Override
        public final void lockInterruptibly() throws InterruptedException {
            CycleDetectingLockFactory.access$600(this.this$0, this);
            try {
                super.lockInterruptibly();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this);
            }
        }

        @Override
        public final boolean tryLock() {
            CycleDetectingLockFactory.access$600(this.this$0, this);
            try {
                boolean bl = super.tryLock();
                return bl;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
            CycleDetectingLockFactory.access$600(this.this$0, this);
            try {
                void var3_4;
                void var1_1;
                boolean bl = super.tryLock((long)var1_1, (TimeUnit)var3_4);
                return bl;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this);
            }
        }

        @Override
        public final void unlock() {
            try {
                super.unlock();
                return;
            }
            finally {
                CycleDetectingLockFactory.lockStateChanged(this);
            }
        }
    }

    private static class LockGraphNode {
        final Map<LockGraphNode, ExampleStackTrace> allowedPriorLocks = new MapMaker().weakKeys().makeMap();
        final Map<LockGraphNode, PotentialDeadlockException> disallowedPriorLocks = new MapMaker().weakKeys().makeMap();
        final String lockName;

        /*
         * WARNING - void declaration
         */
        LockGraphNode(String lockName) {
            void var1_1;
            this.lockName = (String)Preconditions.checkNotNull(var1_1);
        }

        String getLockName() {
            return this.lockName;
        }

        /*
         * WARNING - void declaration
         */
        void checkAcquiredLocks(Policy policy, List<LockGraphNode> acquiredLocks) {
            for (LockGraphNode acquiredLock : acquiredLocks) {
                void var3_3;
                this.checkAcquiredLock(policy, (LockGraphNode)var3_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        void checkAcquiredLock(Policy policy, LockGraphNode acquiredLock) {
            void var3_3;
            void var1_1;
            void var2_2;
            PotentialDeadlockException exception;
            Preconditions.checkState(this != acquiredLock, "Attempted to acquire multiple locks with the same rank %s", (Object)acquiredLock.getLockName());
            if (this.allowedPriorLocks.containsKey(acquiredLock)) {
                return;
            }
            PotentialDeadlockException previousDeadlockException = this.disallowedPriorLocks.get(acquiredLock);
            if (previousDeadlockException != null) {
                exception = new PotentialDeadlockException(acquiredLock, this, previousDeadlockException.getConflictingStackTrace());
                policy.handlePotentialDeadlock(exception);
                return;
            }
            Set<LockGraphNode> seen = Sets.newIdentityHashSet();
            ExampleStackTrace path = acquiredLock.findPathTo(this, seen);
            if (path == null) {
                this.allowedPriorLocks.put(acquiredLock, new ExampleStackTrace(acquiredLock, this));
                return;
            }
            exception = new PotentialDeadlockException(acquiredLock, this, path);
            this.disallowedPriorLocks.put((LockGraphNode)var2_2, exception);
            var1_1.handlePotentialDeadlock((PotentialDeadlockException)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private ExampleStackTrace findPathTo(LockGraphNode node, Set<LockGraphNode> seen) {
            if (!seen.add(this)) {
                return null;
            }
            ExampleStackTrace found = this.allowedPriorLocks.get(node);
            if (found != null) {
                return found;
            }
            for (Map.Entry<LockGraphNode, ExampleStackTrace> entry : this.allowedPriorLocks.entrySet()) {
                void var1_1;
                void var3_3;
                LockGraphNode preAcquiredLock = entry.getKey();
                found = preAcquiredLock.findPathTo(node, seen);
                if (found == null) continue;
                ExampleStackTrace path = new ExampleStackTrace(preAcquiredLock, this);
                path.setStackTrace(entry.getValue().getStackTrace());
                path.initCause((Throwable)var3_3);
                return var1_1;
            }
            return null;
        }
    }

    private static interface CycleDetectingLock {
        public LockGraphNode getLockGraphNode();

        public boolean isAcquiredByCurrentThread();
    }

    @Beta
    public static final class PotentialDeadlockException
    extends ExampleStackTrace {
        private final ExampleStackTrace conflictingStackTrace;

        /*
         * WARNING - void declaration
         */
        private PotentialDeadlockException(LockGraphNode node1, LockGraphNode node2, ExampleStackTrace conflictingStackTrace) {
            super((LockGraphNode)var1_1, (LockGraphNode)var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.conflictingStackTrace = conflictingStackTrace;
            this.initCause((Throwable)var3_3);
        }

        public final ExampleStackTrace getConflictingStackTrace() {
            return this.conflictingStackTrace;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String getMessage() {
            void var1_1;
            StringBuilder message = new StringBuilder(Objects.requireNonNull(super.getMessage()));
            for (Throwable t = this.conflictingStackTrace; t != null; t = t.getCause()) {
                message.append(", ").append(t.getMessage());
            }
            return var1_1.toString();
        }
    }

    private static class ExampleStackTrace
    extends IllegalStateException {
        static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
        static final ImmutableSet<String> EXCLUDED_CLASS_NAMES = ImmutableSet.of(CycleDetectingLockFactory.class.getName(), ExampleStackTrace.class.getName(), LockGraphNode.class.getName());

        ExampleStackTrace(LockGraphNode node1, LockGraphNode node2) {
            node1 = ((LockGraphNode)node1).getLockName();
            node2 = ((LockGraphNode)node2).getLockName();
            super(new StringBuilder(4 + String.valueOf(node1).length() + String.valueOf(node2).length()).append((String)node1).append(" -> ").append((String)node2).toString());
            StackTraceElement[] origStackTrace = this.getStackTrace();
            int n = origStackTrace.length;
            for (int i = 0; i < n; ++i) {
                if (WithExplicitOrdering.class.getName().equals(origStackTrace[i].getClassName())) {
                    this.setStackTrace(EMPTY_STACK_TRACE);
                    return;
                }
                if (EXCLUDED_CLASS_NAMES.contains(origStackTrace[i].getClassName())) continue;
                this.setStackTrace(Arrays.copyOfRange(origStackTrace, i, n));
                return;
            }
        }
    }

    @Beta
    public static final class WithExplicitOrdering<E extends Enum<E>>
    extends CycleDetectingLockFactory {
        private final Map<E, LockGraphNode> lockGraphNodes;

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        WithExplicitOrdering(Policy policy, Map<E, LockGraphNode> lockGraphNodes) {
            super((Policy)var1_1);
            void var2_2;
            void var1_1;
            this.lockGraphNodes = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final ReentrantLock newReentrantLock(E rank) {
            void var1_1;
            return this.newReentrantLock(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        public final ReentrantLock newReentrantLock(E rank, boolean fair) {
            void var2_2;
            void var1_1;
            if (this.policy == Policies.DISABLED) {
                return new ReentrantLock(fair);
            }
            WithExplicitOrdering withExplicitOrdering = this;
            return new CycleDetectingReentrantLock(withExplicitOrdering, Objects.requireNonNull(withExplicitOrdering.lockGraphNodes.get(var1_1)), (boolean)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final ReentrantReadWriteLock newReentrantReadWriteLock(E rank) {
            void var1_1;
            return this.newReentrantReadWriteLock(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        public final ReentrantReadWriteLock newReentrantReadWriteLock(E rank, boolean fair) {
            void var2_2;
            void var1_1;
            if (this.policy == Policies.DISABLED) {
                return new ReentrantReadWriteLock(fair);
            }
            WithExplicitOrdering withExplicitOrdering = this;
            return new CycleDetectingReentrantReadWriteLock(withExplicitOrdering, Objects.requireNonNull(withExplicitOrdering.lockGraphNodes.get(var1_1)), (boolean)var2_2);
        }
    }

    @Beta
    public static enum Policies implements Policy
    {
        THROW{

            @Override
            public final void handlePotentialDeadlock(PotentialDeadlockException e) {
                throw e;
            }
        }
        ,
        WARN{

            /*
             * WARNING - void declaration
             */
            @Override
            public final void handlePotentialDeadlock(PotentialDeadlockException e) {
                void var1_1;
                logger.log(Level.SEVERE, "Detected potential deadlock", (Throwable)var1_1);
            }
        }
        ,
        DISABLED{

            @Override
            public final void handlePotentialDeadlock(PotentialDeadlockException e) {
            }
        };

    }

    @Beta
    public static interface Policy {
        public void handlePotentialDeadlock(PotentialDeadlockException var1);
    }
}

