/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AggregateFuture;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.InterruptibleTask;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ParametricNullness;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class CombinedFuture<V>
extends AggregateFuture<Object, V> {
    private CombinedFutureInterruptibleTask<?> task;

    /*
     * WARNING - void declaration
     */
    CombinedFuture(ImmutableCollection<? extends ListenableFuture<?>> futures, boolean allMustSucceed, Executor listenerExecutor, AsyncCallable<V> callable) {
        super(var1_1, (boolean)var2_2, false);
        void var3_3;
        void var2_2;
        void var1_1;
        this.task = new AsyncCallableInterruptibleTask(callable, (Executor)var3_3);
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    CombinedFuture(ImmutableCollection<? extends ListenableFuture<?>> futures, boolean allMustSucceed, Executor listenerExecutor, Callable<V> callable) {
        super(var1_1, (boolean)var2_2, false);
        void var3_3;
        void var2_2;
        void var1_1;
        this.task = new CallableInterruptibleTask(callable, (Executor)var3_3);
        this.init();
    }

    @Override
    final void collectOneValue(int index, Object returnValue) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void handleAllCompleted() {
        CombinedFutureInterruptibleTask<?> localTask = this.task;
        if (localTask != null) {
            void var1_1;
            var1_1.execute();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void releaseResources(AggregateFuture.ReleaseResourcesReason reason) {
        void var1_1;
        super.releaseResources(reason);
        if (var1_1 == AggregateFuture.ReleaseResourcesReason.OUTPUT_FUTURE_DONE) {
            this.task = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final void interruptTask() {
        CombinedFutureInterruptibleTask<?> localTask = this.task;
        if (localTask != null) {
            void var1_1;
            var1_1.interruptTask();
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ CombinedFutureInterruptibleTask access$002(CombinedFuture x0, CombinedFutureInterruptibleTask x1) {
        void var1_1;
        x0.task = var1_1;
        return x0.task;
    }

    private final class CallableInterruptibleTask
    extends CombinedFutureInterruptibleTask<V> {
        private final Callable<V> callable;

        /*
         * WARNING - void declaration
         */
        CallableInterruptibleTask(Callable<V> callable, Executor listenerExecutor) {
            void var2_2;
            void var3_3;
            super((Executor)var3_3);
            this.callable = (Callable)Preconditions.checkNotNull(var2_2);
        }

        @Override
        @ParametricNullness
        final V runInterruptibly() throws Exception {
            return this.callable.call();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void setValue(@ParametricNullness V value) {
            void var1_1;
            CombinedFuture.this.set(var1_1);
        }

        @Override
        final String toPendingString() {
            return this.callable.toString();
        }
    }

    private final class AsyncCallableInterruptibleTask
    extends CombinedFutureInterruptibleTask<ListenableFuture<V>> {
        private final AsyncCallable<V> callable;

        /*
         * WARNING - void declaration
         */
        AsyncCallableInterruptibleTask(AsyncCallable<V> callable, Executor listenerExecutor) {
            void var2_2;
            void var3_3;
            super((Executor)var3_3);
            this.callable = (AsyncCallable)Preconditions.checkNotNull(var2_2);
        }

        @Override
        final ListenableFuture<V> runInterruptibly() throws Exception {
            ListenableFuture listenableFuture = this.callable.call();
            return Preconditions.checkNotNull(listenableFuture, "AsyncCallable.call returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", this.callable);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void setValue(ListenableFuture<V> value) {
            void var1_1;
            CombinedFuture.this.setFuture(var1_1);
        }

        @Override
        final String toPendingString() {
            return this.callable.toString();
        }
    }

    private abstract class CombinedFutureInterruptibleTask<T>
    extends InterruptibleTask<T> {
        private final Executor listenerExecutor;

        /*
         * WARNING - void declaration
         */
        CombinedFutureInterruptibleTask(Executor listenerExecutor) {
            void var2_2;
            this.listenerExecutor = (Executor)Preconditions.checkNotNull(var2_2);
        }

        @Override
        final boolean isDone() {
            return ((AbstractFuture)CombinedFuture.this).isDone();
        }

        /*
         * WARNING - void declaration
         */
        final void execute() {
            try {
                this.listenerExecutor.execute(this);
                return;
            }
            catch (RejectedExecutionException e) {
                void var1_1;
                CombinedFuture.this.setException((Throwable)var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void afterRanInterruptiblySuccess(@ParametricNullness T result) {
            void var1_1;
            CombinedFuture.access$002(CombinedFuture.this, null);
            this.setValue(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void afterRanInterruptiblyFailure(Throwable error) {
            void var1_1;
            CombinedFuture.access$002(CombinedFuture.this, null);
            if (error instanceof ExecutionException) {
                CombinedFuture.this.setException(((ExecutionException)error).getCause());
                return;
            }
            if (error instanceof CancellationException) {
                ((AbstractFuture)CombinedFuture.this).cancel(false);
                return;
            }
            CombinedFuture.this.setException((Throwable)var1_1);
        }

        abstract void setValue(@ParametricNullness T var1);
    }
}

