/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AggregateFuture;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ParametricNullness;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    private List<Present<V>> values;

    /*
     * WARNING - void declaration
     */
    CollectionFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
        super(futures, allMustSucceed, true);
        void var2_3;
        List values = futures.isEmpty() ? Collections.emptyList() : Lists.newArrayListWithCapacity(futures.size());
        for (int i = 0; i < futures.size(); ++i) {
            values.add(null);
        }
        this.values = var2_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void collectOneValue(int index, @ParametricNullness V returnValue) {
        List<Present<V>> localValues = this.values;
        if (localValues != null) {
            void var2_2;
            void var1_1;
            void var3_3;
            var3_3.set((int)var1_1, new Present<void>(var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void handleAllCompleted() {
        List<Present<V>> localValues = this.values;
        if (localValues != null) {
            void var1_1;
            CollectionFuture collectionFuture = this;
            collectionFuture.set(collectionFuture.combine((List<Present<V>>)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void releaseResources(AggregateFuture.ReleaseResourcesReason reason) {
        void var1_1;
        super.releaseResources((AggregateFuture.ReleaseResourcesReason)var1_1);
        this.values = null;
    }

    abstract C combine(List<Present<V>> var1);

    private static final class Present<V> {
        V value;

        /*
         * WARNING - void declaration
         */
        Present(V value) {
            void var1_1;
            this.value = var1_1;
        }
    }

    static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        /*
         * WARNING - void declaration
         */
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            super(var1_1, (boolean)var2_2);
            void var2_2;
            void var1_1;
            this.init();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final List<V> combine(List<Present<V>> values) {
            void var2_2;
            Iterator iterator;
            ArrayList<Object> result = Lists.newArrayListWithCapacity(values.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Present element = (Present)iterator.next();
                result.add(element != null ? (Object)var3_3.value : null);
            }
            return Collections.unmodifiableList(var2_2);
        }
    }
}

