/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.TrustedListenableFutureTask;
import java.io.Closeable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
public final class ClosingFuture<V> {
    private static final Logger logger = Logger.getLogger(ClosingFuture.class.getName());
    private final AtomicReference<State> state = new AtomicReference<State>(State.OPEN);
    private final CloseableList closeables = new CloseableList();
    private final FluentFuture<V> future;

    /*
     * WARNING - void declaration
     */
    public static <V> ClosingFuture<V> submit(ClosingCallable<V> callable, Executor executor) {
        void var1_1;
        ClosingCallable<V> closingCallable;
        return new ClosingFuture<V>(closingCallable, (Executor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <V> ClosingFuture<V> submitAsync(AsyncClosingCallable<V> callable, Executor executor) {
        void var1_1;
        AsyncClosingCallable<V> asyncClosingCallable;
        return new ClosingFuture<V>(asyncClosingCallable, (Executor)var1_1);
    }

    public static <V> ClosingFuture<V> from(ListenableFuture<V> future) {
        ListenableFuture<V> listenableFuture;
        return new ClosingFuture<V>(listenableFuture);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static <C> ClosingFuture<C> eventuallyClosing(ListenableFuture<C> future, Executor closingExecutor) {
        void var2_2;
        void var1_1;
        ListenableFuture<C> listenableFuture;
        Preconditions.checkNotNull(closingExecutor);
        final ClosingFuture<C> closingFuture = new ClosingFuture<C>(Futures.nonCancellationPropagating(future));
        Futures.addCallback(listenableFuture, new FutureCallback<AutoCloseable>((Executor)var1_1){
            final /* synthetic */ Executor val$closingExecutor;
            {
                this.val$closingExecutor = executor;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onSuccess(AutoCloseable result) {
                void var1_1;
                closingFuture.closeables.closer.eventuallyClose(var1_1, this.val$closingExecutor);
            }

            @Override
            public void onFailure(Throwable t) {
            }
        }, MoreExecutors.directExecutor());
        return var2_2;
    }

    public static Combiner whenAllComplete(Iterable<? extends ClosingFuture<?>> futures) {
        Iterable<? extends ClosingFuture<?>> iterable;
        return new Combiner(false, iterable);
    }

    /*
     * WARNING - void declaration
     */
    public static Combiner whenAllComplete(ClosingFuture<?> future1, ClosingFuture<?> ... moreFutures) {
        void var1_1;
        return ClosingFuture.whenAllComplete(Lists.asList(future1, var1_1));
    }

    public static Combiner whenAllSucceed(Iterable<? extends ClosingFuture<?>> futures) {
        Iterable<? extends ClosingFuture<?>> iterable;
        return new Combiner(true, iterable);
    }

    /*
     * WARNING - void declaration
     */
    public static <V1, V2> Combiner2<V1, V2> whenAllSucceed(ClosingFuture<V1> future1, ClosingFuture<V2> future2) {
        void var1_1;
        ClosingFuture<V1> closingFuture;
        return new Combiner2(closingFuture, (ClosingFuture)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <V1, V2, V3> Combiner3<V1, V2, V3> whenAllSucceed(ClosingFuture<V1> future1, ClosingFuture<V2> future2, ClosingFuture<V3> future3) {
        void var2_2;
        void var1_1;
        ClosingFuture<V1> closingFuture;
        return new Combiner3(closingFuture, (ClosingFuture)var1_1, (ClosingFuture)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <V1, V2, V3, V4> Combiner4<V1, V2, V3, V4> whenAllSucceed(ClosingFuture<V1> future1, ClosingFuture<V2> future2, ClosingFuture<V3> future3, ClosingFuture<V4> future4) {
        void var3_3;
        void var2_2;
        void var1_1;
        ClosingFuture<V1> closingFuture;
        return new Combiner4(closingFuture, (ClosingFuture)var1_1, (ClosingFuture)var2_2, (ClosingFuture)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <V1, V2, V3, V4, V5> Combiner5<V1, V2, V3, V4, V5> whenAllSucceed(ClosingFuture<V1> future1, ClosingFuture<V2> future2, ClosingFuture<V3> future3, ClosingFuture<V4> future4, ClosingFuture<V5> future5) {
        void var3_3;
        void var2_2;
        void var1_1;
        ClosingFuture<V1> closingFuture;
        return new Combiner5(closingFuture, (ClosingFuture)var1_1, (ClosingFuture)var2_2, (ClosingFuture)var3_3, future5);
    }

    /*
     * WARNING - void declaration
     */
    public static Combiner whenAllSucceed(ClosingFuture<?> future1, ClosingFuture<?> future2, ClosingFuture<?> future3, ClosingFuture<?> future4, ClosingFuture<?> future5, ClosingFuture<?> future6, ClosingFuture<?> ... moreFutures) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ClosingFuture.whenAllSucceed(FluentIterable.of(future1, var1_1, var2_2, var3_3, future5, future6).append(moreFutures));
    }

    /*
     * WARNING - void declaration
     */
    private ClosingFuture(ListenableFuture<V> future) {
        void var1_1;
        this.future = FluentFuture.from(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private ClosingFuture(ClosingCallable<V> callable, Executor executor) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(callable);
        TrustedListenableFutureTask task = TrustedListenableFutureTask.create(new Callable<V>(this, callable){
            final /* synthetic */ ClosingCallable val$callable;
            final /* synthetic */ ClosingFuture this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$callable = closingCallable;
            }

            @Override
            @ParametricNullness
            public V call() throws Exception {
                return this.val$callable.call(this.this$0.closeables.closer);
            }

            public String toString() {
                return this.val$callable.toString();
            }
        });
        var2_2.execute(task);
        this.future = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ClosingFuture(AsyncClosingCallable<V> callable, Executor executor) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(callable);
        TrustedListenableFutureTask task = TrustedListenableFutureTask.create(new AsyncCallable<V>(this, callable){
            final /* synthetic */ AsyncClosingCallable val$callable;
            final /* synthetic */ ClosingFuture this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$callable = asyncClosingCallable;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ListenableFuture<V> call() throws Exception {
                CloseableList newCloseables = new CloseableList();
                try {
                    FluentFuture fluentFuture;
                    ClosingFuture closingFuture = this.val$callable.call(newCloseables.closer);
                    ClosingFuture.access$1000(closingFuture, this.this$0.closeables);
                    fluentFuture = ((ClosingFuture)((Object)fluentFuture)).future;
                    this.this$0.closeables.add(newCloseables, MoreExecutors.directExecutor());
                    return fluentFuture;
                }
                catch (Throwable throwable) {
                    void var1_1;
                    this.this$0.closeables.add((AutoCloseable)var1_1, MoreExecutors.directExecutor());
                    throw throwable;
                }
            }

            public String toString() {
                return this.val$callable.toString();
            }
        });
        var2_2.execute(task);
        this.future = var1_1;
    }

    public final ListenableFuture<?> statusFuture() {
        return Futures.nonCancellationPropagating(this.future.transform(Functions.constant(null), MoreExecutors.directExecutor()));
    }

    /*
     * WARNING - void declaration
     */
    public final <U> ClosingFuture<U> transform(ClosingFunction<? super V, U> function, Executor executor) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(function);
        AsyncFunction applyFunction = new AsyncFunction<V, U>(this, function){
            final /* synthetic */ ClosingFunction val$function;
            final /* synthetic */ ClosingFuture this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$function = closingFunction;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ListenableFuture<U> apply(V input) throws Exception {
                void var1_1;
                return this.this$0.closeables.applyClosingFunction(this.val$function, var1_1);
            }

            public String toString() {
                return this.val$function.toString();
            }
        };
        ClosingFuture closingFuture = this;
        return closingFuture.derive(closingFuture.future.transformAsync(var1_1, (Executor)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final <U> ClosingFuture<U> transformAsync(AsyncClosingFunction<? super V, U> function, Executor executor) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(function);
        AsyncFunction applyFunction = new AsyncFunction<V, U>(this, function){
            final /* synthetic */ AsyncClosingFunction val$function;
            final /* synthetic */ ClosingFuture this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$function = asyncClosingFunction;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ListenableFuture<U> apply(V input) throws Exception {
                void var1_1;
                return this.this$0.closeables.applyAsyncClosingFunction(this.val$function, var1_1);
            }

            public String toString() {
                return this.val$function.toString();
            }
        };
        ClosingFuture closingFuture = this;
        return closingFuture.derive(closingFuture.future.transformAsync(var1_1, (Executor)var2_2));
    }

    public static <V, U> AsyncClosingFunction<V, U> withoutCloser(AsyncFunction<V, U> function) {
        AsyncFunction<V, U> asyncFunction;
        Preconditions.checkNotNull(function);
        return new AsyncClosingFunction<V, U>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public ClosingFuture<U> apply(DeferredCloser closer, V input) throws Exception {
                void var2_2;
                return ClosingFuture.from(asyncFunction.apply(var2_2));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public final <X extends Throwable> ClosingFuture<V> catching(Class<X> exceptionType, ClosingFunction<? super X, ? extends V> fallback, Executor executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.catchingMoreGeneric((Class<X>)var1_1, (ClosingFunction)var2_2, (Executor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private <X extends Throwable, W extends V> ClosingFuture<V> catchingMoreGeneric(Class<X> exceptionType, ClosingFunction<? super X, W> fallback, Executor executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(fallback);
        AsyncFunction applyFallback = new AsyncFunction<X, W>(this, fallback){
            final /* synthetic */ ClosingFunction val$fallback;
            final /* synthetic */ ClosingFuture this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$fallback = closingFunction;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ListenableFuture<W> apply(X exception) throws Exception {
                void var1_1;
                return this.this$0.closeables.applyClosingFunction(this.val$fallback, var1_1);
            }

            public String toString() {
                return this.val$fallback.toString();
            }
        };
        ClosingFuture closingFuture = this;
        return closingFuture.derive(closingFuture.future.catchingAsync(var1_1, var2_2, (Executor)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public final <X extends Throwable> ClosingFuture<V> catchingAsync(Class<X> exceptionType, AsyncClosingFunction<? super X, ? extends V> fallback, Executor executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.catchingAsyncMoreGeneric((Class<X>)var1_1, (AsyncClosingFunction)var2_2, (Executor)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private <X extends Throwable, W extends V> ClosingFuture<V> catchingAsyncMoreGeneric(Class<X> exceptionType, AsyncClosingFunction<? super X, W> fallback, Executor executor) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(fallback);
        AsyncFunction asyncFunction = new AsyncFunction<X, W>(this, fallback){
            final /* synthetic */ AsyncClosingFunction val$fallback;
            final /* synthetic */ ClosingFuture this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$fallback = asyncClosingFunction;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ListenableFuture<W> apply(X exception) throws Exception {
                void var1_1;
                return this.this$0.closeables.applyAsyncClosingFunction(this.val$fallback, var1_1);
            }

            public String toString() {
                return this.val$fallback.toString();
            }
        };
        ClosingFuture closingFuture = this;
        return closingFuture.derive(closingFuture.future.catchingAsync(var1_1, var2_2, (Executor)var3_3));
    }

    public final FluentFuture<V> finishToFuture() {
        if (this.compareAndUpdateState(State.OPEN, State.WILL_CLOSE)) {
            logger.log(Level.FINER, "will close {0}", this);
            this.future.addListener(new Runnable(this){
                final /* synthetic */ ClosingFuture this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void run() {
                    ClosingFuture.access$1100(this.this$0, State.WILL_CLOSE, State.CLOSING);
                    this.this$0.close();
                    ClosingFuture.access$1100(this.this$0, State.CLOSING, State.CLOSED);
                }
            }, MoreExecutors.directExecutor());
        } else {
            switch (this.state.get()) {
                case SUBSUMED: {
                    throw new IllegalStateException("Cannot call finishToFuture() after deriving another step");
                }
                case WILL_CREATE_VALUE_AND_CLOSER: {
                    throw new IllegalStateException("Cannot call finishToFuture() after calling finishToValueAndCloser()");
                }
                case WILL_CLOSE: 
                case CLOSING: 
                case CLOSED: {
                    throw new IllegalStateException("Cannot call finishToFuture() twice");
                }
                case OPEN: {
                    throw new AssertionError();
                }
            }
        }
        return this.future;
    }

    /*
     * WARNING - void declaration
     */
    public final void finishToValueAndCloser(ValueAndCloserConsumer<? super V> consumer, Executor executor) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(consumer);
        if (!this.compareAndUpdateState(State.OPEN, State.WILL_CREATE_VALUE_AND_CLOSER)) {
            switch (this.state.get()) {
                case SUBSUMED: {
                    throw new IllegalStateException("Cannot call finishToValueAndCloser() after deriving another step");
                }
                case WILL_CLOSE: 
                case CLOSING: 
                case CLOSED: {
                    throw new IllegalStateException("Cannot call finishToValueAndCloser() after calling finishToFuture()");
                }
                case WILL_CREATE_VALUE_AND_CLOSER: {
                    throw new IllegalStateException("Cannot call finishToValueAndCloser() twice");
                }
            }
            throw new AssertionError(this.state);
        }
        this.future.addListener(new Runnable(this, (ValueAndCloserConsumer)var1_1){
            final /* synthetic */ ValueAndCloserConsumer val$consumer;
            final /* synthetic */ ClosingFuture this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$consumer = valueAndCloserConsumer;
            }

            @Override
            public void run() {
                ClosingFuture.access$1200(this.val$consumer, this.this$0);
            }
        }, (Executor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static <C, V extends C> void provideValueAndCloser(ValueAndCloserConsumer<C> consumer, ClosingFuture<V> closingFuture) {
        void var1_1;
        consumer.accept(new ValueAndCloser(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean cancel(boolean mayInterruptIfRunning) {
        void var1_1;
        logger.log(Level.FINER, "cancelling {0}", this);
        boolean cancelled = this.future.cancel(mayInterruptIfRunning);
        if (cancelled) {
            this.close();
        }
        return (boolean)var1_1;
    }

    private void close() {
        logger.log(Level.FINER, "closing {0}", this);
        this.closeables.close();
    }

    /*
     * WARNING - void declaration
     */
    private <U> ClosingFuture<U> derive(FluentFuture<U> future) {
        void var1_1;
        ClosingFuture<U> derived = new ClosingFuture<U>(future);
        this.becomeSubsumedInto(derived.closeables);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void becomeSubsumedInto(CloseableList otherCloseables) {
        void var1_1;
        this.checkAndUpdateState(State.OPEN, State.SUBSUMED);
        var1_1.add(this.closeables, MoreExecutors.directExecutor());
    }

    public final String toString() {
        return MoreObjects.toStringHelper(this).add("state", (Object)this.state.get()).addValue(this.future).toString();
    }

    protected final void finalize() {
        if (this.state.get().equals((Object)State.OPEN)) {
            logger.log(Level.SEVERE, "Uh oh! An open ClosingFuture has leaked and will close: {0}", this);
            this.finishToFuture();
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void closeQuietly(final AutoCloseable closeable, Executor executor) {
        while (closeable != null) {
            try {
                executor.execute(new Runnable(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void run() {
                        try {
                            closeable.close();
                            return;
                        }
                        catch (Exception e) {
                            void var1_1;
                            logger.log(Level.WARNING, "thrown by close()", (Throwable)var1_1);
                            return;
                        }
                    }
                });
                return;
            }
            catch (RejectedExecutionException e) {
                if (logger.isLoggable(Level.WARNING)) {
                    void var2_2;
                    logger.log(Level.WARNING, String.format("while submitting close to %s; will close inline", executor), (Throwable)var2_2);
                }
                executor = MoreExecutors.directExecutor();
                continue;
            }
            break;
        }
        return;
    }

    /*
     * WARNING - void declaration
     */
    private void checkAndUpdateState(State oldState, State newState) {
        void var2_2;
        void var1_1;
        Preconditions.checkState(this.compareAndUpdateState(oldState, newState), "Expected state to be %s, but it was %s", (Object)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private boolean compareAndUpdateState(State oldState, State newState) {
        void var2_2;
        void var1_1;
        return this.state.compareAndSet((State)var1_1, (State)var2_2);
    }

    @VisibleForTesting
    final CountDownLatch whenClosedCountDown() {
        return this.closeables.whenClosedCountDown();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1000(ClosingFuture x0, CloseableList x1) {
        void var1_1;
        x0.becomeSubsumedInto((CloseableList)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1100(ClosingFuture x0, State x1, State x2) {
        void var2_2;
        void var1_1;
        x0.checkAndUpdateState((State)var1_1, (State)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1200(ValueAndCloserConsumer x0, ClosingFuture x1) {
        void var1_1;
        ClosingFuture.provideValueAndCloser(x0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$3300(AutoCloseable x0, Executor x1) {
        void var1_1;
        ClosingFuture.closeQuietly(x0, (Executor)var1_1);
    }

    static enum State {
        OPEN,
        SUBSUMED,
        WILL_CLOSE,
        CLOSING,
        CLOSED,
        WILL_CREATE_VALUE_AND_CLOSER;

    }

    private static final class CloseableList
    extends IdentityHashMap<AutoCloseable, Executor>
    implements Closeable {
        private final DeferredCloser closer = new DeferredCloser(this);
        private volatile boolean closed;
        private volatile CountDownLatch whenClosed;

        private CloseableList() {
        }

        /*
         * WARNING - void declaration
         */
        final <V, U> ListenableFuture<U> applyClosingFunction(ClosingFunction<? super V, U> transformation, @ParametricNullness V input) throws Exception {
            CloseableList newCloseables = new CloseableList();
            try {
                void var2_3;
                ListenableFuture listenableFuture;
                listenableFuture = Futures.immediateFuture(listenableFuture.apply(newCloseables.closer, var2_3));
                this.add(newCloseables, MoreExecutors.directExecutor());
                return listenableFuture;
            }
            catch (Throwable throwable) {
                void var3_4;
                this.add((AutoCloseable)var3_4, MoreExecutors.directExecutor());
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        final <V, U> FluentFuture<U> applyAsyncClosingFunction(AsyncClosingFunction<V, U> transformation, @ParametricNullness V input) throws Exception {
            CloseableList newCloseables = new CloseableList();
            try {
                FluentFuture fluentFuture;
                void var2_3;
                ClosingFuture<U> closingFuture = transformation.apply(newCloseables.closer, var2_3);
                ClosingFuture.access$1000(closingFuture, newCloseables);
                fluentFuture = ((ClosingFuture)((Object)fluentFuture)).future;
                this.add(newCloseables, MoreExecutors.directExecutor());
                return fluentFuture;
            }
            catch (Throwable throwable) {
                void var3_4;
                this.add((AutoCloseable)var3_4, MoreExecutors.directExecutor());
                throw throwable;
            }
        }

        @Override
        public final void close() {
            if (this.closed) {
                return;
            }
            CloseableList closeableList = this;
            synchronized (closeableList) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            for (Map.Entry entry : this.entrySet()) {
                ClosingFuture.access$3300((AutoCloseable)entry.getKey(), (Executor)entry.getValue());
            }
            this.clear();
            if (this.whenClosed != null) {
                this.whenClosed.countDown();
            }
        }

        /*
         * WARNING - void declaration
         */
        final void add(AutoCloseable closeable, Executor executor) {
            void var2_3;
            void var1_1;
            Preconditions.checkNotNull(executor);
            if (closeable == null) {
                return;
            }
            CloseableList closeableList = this;
            synchronized (closeableList) {
                if (!this.closed) {
                    this.put(closeable, executor);
                    return;
                }
            }
            ClosingFuture.access$3300((AutoCloseable)var1_1, (Executor)var2_3);
        }

        final CountDownLatch whenClosedCountDown() {
            if (this.closed) {
                return new CountDownLatch(0);
            }
            CloseableList closeableList = this;
            synchronized (closeableList) {
                if (this.closed) {
                    return new CountDownLatch(0);
                }
                Preconditions.checkState(this.whenClosed == null);
                this.whenClosed = new CountDownLatch(1);
                return this.whenClosed;
            }
        }
    }

    public static final class Combiner5<V1, V2, V3, V4, V5>
    extends Combiner {
        private final ClosingFuture<V1> future1;
        private final ClosingFuture<V2> future2;
        private final ClosingFuture<V3> future3;
        private final ClosingFuture<V4> future4;
        private final ClosingFuture<V5> future5;

        /*
         * WARNING - void declaration
         */
        private Combiner5(ClosingFuture<V1> future1, ClosingFuture<V2> future2, ClosingFuture<V3> future3, ClosingFuture<V4> future4, ClosingFuture<V5> future5) {
            super(true, ImmutableList.of(future1, future2, future3, future4, future5));
            void var3_3;
            void var2_2;
            void var1_1;
            this.future1 = var1_1;
            this.future2 = var2_2;
            this.future3 = var3_3;
            this.future4 = future4;
            this.future5 = future5;
        }

        /*
         * WARNING - void declaration
         */
        public final <U> ClosingFuture<U> call(ClosingFunction5<V1, V2, V3, V4, V5, U> function, Executor executor) {
            void var2_2;
            void var1_1;
            return this.call(new Combiner.CombiningCallable<U>(this, (ClosingFunction5)var1_1){
                final /* synthetic */ ClosingFunction5 val$function;
                final /* synthetic */ Combiner5 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$function = closingFunction5;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                @ParametricNullness
                public U call(DeferredCloser closer, Peeker peeker) throws Exception {
                    void var2_2;
                    void var1_1;
                    return this.val$function.apply((DeferredCloser)var1_1, peeker.getDone(this.this$0.future1), peeker.getDone(this.this$0.future2), peeker.getDone(this.this$0.future3), peeker.getDone(this.this$0.future4), var2_2.getDone(this.this$0.future5));
                }

                public String toString() {
                    return this.val$function.toString();
                }
            }, (Executor)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final <U> ClosingFuture<U> callAsync(AsyncClosingFunction5<V1, V2, V3, V4, V5, U> function, Executor executor) {
            void var2_2;
            void var1_1;
            return this.callAsync(new Combiner.AsyncCombiningCallable<U>(this, (AsyncClosingFunction5)var1_1){
                final /* synthetic */ AsyncClosingFunction5 val$function;
                final /* synthetic */ Combiner5 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$function = asyncClosingFunction5;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public ClosingFuture<U> call(DeferredCloser closer, Peeker peeker) throws Exception {
                    void var2_2;
                    void var1_1;
                    return this.val$function.apply((DeferredCloser)var1_1, peeker.getDone(this.this$0.future1), peeker.getDone(this.this$0.future2), peeker.getDone(this.this$0.future3), peeker.getDone(this.this$0.future4), var2_2.getDone(this.this$0.future5));
                }

                public String toString() {
                    return this.val$function.toString();
                }
            }, (Executor)var2_2);
        }

        @FunctionalInterface
        public static interface AsyncClosingFunction5<V1, V2, V3, V4, V5, U> {
            public ClosingFuture<U> apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3, @ParametricNullness V3 var4, @ParametricNullness V4 var5, @ParametricNullness V5 var6) throws Exception;
        }

        @FunctionalInterface
        public static interface ClosingFunction5<V1, V2, V3, V4, V5, U> {
            @ParametricNullness
            public U apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3, @ParametricNullness V3 var4, @ParametricNullness V4 var5, @ParametricNullness V5 var6) throws Exception;
        }
    }

    public static final class Combiner4<V1, V2, V3, V4>
    extends Combiner {
        private final ClosingFuture<V1> future1;
        private final ClosingFuture<V2> future2;
        private final ClosingFuture<V3> future3;
        private final ClosingFuture<V4> future4;

        /*
         * WARNING - void declaration
         */
        private Combiner4(ClosingFuture<V1> future1, ClosingFuture<V2> future2, ClosingFuture<V3> future3, ClosingFuture<V4> future4) {
            super(true, ImmutableList.of(future1, future2, future3, future4));
            void var3_3;
            void var2_2;
            void var1_1;
            this.future1 = var1_1;
            this.future2 = var2_2;
            this.future3 = var3_3;
            this.future4 = future4;
        }

        /*
         * WARNING - void declaration
         */
        public final <U> ClosingFuture<U> call(ClosingFunction4<V1, V2, V3, V4, U> function, Executor executor) {
            void var2_2;
            void var1_1;
            return this.call(new Combiner.CombiningCallable<U>(this, (ClosingFunction4)var1_1){
                final /* synthetic */ ClosingFunction4 val$function;
                final /* synthetic */ Combiner4 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$function = closingFunction4;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                @ParametricNullness
                public U call(DeferredCloser closer, Peeker peeker) throws Exception {
                    void var2_2;
                    void var1_1;
                    return this.val$function.apply((DeferredCloser)var1_1, peeker.getDone(this.this$0.future1), peeker.getDone(this.this$0.future2), peeker.getDone(this.this$0.future3), var2_2.getDone(this.this$0.future4));
                }

                public String toString() {
                    return this.val$function.toString();
                }
            }, (Executor)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final <U> ClosingFuture<U> callAsync(AsyncClosingFunction4<V1, V2, V3, V4, U> function, Executor executor) {
            void var2_2;
            void var1_1;
            return this.callAsync(new Combiner.AsyncCombiningCallable<U>(this, (AsyncClosingFunction4)var1_1){
                final /* synthetic */ AsyncClosingFunction4 val$function;
                final /* synthetic */ Combiner4 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$function = asyncClosingFunction4;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public ClosingFuture<U> call(DeferredCloser closer, Peeker peeker) throws Exception {
                    void var2_2;
                    void var1_1;
                    return this.val$function.apply((DeferredCloser)var1_1, peeker.getDone(this.this$0.future1), peeker.getDone(this.this$0.future2), peeker.getDone(this.this$0.future3), var2_2.getDone(this.this$0.future4));
                }

                public String toString() {
                    return this.val$function.toString();
                }
            }, (Executor)var2_2);
        }

        @FunctionalInterface
        public static interface AsyncClosingFunction4<V1, V2, V3, V4, U> {
            public ClosingFuture<U> apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3, @ParametricNullness V3 var4, @ParametricNullness V4 var5) throws Exception;
        }

        @FunctionalInterface
        public static interface ClosingFunction4<V1, V2, V3, V4, U> {
            @ParametricNullness
            public U apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3, @ParametricNullness V3 var4, @ParametricNullness V4 var5) throws Exception;
        }
    }

    public static final class Combiner3<V1, V2, V3>
    extends Combiner {
        private final ClosingFuture<V1> future1;
        private final ClosingFuture<V2> future2;
        private final ClosingFuture<V3> future3;

        /*
         * WARNING - void declaration
         */
        private Combiner3(ClosingFuture<V1> future1, ClosingFuture<V2> future2, ClosingFuture<V3> future3) {
            super(true, ImmutableList.of(future1, future2, future3));
            void var3_3;
            void var2_2;
            void var1_1;
            this.future1 = var1_1;
            this.future2 = var2_2;
            this.future3 = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public final <U> ClosingFuture<U> call(ClosingFunction3<V1, V2, V3, U> function, Executor executor) {
            void var2_2;
            void var1_1;
            return this.call(new Combiner.CombiningCallable<U>(this, (ClosingFunction3)var1_1){
                final /* synthetic */ ClosingFunction3 val$function;
                final /* synthetic */ Combiner3 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$function = closingFunction3;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                @ParametricNullness
                public U call(DeferredCloser closer, Peeker peeker) throws Exception {
                    void var2_2;
                    void var1_1;
                    return this.val$function.apply((DeferredCloser)var1_1, peeker.getDone(this.this$0.future1), peeker.getDone(this.this$0.future2), var2_2.getDone(this.this$0.future3));
                }

                public String toString() {
                    return this.val$function.toString();
                }
            }, (Executor)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final <U> ClosingFuture<U> callAsync(AsyncClosingFunction3<V1, V2, V3, U> function, Executor executor) {
            void var2_2;
            void var1_1;
            return this.callAsync(new Combiner.AsyncCombiningCallable<U>(this, (AsyncClosingFunction3)var1_1){
                final /* synthetic */ AsyncClosingFunction3 val$function;
                final /* synthetic */ Combiner3 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$function = asyncClosingFunction3;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public ClosingFuture<U> call(DeferredCloser closer, Peeker peeker) throws Exception {
                    void var2_2;
                    void var1_1;
                    return this.val$function.apply((DeferredCloser)var1_1, peeker.getDone(this.this$0.future1), peeker.getDone(this.this$0.future2), var2_2.getDone(this.this$0.future3));
                }

                public String toString() {
                    return this.val$function.toString();
                }
            }, (Executor)var2_2);
        }

        @FunctionalInterface
        public static interface AsyncClosingFunction3<V1, V2, V3, U> {
            public ClosingFuture<U> apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3, @ParametricNullness V3 var4) throws Exception;
        }

        @FunctionalInterface
        public static interface ClosingFunction3<V1, V2, V3, U> {
            @ParametricNullness
            public U apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3, @ParametricNullness V3 var4) throws Exception;
        }
    }

    public static final class Combiner2<V1, V2>
    extends Combiner {
        private final ClosingFuture<V1> future1;
        private final ClosingFuture<V2> future2;

        /*
         * WARNING - void declaration
         */
        private Combiner2(ClosingFuture<V1> future1, ClosingFuture<V2> future2) {
            super(true, ImmutableList.of(future1, future2));
            void var2_2;
            void var1_1;
            this.future1 = var1_1;
            this.future2 = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public final <U> ClosingFuture<U> call(ClosingFunction2<V1, V2, U> function, Executor executor) {
            void var2_2;
            void var1_1;
            return this.call(new Combiner.CombiningCallable<U>(this, (ClosingFunction2)var1_1){
                final /* synthetic */ ClosingFunction2 val$function;
                final /* synthetic */ Combiner2 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$function = closingFunction2;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                @ParametricNullness
                public U call(DeferredCloser closer, Peeker peeker) throws Exception {
                    void var2_2;
                    void var1_1;
                    return this.val$function.apply((DeferredCloser)var1_1, peeker.getDone(this.this$0.future1), var2_2.getDone(this.this$0.future2));
                }

                public String toString() {
                    return this.val$function.toString();
                }
            }, (Executor)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final <U> ClosingFuture<U> callAsync(AsyncClosingFunction2<V1, V2, U> function, Executor executor) {
            void var2_2;
            void var1_1;
            return this.callAsync(new Combiner.AsyncCombiningCallable<U>(this, (AsyncClosingFunction2)var1_1){
                final /* synthetic */ AsyncClosingFunction2 val$function;
                final /* synthetic */ Combiner2 this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$function = asyncClosingFunction2;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public ClosingFuture<U> call(DeferredCloser closer, Peeker peeker) throws Exception {
                    void var2_2;
                    void var1_1;
                    return this.val$function.apply((DeferredCloser)var1_1, peeker.getDone(this.this$0.future1), var2_2.getDone(this.this$0.future2));
                }

                public String toString() {
                    return this.val$function.toString();
                }
            }, (Executor)var2_2);
        }

        @FunctionalInterface
        public static interface AsyncClosingFunction2<V1, V2, U> {
            public ClosingFuture<U> apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3) throws Exception;
        }

        @FunctionalInterface
        public static interface ClosingFunction2<V1, V2, U> {
            @ParametricNullness
            public U apply(DeferredCloser var1, @ParametricNullness V1 var2, @ParametricNullness V2 var3) throws Exception;
        }
    }

    public static class Combiner {
        private final CloseableList closeables = new CloseableList();
        private final boolean allMustSucceed;
        protected final ImmutableList<ClosingFuture<?>> inputs;
        private static final Function<ClosingFuture<?>, FluentFuture<?>> INNER_FUTURE = new Function<ClosingFuture<?>, FluentFuture<?>>(){

            @Override
            public FluentFuture<?> apply(ClosingFuture<?> future) {
                return ((ClosingFuture)future).future;
            }
        };

        /*
         * WARNING - void declaration
         */
        private Combiner(boolean allMustSucceed, Iterable<? extends ClosingFuture<?>> inputs) {
            ClosingFuture closingFuture;
            void var1_1;
            this.allMustSucceed = var1_1;
            this.inputs = ImmutableList.copyOf(inputs);
            Iterator iterator = closingFuture.iterator();
            while (iterator.hasNext()) {
                closingFuture = (ClosingFuture)iterator.next();
                ClosingFuture.access$1000(closingFuture, this.closeables);
            }
        }

        /*
         * WARNING - void declaration
         */
        public <V> ClosingFuture<V> call(CombiningCallable<V> combiningCallable, Executor executor) {
            void var1_1;
            void var2_2;
            Callable callable = new Callable<V>(this, combiningCallable){
                final /* synthetic */ CombiningCallable val$combiningCallable;
                final /* synthetic */ Combiner this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$combiningCallable = combiningCallable;
                }

                @Override
                @ParametricNullness
                public V call() throws Exception {
                    return Peeker.access$1500(new Peeker(this.this$0.inputs), this.val$combiningCallable, this.this$0.closeables);
                }

                public String toString() {
                    return this.val$combiningCallable.toString();
                }
            };
            ClosingFuture derived = new ClosingFuture(this.futureCombiner().call(callable, (Executor)var2_2));
            derived.closeables.add(this.closeables, MoreExecutors.directExecutor());
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public <V> ClosingFuture<V> callAsync(AsyncCombiningCallable<V> combiningCallable, Executor executor) {
            void var1_1;
            void var2_2;
            AsyncCallable asyncCallable = new AsyncCallable<V>(this, combiningCallable){
                final /* synthetic */ AsyncCombiningCallable val$combiningCallable;
                final /* synthetic */ Combiner this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$combiningCallable = asyncCombiningCallable;
                }

                @Override
                public ListenableFuture<V> call() throws Exception {
                    return Peeker.access$1700(new Peeker(this.this$0.inputs), this.val$combiningCallable, this.this$0.closeables);
                }

                public String toString() {
                    return this.val$combiningCallable.toString();
                }
            };
            ClosingFuture derived = new ClosingFuture(this.futureCombiner().callAsync(asyncCallable, (Executor)var2_2));
            derived.closeables.add(this.closeables, MoreExecutors.directExecutor());
            return var1_1;
        }

        private Futures.FutureCombiner<Object> futureCombiner() {
            if (this.allMustSucceed) {
                return Futures.whenAllSucceed(this.inputFutures());
            }
            return Futures.whenAllComplete(this.inputFutures());
        }

        private ImmutableList<FluentFuture<?>> inputFutures() {
            return FluentIterable.from(this.inputs).transform(INNER_FUTURE).toList();
        }

        @FunctionalInterface
        public static interface AsyncCombiningCallable<V> {
            public ClosingFuture<V> call(DeferredCloser var1, Peeker var2) throws Exception;
        }

        @FunctionalInterface
        public static interface CombiningCallable<V> {
            @ParametricNullness
            public V call(DeferredCloser var1, Peeker var2) throws Exception;
        }
    }

    public static final class Peeker {
        private final ImmutableList<ClosingFuture<?>> futures;
        private volatile boolean beingCalled;

        /*
         * WARNING - void declaration
         */
        private Peeker(ImmutableList<ClosingFuture<?>> futures) {
            void var1_1;
            this.futures = (ImmutableList)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @ParametricNullness
        public final <D> D getDone(ClosingFuture<D> closingFuture) throws ExecutionException {
            void var1_1;
            Preconditions.checkState(this.beingCalled);
            Preconditions.checkArgument(((ImmutableCollection)this.futures).contains(closingFuture));
            return (D)Futures.getDone(((ClosingFuture)var1_1).future);
        }

        /*
         * WARNING - void declaration
         */
        @ParametricNullness
        private <V> V call(Combiner.CombiningCallable<V> combiner, CloseableList closeables) throws Exception {
            Object v;
            this.beingCalled = true;
            CloseableList newCloseables = new CloseableList();
            try {
                v = v.call(newCloseables.closer, this);
                closeables.add(newCloseables, MoreExecutors.directExecutor());
                this.beingCalled = false;
            }
            catch (Throwable throwable) {
                void var3_4;
                void var2_3;
                var2_3.add((AutoCloseable)var3_4, MoreExecutors.directExecutor());
                this.beingCalled = false;
                throw throwable;
            }
            return v;
        }

        /*
         * WARNING - void declaration
         */
        private <V> FluentFuture<V> callAsync(Combiner.AsyncCombiningCallable<V> combiner, CloseableList closeables) throws Exception {
            this.beingCalled = true;
            CloseableList newCloseables = new CloseableList();
            try {
                FluentFuture fluentFuture;
                ClosingFuture<V> closingFuture = combiner.call(newCloseables.closer, this);
                ClosingFuture.access$1000(closingFuture, closeables);
                fluentFuture = ((ClosingFuture)((Object)fluentFuture)).future;
                closeables.add(newCloseables, MoreExecutors.directExecutor());
                this.beingCalled = false;
                return fluentFuture;
            }
            catch (Throwable throwable) {
                void var3_4;
                void var2_3;
                var2_3.add((AutoCloseable)var3_4, MoreExecutors.directExecutor());
                this.beingCalled = false;
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Object access$1500(Peeker x0, Combiner.CombiningCallable x1, CloseableList x2) throws Exception {
            void var2_2;
            void var1_1;
            return x0.call((Combiner.CombiningCallable)var1_1, (CloseableList)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ FluentFuture access$1700(Peeker x0, Combiner.AsyncCombiningCallable x1, CloseableList x2) throws Exception {
            void var2_2;
            void var1_1;
            return x0.callAsync((Combiner.AsyncCombiningCallable)var1_1, (CloseableList)var2_2);
        }
    }

    @FunctionalInterface
    public static interface ValueAndCloserConsumer<V> {
        public void accept(ValueAndCloser<V> var1);
    }

    public static final class ValueAndCloser<V> {
        private final ClosingFuture<? extends V> closingFuture;

        /*
         * WARNING - void declaration
         */
        ValueAndCloser(ClosingFuture<? extends V> closingFuture) {
            void var1_1;
            this.closingFuture = (ClosingFuture)Preconditions.checkNotNull(var1_1);
        }

        @ParametricNullness
        public final V get() throws ExecutionException {
            return Futures.getDone(((ClosingFuture)this.closingFuture).future);
        }

        public final void closeAsync() {
            ((ClosingFuture)this.closingFuture).close();
        }
    }

    @FunctionalInterface
    public static interface AsyncClosingFunction<T, U> {
        public ClosingFuture<U> apply(DeferredCloser var1, @ParametricNullness T var2) throws Exception;
    }

    @FunctionalInterface
    public static interface ClosingFunction<T, U> {
        @ParametricNullness
        public U apply(DeferredCloser var1, @ParametricNullness T var2) throws Exception;
    }

    @FunctionalInterface
    public static interface AsyncClosingCallable<V> {
        public ClosingFuture<V> call(DeferredCloser var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ClosingCallable<V> {
        @ParametricNullness
        public V call(DeferredCloser var1) throws Exception;
    }

    public static final class DeferredCloser {
        private final CloseableList list;

        /*
         * WARNING - void declaration
         */
        DeferredCloser(CloseableList list) {
            void var1_1;
            this.list = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @ParametricNullness
        public final <C> C eventuallyClose(@ParametricNullness C closeable, Executor closingExecutor) {
            void var1_1;
            Preconditions.checkNotNull(closingExecutor);
            if (closeable != null) {
                void var2_2;
                this.list.add((AutoCloseable)closeable, (Executor)var2_2);
            }
            return var1_1;
        }
    }
}

