/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ParametricNullness;
import java.util.concurrent.Callable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Callables {
    private Callables() {
    }

    public static <T> Callable<T> returning(@ParametricNullness T value) {
        return () -> value;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static <T> AsyncCallable<T> asAsyncCallable(Callable<T> callable, ListeningExecutorService listeningExecutorService) {
        Callable<T> callable2;
        void var1_1;
        Preconditions.checkNotNull(callable);
        Preconditions.checkNotNull(listeningExecutorService);
        return () -> Callables.lambda$asAsyncCallable$1((ListeningExecutorService)var1_1, callable2);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    static <T> Callable<T> threadRenaming(Callable<T> callable, Supplier<String> nameSupplier) {
        Callable<T> callable2;
        void var1_1;
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(callable);
        return () -> Callables.lambda$threadRenaming$2((Supplier)var1_1, callable2);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    static Runnable threadRenaming(Runnable task, Supplier<String> nameSupplier) {
        Runnable runnable;
        void var1_1;
        Preconditions.checkNotNull(nameSupplier);
        Preconditions.checkNotNull(task);
        return () -> Callables.lambda$threadRenaming$3((Supplier)var1_1, runnable);
    }

    @GwtIncompatible
    private static boolean trySetName(String threadName, Thread currentThread) {
        try {
            String string;
            currentThread.setName(string);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static /* synthetic */ void lambda$threadRenaming$3(Supplier nameSupplier, Runnable task) {
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
        try {
            void var1_2;
            var1_2.run();
            if (!restoreName) return;
        }
        catch (Throwable throwable) {
            void var2_4;
            void var3_5;
            void var0_1;
            if (var0_1 == false) throw throwable;
            Callables.trySetName((String)var3_5, (Thread)var2_4);
            throw throwable;
        }
        Callables.trySetName(oldName, currentThread);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Object lambda$threadRenaming$2(Supplier nameSupplier, Callable callable) throws Exception {
        Object v;
        block3: {
            Thread currentThread = Thread.currentThread();
            String oldName = currentThread.getName();
            boolean restoreName = Callables.trySetName((String)nameSupplier.get(), currentThread);
            try {
                v = v.call();
                if (!restoreName) break block3;
            }
            catch (Throwable throwable) {
                void var0_1;
                if (var0_1 != false) {
                    void var2_4;
                    void var3_5;
                    Callables.trySetName((String)var3_5, (Thread)var2_4);
                }
                throw throwable;
            }
            Callables.trySetName(oldName, currentThread);
        }
        return v;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ ListenableFuture lambda$asAsyncCallable$1(ListeningExecutorService listeningExecutorService, Callable callable) throws Exception {
        void var1_1;
        return listeningExecutorService.submit((Callable)var1_1);
    }
}

