/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import java.util.function.LongUnaryOperator;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class AtomicLongMap<K>
implements Serializable {
    private final ConcurrentHashMap<K, Long> map;
    private transient Map<K, Long> asMap;

    /*
     * WARNING - void declaration
     */
    private AtomicLongMap(ConcurrentHashMap<K, Long> map) {
        void var1_1;
        this.map = (ConcurrentHashMap)Preconditions.checkNotNull(var1_1);
    }

    public static <K> AtomicLongMap<K> create() {
        return new AtomicLongMap(new ConcurrentHashMap());
    }

    /*
     * WARNING - void declaration
     */
    public static <K> AtomicLongMap<K> create(Map<? extends K, ? extends Long> m) {
        void var1_1;
        Map<? extends K, ? extends Long> map;
        AtomicLongMap<? extends K> result = AtomicLongMap.create();
        result.putAll(map);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final long get(K key) {
        void var1_1;
        return this.map.getOrDefault(var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public final long incrementAndGet(K key) {
        void var1_1;
        return this.addAndGet(var1_1, 1L);
    }

    /*
     * WARNING - void declaration
     */
    public final long decrementAndGet(K key) {
        void var1_1;
        return this.addAndGet(var1_1, -1L);
    }

    /*
     * WARNING - void declaration
     */
    public final long addAndGet(K key, long delta) {
        void var2_2;
        void var1_1;
        return this.accumulateAndGet(var1_1, (long)var2_2, Long::sum);
    }

    /*
     * WARNING - void declaration
     */
    public final long getAndIncrement(K key) {
        void var1_1;
        return this.getAndAdd(var1_1, 1L);
    }

    /*
     * WARNING - void declaration
     */
    public final long getAndDecrement(K key) {
        void var1_1;
        return this.getAndAdd(var1_1, -1L);
    }

    /*
     * WARNING - void declaration
     */
    public final long getAndAdd(K key, long delta) {
        void var2_2;
        void var1_1;
        return this.getAndAccumulate(var1_1, (long)var2_2, Long::sum);
    }

    /*
     * WARNING - void declaration
     */
    public final long updateAndGet(K key, LongUnaryOperator updaterFunction) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(updaterFunction);
        return this.map.compute(var1_1, (arg_0, arg_1) -> AtomicLongMap.lambda$updateAndGet$0((LongUnaryOperator)var2_2, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    public final long getAndUpdate(K key, LongUnaryOperator updaterFunction) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(updaterFunction);
        AtomicLong holder = new AtomicLong();
        this.map.compute(var1_1, (arg_0, arg_1) -> AtomicLongMap.lambda$getAndUpdate$1(holder, (LongUnaryOperator)var2_2, arg_0, arg_1));
        return var3_3.get();
    }

    /*
     * WARNING - void declaration
     */
    public final long accumulateAndGet(K key, long x, LongBinaryOperator accumulatorFunction) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(accumulatorFunction);
        return this.updateAndGet(var1_1, arg_0 -> AtomicLongMap.lambda$accumulateAndGet$2(accumulatorFunction, (long)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final long getAndAccumulate(K key, long x, LongBinaryOperator accumulatorFunction) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(accumulatorFunction);
        return this.getAndUpdate(var1_1, arg_0 -> AtomicLongMap.lambda$getAndAccumulate$3(accumulatorFunction, (long)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final long put(K key, long newValue) {
        void var2_2;
        void var1_1;
        return this.getAndUpdate(var1_1, arg_0 -> AtomicLongMap.lambda$put$4((long)var2_2, arg_0));
    }

    public final void putAll(Map<? extends K, ? extends Long> m) {
        m.forEach(this::put);
    }

    /*
     * WARNING - void declaration
     */
    public final long remove(K key) {
        void var1_1;
        Long result = this.map.remove(key);
        if (result == null) {
            return 0L;
        }
        return var1_1.longValue();
    }

    /*
     * WARNING - void declaration
     */
    final boolean remove(K key, long value) {
        void var2_2;
        void var1_1;
        return this.map.remove(var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public final boolean removeIfZero(K key) {
        void var1_1;
        return this.remove(var1_1, 0L);
    }

    public final void removeAllZeros() {
        this.map.values().removeIf(x -> x == 0L);
    }

    public final long sum() {
        return this.map.values().stream().mapToLong(Long::longValue).sum();
    }

    /*
     * WARNING - void declaration
     */
    public final Map<K, Long> asMap() {
        void var1_1;
        Map<K, Long> result = this.asMap;
        if (result == null) {
            this.asMap = this.createAsMap();
            return this.asMap;
        }
        return var1_1;
    }

    private Map<K, Long> createAsMap() {
        return Collections.unmodifiableMap(this.map);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean containsKey(Object key) {
        void var1_1;
        return this.map.containsKey(var1_1);
    }

    public final int size() {
        return this.map.size();
    }

    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    public final void clear() {
        this.map.clear();
    }

    public final String toString() {
        return this.map.toString();
    }

    /*
     * WARNING - void declaration
     */
    final long putIfAbsent(K key, long newValue) {
        void var1_1;
        void var2_2;
        AtomicBoolean noValue = new AtomicBoolean(false);
        Long result = this.map.compute(key, (arg_0, arg_1) -> AtomicLongMap.lambda$putIfAbsent$6(noValue, (long)var2_2, arg_0, arg_1));
        if (noValue.get()) {
            return 0L;
        }
        return var1_1.longValue();
    }

    /*
     * WARNING - void declaration
     */
    final boolean replace(K key, long expectedOldValue, long newValue) {
        void var2_2;
        void var1_1;
        if (expectedOldValue == 0L) {
            return this.putIfAbsent(key, newValue) == 0L;
        }
        return this.map.replace(var1_1, (long)var2_2, newValue);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Long lambda$putIfAbsent$6(AtomicBoolean noValue, long newValue, Object k, Long oldValue) {
        if (oldValue == null || oldValue == 0L) {
            void var1_1;
            AtomicBoolean atomicBoolean;
            atomicBoolean.set(true);
            return (long)var1_1;
        }
        return oldValue;
    }

    private static /* synthetic */ long lambda$put$4(long newValue, long x) {
        return newValue;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ long lambda$getAndAccumulate$3(LongBinaryOperator accumulatorFunction, long x, long oldValue) {
        void var1_1;
        void var3_2;
        return accumulatorFunction.applyAsLong((long)var3_2, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ long lambda$accumulateAndGet$2(LongBinaryOperator accumulatorFunction, long x, long oldValue) {
        void var1_1;
        void var3_2;
        return accumulatorFunction.applyAsLong((long)var3_2, (long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Long lambda$getAndUpdate$1(AtomicLong holder, LongUnaryOperator updaterFunction, Object k, Long value) {
        void var1_1;
        AtomicLong atomicLong;
        void var3_3;
        long oldValue = value == null ? 0L : var3_3.longValue();
        atomicLong.set(oldValue);
        return var1_1.applyAsLong(oldValue);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Long lambda$updateAndGet$0(LongUnaryOperator updaterFunction, Object k, Long value) {
        void var2_2;
        return updaterFunction.applyAsLong(value == null ? 0L : var2_2.longValue());
    }
}

