/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ImmutableLongArray;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient AtomicLongArray longs;

    /*
     * WARNING - void declaration
     */
    public AtomicDoubleArray(int length) {
        void var1_1;
        this.longs = new AtomicLongArray((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public AtomicDoubleArray(double[] array) {
        void var3_3;
        int len = array.length;
        long[] longArray = new long[len];
        for (int i = 0; i < len; ++i) {
            longArray[i] = Double.doubleToRawLongBits(array[i]);
        }
        this.longs = new AtomicLongArray((long[])var3_3);
    }

    public final int length() {
        return this.longs.length();
    }

    /*
     * WARNING - void declaration
     */
    public final double get(int i) {
        void var1_1;
        return Double.longBitsToDouble(this.longs.get((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void set(int i, double newValue) {
        void var1_1;
        long next = Double.doubleToRawLongBits(newValue);
        this.longs.set((int)var1_1, next);
    }

    /*
     * WARNING - void declaration
     */
    public final void lazySet(int i, double newValue) {
        void var1_1;
        long next = Double.doubleToRawLongBits(newValue);
        this.longs.lazySet((int)var1_1, next);
    }

    /*
     * WARNING - void declaration
     */
    public final double getAndSet(int i, double newValue) {
        void var1_1;
        long next = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(this.longs.getAndSet((int)var1_1, next));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean compareAndSet(int i, double expect, double update) {
        void var2_2;
        void var1_1;
        return this.longs.compareAndSet((int)var1_1, Double.doubleToRawLongBits((double)var2_2), Double.doubleToRawLongBits(update));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean weakCompareAndSet(int i, double expect, double update) {
        void var2_2;
        void var1_1;
        return this.longs.weakCompareAndSet((int)var1_1, Double.doubleToRawLongBits((double)var2_2), Double.doubleToRawLongBits(update));
    }

    /*
     * WARNING - void declaration
     */
    public final double getAndAdd(int i, double delta) {
        void var2_2;
        void var1_1;
        return this.getAndAccumulate((int)var1_1, (double)var2_2, Double::sum);
    }

    /*
     * WARNING - void declaration
     */
    public double addAndGet(int i, double delta) {
        void var2_2;
        void var1_1;
        return this.accumulateAndGet((int)var1_1, (double)var2_2, Double::sum);
    }

    /*
     * WARNING - void declaration
     */
    public final double getAndAccumulate(int i, double x, DoubleBinaryOperator accumulatorFunction) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(accumulatorFunction);
        return this.getAndUpdate((int)var1_1, arg_0 -> AtomicDoubleArray.lambda$getAndAccumulate$0(accumulatorFunction, (double)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final double accumulateAndGet(int i, double x, DoubleBinaryOperator accumulatorFunction) {
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(accumulatorFunction);
        return this.updateAndGet((int)var1_1, arg_0 -> AtomicDoubleArray.lambda$accumulateAndGet$1(accumulatorFunction, (double)var2_2, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final double getAndUpdate(int i, DoubleUnaryOperator updaterFunction) {
        long current;
        double currentVal;
        double d;
        long next;
        void var3_3;
        while (!this.longs.compareAndSet(i, (long)var3_3, next = Double.doubleToRawLongBits(d = updaterFunction.applyAsDouble(currentVal = Double.longBitsToDouble(current = this.longs.get(i)))))) {
        }
        return currentVal;
    }

    /*
     * WARNING - void declaration
     */
    public final double updateAndGet(int i, DoubleUnaryOperator updaterFunction) {
        long current;
        double currentVal;
        double nextVal;
        long next;
        void var3_3;
        while (!this.longs.compareAndSet(i, (long)var3_3, next = Double.doubleToRawLongBits(nextVal = updaterFunction.applyAsDouble(currentVal = Double.longBitsToDouble(current = this.longs.get(i)))))) {
        }
        return nextVal;
    }

    public String toString() {
        int iMax = this.length() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder(19 * (iMax + 1));
        b.append('[');
        int i = 0;
        while (true) {
            b.append(Double.longBitsToDouble(this.longs.get(i)));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(',').append(' ');
            ++i;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int length = this.length();
        s.writeInt(length);
        for (int i = 0; i < length; ++i) {
            s.writeDouble(this.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        void var3_3;
        s.defaultReadObject();
        int length = s.readInt();
        ImmutableLongArray.Builder builder = ImmutableLongArray.builder();
        for (int i = 0; i < length; ++i) {
            builder.add(Double.doubleToRawLongBits(s.readDouble()));
        }
        this.longs = new AtomicLongArray(var3_3.build().toArray());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ double lambda$accumulateAndGet$1(DoubleBinaryOperator accumulatorFunction, double x, double oldValue) {
        void var1_1;
        void var3_2;
        return accumulatorFunction.applyAsDouble((double)var3_2, (double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ double lambda$getAndAccumulate$0(DoubleBinaryOperator accumulatorFunction, double x, double oldValue) {
        void var1_1;
        void var3_2;
        return accumulatorFunction.applyAsDouble((double)var3_2, (double)var1_1);
    }
}

