/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public class AtomicDouble
extends Number
implements Serializable {
    private static final long serialVersionUID = 0L;
    private volatile transient long value;
    private static final AtomicLongFieldUpdater<AtomicDouble> updater = AtomicLongFieldUpdater.newUpdater(AtomicDouble.class, "value");

    /*
     * WARNING - void declaration
     */
    public AtomicDouble(double initialValue) {
        void var1_1;
        this.value = Double.doubleToRawLongBits((double)var1_1);
    }

    public AtomicDouble() {
    }

    public final double get() {
        return Double.longBitsToDouble(this.value);
    }

    /*
     * WARNING - void declaration
     */
    public final void set(double newValue) {
        void var3_2;
        long next = Double.doubleToRawLongBits(newValue);
        this.value = var3_2;
    }

    /*
     * WARNING - void declaration
     */
    public final void lazySet(double newValue) {
        void var3_2;
        long next = Double.doubleToRawLongBits(newValue);
        updater.lazySet(this, (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public final double getAndSet(double newValue) {
        void var3_2;
        long next = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(updater.getAndSet(this, (long)var3_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean compareAndSet(double expect, double update) {
        void var3_2;
        void var1_1;
        return updater.compareAndSet(this, Double.doubleToRawLongBits((double)var1_1), Double.doubleToRawLongBits((double)var3_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean weakCompareAndSet(double expect, double update) {
        void var3_2;
        void var1_1;
        return updater.weakCompareAndSet(this, Double.doubleToRawLongBits((double)var1_1), Double.doubleToRawLongBits((double)var3_2));
    }

    /*
     * WARNING - void declaration
     */
    public final double getAndAdd(double delta) {
        void var1_1;
        return this.getAndAccumulate((double)var1_1, Double::sum);
    }

    /*
     * WARNING - void declaration
     */
    public final double addAndGet(double delta) {
        void var1_1;
        return this.accumulateAndGet((double)var1_1, Double::sum);
    }

    /*
     * WARNING - void declaration
     */
    public final double getAndAccumulate(double x, DoubleBinaryOperator accumulatorFunction) {
        void var1_1;
        void var3_2;
        Preconditions.checkNotNull(accumulatorFunction);
        return this.getAndUpdate(arg_0 -> AtomicDouble.lambda$getAndAccumulate$0((DoubleBinaryOperator)var3_2, (double)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final double accumulateAndGet(double x, DoubleBinaryOperator accumulatorFunction) {
        void var1_1;
        void var3_2;
        Preconditions.checkNotNull(accumulatorFunction);
        return this.updateAndGet(arg_0 -> AtomicDouble.lambda$accumulateAndGet$1((DoubleBinaryOperator)var3_2, (double)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public final double getAndUpdate(DoubleUnaryOperator updateFunction) {
        long current;
        double currentVal;
        double d;
        long next;
        void var2_2;
        while (!updater.compareAndSet(this, (long)var2_2, next = Double.doubleToRawLongBits(d = updateFunction.applyAsDouble(currentVal = Double.longBitsToDouble(current = this.value))))) {
        }
        return currentVal;
    }

    /*
     * WARNING - void declaration
     */
    public final double updateAndGet(DoubleUnaryOperator updateFunction) {
        long current;
        double currentVal;
        double nextVal;
        long next;
        void var2_2;
        while (!updater.compareAndSet(this, (long)var2_2, next = Double.doubleToRawLongBits(nextVal = updateFunction.applyAsDouble(currentVal = Double.longBitsToDouble(current = this.value))))) {
        }
        return nextVal;
    }

    public String toString() {
        return Double.toString(this.get());
    }

    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        void var1_1;
        s.defaultWriteObject();
        var1_1.writeDouble(this.get());
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        void var1_1;
        s.defaultReadObject();
        this.set(var1_1.readDouble());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ double lambda$accumulateAndGet$1(DoubleBinaryOperator accumulatorFunction, double x, double oldValue) {
        void var1_1;
        void var3_2;
        return accumulatorFunction.applyAsDouble((double)var3_2, (double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ double lambda$getAndAccumulate$0(DoubleBinaryOperator accumulatorFunction, double x, double oldValue) {
        void var1_1;
        void var3_2;
        return accumulatorFunction.applyAsDouble((double)var3_2, (double)var1_1);
    }
}

