/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class AggregateFutureState<OutputT>
extends AbstractFuture.TrustedFuture<OutputT> {
    private volatile Set<Throwable> seenExceptions = null;
    private volatile int remaining;
    private static final AtomicHelper ATOMIC_HELPER;
    private static final Logger log;

    /*
     * WARNING - void declaration
     */
    AggregateFutureState(int remainingFutures) {
        void var1_1;
        this.remaining = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final Set<Throwable> getOrInitSeenExceptions() {
        void var1_1;
        Set<Throwable> seenExceptionsLocal = this.seenExceptions;
        if (seenExceptionsLocal == null) {
            seenExceptionsLocal = Sets.newConcurrentHashSet();
            this.addInitialException(seenExceptionsLocal);
            ATOMIC_HELPER.compareAndSetSeenExceptions(this, null, seenExceptionsLocal);
            seenExceptionsLocal = Objects.requireNonNull(this.seenExceptions);
        }
        return var1_1;
    }

    abstract void addInitialException(Set<Throwable> var1);

    final int decrementRemainingAndGet() {
        return ATOMIC_HELPER.decrementAndGetRemainingCount(this);
    }

    final void clearSeenExceptions() {
        this.seenExceptions = null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Set access$202(AggregateFutureState x0, Set x1) {
        void var1_1;
        x0.seenExceptions = var1_1;
        return x0.seenExceptions;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0_1;
        Object helper;
        log = Logger.getLogger(AggregateFutureState.class.getName());
        Throwable thrownReflectionFailure = null;
        try {
            helper = new SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(AggregateFutureState.class, Set.class, "seenExceptions"), AtomicIntegerFieldUpdater.newUpdater(AggregateFutureState.class, "remaining"));
        }
        catch (Throwable throwable) {
            helper = throwable;
            thrownReflectionFailure = throwable;
            helper = new SynchronizedAtomicHelper();
        }
        ATOMIC_HELPER = var0_1;
        if (thrownReflectionFailure != null) {
            void var1;
            log.log(Level.SEVERE, "SafeAtomicHelper is broken!", (Throwable)var1);
        }
    }

    private static final class SynchronizedAtomicHelper
    extends AtomicHelper {
        private SynchronizedAtomicHelper() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void compareAndSetSeenExceptions(AggregateFutureState<?> state, Set<Throwable> expect, Set<Throwable> update) {
            AggregateFutureState<?> aggregateFutureState = state;
            synchronized (aggregateFutureState) {
                void var2_3;
                if (((AggregateFutureState)state).seenExceptions == var2_3) {
                    void var3_4;
                    void var1_1;
                    AggregateFutureState.access$202((AggregateFutureState)var1_1, (Set)var3_4);
                }
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int decrementAndGetRemainingCount(AggregateFutureState<?> state) {
            AggregateFutureState<?> aggregateFutureState = state;
            synchronized (aggregateFutureState) {
                void var1_1;
                return --((AggregateFutureState)var1_1).remaining;
            }
        }
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        final AtomicReferenceFieldUpdater<AggregateFutureState<?>, Set<Throwable>> seenExceptionsUpdater;
        final AtomicIntegerFieldUpdater<AggregateFutureState<?>> remainingCountUpdater;

        /*
         * WARNING - void declaration
         */
        SafeAtomicHelper(AtomicReferenceFieldUpdater seenExceptionsUpdater, AtomicIntegerFieldUpdater remainingCountUpdater) {
            void var2_2;
            void var1_1;
            this.seenExceptionsUpdater = var1_1;
            this.remainingCountUpdater = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void compareAndSetSeenExceptions(AggregateFutureState<?> state, Set<Throwable> expect, Set<Throwable> update) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.seenExceptionsUpdater.compareAndSet((AggregateFutureState<?>)var1_1, (Set<Throwable>)var2_2, (Set<Throwable>)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final int decrementAndGetRemainingCount(AggregateFutureState<?> state) {
            void var1_1;
            return this.remainingCountUpdater.decrementAndGet((AggregateFutureState<?>)var1_1);
        }
    }

    private static abstract class AtomicHelper {
        private AtomicHelper() {
        }

        abstract void compareAndSetSeenExceptions(AggregateFutureState<?> var1, Set<Throwable> var2, Set<Throwable> var3);

        abstract int decrementAndGetRemainingCount(AggregateFutureState<?> var1);
    }
}

