/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AggregateFutureState;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ParametricNullness;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AggregateFuture<InputT, OutputT>
extends AggregateFutureState<OutputT> {
    private static final Logger logger = Logger.getLogger(AggregateFuture.class.getName());
    private ImmutableCollection<? extends ListenableFuture<? extends InputT>> futures;
    private final boolean allMustSucceed;
    private final boolean collectsValues;

    /*
     * WARNING - void declaration
     */
    AggregateFuture(ImmutableCollection<? extends ListenableFuture<? extends InputT>> futures, boolean allMustSucceed, boolean collectsValues) {
        super(futures.size());
        void var3_3;
        void var2_2;
        void var1_1;
        this.futures = (ImmutableCollection)Preconditions.checkNotNull(var1_1);
        this.allMustSucceed = var2_2;
        this.collectsValues = var3_3;
    }

    @Override
    protected final void afterDone() {
        super.afterDone();
        ImmutableCollection<? extends ListenableFuture<? extends InputT>> localFutures = this.futures;
        this.releaseResources(ReleaseResourcesReason.OUTPUT_FUTURE_DONE);
        if (((AbstractFuture)this).isCancelled() & localFutures != null) {
            Iterator iterator;
            boolean wasInterrupted = this.wasInterrupted();
            iterator = ((ImmutableCollection)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                Future future = (Future)iterator.next();
                future.cancel(wasInterrupted);
            }
        }
    }

    @Override
    protected final String pendingToString() {
        ImmutableCollection<? extends ListenableFuture<? extends InputT>> localFutures = this.futures;
        if (localFutures != null) {
            String string;
            string = String.valueOf(string);
            return new StringBuilder(8 + String.valueOf(string).length()).append("futures=").append(string).toString();
        }
        return super.pendingToString();
    }

    /*
     * WARNING - void declaration
     */
    final void init() {
        void var1_2;
        Objects.requireNonNull(this.futures);
        if (this.futures.isEmpty()) {
            this.handleAllCompleted();
            return;
        }
        if (this.allMustSucceed) {
            int i = 0;
            for (ListenableFuture listenableFuture : this.futures) {
                int n = i++;
                listenableFuture.addListener(() -> {
                    try {
                        if (listenableFuture.isCancelled()) {
                            this.futures = null;
                            ((AbstractFuture)this).cancel(false);
                        } else {
                            void var1_1;
                            void var2_3;
                            this.collectValueFromNonCancelledFuture((int)var2_3, (Future<? extends InputT>)var1_1);
                        }
                        return;
                    }
                    finally {
                        this.decrementCountAndMaybeComplete(null);
                    }
                }, MoreExecutors.directExecutor());
            }
            return;
        }
        ImmutableCollection<ListenableFuture<InputT>> localFutures = this.collectsValues ? this.futures : null;
        Runnable listener = () -> this.lambda$init$1((ImmutableCollection)var1_2);
        for (ListenableFuture listenableFuture : this.futures) {
            listenableFuture.addListener(listener, MoreExecutors.directExecutor());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handleException(Throwable throwable) {
        boolean bl;
        Preconditions.checkNotNull(throwable);
        if (this.allMustSucceed && !(bl = this.setException(throwable)) && (bl = AggregateFuture.addCausalChain(this.getOrInitSeenExceptions(), throwable))) {
            AggregateFuture.log(throwable);
            return;
        }
        if (throwable instanceof Error) {
            void var1_1;
            AggregateFuture.log((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void log(Throwable throwable) {
        Throwable throwable2;
        void var1_1;
        String message = throwable instanceof Error ? "Input Future failed with Error" : "Got more than one input Future failure. Logging failures after the first";
        logger.log(Level.SEVERE, (String)var1_1, throwable2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final void addInitialException(Set<Throwable> seen) {
        Preconditions.checkNotNull(seen);
        if (!((AbstractFuture)this).isCancelled()) {
            void var1_1;
            AggregateFuture.addCausalChain((Set<Throwable>)var1_1, Objects.requireNonNull(this.tryInternalFastPathGetFailure()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void collectValueFromNonCancelledFuture(int index, Future<? extends InputT> future) {
        try {
            void var2_4;
            this.collectOneValue(index, Futures.getDone(var2_4));
            return;
        }
        catch (ExecutionException e) {
            this.handleException(e.getCause());
            return;
        }
        catch (Throwable t) {
            void var1_3;
            this.handleException((Throwable)var1_3);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void decrementCountAndMaybeComplete(ImmutableCollection<? extends Future<? extends InputT>> futuresIfNeedToCollectAtCompletion) {
        void var2_2;
        int newRemaining = this.decrementRemainingAndGet();
        Preconditions.checkState(newRemaining >= 0, "Less than 0 remaining futures");
        if (var2_2 == false) {
            void var1_1;
            this.processCompleted((ImmutableCollection<? extends Future<? extends InputT>>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processCompleted(ImmutableCollection<? extends Future<? extends InputT>> futuresIfNeedToCollectAtCompletion) {
        if (futuresIfNeedToCollectAtCompletion != null) {
            Iterator iterator;
            int i = 0;
            iterator = ((ImmutableCollection)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                Future future = (Future)iterator.next();
                if (!future.isCancelled()) {
                    void var3_3;
                    this.collectValueFromNonCancelledFuture(i, (Future<? extends InputT>)var3_3);
                }
                ++i;
            }
        }
        this.clearSeenExceptions();
        this.handleAllCompleted();
        this.releaseResources(ReleaseResourcesReason.ALL_INPUT_FUTURES_PROCESSED);
    }

    void releaseResources(ReleaseResourcesReason reason) {
        Preconditions.checkNotNull(reason);
        this.futures = null;
    }

    abstract void collectOneValue(int var1, @ParametricNullness InputT var2);

    abstract void handleAllCompleted();

    private static boolean addCausalChain(Set<Throwable> seen, Throwable param) {
        for (Throwable t = param; t != null; t = t.getCause()) {
            boolean bl = seen.add(t);
            if (bl) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$init$1(ImmutableCollection localFutures) {
        void var1_1;
        this.decrementCountAndMaybeComplete((ImmutableCollection<? extends Future<? extends InputT>>)var1_1);
    }

    static enum ReleaseResourcesReason {
        OUTPUT_FUTURE_DONE,
        ALL_INPUT_FUTURES_PROCESSED;

    }
}

