/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ParametricNullness;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractTransformFuture<I, O, F, T>
extends FluentFuture.TrustedFuture<O>
implements Runnable {
    ListenableFuture<? extends I> inputFuture;
    F function;

    /*
     * WARNING - void declaration
     */
    static <I, O> ListenableFuture<O> create(ListenableFuture<I> input, AsyncFunction<? super I, ? extends O> function, Executor executor) {
        void var1_1;
        void var2_2;
        ListenableFuture<I> listenableFuture;
        Preconditions.checkNotNull(executor);
        AsyncTransformFuture<? super I, ? extends O> output = new AsyncTransformFuture<I, O>(input, function);
        listenableFuture.addListener(output, MoreExecutors.rejectionPropagatingExecutor((Executor)var2_2, output));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static <I, O> ListenableFuture<O> create(ListenableFuture<I> input, Function<? super I, ? extends O> function, Executor executor) {
        void var1_1;
        void var2_2;
        ListenableFuture<I> listenableFuture;
        Preconditions.checkNotNull(function);
        TransformFuture<? super I, ? extends O> output = new TransformFuture<I, O>(input, function);
        listenableFuture.addListener(output, MoreExecutors.rejectionPropagatingExecutor((Executor)var2_2, output));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    AbstractTransformFuture(ListenableFuture<? extends I> inputFuture, F function) {
        void var2_2;
        void var1_1;
        this.inputFuture = (ListenableFuture)Preconditions.checkNotNull(var1_1);
        this.function = Preconditions.checkNotNull(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void run() {
        void var1_1;
        I sourceResult;
        ListenableFuture<I> localInputFuture = this.inputFuture;
        F localFunction = this.function;
        if (((AbstractFuture)this).isCancelled() | localInputFuture == null | localFunction == null) {
            return;
        }
        this.inputFuture = null;
        if (localInputFuture.isCancelled()) {
            this.setFuture(localInputFuture);
            return;
        }
        try {
            sourceResult = Futures.getDone(localInputFuture);
        }
        catch (CancellationException cancellationException) {
            ((AbstractFuture)this).cancel(false);
            return;
        }
        catch (ExecutionException e) {
            this.setException(e.getCause());
            return;
        }
        catch (RuntimeException e) {
            this.setException(e);
            return;
        }
        catch (Error e) {
            this.setException(e);
            return;
        }
        try {
            void var2_7;
            T transformResult = this.doTransform(var2_7, sourceResult);
            this.function = null;
        }
        catch (Throwable t2) {
            try {
                this.setException(t2);
                this.function = null;
                return;
            }
            catch (Throwable t2) {
                void transformResult;
                this.function = null;
                throw transformResult;
            }
        }
        this.setResult(var1_1);
    }

    @ParametricNullness
    abstract T doTransform(F var1, @ParametricNullness I var2) throws Exception;

    abstract void setResult(@ParametricNullness T var1);

    @Override
    protected final void afterDone() {
        AbstractTransformFuture abstractTransformFuture = this;
        abstractTransformFuture.maybePropagateCancellationTo(abstractTransformFuture.inputFuture);
        this.inputFuture = null;
        this.function = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String pendingToString() {
        String string;
        ListenableFuture<? extends I> localInputFuture = this.inputFuture;
        F localFunction = this.function;
        String superString = super.pendingToString();
        String resultString = "";
        if (localInputFuture != null) {
            string = String.valueOf(string);
            resultString = new StringBuilder(16 + String.valueOf(string).length()).append("inputFuture=[").append(string).append("], ").toString();
        }
        if (localFunction != null) {
            String string2;
            string = resultString;
            string2 = String.valueOf(string2);
            return new StringBuilder(11 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("function=[").append(string2).append("]").toString();
        }
        if (superString != null) {
            void var3_3;
            String string3 = String.valueOf(resultString);
            String string4 = String.valueOf(var3_3);
            if (string4.length() != 0) {
                return string3.concat(string4);
            }
            return new String(string3);
        }
        return null;
    }

    private static final class TransformFuture<I, O>
    extends AbstractTransformFuture<I, O, Function<? super I, ? extends O>, O> {
        /*
         * WARNING - void declaration
         */
        TransformFuture(ListenableFuture<? extends I> inputFuture, Function<? super I, ? extends O> function) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        final O doTransform(Function<? super I, ? extends O> function, @ParametricNullness I input) {
            void var2_2;
            return function.apply(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void setResult(@ParametricNullness O result) {
            void var1_1;
            this.set(var1_1);
        }
    }

    private static final class AsyncTransformFuture<I, O>
    extends AbstractTransformFuture<I, O, AsyncFunction<? super I, ? extends O>, ListenableFuture<? extends O>> {
        /*
         * WARNING - void declaration
         */
        AsyncTransformFuture(ListenableFuture<? extends I> inputFuture, AsyncFunction<? super I, ? extends O> function) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ListenableFuture<? extends O> doTransform(AsyncFunction<? super I, ? extends O> function, @ParametricNullness I input) throws Exception {
            void var2_2;
            void var1_1;
            ListenableFuture<? extends O> outputFuture = function.apply(input);
            Preconditions.checkNotNull(outputFuture, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", (Object)var1_1);
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void setResult(ListenableFuture<? extends O> result) {
            void var1_1;
            this.setFuture(var1_1);
        }
    }
}

