/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ListenerCallQueue;
import com.google.common.util.concurrent.Monitor;
import com.google.common.util.concurrent.Service;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class AbstractService
implements Service {
    private static final ListenerCallQueue.Event<Service.Listener> STARTING_EVENT = new ListenerCallQueue.Event<Service.Listener>(){

        @Override
        public void call(Service.Listener listener) {
            listener.starting();
        }

        public String toString() {
            return "starting()";
        }
    };
    private static final ListenerCallQueue.Event<Service.Listener> RUNNING_EVENT = new ListenerCallQueue.Event<Service.Listener>(){

        @Override
        public void call(Service.Listener listener) {
            listener.running();
        }

        public String toString() {
            return "running()";
        }
    };
    private static final ListenerCallQueue.Event<Service.Listener> STOPPING_FROM_STARTING_EVENT = AbstractService.stoppingEvent(Service.State.STARTING);
    private static final ListenerCallQueue.Event<Service.Listener> STOPPING_FROM_RUNNING_EVENT = AbstractService.stoppingEvent(Service.State.RUNNING);
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_NEW_EVENT = AbstractService.terminatedEvent(Service.State.NEW);
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_STARTING_EVENT = AbstractService.terminatedEvent(Service.State.STARTING);
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_RUNNING_EVENT = AbstractService.terminatedEvent(Service.State.RUNNING);
    private static final ListenerCallQueue.Event<Service.Listener> TERMINATED_FROM_STOPPING_EVENT = AbstractService.terminatedEvent(Service.State.STOPPING);
    private final Monitor monitor = new Monitor();
    private final Monitor.Guard isStartable = new IsStartableGuard();
    private final Monitor.Guard isStoppable = new IsStoppableGuard();
    private final Monitor.Guard hasReachedRunning = new HasReachedRunningGuard();
    private final Monitor.Guard isStopped = new IsStoppedGuard();
    private final ListenerCallQueue<Service.Listener> listeners = new ListenerCallQueue();
    private volatile StateSnapshot snapshot = new StateSnapshot(Service.State.NEW);

    private static ListenerCallQueue.Event<Service.Listener> terminatedEvent(Service.State from) {
        Service.State state;
        return new ListenerCallQueue.Event<Service.Listener>(){

            @Override
            public void call(Service.Listener listener) {
                listener.terminated(state);
            }

            public String toString() {
                String string = String.valueOf((Object)state);
                return new StringBuilder(21 + String.valueOf(string).length()).append("terminated({from = ").append(string).append("})").toString();
            }
        };
    }

    private static ListenerCallQueue.Event<Service.Listener> stoppingEvent(Service.State from) {
        Service.State state;
        return new ListenerCallQueue.Event<Service.Listener>(){

            @Override
            public void call(Service.Listener listener) {
                listener.stopping(state);
            }

            public String toString() {
                String string = String.valueOf((Object)state);
                return new StringBuilder(19 + String.valueOf(string).length()).append("stopping({from = ").append(string).append("})").toString();
            }
        };
    }

    protected AbstractService() {
    }

    protected abstract void doStart();

    protected abstract void doStop();

    @Beta
    protected void doCancelStart() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Service startAsync() {
        if (this.monitor.enterIf(this.isStartable)) {
            try {
                this.snapshot = new StateSnapshot(Service.State.STARTING);
                this.enqueueStartingEvent();
                this.doStart();
            }
            catch (Throwable startupFailure) {
                void var1_1;
                this.notifyFailed((Throwable)var1_1);
            }
            finally {
                this.monitor.leave();
                this.dispatchListenerEvents();
            }
        } else {
            String string = String.valueOf(this);
            throw new IllegalStateException(new StringBuilder(33 + String.valueOf(string).length()).append("Service ").append(string).append(" has already been started").toString());
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Service stopAsync() {
        if (!this.monitor.enterIf(this.isStoppable)) return this;
        try {
            Service.State state = this.state();
            switch (state) {
                case NEW: {
                    this.snapshot = new StateSnapshot(Service.State.TERMINATED);
                    this.enqueueTerminatedEvent(Service.State.NEW);
                    return this;
                }
                case STARTING: {
                    this.snapshot = new StateSnapshot(Service.State.STARTING, true, null);
                    this.enqueueStoppingEvent(Service.State.STARTING);
                    this.doCancelStart();
                    return this;
                }
                case RUNNING: {
                    this.snapshot = new StateSnapshot(Service.State.STOPPING);
                    this.enqueueStoppingEvent(Service.State.RUNNING);
                    this.doStop();
                    return this;
                }
                case STOPPING: 
                case TERMINATED: 
                case FAILED: {
                    String string = String.valueOf((Object)state);
                    throw new AssertionError((Object)new StringBuilder(45 + String.valueOf(string).length()).append("isStoppable is incorrectly implemented, saw: ").append(string).toString());
                }
            }
            return this;
        }
        catch (Throwable throwable) {
            this.notifyFailed(throwable);
            return this;
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    @Override
    public final void awaitRunning() {
        this.monitor.enterWhenUninterruptibly(this.hasReachedRunning);
        try {
            this.checkCurrentState(Service.State.RUNNING);
            return;
        }
        finally {
            this.monitor.leave();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitRunning(Duration timeout) throws TimeoutException {
        void var1_1;
        Service.super.awaitRunning((Duration)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitRunning(long timeout, TimeUnit unit) throws TimeoutException {
        void var3_4;
        void var1_1;
        if (this.monitor.enterWhenUninterruptibly(this.hasReachedRunning, (long)var1_1, (TimeUnit)var3_4)) {
            try {
                this.checkCurrentState(Service.State.RUNNING);
            }
            finally {
                this.monitor.leave();
            }
        } else {
            String string = String.valueOf(this);
            throw new TimeoutException(new StringBuilder(50 + String.valueOf(string).length()).append("Timed out waiting for ").append(string).append(" to reach the RUNNING state.").toString());
        }
    }

    @Override
    public final void awaitTerminated() {
        this.monitor.enterWhenUninterruptibly(this.isStopped);
        try {
            this.checkCurrentState(Service.State.TERMINATED);
            return;
        }
        finally {
            this.monitor.leave();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitTerminated(Duration timeout) throws TimeoutException {
        void var1_1;
        Service.super.awaitTerminated((Duration)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitTerminated(long timeout, TimeUnit unit) throws TimeoutException {
        void var3_4;
        void var1_1;
        if (this.monitor.enterWhenUninterruptibly(this.isStopped, (long)var1_1, (TimeUnit)var3_4)) {
            try {
                this.checkCurrentState(Service.State.TERMINATED);
            }
            finally {
                this.monitor.leave();
            }
        } else {
            String string = String.valueOf(this);
            String string2 = String.valueOf((Object)this.state());
            throw new TimeoutException(new StringBuilder(65 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Timed out waiting for ").append(string).append(" to reach a terminal state. Current state: ").append(string2).toString());
        }
    }

    private void checkCurrentState(Service.State expected) {
        Service.State actual = this.state();
        if (actual != expected) {
            String string;
            String string2;
            if (actual == Service.State.FAILED) {
                String string3 = String.valueOf(this);
                expected = String.valueOf(expected);
                throw new IllegalStateException(new StringBuilder(56 + String.valueOf(string3).length() + String.valueOf(expected).length()).append("Expected the service ").append(string3).append(" to be ").append((String)expected).append(", but the service has FAILED").toString(), this.failureCause());
            }
            String string4 = String.valueOf(this);
            string2 = String.valueOf(string2);
            string = String.valueOf(string);
            throw new IllegalStateException(new StringBuilder(38 + String.valueOf(string4).length() + String.valueOf(string2).length() + String.valueOf(string).length()).append("Expected the service ").append(string4).append(" to be ").append(string2).append(", but was ").append(string).toString());
        }
    }

    protected final void notifyStarted() {
        this.monitor.enter();
        try {
            if (this.snapshot.state != Service.State.STARTING) {
                String string = String.valueOf((Object)this.snapshot.state);
                IllegalStateException failure = new IllegalStateException(new StringBuilder(43 + String.valueOf(string).length()).append("Cannot notifyStarted() when the service is ").append(string).toString());
                this.notifyFailed(failure);
                throw string;
            }
            if (this.snapshot.shutdownWhenStartupFinishes) {
                this.snapshot = new StateSnapshot(Service.State.STOPPING);
                this.doStop();
            } else {
                this.snapshot = new StateSnapshot(Service.State.RUNNING);
                this.enqueueRunningEvent();
            }
            return;
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void notifyStopped() {
        this.monitor.enter();
        try {
            Object previous = this.state();
            switch (previous) {
                case NEW: 
                case TERMINATED: 
                case FAILED: {
                    previous = String.valueOf(previous);
                    throw new IllegalStateException(new StringBuilder(43 + String.valueOf(previous).length()).append("Cannot notifyStopped() when the service is ").append((String)previous).toString());
                }
                case STARTING: 
                case RUNNING: 
                case STOPPING: {
                    void var1_1;
                    this.snapshot = new StateSnapshot(Service.State.TERMINATED);
                    this.enqueueTerminatedEvent((Service.State)var1_1);
                    break;
                }
            }
            return;
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void notifyFailed(Throwable cause) {
        Preconditions.checkNotNull(cause);
        this.monitor.enter();
        try {
            Object previous = this.state();
            switch (previous) {
                case NEW: 
                case TERMINATED: {
                    previous = String.valueOf(previous);
                    throw new IllegalStateException(new StringBuilder(22 + String.valueOf(previous).length()).append("Failed while in state:").append((String)previous).toString(), cause);
                }
                case STARTING: 
                case RUNNING: 
                case STOPPING: {
                    void var1_1;
                    void var2_3;
                    this.snapshot = new StateSnapshot(Service.State.FAILED, false, cause);
                    this.enqueueFailedEvent((Service.State)var2_3, (Throwable)var1_1);
                    break;
                }
            }
            return;
        }
        finally {
            this.monitor.leave();
            this.dispatchListenerEvents();
        }
    }

    @Override
    public final boolean isRunning() {
        return this.state() == Service.State.RUNNING;
    }

    @Override
    public final Service.State state() {
        return this.snapshot.externalState();
    }

    @Override
    public final Throwable failureCause() {
        return this.snapshot.failureCause();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addListener(Service.Listener listener, Executor executor) {
        void var2_2;
        void var1_1;
        this.listeners.addListener((Service.Listener)var1_1, (Executor)var2_2);
    }

    public String toString() {
        String string = this.getClass().getSimpleName();
        String string2 = String.valueOf((Object)this.state());
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" [").append(string2).append("]").toString();
    }

    private void dispatchListenerEvents() {
        if (!this.monitor.isOccupiedByCurrentThread()) {
            this.listeners.dispatch();
        }
    }

    private void enqueueStartingEvent() {
        this.listeners.enqueue(STARTING_EVENT);
    }

    private void enqueueRunningEvent() {
        this.listeners.enqueue(RUNNING_EVENT);
    }

    /*
     * WARNING - void declaration
     */
    private void enqueueStoppingEvent(Service.State from) {
        void var1_1;
        if (from == Service.State.STARTING) {
            this.listeners.enqueue(STOPPING_FROM_STARTING_EVENT);
            return;
        }
        if (var1_1 == Service.State.RUNNING) {
            this.listeners.enqueue(STOPPING_FROM_RUNNING_EVENT);
            return;
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    private void enqueueTerminatedEvent(Service.State from) {
        void var1_1;
        switch (6.$SwitchMap$com$google$common$util$concurrent$Service$State[var1_1.ordinal()]) {
            case 1: {
                this.listeners.enqueue(TERMINATED_FROM_NEW_EVENT);
                return;
            }
            case 2: {
                this.listeners.enqueue(TERMINATED_FROM_STARTING_EVENT);
                return;
            }
            case 3: {
                this.listeners.enqueue(TERMINATED_FROM_RUNNING_EVENT);
                return;
            }
            case 4: {
                this.listeners.enqueue(TERMINATED_FROM_STOPPING_EVENT);
                return;
            }
            case 5: 
            case 6: {
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void enqueueFailedEvent(Service.State from, Throwable cause) {
        void var2_2;
        void var1_1;
        this.listeners.enqueue(new ListenerCallQueue.Event<Service.Listener>(this, (Service.State)var1_1, (Throwable)var2_2){
            final /* synthetic */ Service.State val$from;
            final /* synthetic */ Throwable val$cause;
            {
                this.val$from = state;
                this.val$cause = throwable;
            }

            @Override
            public void call(Service.Listener listener) {
                listener.failed(this.val$from, this.val$cause);
            }

            public String toString() {
                String string = String.valueOf((Object)this.val$from);
                String string2 = String.valueOf(this.val$cause);
                return new StringBuilder(27 + String.valueOf(string).length() + String.valueOf(string2).length()).append("failed({from = ").append(string).append(", cause = ").append(string2).append("})").toString();
            }
        });
    }

    private static final class StateSnapshot {
        final Service.State state;
        final boolean shutdownWhenStartupFinishes;
        final Throwable failure;

        /*
         * WARNING - void declaration
         */
        StateSnapshot(Service.State internalState) {
            this((Service.State)var1_1, false, null);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        StateSnapshot(Service.State internalState, boolean shutdownWhenStartupFinishes, Throwable failure) {
            void var3_3;
            void var2_2;
            void var1_1;
            Preconditions.checkArgument(!shutdownWhenStartupFinishes || internalState == Service.State.STARTING, "shutdownWhenStartupFinishes can only be set if state is STARTING. Got %s instead.", (Object)internalState);
            Preconditions.checkArgument(failure != null == (internalState == Service.State.FAILED), "A failure cause should be set if and only if the state is failed.  Got %s and %s instead.", (Object)internalState, (Object)failure);
            this.state = var1_1;
            this.shutdownWhenStartupFinishes = var2_2;
            this.failure = var3_3;
        }

        final Service.State externalState() {
            if (this.shutdownWhenStartupFinishes && this.state == Service.State.STARTING) {
                return Service.State.STOPPING;
            }
            return this.state;
        }

        final Throwable failureCause() {
            Preconditions.checkState(this.state == Service.State.FAILED, "failureCause() is only valid if the service has failed, service is %s", (Object)this.state);
            return Objects.requireNonNull(this.failure);
        }
    }

    private final class IsStoppedGuard
    extends Monitor.Guard {
        IsStoppedGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public final boolean isSatisfied() {
            return AbstractService.this.state().compareTo(Service.State.TERMINATED) >= 0;
        }
    }

    private final class HasReachedRunningGuard
    extends Monitor.Guard {
        HasReachedRunningGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public final boolean isSatisfied() {
            return AbstractService.this.state().compareTo(Service.State.RUNNING) >= 0;
        }
    }

    private final class IsStoppableGuard
    extends Monitor.Guard {
        IsStoppableGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public final boolean isSatisfied() {
            return AbstractService.this.state().compareTo(Service.State.RUNNING) <= 0;
        }
    }

    private final class IsStartableGuard
    extends Monitor.Guard {
        IsStartableGuard() {
            super(AbstractService.this.monitor);
        }

        @Override
        public final boolean isSatisfied() {
            return AbstractService.this.state() == Service.State.NEW;
        }
    }
}

