/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Internal;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class AbstractScheduledService
implements Service {
    private static final Logger logger = Logger.getLogger(AbstractScheduledService.class.getName());
    private final AbstractService delegate = new ServiceDelegate();

    protected AbstractScheduledService() {
    }

    protected abstract void runOneIteration() throws Exception;

    protected void startUp() throws Exception {
    }

    protected void shutDown() throws Exception {
    }

    protected abstract Scheduler scheduler();

    /*
     * WARNING - void declaration
     */
    protected ScheduledExecutorService executor() {
        void var1_1;
        class ThreadFactoryImpl
        implements ThreadFactory {
            final /* synthetic */ AbstractScheduledService this$0;

            /*
             * WARNING - void declaration
             */
            ThreadFactoryImpl(AbstractScheduledService this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Thread newThread(Runnable runnable) {
                void var1_1;
                return MoreExecutors.newThread(this.this$0.serviceName(), (Runnable)var1_1);
            }
        }
        final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryImpl(this));
        this.addListener(new Service.Listener(this){

            @Override
            public void terminated(Service.State from) {
                executor.shutdown();
            }

            @Override
            public void failed(Service.State from, Throwable failure) {
                executor.shutdown();
            }
        }, MoreExecutors.directExecutor());
        return var1_1;
    }

    protected String serviceName() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        String string = this.serviceName();
        String string2 = String.valueOf((Object)this.state());
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" [").append(string2).append("]").toString();
    }

    @Override
    public final boolean isRunning() {
        return this.delegate.isRunning();
    }

    @Override
    public final Service.State state() {
        return this.delegate.state();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addListener(Service.Listener listener, Executor executor) {
        void var2_2;
        void var1_1;
        this.delegate.addListener((Service.Listener)var1_1, (Executor)var2_2);
    }

    @Override
    public final Throwable failureCause() {
        return this.delegate.failureCause();
    }

    @Override
    public final Service startAsync() {
        this.delegate.startAsync();
        return this;
    }

    @Override
    public final Service stopAsync() {
        this.delegate.stopAsync();
        return this;
    }

    @Override
    public final void awaitRunning() {
        this.delegate.awaitRunning();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitRunning(Duration timeout) throws TimeoutException {
        void var1_1;
        Service.super.awaitRunning((Duration)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitRunning(long timeout, TimeUnit unit) throws TimeoutException {
        void var3_2;
        void var1_1;
        this.delegate.awaitRunning((long)var1_1, (TimeUnit)var3_2);
    }

    @Override
    public final void awaitTerminated() {
        this.delegate.awaitTerminated();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitTerminated(Duration timeout) throws TimeoutException {
        void var1_1;
        Service.super.awaitTerminated((Duration)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitTerminated(long timeout, TimeUnit unit) throws TimeoutException {
        void var3_2;
        void var1_1;
        this.delegate.awaitTerminated((long)var1_1, (TimeUnit)var3_2);
    }

    public static abstract class CustomScheduler
    extends Scheduler {
        /*
         * WARNING - void declaration
         */
        @Override
        final Cancellable schedule(AbstractService service, ScheduledExecutorService executor, Runnable runnable) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new ReschedulableCallable((AbstractService)var1_1, (ScheduledExecutorService)var2_2, (Runnable)var3_3).reschedule();
        }

        protected abstract Schedule getNextSchedule() throws Exception;

        protected static final class Schedule {
            private final long delay;
            private final TimeUnit unit;

            /*
             * WARNING - void declaration
             */
            public Schedule(long delay, TimeUnit unit) {
                void var3_2;
                void var1_1;
                this.delay = var1_1;
                this.unit = (TimeUnit)Preconditions.checkNotNull(var3_2);
            }

            /*
             * WARNING - void declaration
             */
            public Schedule(Duration delay) {
                this(Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
                void var1_1;
            }
        }

        private static final class SupplantableFuture
        implements Cancellable {
            private final ReentrantLock lock;
            private Future<Void> currentFuture;

            /*
             * WARNING - void declaration
             */
            SupplantableFuture(ReentrantLock lock, Future<Void> currentFuture) {
                void var2_2;
                void var1_1;
                this.lock = var1_1;
                this.currentFuture = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void cancel(boolean mayInterruptIfRunning) {
                this.lock.lock();
                try {
                    void var1_1;
                    this.currentFuture.cancel((boolean)var1_1);
                    return;
                }
                finally {
                    this.lock.unlock();
                }
            }

            @Override
            public final boolean isCancelled() {
                this.lock.lock();
                try {
                    boolean bl = this.currentFuture.isCancelled();
                    return bl;
                }
                finally {
                    this.lock.unlock();
                }
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ Future access$802(SupplantableFuture x0, Future x1) {
                void var1_1;
                x0.currentFuture = var1_1;
                return x0.currentFuture;
            }
        }

        private final class ReschedulableCallable
        implements Callable<Void> {
            private final Runnable wrappedRunnable;
            private final ScheduledExecutorService executor;
            private final AbstractService service;
            private final ReentrantLock lock = new ReentrantLock();
            private SupplantableFuture cancellationDelegate;

            /*
             * WARNING - void declaration
             */
            ReschedulableCallable(AbstractService service, ScheduledExecutorService executor, Runnable runnable) {
                void var2_2;
                void var3_3;
                this.wrappedRunnable = runnable;
                this.executor = var3_3;
                this.service = var2_2;
            }

            @Override
            public final Void call() throws Exception {
                this.wrappedRunnable.run();
                this.reschedule();
                return null;
            }

            /*
             * WARNING - void declaration
             */
            public final Cancellable reschedule() {
                void var1_1;
                Object toReturn;
                Schedule schedule;
                try {
                    schedule = CustomScheduler.this.getNextSchedule();
                }
                catch (Throwable t) {
                    this.service.notifyFailed(t);
                    return new FutureAsCancellable(Futures.immediateCancelledFuture());
                }
                Throwable scheduleFailure = null;
                this.lock.lock();
                try {
                    toReturn = this.initializeOrUpdateCancellationDelegate(schedule);
                }
                catch (Throwable throwable) {
                    toReturn = throwable;
                    scheduleFailure = throwable;
                    toReturn = new FutureAsCancellable(Futures.immediateCancelledFuture());
                }
                finally {
                    this.lock.unlock();
                }
                if (scheduleFailure != null) {
                    void var2_4;
                    this.service.notifyFailed((Throwable)var2_4);
                }
                return var1_1;
            }

            /*
             * WARNING - void declaration
             */
            private Cancellable initializeOrUpdateCancellationDelegate(Schedule schedule) {
                if (this.cancellationDelegate == null) {
                    this.cancellationDelegate = new SupplantableFuture(this.lock, this.submitToExecutor(schedule));
                    return this.cancellationDelegate;
                }
                if (!this.cancellationDelegate.currentFuture.isCancelled()) {
                    void var1_1;
                    SupplantableFuture.access$802(this.cancellationDelegate, this.submitToExecutor((Schedule)var1_1));
                }
                return this.cancellationDelegate;
            }

            /*
             * WARNING - void declaration
             */
            private ScheduledFuture<Void> submitToExecutor(Schedule schedule) {
                void var1_1;
                return this.executor.schedule(this, schedule.delay, ((Schedule)var1_1).unit);
            }
        }
    }

    private static final class FutureAsCancellable
    implements Cancellable {
        private final Future<?> delegate;

        /*
         * WARNING - void declaration
         */
        FutureAsCancellable(Future<?> delegate) {
            void var1_1;
            this.delegate = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void cancel(boolean mayInterruptIfRunning) {
            void var1_1;
            this.delegate.cancel((boolean)var1_1);
        }

        @Override
        public final boolean isCancelled() {
            return this.delegate.isCancelled();
        }
    }

    static interface Cancellable {
        public void cancel(boolean var1);

        public boolean isCancelled();
    }

    private final class ServiceDelegate
    extends AbstractService {
        private volatile Cancellable runningTask;
        private volatile ScheduledExecutorService executorService;
        private final ReentrantLock lock = new ReentrantLock();
        private final Runnable task = new Task(this);

        private ServiceDelegate() {
        }

        @Override
        protected final void doStart() {
            this.executorService = MoreExecutors.renamingDecorator(AbstractScheduledService.this.executor(), new Supplier<String>(this){
                final /* synthetic */ ServiceDelegate this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                @Override
                public String get() {
                    String string = this.this$1.AbstractScheduledService.this.serviceName();
                    String string2 = String.valueOf((Object)this.this$1.state());
                    return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" ").append(string2).toString();
                }
            });
            this.executorService.execute(new Runnable(this){
                final /* synthetic */ ServiceDelegate this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    this.this$1.lock.lock();
                    try {
                        this.this$1.AbstractScheduledService.this.startUp();
                        ServiceDelegate.access$302(this.this$1, this.this$1.AbstractScheduledService.this.scheduler().schedule(this.this$1.AbstractScheduledService.this.delegate, this.this$1.executorService, this.this$1.task));
                        this.this$1.notifyStarted();
                        return;
                    }
                    catch (Throwable t) {
                        void var1_1;
                        this.this$1.notifyFailed((Throwable)var1_1);
                        if (this.this$1.runningTask != null) {
                            this.this$1.runningTask.cancel(false);
                        }
                        return;
                    }
                    finally {
                        this.this$1.lock.unlock();
                    }
                }
            });
        }

        @Override
        protected final void doStop() {
            Objects.requireNonNull(this.runningTask);
            Objects.requireNonNull(this.executorService);
            this.runningTask.cancel(false);
            this.executorService.execute(new Runnable(this){
                final /* synthetic */ ServiceDelegate this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    try {
                        this.this$1.lock.lock();
                        try {
                            if (this.this$1.state() != Service.State.STOPPING) {
                                return;
                            }
                            this.this$1.AbstractScheduledService.this.shutDown();
                        }
                        finally {
                            this.this$1.lock.unlock();
                        }
                        this.this$1.notifyStopped();
                        return;
                    }
                    catch (Throwable t) {
                        void var1_2;
                        this.this$1.notifyFailed((Throwable)var1_2);
                        return;
                    }
                }
            });
        }

        @Override
        public final String toString() {
            return AbstractScheduledService.this.toString();
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ Cancellable access$302(ServiceDelegate x0, Cancellable x1) {
            void var1_1;
            x0.runningTask = var1_1;
            return x0.runningTask;
        }

        class Task
        implements Runnable {
            final /* synthetic */ ServiceDelegate this$1;

            /*
             * WARNING - void declaration
             */
            Task(ServiceDelegate this$1) {
                void var1_1;
                this.this$1 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                this.this$1.lock.lock();
                try {
                    if (Objects.requireNonNull(this.this$1.runningTask).isCancelled()) {
                        return;
                    }
                    this.this$1.AbstractScheduledService.this.runOneIteration();
                    return;
                }
                catch (Throwable t) {
                    void var1_1;
                    try {
                        this.this$1.AbstractScheduledService.this.shutDown();
                    }
                    catch (Exception ignored) {
                        void var2_3;
                        logger.log(Level.WARNING, "Error while attempting to shut down the service after failure.", (Throwable)var2_3);
                    }
                    this.this$1.notifyFailed((Throwable)var1_1);
                    Objects.requireNonNull(this.this$1.runningTask).cancel(false);
                    return;
                }
                finally {
                    this.this$1.lock.unlock();
                }
            }
        }
    }

    public static abstract class Scheduler {
        /*
         * WARNING - void declaration
         */
        public static Scheduler newFixedDelaySchedule(Duration initialDelay, Duration delay) {
            void var1_1;
            return Scheduler.newFixedDelaySchedule(Internal.toNanosSaturated(initialDelay), Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
        }

        /*
         * WARNING - void declaration
         */
        public static Scheduler newFixedDelaySchedule(long initialDelay, long delay, TimeUnit unit) {
            void var2_2;
            long l;
            Preconditions.checkNotNull(unit);
            Preconditions.checkArgument(delay > 0L, "delay must be > 0, found %s", delay);
            return new Scheduler((long)var2_2, unit){
                final /* synthetic */ long val$delay;
                final /* synthetic */ TimeUnit val$unit;
                {
                    this.val$delay = l2;
                    this.val$unit = timeUnit;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Cancellable schedule(AbstractService service, ScheduledExecutorService executor, Runnable task) {
                    void var3_3;
                    void var2_2;
                    return new FutureAsCancellable(var2_2.scheduleWithFixedDelay((Runnable)var3_3, l, this.val$delay, this.val$unit));
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        public static Scheduler newFixedRateSchedule(Duration initialDelay, Duration period) {
            void var1_1;
            return Scheduler.newFixedRateSchedule(Internal.toNanosSaturated(initialDelay), Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
        }

        /*
         * WARNING - void declaration
         */
        public static Scheduler newFixedRateSchedule(long initialDelay, long period, TimeUnit unit) {
            void var2_2;
            long l;
            Preconditions.checkNotNull(unit);
            Preconditions.checkArgument(period > 0L, "period must be > 0, found %s", period);
            return new Scheduler((long)var2_2, unit){
                final /* synthetic */ long val$period;
                final /* synthetic */ TimeUnit val$unit;
                {
                    this.val$period = l2;
                    this.val$unit = timeUnit;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Cancellable schedule(AbstractService service, ScheduledExecutorService executor, Runnable task) {
                    void var3_3;
                    void var2_2;
                    return new FutureAsCancellable(var2_2.scheduleAtFixedRate((Runnable)var3_3, l, this.val$period, this.val$unit));
                }
            };
        }

        abstract Cancellable schedule(AbstractService var1, ScheduledExecutorService var2, Runnable var3);

        private Scheduler() {
        }
    }
}

