/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class AbstractIdleService
implements Service {
    private final Supplier<String> threadNameSupplier = new ThreadNameSupplier();
    private final Service delegate = new DelegateService();

    protected AbstractIdleService() {
    }

    protected abstract void startUp() throws Exception;

    protected abstract void shutDown() throws Exception;

    protected Executor executor() {
        return new Executor(this){
            final /* synthetic */ AbstractIdleService this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void execute(Runnable command) {
                void var1_1;
                MoreExecutors.newThread((String)this.this$0.threadNameSupplier.get(), (Runnable)var1_1).start();
            }
        };
    }

    public String toString() {
        String string = this.serviceName();
        String string2 = String.valueOf((Object)this.state());
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" [").append(string2).append("]").toString();
    }

    @Override
    public final boolean isRunning() {
        return this.delegate.isRunning();
    }

    @Override
    public final Service.State state() {
        return this.delegate.state();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addListener(Service.Listener listener, Executor executor) {
        void var2_2;
        void var1_1;
        this.delegate.addListener((Service.Listener)var1_1, (Executor)var2_2);
    }

    @Override
    public final Throwable failureCause() {
        return this.delegate.failureCause();
    }

    @Override
    public final Service startAsync() {
        this.delegate.startAsync();
        return this;
    }

    @Override
    public final Service stopAsync() {
        this.delegate.stopAsync();
        return this;
    }

    @Override
    public final void awaitRunning() {
        this.delegate.awaitRunning();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitRunning(Duration timeout) throws TimeoutException {
        void var1_1;
        Service.super.awaitRunning((Duration)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitRunning(long timeout, TimeUnit unit) throws TimeoutException {
        void var3_2;
        void var1_1;
        this.delegate.awaitRunning((long)var1_1, (TimeUnit)var3_2);
    }

    @Override
    public final void awaitTerminated() {
        this.delegate.awaitTerminated();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitTerminated(Duration timeout) throws TimeoutException {
        void var1_1;
        Service.super.awaitTerminated((Duration)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitTerminated(long timeout, TimeUnit unit) throws TimeoutException {
        void var3_2;
        void var1_1;
        this.delegate.awaitTerminated((long)var1_1, (TimeUnit)var3_2);
    }

    protected String serviceName() {
        return this.getClass().getSimpleName();
    }

    private final class DelegateService
    extends AbstractService {
        private DelegateService() {
        }

        @Override
        protected final void doStart() {
            MoreExecutors.renamingDecorator(AbstractIdleService.this.executor(), (Supplier<String>)AbstractIdleService.this.threadNameSupplier).execute(new Runnable(this){
                final /* synthetic */ DelegateService this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    try {
                        this.this$1.AbstractIdleService.this.startUp();
                        this.this$1.notifyStarted();
                        return;
                    }
                    catch (Throwable t) {
                        void var1_1;
                        this.this$1.notifyFailed((Throwable)var1_1);
                        return;
                    }
                }
            });
        }

        @Override
        protected final void doStop() {
            MoreExecutors.renamingDecorator(AbstractIdleService.this.executor(), (Supplier<String>)AbstractIdleService.this.threadNameSupplier).execute(new Runnable(this){
                final /* synthetic */ DelegateService this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    try {
                        this.this$1.AbstractIdleService.this.shutDown();
                        this.this$1.notifyStopped();
                        return;
                    }
                    catch (Throwable t) {
                        void var1_1;
                        this.this$1.notifyFailed((Throwable)var1_1);
                        return;
                    }
                }
            });
        }

        @Override
        public final String toString() {
            return AbstractIdleService.this.toString();
        }
    }

    private final class ThreadNameSupplier
    implements Supplier<String> {
        private ThreadNameSupplier() {
        }

        @Override
        public final String get() {
            String string = AbstractIdleService.this.serviceName();
            String string2 = String.valueOf((Object)AbstractIdleService.this.state());
            return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" ").append(string2).toString();
        }
    }
}

