/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.DirectExecutor;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.NullnessCasts;
import com.google.common.util.concurrent.OverflowAvoidingLockSupport;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.internal.InternalFutureFailureAccess;
import com.google.common.util.concurrent.internal.InternalFutures;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class AbstractFuture<V>
extends InternalFutureFailureAccess
implements ListenableFuture<V> {
    static final boolean GENERATE_CANCELLATION_CAUSES;
    private static final Logger log;
    private static final long SPIN_THRESHOLD_NANOS = 1000L;
    private static final AtomicHelper ATOMIC_HELPER;
    private static final Object NULL;
    private volatile Object value;
    private volatile Listener listeners;
    private volatile Waiter waiters;

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(Waiter node) {
        node.thread = null;
        block0: while (true) {
            pred = null;
            curr = this.waiters;
            if (curr == Waiter.TOMBSTONE) {
                return;
            }
            while (curr != null) {
                succ = curr.next;
                if (curr.thread != null) {
                    pred = curr;
                } else if (pred != null) {
                    pred.next = succ;
                    if (pred.thread == null) {
                        continue block0;
                    }
                } else {
                    if (AbstractFuture.ATOMIC_HELPER.casWaiters(this, curr, succ)) ** break;
                    continue block0;
                }
                curr = var3_3;
            }
            break;
        }
    }

    protected AbstractFuture() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ParametricNullness
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        void var1_2;
        Object oldHead;
        long endNanos;
        long remainingNanos;
        block15: {
            long l;
            remainingNanos = l = unit.toNanos(timeout);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Object localValue = this.value;
            if (localValue != null & !(localValue instanceof SetFuture)) {
                return this.getDoneValue(localValue);
            }
            long l2 = endNanos = remainingNanos > 0L ? System.nanoTime() + remainingNanos : 0L;
            if (remainingNanos >= 1000L) {
                oldHead = this.waiters;
                if (oldHead != Waiter.TOMBSTONE) {
                    Waiter node = new Waiter();
                    do {
                        node.setNext((Waiter)oldHead);
                        if (!ATOMIC_HELPER.casWaiters(this, (Waiter)oldHead, node)) continue;
                        do {
                            OverflowAvoidingLockSupport.parkNanos(this, remainingNanos);
                            if (Thread.interrupted()) {
                                this.removeWaiter(node);
                                throw new InterruptedException();
                            }
                            oldHead = this.value;
                            if (!(oldHead != null & !(oldHead instanceof SetFuture))) continue;
                            return this.getDoneValue(oldHead);
                        } while ((remainingNanos = endNanos - System.nanoTime()) >= 1000L);
                        this.removeWaiter(node);
                        break block15;
                    } while ((oldHead = this.waiters) != Waiter.TOMBSTONE);
                }
                AbstractFuture abstractFuture = this;
                return abstractFuture.getDoneValue(Objects.requireNonNull(abstractFuture.value));
            }
        }
        while (remainingNanos > 0L) {
            oldHead = this.value;
            if (oldHead != null & !(oldHead instanceof SetFuture)) {
                return this.getDoneValue(oldHead);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            remainingNanos = endNanos - System.nanoTime();
        }
        String futureToString = this.toString();
        String unitString = unit.toString().toLowerCase(Locale.ROOT);
        String string = unit.toString().toLowerCase(Locale.ROOT);
        String message = new StringBuilder(28 + String.valueOf(string).length()).append("Waited ").append(timeout).append(" ").append(string).toString();
        if (remainingNanos + 1000L < 0L) {
            void var2_13;
            boolean shouldShowExtraNanos;
            void var3_3;
            message = String.valueOf(message).concat(" (plus ");
            long overWaitNanos = -remainingNanos;
            long overWaitUnits = unit.convert(overWaitNanos, TimeUnit.NANOSECONDS);
            long overWaitLeftoverNanos = overWaitNanos - var3_3.toNanos(overWaitUnits);
            boolean bl = shouldShowExtraNanos = overWaitUnits == 0L || overWaitLeftoverNanos > 1000L;
            if (overWaitUnits > 0L) {
                message = String.valueOf(message);
                message = new StringBuilder(21 + String.valueOf(message).length() + String.valueOf(unitString).length()).append(message).append(overWaitUnits).append(" ").append(unitString).toString();
                if (shouldShowExtraNanos) {
                    message = String.valueOf(message).concat(",");
                }
                message = String.valueOf(message).concat(" ");
            }
            if (var2_13 != false) {
                message = String.valueOf(message);
                message = new StringBuilder(33 + String.valueOf(message).length()).append(message).append(overWaitLeftoverNanos).append(" nanoseconds ").toString();
            }
            message = String.valueOf(message).concat("delay)");
        }
        if (this.isDone()) {
            throw new TimeoutException(String.valueOf(message).concat(" but future completed as timeout expired"));
        }
        string = var1_2;
        throw new TimeoutException(new StringBuilder(5 + String.valueOf(string).length() + String.valueOf(futureToString).length()).append(string).append(" for ").append(futureToString).toString());
    }

    @Override
    @ParametricNullness
    public V get() throws InterruptedException, ExecutionException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object localValue = this.value;
        if (localValue != null & !(localValue instanceof SetFuture)) {
            return this.getDoneValue(localValue);
        }
        Object oldHead = this.waiters;
        if (oldHead != Waiter.TOMBSTONE) {
            Waiter node = new Waiter();
            do {
                node.setNext((Waiter)oldHead);
                if (!ATOMIC_HELPER.casWaiters(this, (Waiter)oldHead, node)) continue;
                do {
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    this.removeWaiter(node);
                    throw new InterruptedException();
                } while (!((oldHead = this.value) != null & !(oldHead instanceof SetFuture)));
                return this.getDoneValue(oldHead);
            } while ((oldHead = this.waiters) != Waiter.TOMBSTONE);
        }
        AbstractFuture abstractFuture = this;
        return abstractFuture.getDoneValue(Objects.requireNonNull(abstractFuture.value));
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    private V getDoneValue(Object obj) throws ExecutionException {
        void var1_1;
        if (obj instanceof Cancellation) {
            throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", ((Cancellation)obj).cause);
        }
        if (obj instanceof Failure) {
            throw new ExecutionException(((Failure)obj).exception);
        }
        if (obj == NULL) {
            return (V)NullnessCasts.uncheckedNull();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isDone() {
        void var1_1;
        Object localValue = this.value;
        return localValue != null & !(var1_1 instanceof SetFuture);
    }

    @Override
    public boolean isCancelled() {
        Object object = this.value;
        return object instanceof Cancellation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        void var3_3;
        Object localValue = this.value;
        boolean rValue = false;
        if (localValue == null | localValue instanceof SetFuture) {
            Cancellation valueToSet = GENERATE_CANCELLATION_CAUSES ? new Cancellation(mayInterruptIfRunning, new CancellationException("Future.cancel() was called.")) : Objects.requireNonNull(mayInterruptIfRunning ? Cancellation.CAUSELESS_INTERRUPTED : Cancellation.CAUSELESS_CANCELLED);
            AbstractFuture abstractFuture = this;
            while (true) {
                Object object;
                AbstractFuture abstractFuture2;
                if (ATOMIC_HELPER.casValue(abstractFuture, localValue, valueToSet)) {
                    rValue = true;
                    if (mayInterruptIfRunning) {
                        abstractFuture.interruptTask();
                    }
                    AbstractFuture.complete(abstractFuture);
                    if (!(localValue instanceof SetFuture)) break;
                    Object futureToPropagateTo = ((SetFuture)localValue).future;
                    if (futureToPropagateTo instanceof Trusted) {
                        AbstractFuture trusted = (AbstractFuture)futureToPropagateTo;
                        futureToPropagateTo = trusted.value;
                        if (!(futureToPropagateTo == null | futureToPropagateTo instanceof SetFuture)) break;
                        abstractFuture2 = trusted;
                        continue;
                    }
                    object.cancel(mayInterruptIfRunning);
                    break;
                }
                object = abstractFuture2.value;
                if (!(object instanceof SetFuture)) break;
            }
        }
        return (boolean)var3_3;
    }

    protected void interruptTask() {
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean wasInterrupted() {
        void var1_1;
        Object localValue = this.value;
        return localValue instanceof Cancellation && ((Cancellation)var1_1).wasInterrupted;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addListener(Runnable listener, Executor executor) {
        void var2_2;
        void var1_1;
        Listener oldHead;
        Preconditions.checkNotNull(listener, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        if (!this.isDone() && (oldHead = this.listeners) != Listener.TOMBSTONE) {
            Listener newNode = new Listener(listener, executor);
            do {
                newNode.next = oldHead;
                if (!ATOMIC_HELPER.casListeners(this, oldHead, newNode)) continue;
                return;
            } while ((oldHead = this.listeners) != Listener.TOMBSTONE);
        }
        AbstractFuture.executeListener((Runnable)var1_1, (Executor)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean set(@ParametricNullness V value) {
        void var1_1;
        Object valueToSet;
        Object object = valueToSet = value == null ? NULL : valueToSet;
        if (ATOMIC_HELPER.casValue(this, null, var1_1)) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setException(Throwable throwable) {
        void var1_1;
        Failure valueToSet = new Failure(Preconditions.checkNotNull(throwable));
        if (ATOMIC_HELPER.casValue(this, null, var1_1)) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setFuture(ListenableFuture<? extends V> future) {
        Object object;
        Preconditions.checkNotNull(future);
        Object localValue = this.value;
        if (localValue == null) {
            if (future.isDone()) {
                Object value = AbstractFuture.getFutureValue(future);
                if (ATOMIC_HELPER.casValue(this, null, value)) {
                    AbstractFuture.complete(this);
                    return true;
                }
                return false;
            }
            SetFuture<? extends V> valueToSet = new SetFuture<V>(this, future);
            if (ATOMIC_HELPER.casValue(this, null, valueToSet)) {
                try {
                    future.addListener(valueToSet, DirectExecutor.INSTANCE);
                }
                catch (Throwable t) {
                    void var1_3;
                    Failure failure;
                    try {
                        failure = new Failure(t);
                    }
                    catch (Throwable throwable) {
                        failure = Failure.FALLBACK_INSTANCE;
                    }
                    ATOMIC_HELPER.casValue(this, object, var1_3);
                }
                return true;
            }
            object = this.value;
        }
        if (object instanceof Cancellation) {
            void var1_1;
            var1_1.cancel(((Cancellation)object).wasInterrupted);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static Object getFutureValue(ListenableFuture<?> future) {
        boolean wasCancelled;
        Throwable throwable;
        if (future instanceof Trusted) {
            Object v = ((AbstractFuture)future).value;
            if (v instanceof Cancellation) {
                Cancellation c = (Cancellation)v;
                if (c.wasInterrupted) {
                    v = c.cause != null ? new Cancellation(false, c.cause) : Cancellation.CAUSELESS_CANCELLED;
                }
            }
            return Objects.requireNonNull(v);
        }
        if (future instanceof InternalFutureFailureAccess && (throwable = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)((InternalFutureFailureAccess)future))) != null) {
            return new Failure(throwable);
        }
        if (!GENERATE_CANCELLATION_CAUSES & (wasCancelled = future.isCancelled())) {
            return Objects.requireNonNull(Cancellation.CAUSELESS_CANCELLED);
        }
        try {
            Object v = AbstractFuture.getUninterruptibly(future);
            if (wasCancelled) {
                String string = String.valueOf(future);
                return new Cancellation(false, new IllegalArgumentException(new StringBuilder(84 + String.valueOf(string).length()).append("get() did not throw CancellationException, despite reporting isCancelled() == true: ").append(string).toString()));
            }
            if (v == null) {
                return NULL;
            }
            return v;
        }
        catch (ExecutionException exception) {
            if (wasCancelled) {
                String string = String.valueOf(future);
                return new Cancellation(false, new IllegalArgumentException(new StringBuilder(84 + String.valueOf(string).length()).append("get() did not throw CancellationException, despite reporting isCancelled() == true: ").append(string).toString(), exception));
            }
            return new Failure(exception.getCause());
        }
        catch (CancellationException cancellation) {
            void var1_3;
            if (var1_3 == false) {
                ListenableFuture<?> listenableFuture;
                String string = String.valueOf(listenableFuture);
                return new Failure(new IllegalArgumentException(new StringBuilder(77 + String.valueOf(string).length()).append("get() threw CancellationException, despite reporting isCancelled() == false: ").append(string).toString(), cancellation));
            }
            return new Cancellation(false, cancellation);
        }
        catch (Throwable t) {
            void var2_8;
            return new Failure((Throwable)var2_8);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    private static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean interrupted = false;
        while (true) {
            V v;
            block5: {
                try {
                    v = future.get();
                    if (!interrupted) break block5;
                    Thread.currentThread().interrupt();
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                    continue;
                }
                catch (Throwable throwable) {
                    void var1_2;
                    if (var1_2 != false) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
            }
            return v;
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void complete(AbstractFuture<?> param) {
        AbstractFuture future = param;
        Listener next = null;
        block0: while (true) {
            super.releaseWaiters();
            future.afterDone();
            next = super.clearListeners(next);
            while (next != null) {
                AbstractFuture abstractFuture;
                void var2_2;
                AbstractFuture curr = next;
                next = next.next;
                Runnable task = Objects.requireNonNull(((Listener)((Object)curr)).task);
                if (task instanceof SetFuture) {
                    void var3_3;
                    SetFuture setFuture = (SetFuture)task;
                    curr = setFuture.owner;
                    if (curr.value != setFuture) continue;
                    Object valueToSet = AbstractFuture.getFutureValue(setFuture.future);
                    if (ATOMIC_HELPER.casValue(curr, var2_2, var3_3)) continue block0;
                    continue;
                }
                AbstractFuture.executeListener((Runnable)var2_2, Objects.requireNonNull(((Listener)((Object)abstractFuture)).executor));
            }
            break;
        }
    }

    @Beta
    protected void afterDone() {
    }

    /*
     * WARNING - void declaration
     */
    protected final Throwable tryInternalFastPathGetFailure() {
        Object obj;
        if (this instanceof Trusted && (obj = this.value) instanceof Failure) {
            void var1_1;
            return ((Failure)var1_1).exception;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    final void maybePropagateCancellationTo(Future<?> related) {
        if (related != null & this.isCancelled()) {
            void var1_1;
            var1_1.cancel(this.wasInterrupted());
        }
    }

    private void releaseWaiters() {
        Waiter currentWaiter = ATOMIC_HELPER.gasWaiters(this, Waiter.TOMBSTONE);
        while (currentWaiter != null) {
            currentWaiter.unpark();
            currentWaiter = currentWaiter.next;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Listener clearListeners(Listener onto) {
        void var1_1;
        Listener head = ATOMIC_HELPER.gasListeners(this, Listener.TOMBSTONE);
        while (head != null) {
            void var3_3;
            void reversedList;
            Listener tmp = head;
            head = head.next;
            tmp.next = reversedList;
            reversedList = var3_3;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        if (this.getClass().getName().startsWith("com.google.common.util.concurrent.")) {
            builder.append(this.getClass().getSimpleName());
        } else {
            builder.append(this.getClass().getName());
        }
        builder.append('@').append(Integer.toHexString(System.identityHashCode(this))).append("[status=");
        if (this.isCancelled()) {
            builder.append("CANCELLED");
        } else if (this.isDone()) {
            this.addDoneString(builder);
        } else {
            this.addPendingString(builder);
        }
        return var1_1.append("]").toString();
    }

    protected String pendingToString() {
        if (this instanceof ScheduledFuture) {
            long l = ((ScheduledFuture)((Object)this)).getDelay(TimeUnit.MILLISECONDS);
            return new StringBuilder(41).append("remaining delay=[").append(l).append(" ms]").toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void addPendingString(StringBuilder builder) {
        int truncateLength = builder.length();
        builder.append("PENDING");
        Object localValue = this.value;
        if (localValue instanceof SetFuture) {
            builder.append(", setFuture=[");
            this.appendUserObject(builder, ((SetFuture)localValue).future);
            builder.append("]");
        } else {
            Object pendingDescription;
            try {
                pendingDescription = Strings.emptyToNull(this.pendingToString());
            }
            catch (RuntimeException | StackOverflowError throwable) {
                pendingDescription = throwable;
                pendingDescription = String.valueOf(throwable.getClass());
                pendingDescription = new StringBuilder(38 + String.valueOf(pendingDescription).length()).append("Exception thrown from implementation: ").append((String)pendingDescription).toString();
            }
            if (pendingDescription != null) {
                void var3_3;
                builder.append(", info=[").append((String)var3_3).append("]");
            }
        }
        if (this.isDone()) {
            void var1_1;
            void var2_2;
            builder.delete((int)var2_2, builder.length());
            this.addDoneString((StringBuilder)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addDoneString(StringBuilder builder) {
        try {
            V value = AbstractFuture.getUninterruptibly(this);
            builder.append("SUCCESS, result=[");
            this.appendResultObject(builder, value);
            builder.append("]");
            return;
        }
        catch (ExecutionException e) {
            builder.append("FAILURE, cause=[").append(e.getCause()).append("]");
            return;
        }
        catch (CancellationException cancellationException) {
            builder.append("CANCELLED");
            return;
        }
        catch (RuntimeException e) {
            void var2_4;
            void var1_1;
            var1_1.append("UNKNOWN, cause=[").append(var2_4.getClass()).append(" thrown from get()]");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void appendResultObject(StringBuilder builder, Object o) {
        void var2_2;
        void var1_1;
        if (o == null) {
            builder.append("null");
            return;
        }
        if (o == this) {
            builder.append("this future");
            return;
        }
        var1_1.append(o.getClass().getName()).append("@").append(Integer.toHexString(System.identityHashCode(var2_2)));
    }

    /*
     * WARNING - void declaration
     */
    private void appendUserObject(StringBuilder builder, Object o) {
        try {
            if (o != this) {
                builder.append(o);
                return;
            }
            builder.append("this future");
        }
        catch (RuntimeException | StackOverflowError e) {
            void var2_3;
            void var1_1;
            var1_1.append("Exception thrown from implementation: ").append(var2_3.getClass());
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void executeListener(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
            return;
        }
        catch (RuntimeException e) {
            void var2_2;
            String string;
            String string2;
            string2 = String.valueOf(string2);
            string = String.valueOf(string);
            log.log(Level.SEVERE, new StringBuilder(57 + String.valueOf(string2).length() + String.valueOf(string).length()).append("RuntimeException while executing runnable ").append(string2).append(" with executor ").append(string).toString(), (Throwable)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static CancellationException cancellationExceptionWithCause(String message, Throwable cause) {
        CancellationException cancellationException;
        void var1_1;
        CancellationException exception = new CancellationException(message);
        exception.initCause((Throwable)var1_1);
        return cancellationException;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Waiter access$702(AbstractFuture x0, Waiter x1) {
        void var1_1;
        x0.waiters = var1_1;
        return x0.waiters;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Listener access$802(AbstractFuture x0, Listener x1) {
        void var1_1;
        x0.listeners = var1_1;
        return x0.listeners;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$302(AbstractFuture x0, Object x1) {
        void var1_1;
        x0.value = var1_1;
        return x0.value;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0_1;
        Object helper;
        boolean generateCancellationCauses;
        try {
            generateCancellationCauses = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        }
        catch (SecurityException securityException) {
            generateCancellationCauses = false;
        }
        GENERATE_CANCELLATION_CAUSES = generateCancellationCauses;
        log = Logger.getLogger(AbstractFuture.class.getName());
        Throwable thrownUnsafeFailure = null;
        Throwable thrownAtomicReferenceFieldUpdaterFailure = null;
        try {
            helper = new UnsafeAtomicHelper();
        }
        catch (Throwable throwable) {
            helper = throwable;
            thrownUnsafeFailure = throwable;
            try {
                helper = new SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Thread.class, "thread"), AtomicReferenceFieldUpdater.newUpdater(Waiter.class, Waiter.class, "next"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Waiter.class, "waiters"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Listener.class, "listeners"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Object.class, "value"));
            }
            catch (Throwable throwable2) {
                helper = throwable2;
                thrownAtomicReferenceFieldUpdaterFailure = throwable2;
                helper = new SynchronizedHelper();
            }
        }
        ATOMIC_HELPER = var0_1;
        if (thrownAtomicReferenceFieldUpdaterFailure != null) {
            void var2_3;
            void var1_2;
            log.log(Level.SEVERE, "UnsafeAtomicHelper is broken!", (Throwable)var1_2);
            log.log(Level.SEVERE, "SafeAtomicHelper is broken!", (Throwable)var2_3);
        }
        NULL = new Object();
    }

    private static final class SynchronizedHelper
    extends AtomicHelper {
        private SynchronizedHelper() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void putThread(Waiter waiter, Thread newValue) {
            void var2_2;
            waiter.thread = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void putNext(Waiter waiter, Waiter newValue) {
            void var2_2;
            waiter.next = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean casWaiters(AbstractFuture<?> future, Waiter expect, Waiter update) {
            AbstractFuture<?> abstractFuture = future;
            synchronized (abstractFuture) {
                void var2_3;
                if (((AbstractFuture)future).waiters == var2_3) {
                    void var3_4;
                    void var1_1;
                    AbstractFuture.access$702((AbstractFuture)var1_1, (Waiter)var3_4);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean casListeners(AbstractFuture<?> future, Listener expect, Listener update) {
            AbstractFuture<?> abstractFuture = future;
            synchronized (abstractFuture) {
                void var2_3;
                if (((AbstractFuture)future).listeners == var2_3) {
                    void var3_4;
                    void var1_1;
                    AbstractFuture.access$802((AbstractFuture)var1_1, (Listener)var3_4);
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Listener gasListeners(AbstractFuture<?> future, Listener update) {
            AbstractFuture<?> abstractFuture = future;
            synchronized (abstractFuture) {
                Listener old = ((AbstractFuture)future).listeners;
                if (old != update) {
                    void var2_3;
                    void var1_1;
                    AbstractFuture.access$802((AbstractFuture)var1_1, (Listener)var2_3);
                }
                return old;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Waiter gasWaiters(AbstractFuture<?> future, Waiter update) {
            AbstractFuture<?> abstractFuture = future;
            synchronized (abstractFuture) {
                Waiter old = ((AbstractFuture)future).waiters;
                if (old != update) {
                    void var2_3;
                    void var1_1;
                    AbstractFuture.access$702((AbstractFuture)var1_1, (Waiter)var2_3);
                }
                return old;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean casValue(AbstractFuture<?> future, Object expect, Object update) {
            AbstractFuture<?> abstractFuture = future;
            synchronized (abstractFuture) {
                void var2_3;
                if (((AbstractFuture)future).value == var2_3) {
                    void var3_4;
                    void var1_1;
                    AbstractFuture.access$302((AbstractFuture)var1_1, var3_4);
                    return true;
                }
                return false;
            }
        }
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        final AtomicReferenceFieldUpdater<Waiter, Thread> waiterThreadUpdater;
        final AtomicReferenceFieldUpdater<Waiter, Waiter> waiterNextUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Waiter> waitersUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Listener> listenersUpdater;
        final AtomicReferenceFieldUpdater<AbstractFuture, Object> valueUpdater;

        /*
         * WARNING - void declaration
         */
        SafeAtomicHelper(AtomicReferenceFieldUpdater<Waiter, Thread> waiterThreadUpdater, AtomicReferenceFieldUpdater<Waiter, Waiter> waiterNextUpdater, AtomicReferenceFieldUpdater<AbstractFuture, Waiter> waitersUpdater, AtomicReferenceFieldUpdater<AbstractFuture, Listener> listenersUpdater, AtomicReferenceFieldUpdater<AbstractFuture, Object> valueUpdater) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.waiterThreadUpdater = var1_1;
            this.waiterNextUpdater = var2_2;
            this.waitersUpdater = var3_3;
            this.listenersUpdater = listenersUpdater;
            this.valueUpdater = valueUpdater;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void putThread(Waiter waiter, Thread newValue) {
            void var2_2;
            void var1_1;
            this.waiterThreadUpdater.lazySet((Waiter)var1_1, (Thread)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void putNext(Waiter waiter, Waiter newValue) {
            void var2_2;
            void var1_1;
            this.waiterNextUpdater.lazySet((Waiter)var1_1, (Waiter)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean casWaiters(AbstractFuture<?> future, Waiter expect, Waiter update) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.waitersUpdater.compareAndSet((AbstractFuture)var1_1, (Waiter)var2_2, (Waiter)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean casListeners(AbstractFuture<?> future, Listener expect, Listener update) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.listenersUpdater.compareAndSet((AbstractFuture)var1_1, (Listener)var2_2, (Listener)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Listener gasListeners(AbstractFuture<?> future, Listener update) {
            void var2_2;
            void var1_1;
            return this.listenersUpdater.getAndSet((AbstractFuture)var1_1, (Listener)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Waiter gasWaiters(AbstractFuture<?> future, Waiter update) {
            void var2_2;
            void var1_1;
            return this.waitersUpdater.getAndSet((AbstractFuture)var1_1, (Waiter)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean casValue(AbstractFuture<?> future, Object expect, Object update) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.valueUpdater.compareAndSet((AbstractFuture)var1_1, var2_2, var3_3);
        }
    }

    private static final class UnsafeAtomicHelper
    extends AtomicHelper {
        static final Unsafe UNSAFE;
        static final long LISTENERS_OFFSET;
        static final long WAITERS_OFFSET;
        static final long VALUE_OFFSET;
        static final long WAITER_THREAD_OFFSET;
        static final long WAITER_NEXT_OFFSET;

        private UnsafeAtomicHelper() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void putThread(Waiter waiter, Thread newValue) {
            void var2_2;
            void var1_1;
            UNSAFE.putObject(var1_1, WAITER_THREAD_OFFSET, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void putNext(Waiter waiter, Waiter newValue) {
            void var2_2;
            void var1_1;
            UNSAFE.putObject(var1_1, WAITER_NEXT_OFFSET, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean casWaiters(AbstractFuture<?> future, Waiter expect, Waiter update) {
            void var3_3;
            void var2_2;
            void var1_1;
            return UNSAFE.compareAndSwapObject(var1_1, WAITERS_OFFSET, var2_2, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean casListeners(AbstractFuture<?> future, Listener expect, Listener update) {
            void var3_3;
            void var2_2;
            void var1_1;
            return UNSAFE.compareAndSwapObject(var1_1, LISTENERS_OFFSET, var2_2, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Listener gasListeners(AbstractFuture<?> future, Listener update) {
            void var2_2;
            void var1_1;
            return (Listener)UNSAFE.getAndSetObject(var1_1, LISTENERS_OFFSET, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Waiter gasWaiters(AbstractFuture<?> future, Waiter update) {
            void var2_2;
            void var1_1;
            return (Waiter)UNSAFE.getAndSetObject(var1_1, WAITERS_OFFSET, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final boolean casValue(AbstractFuture<?> future, Object expect, Object update) {
            void var3_3;
            void var2_2;
            void var1_1;
            return UNSAFE.compareAndSwapObject(var1_1, VALUE_OFFSET, var2_2, var3_3);
        }

        /*
         * WARNING - void declaration
         */
        static {
            Unsafe unsafe;
            try {
                unsafe = Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public Unsafe run() throws Exception {
                            Class<Unsafe> k = Unsafe.class;
                            for (Field f : Unsafe.class.getDeclaredFields()) {
                                f.setAccessible(true);
                                Object x = f.get(null);
                                if (!k.isInstance(x)) continue;
                                return (Unsafe)k.cast(x);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException e) {
                    void var0_1;
                    throw new RuntimeException("Could not initialize intrinsics", var0_1.getCause());
                }
            }
            try {
                void var0;
                Class<AbstractFuture> abstractFuture = AbstractFuture.class;
                WAITERS_OFFSET = var0.objectFieldOffset(abstractFuture.getDeclaredField("waiters"));
                LISTENERS_OFFSET = var0.objectFieldOffset(abstractFuture.getDeclaredField("listeners"));
                VALUE_OFFSET = var0.objectFieldOffset(abstractFuture.getDeclaredField("value"));
                WAITER_THREAD_OFFSET = var0.objectFieldOffset(Waiter.class.getDeclaredField("thread"));
                WAITER_NEXT_OFFSET = var0.objectFieldOffset(Waiter.class.getDeclaredField("next"));
                UNSAFE = var0;
                return;
            }
            catch (Exception exception) {
                void var1_3;
                Exception e = exception;
                Throwables.throwIfUnchecked(exception);
                throw new RuntimeException((Throwable)var1_3);
            }
        }
    }

    private static abstract class AtomicHelper {
        private AtomicHelper() {
        }

        abstract void putThread(Waiter var1, Thread var2);

        abstract void putNext(Waiter var1, Waiter var2);

        abstract boolean casWaiters(AbstractFuture<?> var1, Waiter var2, Waiter var3);

        abstract boolean casListeners(AbstractFuture<?> var1, Listener var2, Listener var3);

        abstract Waiter gasWaiters(AbstractFuture<?> var1, Waiter var2);

        abstract Listener gasListeners(AbstractFuture<?> var1, Listener var2);

        abstract boolean casValue(AbstractFuture<?> var1, Object var2, Object var3);
    }

    private static final class SetFuture<V>
    implements Runnable {
        final AbstractFuture<V> owner;
        final ListenableFuture<? extends V> future;

        /*
         * WARNING - void declaration
         */
        SetFuture(AbstractFuture<V> owner, ListenableFuture<? extends V> future) {
            void var2_2;
            void var1_1;
            this.owner = var1_1;
            this.future = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            void var1_1;
            if (((AbstractFuture)this.owner).value != this) {
                return;
            }
            Object valueToSet = AbstractFuture.getFutureValue(this.future);
            if (ATOMIC_HELPER.casValue(this.owner, this, var1_1)) {
                AbstractFuture.complete((AbstractFuture)this.owner);
            }
        }
    }

    private static final class Cancellation {
        static final Cancellation CAUSELESS_INTERRUPTED;
        static final Cancellation CAUSELESS_CANCELLED;
        final boolean wasInterrupted;
        final Throwable cause;

        /*
         * WARNING - void declaration
         */
        Cancellation(boolean wasInterrupted, Throwable cause) {
            void var2_2;
            void var1_1;
            this.wasInterrupted = var1_1;
            this.cause = var2_2;
        }

        static {
            if (GENERATE_CANCELLATION_CAUSES) {
                CAUSELESS_CANCELLED = null;
                CAUSELESS_INTERRUPTED = null;
            } else {
                CAUSELESS_CANCELLED = new Cancellation(false, null);
                CAUSELESS_INTERRUPTED = new Cancellation(true, null);
            }
        }
    }

    private static final class Failure {
        static final Failure FALLBACK_INSTANCE = new Failure(new Throwable("Failure occurred while trying to finish a future."){
            {
                void var1_1;
            }

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        });
        final Throwable exception;

        /*
         * WARNING - void declaration
         */
        Failure(Throwable exception) {
            void var1_1;
            this.exception = (Throwable)Preconditions.checkNotNull(var1_1);
        }
    }

    private static final class Listener {
        static final Listener TOMBSTONE = new Listener();
        final Runnable task;
        final Executor executor;
        Listener next;

        /*
         * WARNING - void declaration
         */
        Listener(Runnable task, Executor executor) {
            void var2_2;
            void var1_1;
            this.task = var1_1;
            this.executor = var2_2;
        }

        Listener() {
            this.task = null;
            this.executor = null;
        }
    }

    private static final class Waiter {
        static final Waiter TOMBSTONE = new Waiter(false);
        volatile Thread thread;
        volatile Waiter next;

        Waiter(boolean unused) {
        }

        Waiter() {
            ATOMIC_HELPER.putThread(this, Thread.currentThread());
        }

        /*
         * WARNING - void declaration
         */
        final void setNext(Waiter next) {
            void var1_1;
            ATOMIC_HELPER.putNext(this, (Waiter)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final void unpark() {
            Thread w = this.thread;
            if (w != null) {
                void var1_1;
                this.thread = null;
                LockSupport.unpark((Thread)var1_1);
            }
        }
    }

    static abstract class TrustedFuture<V>
    extends AbstractFuture<V>
    implements Trusted<V> {
        TrustedFuture() {
        }

        @Override
        @ParametricNullness
        public final V get() throws InterruptedException, ExecutionException {
            return super.get();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            void var3_2;
            void var1_1;
            return super.get((long)var1_1, (TimeUnit)var3_2);
        }

        @Override
        public final boolean isDone() {
            return super.isDone();
        }

        @Override
        public final boolean isCancelled() {
            return super.isCancelled();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void addListener(Runnable listener, Executor executor) {
            void var2_2;
            void var1_1;
            super.addListener((Runnable)var1_1, (Executor)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean cancel(boolean mayInterruptIfRunning) {
            void var1_1;
            return super.cancel((boolean)var1_1);
        }
    }

    static interface Trusted<V>
    extends ListenableFuture<V> {
    }
}

