/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.AbstractService;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class AbstractExecutionThreadService
implements Service {
    private static final Logger logger = Logger.getLogger(AbstractExecutionThreadService.class.getName());
    private final Service delegate = new AbstractService(this){
        final /* synthetic */ AbstractExecutionThreadService this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        protected final void doStart() {
            Executor executor = MoreExecutors.renamingDecorator(this.this$0.executor(), new Supplier<String>(this){
                final /* synthetic */ 1 this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                @Override
                public String get() {
                    return this.this$1.this$0.serviceName();
                }
            });
            executor.execute(new Runnable(this){
                final /* synthetic */ 1 this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    try {
                        this.this$1.this$0.startUp();
                        this.this$1.notifyStarted();
                        if (this.this$1.isRunning()) {
                            try {
                                this.this$1.this$0.run();
                            }
                            catch (Throwable t) {
                                try {
                                    this.this$1.this$0.shutDown();
                                }
                                catch (Exception ignored) {
                                    void var2_3;
                                    logger.log(Level.WARNING, "Error while attempting to shut down the service after failure.", (Throwable)var2_3);
                                }
                                this.this$1.notifyFailed(t);
                                return;
                            }
                        }
                        this.this$1.this$0.shutDown();
                        this.this$1.notifyStopped();
                        return;
                    }
                    catch (Throwable t) {
                        void var1_2;
                        this.this$1.notifyFailed((Throwable)var1_2);
                        return;
                    }
                }
            });
        }

        @Override
        protected void doStop() {
            this.this$0.triggerShutdown();
        }

        @Override
        public String toString() {
            return this.this$0.toString();
        }
    };

    protected AbstractExecutionThreadService() {
    }

    protected void startUp() throws Exception {
    }

    protected abstract void run() throws Exception;

    protected void shutDown() throws Exception {
    }

    @Beta
    protected void triggerShutdown() {
    }

    protected Executor executor() {
        return new Executor(this){
            final /* synthetic */ AbstractExecutionThreadService this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void execute(Runnable command) {
                void var1_1;
                MoreExecutors.newThread(this.this$0.serviceName(), (Runnable)var1_1).start();
            }
        };
    }

    public String toString() {
        String string = this.serviceName();
        String string2 = String.valueOf((Object)this.state());
        return new StringBuilder(3 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" [").append(string2).append("]").toString();
    }

    @Override
    public final boolean isRunning() {
        return this.delegate.isRunning();
    }

    @Override
    public final Service.State state() {
        return this.delegate.state();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void addListener(Service.Listener listener, Executor executor) {
        void var2_2;
        void var1_1;
        this.delegate.addListener((Service.Listener)var1_1, (Executor)var2_2);
    }

    @Override
    public final Throwable failureCause() {
        return this.delegate.failureCause();
    }

    @Override
    public final Service startAsync() {
        this.delegate.startAsync();
        return this;
    }

    @Override
    public final Service stopAsync() {
        this.delegate.stopAsync();
        return this;
    }

    @Override
    public final void awaitRunning() {
        this.delegate.awaitRunning();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitRunning(Duration timeout) throws TimeoutException {
        void var1_1;
        Service.super.awaitRunning((Duration)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitRunning(long timeout, TimeUnit unit) throws TimeoutException {
        void var3_2;
        void var1_1;
        this.delegate.awaitRunning((long)var1_1, (TimeUnit)var3_2);
    }

    @Override
    public final void awaitTerminated() {
        this.delegate.awaitTerminated();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitTerminated(Duration timeout) throws TimeoutException {
        void var1_1;
        Service.super.awaitTerminated((Duration)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void awaitTerminated(long timeout, TimeUnit unit) throws TimeoutException {
        void var3_2;
        void var1_1;
        this.delegate.awaitTerminated((long)var1_1, (TimeUnit)var3_2);
    }

    protected String serviceName() {
        return this.getClass().getSimpleName();
    }
}

