/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.NullnessCasts;
import com.google.common.util.concurrent.ParametricNullness;
import com.google.common.util.concurrent.Platform;
import com.google.common.util.concurrent.internal.InternalFutureFailureAccess;
import com.google.common.util.concurrent.internal.InternalFutures;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@ElementTypesAreNonnullByDefault
@GwtCompatible
abstract class AbstractCatchingFuture<V, X extends Throwable, F, T>
extends FluentFuture.TrustedFuture<V>
implements Runnable {
    ListenableFuture<? extends V> inputFuture;
    Class<X> exceptionType;
    F fallback;

    /*
     * WARNING - void declaration
     */
    static <V, X extends Throwable> ListenableFuture<V> create(ListenableFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> fallback, Executor executor) {
        void var1_1;
        void var3_3;
        ListenableFuture<V> listenableFuture;
        void var2_2;
        CatchingFuture<? extends V, X> future = new CatchingFuture<V, X>(input, exceptionType, var2_2);
        listenableFuture.addListener(future, MoreExecutors.rejectionPropagatingExecutor((Executor)var3_3, future));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static <X extends Throwable, V> ListenableFuture<V> create(ListenableFuture<? extends V> input, Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback, Executor executor) {
        void var1_1;
        void var3_3;
        ListenableFuture<V> listenableFuture;
        void var2_2;
        AsyncCatchingFuture<? extends V, X> future = new AsyncCatchingFuture<V, X>(input, exceptionType, var2_2);
        listenableFuture.addListener(future, MoreExecutors.rejectionPropagatingExecutor((Executor)var3_3, future));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    AbstractCatchingFuture(ListenableFuture<? extends V> inputFuture, Class<X> exceptionType, F fallback) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.inputFuture = (ListenableFuture)Preconditions.checkNotNull(var1_1);
        this.exceptionType = (Class)Preconditions.checkNotNull(var2_2);
        this.fallback = Preconditions.checkNotNull(var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void run() {
        T fallbackResult;
        void var2_3;
        Object e;
        F localFallback;
        Class<X> localExceptionType;
        ListenableFuture<V> localInputFuture = this.inputFuture;
        if (localInputFuture == null | (localExceptionType = this.exceptionType) == null | (localFallback = this.fallback) == null || ((AbstractFuture)this).isCancelled()) {
            return;
        }
        this.inputFuture = null;
        Object sourceResult = null;
        Object throwable = null;
        try {
            if (localInputFuture instanceof InternalFutureFailureAccess) {
                throwable = InternalFutures.tryInternalFastPathGetFailure((InternalFutureFailureAccess)((InternalFutureFailureAccess)localInputFuture));
            }
            if (throwable == null) {
                sourceResult = Futures.getDone(localInputFuture);
            }
        }
        catch (ExecutionException executionException) {
            e = executionException;
            throwable = executionException.getCause();
            if (throwable == null) {
                throwable = String.valueOf(localInputFuture.getClass());
                e = String.valueOf(e.getClass());
                throwable = new NullPointerException(new StringBuilder(35 + String.valueOf(throwable).length() + String.valueOf(e).length()).append("Future type ").append((String)throwable).append(" threw ").append((String)e).append(" without a cause").toString());
            }
        }
        catch (Throwable throwable2) {
            e = throwable2;
            throwable = throwable2;
        }
        if (throwable == null) {
            this.set(NullnessCasts.uncheckedCastNullableTToT(sourceResult));
            return;
        }
        if (!Platform.isInstanceOfThrowableClass((Throwable)throwable, (Class<? extends Throwable>)var2_3)) {
            void var1_1;
            this.setFuture(var1_1);
            return;
        }
        Throwable castThrowable = throwable;
        try {
            void var3_4;
            fallbackResult = this.doFallback(var3_4, castThrowable);
        }
        catch (Throwable t) {
            this.setException(t);
            return;
        }
        finally {
            this.exceptionType = null;
            this.fallback = null;
        }
        this.setResult(fallbackResult);
    }

    @Override
    protected String pendingToString() {
        String string;
        ListenableFuture<? extends V> localInputFuture = this.inputFuture;
        Class<X> localExceptionType = this.exceptionType;
        F localFallback = this.fallback;
        String superString = super.pendingToString();
        String resultString = "";
        if (localInputFuture != null) {
            string = String.valueOf(string);
            resultString = new StringBuilder(16 + String.valueOf(string).length()).append("inputFuture=[").append(string).append("], ").toString();
        }
        if (localExceptionType != null && localFallback != null) {
            String string2;
            String string3;
            string = resultString;
            string3 = String.valueOf(string3);
            string2 = String.valueOf(string2);
            return new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string).append("exceptionType=[").append(string3).append("], fallback=[").append(string2).append("]").toString();
        }
        if (superString != null) {
            String string4 = String.valueOf(resultString);
            String string5 = String.valueOf(superString);
            if (string5.length() != 0) {
                return string4.concat(string5);
            }
            return new String(string4);
        }
        return null;
    }

    @ParametricNullness
    abstract T doFallback(F var1, X var2) throws Exception;

    abstract void setResult(@ParametricNullness T var1);

    @Override
    protected final void afterDone() {
        AbstractCatchingFuture abstractCatchingFuture = this;
        abstractCatchingFuture.maybePropagateCancellationTo(abstractCatchingFuture.inputFuture);
        this.inputFuture = null;
        this.exceptionType = null;
        this.fallback = null;
    }

    private static final class CatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, Function<? super X, ? extends V>, V> {
        /*
         * WARNING - void declaration
         */
        CatchingFuture(ListenableFuture<? extends V> input, Class<X> exceptionType, Function<? super X, ? extends V> fallback) {
            super(var1_1, var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        final V doFallback(Function<? super X, ? extends V> fallback, X cause) throws Exception {
            void var2_2;
            return fallback.apply(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void setResult(@ParametricNullness V result) {
            void var1_1;
            this.set(var1_1);
        }
    }

    private static final class AsyncCatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, AsyncFunction<? super X, ? extends V>, ListenableFuture<? extends V>> {
        /*
         * WARNING - void declaration
         */
        AsyncCatchingFuture(ListenableFuture<? extends V> input, Class<X> exceptionType, AsyncFunction<? super X, ? extends V> fallback) {
            super(var1_1, var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ListenableFuture<? extends V> doFallback(AsyncFunction<? super X, ? extends V> fallback, X cause) throws Exception {
            void var2_2;
            void var1_1;
            ListenableFuture<? extends V> replacement = fallback.apply(cause);
            Preconditions.checkNotNull(replacement, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)? %s", (Object)var1_1);
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void setResult(ListenableFuture<? extends V> result) {
            void var1_1;
            this.setFuture(var1_1);
        }
    }
}

