/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.reflect.ElementTypesAreNonnullByDefault;
import com.google.common.reflect.Reflection;
import com.google.common.reflect.TypeCapture;
import com.google.common.reflect.TypeVisitor;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.AccessControlException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

@ElementTypesAreNonnullByDefault
final class Types {
    private static final Joiner COMMA_JOINER = Joiner.on(", ").useForNull("null");

    /*
     * WARNING - void declaration
     */
    static Type newArrayType(Type componentType) {
        Object object;
        if (componentType instanceof WildcardType) {
            Object wildcard = (WildcardType)componentType;
            Type[] lowerBounds = wildcard.getLowerBounds();
            Preconditions.checkArgument(lowerBounds.length <= 1, "Wildcard cannot have more than one lower bounds.");
            if (lowerBounds.length == 1) {
                void var1_1;
                return Types.supertypeOf(Types.newArrayType((Type)var1_1[0]));
            }
            Object upperBounds = wildcard.getUpperBounds();
            Preconditions.checkArgument(((Type[])upperBounds).length == 1, "Wildcard should have only one upper bound.");
            return Types.subtypeOf(Types.newArrayType(object[0]));
        }
        return JavaVersion.CURRENT.newArrayType((Type)object);
    }

    /*
     * WARNING - void declaration
     */
    static ParameterizedType newParameterizedTypeWithOwner(Type ownerType, Class<?> rawType, Type ... arguments) {
        void var2_2;
        void var1_1;
        Type type;
        if (ownerType == null) {
            return Types.newParameterizedType(rawType, arguments);
        }
        Preconditions.checkNotNull(arguments);
        Preconditions.checkArgument(rawType.getEnclosingClass() != null, "Owner type for unenclosed %s", rawType);
        return new ParameterizedTypeImpl(type, (Class<?>)var1_1, (Type[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static ParameterizedType newParameterizedType(Class<?> rawType, Type ... arguments) {
        void var1_1;
        Class<?> clazz;
        return new ParameterizedTypeImpl(ClassOwnership.JVM_BEHAVIOR.getOwnerType(rawType), clazz, (Type[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <D extends GenericDeclaration> TypeVariable<D> newArtificialTypeVariable(D declaration, String name, Type ... bounds) {
        void var1_1;
        Type[] typeArray;
        if (bounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = Object.class;
        } else {
            void var2_2;
            typeArray = var2_2;
        }
        return Types.newTypeVariableImpl(declaration, (String)var1_1, typeArray);
    }

    @VisibleForTesting
    static WildcardType subtypeOf(Type upperBound) {
        Type type;
        return new WildcardTypeImpl(new Type[0], new Type[]{type});
    }

    @VisibleForTesting
    static WildcardType supertypeOf(Type lowerBound) {
        Type type;
        return new WildcardTypeImpl(new Type[]{type}, new Type[]{Object.class});
    }

    static String toString(Type type) {
        Type type2;
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type2.toString();
    }

    /*
     * WARNING - void declaration
     */
    static Type getComponentType(Type type) {
        void var1_1;
        Type type2;
        Preconditions.checkNotNull(type);
        final AtomicReference result = new AtomicReference();
        new TypeVisitor(){

            /*
             * WARNING - void declaration
             */
            @Override
            void visitTypeVariable(TypeVariable<?> t) {
                void var1_1;
                result.set(Types.subtypeOfComponentType(var1_1.getBounds()));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void visitWildcardType(WildcardType t) {
                void var1_1;
                result.set(Types.subtypeOfComponentType(var1_1.getUpperBounds()));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void visitGenericArrayType(GenericArrayType t) {
                void var1_1;
                result.set(var1_1.getGenericComponentType());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void visitClass(Class<?> t) {
                void var1_1;
                result.set(var1_1.getComponentType());
            }
        }.visit(type2);
        return (Type)var1_1.get();
    }

    private static Type subtypeOfComponentType(Type[] bounds) {
        for (Type type : bounds) {
            Object componentClass;
            Type componentType = Types.getComponentType(type);
            if (componentType == null) continue;
            if (componentType instanceof Class && (componentClass = (Class)componentType).isPrimitive()) {
                Object object;
                return object;
            }
            return Types.subtypeOf(type);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static <D extends GenericDeclaration> TypeVariable<D> newTypeVariableImpl(D genericDeclaration, String name, Type[] bounds) {
        Object object;
        void var2_2;
        void var1_1;
        Object typeVariableImpl = new TypeVariableImpl<D>(genericDeclaration, (String)var1_1, (Type[])var2_2);
        object = Reflection.newProxy(TypeVariable.class, new TypeVariableInvocationHandler((TypeVariableImpl<?>)object));
        return object;
    }

    private static Type[] toArray(Collection<Type> types) {
        return types.toArray(new Type[0]);
    }

    private static Iterable<Type> filterUpperBounds(Iterable<Type> bounds) {
        return Iterables.filter(bounds, Predicates.not(Predicates.equalTo(Object.class)));
    }

    private static void disallowPrimitiveType(Type[] types, String usedAs) {
        Type[] typeArray = types;
        int n = types.length;
        for (int i = 0; i < n; ++i) {
            Type type = typeArray[i];
            if (!(type instanceof Class)) continue;
            Class cls = (Class)type;
            Preconditions.checkArgument(!cls.isPrimitive(), "Primitive type '%s' used as %s", (Object)cls, (Object)usedAs);
        }
    }

    static Class<?> getArrayClass(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    private Types() {
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(Type[] x0, String x1) {
        void var1_1;
        Types.disallowPrimitiveType(x0, (String)var1_1);
    }

    static final class NativeTypeVariableEquals<X> {
        static final boolean NATIVE_TYPE_VARIABLE_ONLY = !NativeTypeVariableEquals.class.getTypeParameters()[0].equals(Types.newArtificialTypeVariable(NativeTypeVariableEquals.class, "X", new Type[0]));

        NativeTypeVariableEquals() {
        }
    }

    static enum JavaVersion {
        JAVA6{

            /*
             * WARNING - void declaration
             */
            @Override
            final GenericArrayType newArrayType(Type componentType) {
                void var1_1;
                return new GenericArrayTypeImpl((Type)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final Type usedInGenericType(Type type) {
                void var1_1;
                Class cls;
                Preconditions.checkNotNull(type);
                if (type instanceof Class && (cls = (Class)type).isArray()) {
                    void var2_2;
                    return new GenericArrayTypeImpl(var2_2.getComponentType());
                }
                return var1_1;
            }
        }
        ,
        JAVA7{

            /*
             * WARNING - void declaration
             */
            @Override
            final Type newArrayType(Type componentType) {
                void var1_1;
                if (componentType instanceof Class) {
                    return Types.getArrayClass((Class)componentType);
                }
                return new GenericArrayTypeImpl((Type)var1_1);
            }

            @Override
            final Type usedInGenericType(Type type) {
                return Preconditions.checkNotNull(type);
            }
        }
        ,
        JAVA8{

            /*
             * WARNING - void declaration
             */
            @Override
            final Type newArrayType(Type componentType) {
                void var1_1;
                return JAVA7.newArrayType((Type)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final Type usedInGenericType(Type type) {
                void var1_1;
                return JAVA7.usedInGenericType((Type)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final String typeName(Type type) {
                try {
                    void var1_1;
                    Method method = Type.class.getMethod("getTypeName", new Class[0]);
                    return (String)method.invoke((Object)var1_1, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new AssertionError((Object)"Type.getTypeName should be available in Java 8");
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    void var2_4;
                    throw new RuntimeException((Throwable)var2_4);
                }
            }
        }
        ,
        JAVA9{

            /*
             * WARNING - void declaration
             */
            @Override
            final Type newArrayType(Type componentType) {
                void var1_1;
                return JAVA8.newArrayType((Type)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final Type usedInGenericType(Type type) {
                void var1_1;
                return JAVA8.usedInGenericType((Type)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            final String typeName(Type type) {
                void var1_1;
                return JAVA8.typeName((Type)var1_1);
            }

            @Override
            final boolean jdkTypeDuplicatesOwnerName() {
                return false;
            }
        };

        static final JavaVersion CURRENT;

        abstract Type newArrayType(Type var1);

        abstract Type usedInGenericType(Type var1);

        /*
         * WARNING - void declaration
         */
        final ImmutableList<Type> usedInGenericType(Type[] types) {
            void var2_2;
            void var1_1;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (void type : var1_1) {
                builder.add(this.usedInGenericType((Type)type));
            }
            return var2_2.build();
        }

        String typeName(Type type) {
            return Types.toString(type);
        }

        boolean jdkTypeDuplicatesOwnerName() {
            return true;
        }

        static {
            CURRENT = AnnotatedElement.class.isAssignableFrom(TypeVariable.class) ? (new TypeCapture<Map.Entry<String, int[][]>>(){}.capture().toString().contains("java.util.Map.java.util.Map") ? JAVA8 : JAVA9) : (new TypeCapture<int[]>(){}.capture() instanceof Class ? JAVA7 : JAVA6);
        }
    }

    static final class WildcardTypeImpl
    implements Serializable,
    WildcardType {
        private final ImmutableList<Type> lowerBounds;
        private final ImmutableList<Type> upperBounds;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        WildcardTypeImpl(Type[] lowerBounds, Type[] upperBounds) {
            void var2_2;
            void var1_1;
            Types.access$200(lowerBounds, "lower bound for wildcard");
            Types.access$200(upperBounds, "upper bound for wildcard");
            this.lowerBounds = JavaVersion.CURRENT.usedInGenericType((Type[])var1_1);
            this.upperBounds = JavaVersion.CURRENT.usedInGenericType((Type[])var2_2);
        }

        @Override
        public final Type[] getLowerBounds() {
            return Types.toArray(this.lowerBounds);
        }

        @Override
        public final Type[] getUpperBounds() {
            return Types.toArray(this.upperBounds);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            if (obj instanceof WildcardType) {
                void var1_1;
                WildcardType that = (WildcardType)obj;
                return this.lowerBounds.equals(Arrays.asList(that.getLowerBounds())) && this.upperBounds.equals(Arrays.asList(var1_1.getUpperBounds()));
            }
            return false;
        }

        public final int hashCode() {
            return this.lowerBounds.hashCode() ^ this.upperBounds.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder("?");
            for (Type lowerBound : this.lowerBounds) {
                builder.append(" super ").append(JavaVersion.CURRENT.typeName(lowerBound));
            }
            for (Type upperBound : Types.filterUpperBounds(this.upperBounds)) {
                void var3_3;
                builder.append(" extends ").append(JavaVersion.CURRENT.typeName((Type)var3_3));
            }
            return var1_1.toString();
        }
    }

    private static final class TypeVariableImpl<D extends GenericDeclaration> {
        private final D genericDeclaration;
        private final String name;
        private final ImmutableList<Type> bounds;

        /*
         * WARNING - void declaration
         */
        TypeVariableImpl(D genericDeclaration, String name, Type[] bounds) {
            void var3_3;
            void var2_2;
            void var1_1;
            Types.access$200(bounds, "bound for type variable");
            this.genericDeclaration = (GenericDeclaration)Preconditions.checkNotNull(var1_1);
            this.name = (String)Preconditions.checkNotNull(var2_2);
            this.bounds = ImmutableList.copyOf(var3_3);
        }

        public final Type[] getBounds() {
            return Types.toArray(this.bounds);
        }

        public final D getGenericDeclaration() {
            return this.genericDeclaration;
        }

        public final String getName() {
            return this.name;
        }

        public final String getTypeName() {
            return this.name;
        }

        public final String toString() {
            return this.name;
        }

        public final int hashCode() {
            return this.genericDeclaration.hashCode() ^ this.name.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            Object that;
            if (NativeTypeVariableEquals.NATIVE_TYPE_VARIABLE_ONLY) {
                if (obj != null && Proxy.isProxyClass(obj.getClass()) && Proxy.getInvocationHandler(obj) instanceof TypeVariableInvocationHandler) {
                    that = ((TypeVariableInvocationHandler)(obj = (TypeVariableInvocationHandler)Proxy.getInvocationHandler(obj))).typeVariableImpl;
                    return this.name.equals(((TypeVariableImpl)that).getName()) && this.genericDeclaration.equals(((TypeVariableImpl)that).getGenericDeclaration()) && this.bounds.equals(((TypeVariableImpl)that).bounds);
                }
                return false;
            }
            if (that instanceof TypeVariable) {
                void var1_1;
                return this.name.equals((that = (TypeVariable)that).getName()) && this.genericDeclaration.equals(var1_1.getGenericDeclaration());
            }
            return false;
        }
    }

    private static final class TypeVariableInvocationHandler
    implements InvocationHandler {
        private static final ImmutableMap<String, Method> typeVariableMethods;
        private final TypeVariableImpl<?> typeVariableImpl;

        /*
         * WARNING - void declaration
         */
        TypeVariableInvocationHandler(TypeVariableImpl<?> typeVariableImpl) {
            void var1_1;
            this.typeVariableImpl = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            InvocationTargetException invocationTargetException;
            String methodName = method.getName();
            Method typeVariableMethod = typeVariableMethods.get(methodName);
            if (typeVariableMethod == null) {
                throw new UnsupportedOperationException((String)((Object)invocationTargetException));
            }
            try {
                void var3_3;
                void var2_2;
                return var2_2.invoke(this.typeVariableImpl, (Object[])var3_3);
            }
            catch (InvocationTargetException invocationTargetException2) {
                invocationTargetException = invocationTargetException2;
                throw invocationTargetException2.getCause();
            }
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            ImmutableMap.Builder<String, Method> builder = ImmutableMap.builder();
            for (Method method : TypeVariableImpl.class.getMethods()) {
                if (!method.getDeclaringClass().equals(TypeVariableImpl.class)) continue;
                try {
                    method.setAccessible(true);
                }
                catch (AccessControlException accessControlException) {}
                builder.put(method.getName(), method);
            }
            typeVariableMethods = var0.buildKeepingLast();
        }
    }

    private static final class ParameterizedTypeImpl
    implements Serializable,
    ParameterizedType {
        private final Type ownerType;
        private final ImmutableList<Type> argumentsList;
        private final Class<?> rawType;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        ParameterizedTypeImpl(Type ownerType, Class<?> rawType, Type[] typeArguments) {
            void var3_3;
            void var2_2;
            void var1_1;
            Preconditions.checkNotNull(rawType);
            Preconditions.checkArgument(typeArguments.length == rawType.getTypeParameters().length);
            Types.access$200(typeArguments, "type parameter");
            this.ownerType = var1_1;
            this.rawType = var2_2;
            this.argumentsList = JavaVersion.CURRENT.usedInGenericType((Type[])var3_3);
        }

        @Override
        public final Type[] getActualTypeArguments() {
            return Types.toArray(this.argumentsList);
        }

        @Override
        public final Type getRawType() {
            return this.rawType;
        }

        @Override
        public final Type getOwnerType() {
            return this.ownerType;
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder();
            if (this.ownerType != null && JavaVersion.CURRENT.jdkTypeDuplicatesOwnerName()) {
                builder.append(JavaVersion.CURRENT.typeName(this.ownerType)).append('.');
            }
            return var1_1.append(this.rawType.getName()).append('<').append(COMMA_JOINER.join(Iterables.transform(this.argumentsList, JavaVersion.CURRENT::typeName))).append('>').toString();
        }

        public final int hashCode() {
            return (this.ownerType == null ? 0 : this.ownerType.hashCode()) ^ this.argumentsList.hashCode() ^ this.rawType.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            if (!(other instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType that = (ParameterizedType)other;
            return this.getRawType().equals(that.getRawType()) && com.google.common.base.Objects.equal(this.getOwnerType(), that.getOwnerType()) && Arrays.equals(this.getActualTypeArguments(), var1_1.getActualTypeArguments());
        }
    }

    private static final class GenericArrayTypeImpl
    implements Serializable,
    GenericArrayType {
        private final Type componentType;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        GenericArrayTypeImpl(Type componentType) {
            void var1_1;
            this.componentType = JavaVersion.CURRENT.usedInGenericType((Type)var1_1);
        }

        @Override
        public final Type getGenericComponentType() {
            return this.componentType;
        }

        public final String toString() {
            return String.valueOf(Types.toString(this.componentType)).concat("[]");
        }

        public final int hashCode() {
            return this.componentType.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            if (obj instanceof GenericArrayType) {
                void var1_1;
                GenericArrayType that = (GenericArrayType)obj;
                return com.google.common.base.Objects.equal(this.getGenericComponentType(), var1_1.getGenericComponentType());
            }
            return false;
        }
    }

    private static enum ClassOwnership {
        OWNED_BY_ENCLOSING_CLASS{

            @Override
            final Class<?> getOwnerType(Class<?> rawType) {
                return rawType.getEnclosingClass();
            }
        }
        ,
        LOCAL_CLASS_HAS_NO_OWNER{

            /*
             * WARNING - void declaration
             */
            @Override
            final Class<?> getOwnerType(Class<?> rawType) {
                void var1_1;
                if (rawType.isLocalClass()) {
                    return null;
                }
                return var1_1.getEnclosingClass();
            }
        };

        static final ClassOwnership JVM_BEHAVIOR;

        abstract Class<?> getOwnerType(Class<?> var1);

        private static ClassOwnership detectJvmBehavior() {
            class LocalClass<T> {
                LocalClass() {
                }
            }
            Class<?> clazz = new LocalClass<String>(){
                {
                }
            }.getClass();
            ParameterizedType parameterizedType = Objects.requireNonNull((ParameterizedType)clazz.getGenericSuperclass());
            for (ClassOwnership behavior : ClassOwnership.values()) {
                if (behavior.getOwnerType(LocalClass.class) != parameterizedType.getOwnerType()) continue;
                return behavior;
            }
            throw new AssertionError();
        }

        static {
            JVM_BEHAVIOR = ClassOwnership.detectJvmBehavior();
        }
    }
}

