/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.collect.Sets;
import com.google.common.reflect.ElementTypesAreNonnullByDefault;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Set;

@ElementTypesAreNonnullByDefault
abstract class TypeVisitor {
    private final Set<Type> visited = Sets.newHashSet();

    TypeVisitor() {
    }

    public final void visit(Type ... types) {
        Object object = types;
        int n = types.length;
        for (int i = 0; i < n; ++i) {
            Type type = object[i];
            if (type == null || !this.visited.add(type)) continue;
            try {
                if (type instanceof TypeVariable) {
                    this.visitTypeVariable((TypeVariable)type);
                    continue;
                }
                if (type instanceof WildcardType) {
                    this.visitWildcardType((WildcardType)type);
                    continue;
                }
                if (type instanceof ParameterizedType) {
                    this.visitParameterizedType((ParameterizedType)type);
                    continue;
                }
                if (type instanceof Class) {
                    this.visitClass((Class)type);
                    continue;
                }
                if (type instanceof GenericArrayType) {
                    this.visitGenericArrayType((GenericArrayType)type);
                    continue;
                }
                object = String.valueOf(type);
                throw new AssertionError((Object)new StringBuilder(14 + String.valueOf(object).length()).append("Unknown type: ").append((String)object).toString());
            }
            catch (Throwable throwable) {
                this.visited.remove(type);
                throw throwable;
            }
        }
    }

    void visitClass(Class<?> t) {
    }

    void visitGenericArrayType(GenericArrayType t) {
    }

    void visitParameterizedType(ParameterizedType t) {
    }

    void visitTypeVariable(TypeVariable<?> t) {
    }

    void visitWildcardType(WildcardType t) {
    }
}

