/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Primitives;
import com.google.common.reflect.ElementTypesAreNonnullByDefault;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeCapture;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeResolver;
import com.google.common.reflect.TypeVisitor;
import com.google.common.reflect.Types;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ElementTypesAreNonnullByDefault
public abstract class TypeToken<T>
extends TypeCapture<T>
implements Serializable {
    private final Type runtimeType;
    private transient TypeResolver invariantTypeResolver;
    private transient TypeResolver covariantTypeResolver;
    private static final long serialVersionUID = 3637540370352322684L;

    protected TypeToken() {
        this.runtimeType = this.capture();
        Preconditions.checkState(!(this.runtimeType instanceof TypeVariable), "Cannot construct a TypeToken for a type variable.\nYou probably meant to call new TypeToken<%s>(getClass()) that can resolve the type variable for you.\nIf you do need to create a TypeToken of a type variable, please use TypeToken.of() instead.", (Object)this.runtimeType);
    }

    /*
     * WARNING - void declaration
     */
    protected TypeToken(Class<?> declaringClass) {
        void var2_2;
        void var1_1;
        Type captured = super.capture();
        if (captured instanceof Class) {
            this.runtimeType = captured;
            return;
        }
        this.runtimeType = TypeResolver.covariantly((Type)var1_1).resolveType((Type)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private TypeToken(Type type) {
        void var1_1;
        this.runtimeType = (Type)Preconditions.checkNotNull(var1_1);
    }

    public static <T> TypeToken<T> of(Class<T> type) {
        Class<T> clazz;
        return new SimpleTypeToken((Type)clazz);
    }

    public static TypeToken<?> of(Type type) {
        Type type2;
        return new SimpleTypeToken(type2);
    }

    public final Class<? super T> getRawType() {
        Class clazz = (Class)((ImmutableCollection)this.getRawTypes()).iterator().next();
        Class clazz2 = clazz;
        clazz2 = clazz;
        return clazz;
    }

    public final Type getType() {
        return this.runtimeType;
    }

    /*
     * WARNING - void declaration
     */
    public final <X> TypeToken<T> where(TypeParameter<X> typeParam, TypeToken<X> typeArg) {
        void var1_1;
        void var2_2;
        TypeResolver resolver = new TypeResolver().where(ImmutableMap.of(new TypeResolver.TypeVariableKey(typeParam.typeVariable), var2_2.runtimeType));
        return new SimpleTypeToken(var1_1.resolveType(this.runtimeType));
    }

    /*
     * WARNING - void declaration
     */
    public final <X> TypeToken<T> where(TypeParameter<X> typeParam, Class<X> typeArg) {
        void var2_2;
        void var1_1;
        return this.where((TypeParameter<X>)var1_1, (TypeToken<X>)TypeToken.of(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final TypeToken<?> resolveType(Type type) {
        void var1_1;
        Preconditions.checkNotNull(type);
        return TypeToken.of(this.getInvariantTypeResolver().resolveType((Type)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private TypeToken<?> resolveSupertype(Type type) {
        void var1_1;
        TypeToken<?> supertype = TypeToken.of(this.getCovariantTypeResolver().resolveType(type));
        TypeToken.of(this.getCovariantTypeResolver().resolveType(type)).covariantTypeResolver = this.covariantTypeResolver;
        supertype.invariantTypeResolver = this.invariantTypeResolver;
        return var1_1;
    }

    final TypeToken<? super T> getGenericSuperclass() {
        TypeToken<?> typeToken;
        if (this.runtimeType instanceof TypeVariable) {
            TypeToken typeToken2 = this;
            return typeToken2.boundAsSuperclass(((TypeVariable)typeToken2.runtimeType).getBounds()[0]);
        }
        if (this.runtimeType instanceof WildcardType) {
            TypeToken typeToken3 = this;
            return typeToken3.boundAsSuperclass(((WildcardType)typeToken3.runtimeType).getUpperBounds()[0]);
        }
        Type superclass = this.getRawType().getGenericSuperclass();
        if (superclass == null) {
            return null;
        }
        typeToken = this.resolveSupertype((Type)((Object)typeToken));
        return typeToken;
    }

    /*
     * WARNING - void declaration
     */
    private TypeToken<? super T> boundAsSuperclass(Type bound) {
        void var1_1;
        TypeToken<?> token = TypeToken.of(bound);
        if (token.getRawType().isInterface()) {
            return null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final ImmutableList<TypeToken<? super T>> getGenericInterfaces() {
        void var1_1;
        if (this.runtimeType instanceof TypeVariable) {
            TypeToken typeToken = this;
            return typeToken.boundsAsInterfaces(((TypeVariable)typeToken.runtimeType).getBounds());
        }
        if (this.runtimeType instanceof WildcardType) {
            TypeToken typeToken = this;
            return typeToken.boundsAsInterfaces(((WildcardType)typeToken.runtimeType).getUpperBounds());
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type interfaceType : this.getRawType().getGenericInterfaces()) {
            TypeToken<?> resolvedInterface = this.resolveSupertype(interfaceType);
            builder.add(resolvedInterface);
        }
        return var1_1.build();
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableList<TypeToken<? super T>> boundsAsInterfaces(Type[] bounds) {
        void var2_2;
        void var1_1;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (void var5_5 : var1_1) {
            TypeToken<?> boundType = TypeToken.of((Type)var5_5);
            if (!boundType.getRawType().isInterface()) continue;
            builder.add(boundType);
        }
        return var2_2.build();
    }

    public final TypeSet getTypes() {
        return new TypeSet(this);
    }

    public final TypeToken<? super T> getSupertype(Class<? super T> superclass) {
        TypeToken<?> typeToken;
        Preconditions.checkArgument(this.someRawTypeIsSubclassOf(superclass), "%s is not a super class of %s", superclass, (Object)this);
        if (this.runtimeType instanceof TypeVariable) {
            return this.getSupertypeFromUpperBounds(superclass, ((TypeVariable)this.runtimeType).getBounds());
        }
        if (this.runtimeType instanceof WildcardType) {
            return this.getSupertypeFromUpperBounds(superclass, ((WildcardType)this.runtimeType).getUpperBounds());
        }
        if (superclass.isArray()) {
            return this.getArraySupertype(superclass);
        }
        typeToken = this.resolveSupertype(TypeToken.toGenericType(typeToken).runtimeType);
        return typeToken;
    }

    /*
     * WARNING - void declaration
     */
    public final TypeToken<? extends T> getSubtype(Class<?> subclass) {
        void var1_1;
        Preconditions.checkArgument(!(this.runtimeType instanceof TypeVariable), "Cannot get subtype of type variable <%s>", (Object)this);
        if (this.runtimeType instanceof WildcardType) {
            return this.getSubtypeFromLowerBounds((Class<?>)subclass, ((WildcardType)this.runtimeType).getLowerBounds());
        }
        if (this.isArray()) {
            return this.getArraySubtype((Class<?>)subclass);
        }
        Preconditions.checkArgument(this.getRawType().isAssignableFrom((Class<?>)subclass), "%s isn't a subclass of %s", subclass, (Object)this);
        subclass = this.resolveTypeArgsForSubclass((Class<?>)subclass);
        TypeToken<?> subtype = TypeToken.of(subclass);
        Preconditions.checkArgument(subtype.isSubtypeOf(this), "%s does not appear to be a subtype of %s", subtype, (Object)this);
        return var1_1;
    }

    public final boolean isSupertypeOf(TypeToken<?> type) {
        return type.isSubtypeOf(this.getType());
    }

    public final boolean isSupertypeOf(Type type) {
        return TypeToken.of(type).isSubtypeOf(this.getType());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isSubtypeOf(TypeToken<?> type) {
        void var1_1;
        return this.isSubtypeOf(var1_1.getType());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isSubtypeOf(Type supertype) {
        Preconditions.checkNotNull(supertype);
        if (supertype instanceof WildcardType) {
            return TypeToken.any(((WildcardType)supertype).getLowerBounds()).isSupertypeOf(this.runtimeType);
        }
        if (this.runtimeType instanceof WildcardType) {
            return TypeToken.any(((WildcardType)this.runtimeType).getUpperBounds()).isSubtypeOf(supertype);
        }
        if (this.runtimeType instanceof TypeVariable) {
            return this.runtimeType.equals(supertype) || TypeToken.any(((TypeVariable)this.runtimeType).getBounds()).isSubtypeOf(supertype);
        }
        if (this.runtimeType instanceof GenericArrayType) {
            return super.isSupertypeOfArray((GenericArrayType)this.runtimeType);
        }
        if (supertype instanceof Class) {
            return this.someRawTypeIsSubclassOf((Class)supertype);
        }
        if (supertype instanceof ParameterizedType) {
            return this.isSubtypeOfParameterizedType((ParameterizedType)supertype);
        }
        if (supertype instanceof GenericArrayType) {
            void var1_1;
            return this.isSubtypeOfArrayType((GenericArrayType)var1_1);
        }
        return false;
    }

    public final boolean isArray() {
        return this.getComponentType() != null;
    }

    public final boolean isPrimitive() {
        return this.runtimeType instanceof Class && ((Class)this.runtimeType).isPrimitive();
    }

    public final TypeToken<T> wrap() {
        if (this.isPrimitive()) {
            Class clazz = (Class)this.runtimeType;
            return TypeToken.of(Primitives.wrap(clazz));
        }
        return this;
    }

    private boolean isWrapper() {
        return Primitives.allWrapperTypes().contains(this.runtimeType);
    }

    public final TypeToken<T> unwrap() {
        if (this.isWrapper()) {
            Class clazz = (Class)this.runtimeType;
            return TypeToken.of(Primitives.unwrap(clazz));
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final TypeToken<?> getComponentType() {
        void var1_1;
        Type componentType = Types.getComponentType(this.runtimeType);
        if (componentType == null) {
            return null;
        }
        return TypeToken.of((Type)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public final Invokable<T, Object> method(Method method) {
        void var1_1;
        Preconditions.checkArgument(this.someRawTypeIsSubclassOf(method.getDeclaringClass()), "%s not declared by %s", (Object)method, (Object)this);
        return new Invokable.MethodInvokable<T>(this, (Method)var1_1){
            final /* synthetic */ TypeToken this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((Method)var2_2);
            }

            @Override
            Type getGenericReturnType() {
                return this.this$0.getCovariantTypeResolver().resolveType(super.getGenericReturnType());
            }

            @Override
            Type[] getGenericParameterTypes() {
                return this.this$0.getInvariantTypeResolver().resolveTypesInPlace(super.getGenericParameterTypes());
            }

            @Override
            Type[] getGenericExceptionTypes() {
                return this.this$0.getCovariantTypeResolver().resolveTypesInPlace(super.getGenericExceptionTypes());
            }

            @Override
            public TypeToken<T> getOwnerType() {
                return this.this$0;
            }

            @Override
            public String toString() {
                String string = String.valueOf(((Invokable)this).getOwnerType());
                String string2 = super.toString();
                return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public final Invokable<T, T> constructor(Constructor<?> constructor) {
        void var1_1;
        Preconditions.checkArgument(constructor.getDeclaringClass() == this.getRawType(), "%s not declared by %s", constructor, this.getRawType());
        return new Invokable.ConstructorInvokable<T>(this, (Constructor)var1_1){
            final /* synthetic */ TypeToken this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((Constructor<?>)var2_2);
            }

            @Override
            Type getGenericReturnType() {
                return this.this$0.getCovariantTypeResolver().resolveType(super.getGenericReturnType());
            }

            @Override
            Type[] getGenericParameterTypes() {
                return this.this$0.getInvariantTypeResolver().resolveTypesInPlace(super.getGenericParameterTypes());
            }

            @Override
            Type[] getGenericExceptionTypes() {
                return this.this$0.getCovariantTypeResolver().resolveTypesInPlace(super.getGenericExceptionTypes());
            }

            @Override
            public TypeToken<T> getOwnerType() {
                return this.this$0;
            }

            @Override
            public String toString() {
                String string = String.valueOf(((Invokable)this).getOwnerType());
                String string2 = Joiner.on(", ").join(this.getGenericParameterTypes());
                return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("(").append(string2).append(")").toString();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        if (o instanceof TypeToken) {
            void var1_1;
            TypeToken that = (TypeToken)o;
            return this.runtimeType.equals(var1_1.runtimeType);
        }
        return false;
    }

    public int hashCode() {
        return this.runtimeType.hashCode();
    }

    public String toString() {
        return Types.toString(this.runtimeType);
    }

    protected Object writeReplace() {
        return TypeToken.of(new TypeResolver().resolveType(this.runtimeType));
    }

    final TypeToken<T> rejectTypeVariables() {
        new TypeVisitor(this){
            final /* synthetic */ TypeToken this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            void visitTypeVariable(TypeVariable<?> type) {
                String string = String.valueOf(this.this$0.runtimeType);
                throw new IllegalArgumentException(new StringBuilder(58 + String.valueOf(string).length()).append(string).append("contains a type variable and is not safe for the operation").toString());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void visitWildcardType(WildcardType type) {
                void var1_1;
                this.visit(type.getLowerBounds());
                this.visit(var1_1.getUpperBounds());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void visitParameterizedType(ParameterizedType type) {
                void var1_1;
                this.visit(type.getActualTypeArguments());
                this.visit(var1_1.getOwnerType());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void visitGenericArrayType(GenericArrayType type) {
                void var1_1;
                this.visit(var1_1.getGenericComponentType());
            }
        }.visit(this.runtimeType);
        return this;
    }

    private boolean someRawTypeIsSubclassOf(Class<?> superclass) {
        for (Class clazz : this.getRawTypes()) {
            if (!superclass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSubtypeOfParameterizedType(ParameterizedType supertype) {
        void var1_1;
        Class<?> matchedClass = TypeToken.of(supertype).getRawType();
        if (!this.someRawTypeIsSubclassOf(matchedClass)) {
            return false;
        }
        TypeVariable<Class<?>>[] typeVars = matchedClass.getTypeParameters();
        Type[] supertypeArgs = supertype.getActualTypeArguments();
        for (int i = 0; i < typeVars.length; ++i) {
            Type type = this.getCovariantTypeResolver().resolveType(typeVars[i]);
            if (super.is(supertypeArgs[i], typeVars[i])) continue;
            return false;
        }
        return Modifier.isStatic(((Class)supertype.getRawType()).getModifiers()) || supertype.getOwnerType() == null || this.isOwnedBySubtypeOf(var1_1.getOwnerType());
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSubtypeOfArrayType(GenericArrayType supertype) {
        if (this.runtimeType instanceof Class) {
            void var2_2;
            Class fromClass = (Class)this.runtimeType;
            if (!fromClass.isArray()) {
                return false;
            }
            return TypeToken.of(var2_2.getComponentType()).isSubtypeOf(supertype.getGenericComponentType());
        }
        if (this.runtimeType instanceof GenericArrayType) {
            void var1_1;
            GenericArrayType genericArrayType = (GenericArrayType)this.runtimeType;
            return TypeToken.of(genericArrayType.getGenericComponentType()).isSubtypeOf(var1_1.getGenericComponentType());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSupertypeOfArray(GenericArrayType subtype) {
        if (this.runtimeType instanceof Class) {
            void var2_2;
            Class thisClass = (Class)this.runtimeType;
            if (!thisClass.isArray()) {
                return thisClass.isAssignableFrom(Object[].class);
            }
            return TypeToken.of(subtype.getGenericComponentType()).isSubtypeOf(var2_2.getComponentType());
        }
        if (this.runtimeType instanceof GenericArrayType) {
            void var1_1;
            return TypeToken.of(var1_1.getGenericComponentType()).isSubtypeOf(((GenericArrayType)this.runtimeType).getGenericComponentType());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean is(Type formalType, TypeVariable<?> declaration) {
        void var1_1;
        if (this.runtimeType.equals(formalType)) {
            return true;
        }
        if (formalType instanceof WildcardType) {
            void var2_2;
            WildcardType your = TypeToken.canonicalizeWildcardType(var2_2, (WildcardType)formalType);
            return TypeToken.every(your.getUpperBounds()).isSupertypeOf(this.runtimeType) && TypeToken.every(var1_1.getLowerBounds()).isSubtypeOf(this.runtimeType);
        }
        return TypeToken.canonicalizeWildcardsInType(this.runtimeType).equals(TypeToken.canonicalizeWildcardsInType((Type)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static Type canonicalizeTypeArg(TypeVariable<?> declaration, Type typeArg) {
        void var1_1;
        if (typeArg instanceof WildcardType) {
            TypeVariable<?> typeVariable;
            return TypeToken.canonicalizeWildcardType(typeVariable, (WildcardType)typeArg);
        }
        return TypeToken.canonicalizeWildcardsInType((Type)var1_1);
    }

    private static Type canonicalizeWildcardsInType(Type type) {
        Type type2;
        if (type instanceof ParameterizedType) {
            return TypeToken.canonicalizeWildcardsInParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return Types.newArrayType(TypeToken.canonicalizeWildcardsInType(((GenericArrayType)type).getGenericComponentType()));
        }
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    private static WildcardType canonicalizeWildcardType(TypeVariable<?> declaration, WildcardType type) {
        void var2_2;
        void var1_1;
        Type[] declared = declaration.getBounds();
        ArrayList<Type> upperBounds = new ArrayList<Type>();
        for (Type bound : type.getUpperBounds()) {
            if (TypeToken.any(declared).isSubtypeOf(bound)) continue;
            upperBounds.add(TypeToken.canonicalizeWildcardsInType(bound));
        }
        return new Types.WildcardTypeImpl(var1_1.getLowerBounds(), var2_2.toArray(new Type[0]));
    }

    /*
     * WARNING - void declaration
     */
    private static ParameterizedType canonicalizeWildcardsInParameterizedType(ParameterizedType type) {
        void var3_3;
        void var1_1;
        ParameterizedType parameterizedType;
        Class rawType = (Class)type.getRawType();
        TypeVariable<Class<T>>[] typeVars = rawType.getTypeParameters();
        Type[] typeArgs = type.getActualTypeArguments();
        for (int i = 0; i < typeArgs.length; ++i) {
            typeArgs[i] = TypeToken.canonicalizeTypeArg(typeVars[i], typeArgs[i]);
        }
        return Types.newParameterizedTypeWithOwner(parameterizedType.getOwnerType(), var1_1, (Type[])var3_3);
    }

    private static Bounds every(Type[] bounds) {
        Type[] typeArray;
        return new Bounds(typeArray, false);
    }

    private static Bounds any(Type[] bounds) {
        Type[] typeArray;
        return new Bounds(typeArray, true);
    }

    private ImmutableSet<Class<? super T>> getRawTypes() {
        ImmutableCollection immutableCollection;
        final ImmutableSet.Builder builder = ImmutableSet.builder();
        new TypeVisitor(this){

            /*
             * WARNING - void declaration
             */
            @Override
            void visitTypeVariable(TypeVariable<?> t) {
                void var1_1;
                this.visit(var1_1.getBounds());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void visitWildcardType(WildcardType t) {
                void var1_1;
                this.visit(var1_1.getUpperBounds());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void visitParameterizedType(ParameterizedType t) {
                void var1_1;
                builder.add((Class)var1_1.getRawType());
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void visitClass(Class<?> t) {
                void var1_1;
                builder.add((Object)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void visitGenericArrayType(GenericArrayType t) {
                void var1_1;
                builder.add(Types.getArrayClass(TypeToken.of(var1_1.getGenericComponentType()).getRawType()));
            }
        }.visit(this.runtimeType);
        immutableCollection = ((ImmutableSet.Builder)((Object)immutableCollection)).build();
        return immutableCollection;
    }

    private boolean isOwnedBySubtypeOf(Type supertype) {
        for (TypeToken typeToken : this.getTypes()) {
            Type ownerType = typeToken.getOwnerTypeIfPresent();
            if (ownerType == null || !TypeToken.of((Type)((Object)typeToken)).isSubtypeOf(supertype)) continue;
            return true;
        }
        return false;
    }

    private Type getOwnerTypeIfPresent() {
        if (this.runtimeType instanceof ParameterizedType) {
            return ((ParameterizedType)this.runtimeType).getOwnerType();
        }
        if (this.runtimeType instanceof Class) {
            return ((Class)this.runtimeType).getEnclosingClass();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static <T> TypeToken<? extends T> toGenericType(Class<T> cls) {
        Class<T> clazz;
        Type ownerType;
        if (cls.isArray()) {
            Type type = Types.newArrayType(TypeToken.toGenericType(cls.getComponentType()).runtimeType);
            TypeToken<?> typeToken = TypeToken.of(type);
            return typeToken;
        }
        TypeVariable<Class<T>>[] typeParams = cls.getTypeParameters();
        Type type = ownerType = cls.isMemberClass() && !Modifier.isStatic(cls.getModifiers()) ? TypeToken.toGenericType(cls.getEnclosingClass()).runtimeType : null;
        if (typeParams.length > 0 || ownerType != null && ownerType != cls.getEnclosingClass()) {
            void var1_2;
            void var2_4;
            cls = TypeToken.of(Types.newParameterizedTypeWithOwner((Type)var2_4, cls, (Type[])var1_2));
            return cls;
        }
        return TypeToken.of(clazz);
    }

    /*
     * WARNING - void declaration
     */
    private TypeResolver getCovariantTypeResolver() {
        void var1_1;
        TypeResolver resolver = this.covariantTypeResolver;
        if (resolver == null) {
            resolver = this.covariantTypeResolver = TypeResolver.covariantly(this.runtimeType);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private TypeResolver getInvariantTypeResolver() {
        void var1_1;
        TypeResolver resolver = this.invariantTypeResolver;
        if (resolver == null) {
            resolver = this.invariantTypeResolver = TypeResolver.invariantly(this.runtimeType);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private TypeToken<? super T> getSupertypeFromUpperBounds(Class<? super T> supertype, Type[] upperBounds) {
        void var1_1;
        Object object = upperBounds;
        int n = upperBounds.length;
        for (int i = 0; i < n; ++i) {
            Type type = object[i];
            TypeToken<?> bound = TypeToken.of(type);
            if (!bound.isSubtypeOf((Type)((Object)supertype))) continue;
            supertype = bound.getSupertype((Class<?>)supertype);
            return supertype;
        }
        object = String.valueOf(var1_1);
        String string = String.valueOf(this);
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(" isn't a super type of ").append(string).toString());
    }

    private TypeToken<? extends T> getSubtypeFromLowerBounds(Class<?> subclass, Type[] lowerBounds) {
        String string;
        Object object;
        if (lowerBounds.length > 0) {
            object = TypeToken.of((Type)object[0]);
            return ((TypeToken)object).getSubtype(subclass);
        }
        object = String.valueOf(string);
        string = String.valueOf(this);
        throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(object).length() + String.valueOf(string).length()).append((String)object).append(" isn't a subclass of ").append(string).toString());
    }

    private TypeToken<? super T> getArraySupertype(Class<? super T> supertype) {
        TypeToken<?> typeToken;
        TypeToken<?> typeToken2;
        TypeToken<?> componentType = this.getComponentType();
        if (componentType == null) {
            supertype = String.valueOf(supertype);
            componentType = String.valueOf(this);
            throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(supertype).length() + String.valueOf(componentType).length()).append((String)supertype).append(" isn't a super type of ").append((String)((Object)componentType)).toString());
        }
        typeToken = typeToken2.getSupertype(Objects.requireNonNull(((Class)((Object)typeToken)).getComponentType()));
        typeToken2 = TypeToken.of(TypeToken.newArrayClassOrGenericArrayType(typeToken.runtimeType));
        return typeToken2;
    }

    private TypeToken<? extends T> getArraySubtype(Class<?> subclass) {
        TypeToken<?> typeToken;
        Object object;
        Class<?> subclassComponentType = subclass.getComponentType();
        if (subclassComponentType == null) {
            object = String.valueOf(object);
            subclassComponentType = String.valueOf(this);
            throw new IllegalArgumentException(new StringBuilder(36 + String.valueOf(object).length() + String.valueOf(subclassComponentType).length()).append((String)object).append(" does not appear to be a subtype of ").append((String)((Object)subclassComponentType)).toString());
        }
        object = Objects.requireNonNull(this.getComponentType()).getSubtype((Class<?>)((Object)typeToken));
        typeToken = TypeToken.of(TypeToken.newArrayClassOrGenericArrayType(((TypeToken)object).runtimeType));
        return typeToken;
    }

    /*
     * WARNING - void declaration
     */
    private Type resolveTypeArgsForSubclass(Class<?> subclass) {
        void var1_1;
        void var2_2;
        if (this.runtimeType instanceof Class && (subclass.getTypeParameters().length == 0 || this.getRawType().getTypeParameters().length != 0)) {
            return subclass;
        }
        TypeToken<?> genericSubtype = TypeToken.toGenericType(subclass);
        Type supertypeWithArgsFromSubtype = genericSubtype.getSupertype(this.getRawType()).runtimeType;
        return new TypeResolver().where((Type)var2_2, this.runtimeType).resolveType(var1_1.runtimeType);
    }

    private static Type newArrayClassOrGenericArrayType(Type componentType) {
        Type type;
        return Types.JavaVersion.JAVA7.newArrayType(type);
    }

    private static abstract class TypeCollector<K> {
        static final TypeCollector<TypeToken<?>> FOR_GENERIC_TYPE = new TypeCollector<TypeToken<?>>(){

            @Override
            Class<?> getRawType(TypeToken<?> type) {
                return type.getRawType();
            }

            @Override
            Iterable<? extends TypeToken<?>> getInterfaces(TypeToken<?> type) {
                return type.getGenericInterfaces();
            }

            @Override
            TypeToken<?> getSuperclass(TypeToken<?> type) {
                return type.getGenericSuperclass();
            }
        };
        static final TypeCollector<Class<?>> FOR_RAW_TYPE = new TypeCollector<Class<?>>(){

            @Override
            Class<?> getRawType(Class<?> type) {
                return type;
            }

            @Override
            Iterable<? extends Class<?>> getInterfaces(Class<?> type) {
                return Arrays.asList(type.getInterfaces());
            }

            @Override
            Class<?> getSuperclass(Class<?> type) {
                return type.getSuperclass();
            }
        };

        private TypeCollector() {
        }

        final TypeCollector<K> classesOnly() {
            TypeCollector typeCollector = this;
            return new ForwardingTypeCollector<K>(typeCollector, typeCollector){
                {
                    void var2_2;
                }

                @Override
                Iterable<? extends K> getInterfaces(K type) {
                    return ImmutableSet.of();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                ImmutableList<K> collectTypes(Iterable<? extends K> types) {
                    void var2_2;
                    Iterator iterator;
                    ImmutableList.Builder builder = ImmutableList.builder();
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        void var3_3;
                        Object type = iterator.next();
                        if (this.getRawType(type).isInterface()) continue;
                        builder.add((Object)var3_3);
                    }
                    return super.collectTypes(var2_2.build());
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        final ImmutableList<K> collectTypes(K type) {
            void var1_1;
            return this.collectTypes((Iterable<? extends K>)ImmutableList.of(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        ImmutableList<K> collectTypes(Iterable<? extends K> types) {
            void var2_2;
            Iterator iterator;
            HashMap map = Maps.newHashMap();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Object type = iterator.next();
                this.collectTypes(var3_3, map);
            }
            return TypeCollector.sortKeysByValue(var2_2, Ordering.natural().reverse());
        }

        /*
         * WARNING - void declaration
         */
        private int collectTypes(K type, Map<? super K, Integer> map) {
            void var3_4;
            void var1_1;
            void var2_2;
            Integer existing = map.get(type);
            if (existing != null) {
                return existing;
            }
            int aboveMe = this.getRawType(type).isInterface() ? 1 : 0;
            for (K interfaceType : this.getInterfaces(type)) {
                aboveMe = Math.max(aboveMe, this.collectTypes(interfaceType, map));
            }
            K superclass = this.getSuperclass(type);
            if (superclass != null) {
                aboveMe = Math.max(aboveMe, this.collectTypes(superclass, map));
            }
            var2_2.put(var1_1, aboveMe + 1);
            return (int)(var3_4 + true);
        }

        private static <K, V> ImmutableList<K> sortKeysByValue(final Map<K, V> map, Comparator<? super V> valueComparator) {
            Map<K, V> map2;
            Ordering ordering;
            ordering = new Ordering<K>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public int compare(K left, K right) {
                    void var2_2;
                    void var1_1;
                    return ordering.compare(Objects.requireNonNull(map.get(var1_1)), Objects.requireNonNull(map.get(var2_2)));
                }
            };
            return ordering.immutableSortedCopy(map2.keySet());
        }

        abstract Class<?> getRawType(K var1);

        abstract Iterable<? extends K> getInterfaces(K var1);

        abstract K getSuperclass(K var1);

        private static class ForwardingTypeCollector<K>
        extends TypeCollector<K> {
            private final TypeCollector<K> delegate;

            /*
             * WARNING - void declaration
             */
            ForwardingTypeCollector(TypeCollector<K> delegate) {
                void var1_1;
                this.delegate = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Class<?> getRawType(K type) {
                void var1_1;
                return this.delegate.getRawType(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Iterable<? extends K> getInterfaces(K type) {
                void var1_1;
                return this.delegate.getInterfaces(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            K getSuperclass(K type) {
                void var1_1;
                return this.delegate.getSuperclass(var1_1);
            }
        }
    }

    private static final class SimpleTypeToken<T>
    extends TypeToken<T> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SimpleTypeToken(Type type) {
            super((Type)var1_1);
            void var1_1;
        }
    }

    private static class Bounds {
        private final Type[] bounds;
        private final boolean target;

        /*
         * WARNING - void declaration
         */
        Bounds(Type[] bounds, boolean target) {
            void var2_2;
            void var1_1;
            this.bounds = var1_1;
            this.target = var2_2;
        }

        boolean isSubtypeOf(Type supertype) {
            Type[] typeArray = this.bounds;
            int n = this.bounds.length;
            for (int i = 0; i < n; ++i) {
                Type type = typeArray[i];
                if (TypeToken.of(type).isSubtypeOf(supertype) != this.target) continue;
                return this.target;
            }
            return !this.target;
        }

        boolean isSupertypeOf(Type subtype) {
            TypeToken<?> type = TypeToken.of(subtype);
            Type[] typeArray = this.bounds;
            int n = this.bounds.length;
            for (int i = 0; i < n; ++i) {
                Type bound = typeArray[i];
                if (type.isSubtypeOf(bound) != this.target) continue;
                return this.target;
            }
            return !this.target;
        }
    }

    private static enum TypeFilter implements Predicate<TypeToken<?>>
    {
        IGNORE_TYPE_VARIABLE_OR_WILDCARD{

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean apply(TypeToken<?> type) {
                void var1_1;
                return !(((TypeToken)type).runtimeType instanceof TypeVariable) && !(((TypeToken)var1_1).runtimeType instanceof WildcardType);
            }
        }
        ,
        INTERFACE_ONLY{

            @Override
            public final boolean apply(TypeToken<?> type) {
                return type.getRawType().isInterface();
            }
        };

    }

    private final class ClassSet
    extends TypeSet {
        private transient ImmutableSet<TypeToken<? super T>> classes;
        private static final long serialVersionUID = 0L;

        private ClassSet() {
            super(TypeToken.this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final Set<TypeToken<? super T>> delegate() {
            void var1_1;
            ImmutableSet result = this.classes;
            if (result == null) {
                ImmutableList<TypeToken> collectedTypes = TypeCollector.FOR_GENERIC_TYPE.classesOnly().collectTypes(TypeToken.this);
                this.classes = FluentIterable.from(var1_1).filter(TypeFilter.IGNORE_TYPE_VARIABLE_OR_WILDCARD).toSet();
                return this.classes;
            }
            return var1_1;
        }

        @Override
        public final TypeSet classes() {
            return this;
        }

        @Override
        public final Set<Class<? super T>> rawTypes() {
            ImmutableList<Class<?>> immutableList = TypeCollector.FOR_RAW_TYPE.classesOnly().collectTypes(TypeToken.this.getRawTypes());
            return ImmutableSet.copyOf(immutableList);
        }

        @Override
        public final TypeSet interfaces() {
            throw new UnsupportedOperationException("classes().interfaces() not supported.");
        }

        private Object readResolve() {
            return TypeToken.this.getTypes().classes();
        }
    }

    private final class InterfaceSet
    extends TypeSet {
        private final transient TypeSet allTypes;
        private transient ImmutableSet<TypeToken<? super T>> interfaces;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        InterfaceSet(TypeSet allTypes) {
            void var2_2;
            super(TypeToken.this);
            this.allTypes = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final Set<TypeToken<? super T>> delegate() {
            void var1_1;
            ImmutableSet result = this.interfaces;
            if (result == null) {
                this.interfaces = FluentIterable.from(this.allTypes).filter(TypeFilter.INTERFACE_ONLY).toSet();
                return this.interfaces;
            }
            return var1_1;
        }

        @Override
        public final TypeSet interfaces() {
            return this;
        }

        @Override
        public final Set<Class<? super T>> rawTypes() {
            ImmutableList<Class<?>> immutableList = TypeCollector.FOR_RAW_TYPE.collectTypes(TypeToken.this.getRawTypes());
            return FluentIterable.from(immutableList).filter(Class::isInterface).toSet();
        }

        @Override
        public final TypeSet classes() {
            throw new UnsupportedOperationException("interfaces().classes() not supported.");
        }

        private Object readResolve() {
            return TypeToken.this.getTypes().interfaces();
        }
    }

    public class TypeSet
    extends ForwardingSet<TypeToken<? super T>>
    implements Serializable {
        private transient ImmutableSet<TypeToken<? super T>> types;
        private static final long serialVersionUID = 0L;
        final /* synthetic */ TypeToken this$0;

        /*
         * WARNING - void declaration
         */
        TypeSet(TypeToken this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        public TypeSet interfaces() {
            return this.this$0.new InterfaceSet(this);
        }

        public TypeSet classes() {
            return this.this$0.new ClassSet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected Set<TypeToken<? super T>> delegate() {
            void var1_1;
            ImmutableSet filteredTypes = this.types;
            if (filteredTypes == null) {
                ImmutableList<TypeToken> collectedTypes = TypeCollector.FOR_GENERIC_TYPE.collectTypes(this.this$0);
                this.types = FluentIterable.from(var1_1).filter(TypeFilter.IGNORE_TYPE_VARIABLE_OR_WILDCARD).toSet();
                return this.types;
            }
            return var1_1;
        }

        public Set<Class<? super T>> rawTypes() {
            ImmutableList<Class<?>> immutableList = TypeCollector.FOR_RAW_TYPE.collectTypes(this.this$0.getRawTypes());
            return ImmutableSet.copyOf(immutableList);
        }
    }
}

