/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.ElementTypesAreNonnullByDefault;
import com.google.common.reflect.TypeVisitor;
import com.google.common.reflect.Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@ElementTypesAreNonnullByDefault
public final class TypeResolver {
    private final TypeTable typeTable;

    public TypeResolver() {
        this.typeTable = new TypeTable();
    }

    /*
     * WARNING - void declaration
     */
    private TypeResolver(TypeTable typeTable) {
        void var1_1;
        this.typeTable = var1_1;
    }

    static TypeResolver covariantly(Type contextType) {
        Type type;
        return new TypeResolver().where(TypeMappingIntrospector.getTypeMappings(type));
    }

    static TypeResolver invariantly(Type contextType) {
        Type type;
        Type invariantContext = WildcardCapturer.INSTANCE.capture(contextType);
        return new TypeResolver().where(TypeMappingIntrospector.getTypeMappings(type));
    }

    /*
     * WARNING - void declaration
     */
    public final TypeResolver where(Type formal, Type actual) {
        void var3_3;
        void var2_2;
        void var1_1;
        HashMap<TypeVariableKey, Type> mappings = Maps.newHashMap();
        TypeResolver.populateTypeMappings(mappings, (Type)Preconditions.checkNotNull(var1_1), (Type)Preconditions.checkNotNull(var2_2));
        return this.where((Map<TypeVariableKey, ? extends Type>)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    final TypeResolver where(Map<TypeVariableKey, ? extends Type> mappings) {
        void var1_1;
        return new TypeResolver(this.typeTable.where((Map<TypeVariableKey, ? extends Type>)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static void populateTypeMappings(Map<TypeVariableKey, Type> mappings, Type from, Type to) {
        void var1_1;
        void var2_2;
        Map<TypeVariableKey, Type> map;
        if (from.equals(to)) {
            return;
        }
        new TypeVisitor((Type)var2_2){
            final /* synthetic */ Type val$to;
            {
                this.val$to = type;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void visitTypeVariable(TypeVariable<?> typeVariable) {
                void var1_1;
                map.put(new TypeVariableKey((TypeVariable<?>)var1_1), this.val$to);
            }

            @Override
            void visitWildcardType(WildcardType fromWildcardType) {
                int i;
                if (!(this.val$to instanceof WildcardType)) {
                    return;
                }
                WildcardType toWildcardType = (WildcardType)this.val$to;
                Type[] fromUpperBounds = fromWildcardType.getUpperBounds();
                Type[] toUpperBounds = toWildcardType.getUpperBounds();
                Type[] fromLowerBounds = fromWildcardType.getLowerBounds();
                Type[] toLowerBounds = toWildcardType.getLowerBounds();
                Preconditions.checkArgument(fromUpperBounds.length == toUpperBounds.length && fromLowerBounds.length == toLowerBounds.length, "Incompatible type: %s vs. %s", (Object)fromWildcardType, (Object)this.val$to);
                for (i = 0; i < fromUpperBounds.length; ++i) {
                    TypeResolver.access$000(map, fromUpperBounds[i], toUpperBounds[i]);
                }
                for (i = 0; i < fromLowerBounds.length; ++i) {
                    TypeResolver.access$000(map, fromLowerBounds[i], toLowerBounds[i]);
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void visitParameterizedType(ParameterizedType fromParameterizedType) {
                void var2_3;
                if (this.val$to instanceof WildcardType) {
                    return;
                }
                ParameterizedType toParameterizedType = (ParameterizedType)TypeResolver.access$100(ParameterizedType.class, this.val$to);
                if (fromParameterizedType.getOwnerType() != null && toParameterizedType.getOwnerType() != null) {
                    TypeResolver.access$000(map, fromParameterizedType.getOwnerType(), toParameterizedType.getOwnerType());
                }
                Preconditions.checkArgument(fromParameterizedType.getRawType().equals(toParameterizedType.getRawType()), "Inconsistent raw type: %s vs. %s", (Object)fromParameterizedType, (Object)this.val$to);
                Type[] fromArgs = fromParameterizedType.getActualTypeArguments();
                Type[] toArgs = toParameterizedType.getActualTypeArguments();
                Preconditions.checkArgument(fromArgs.length == toArgs.length, "%s not compatible with %s", (Object)fromParameterizedType, (Object)var2_3);
                for (int i = 0; i < fromArgs.length; ++i) {
                    TypeResolver.access$000(map, fromArgs[i], toArgs[i]);
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            void visitGenericArrayType(GenericArrayType fromArrayType) {
                void var2_2;
                void var1_1;
                if (this.val$to instanceof WildcardType) {
                    return;
                }
                Type componentType = Types.getComponentType(this.val$to);
                Preconditions.checkArgument(componentType != null, "%s is not an array type.", (Object)this.val$to);
                TypeResolver.access$000(map, var1_1.getGenericComponentType(), (Type)var2_2);
            }

            @Override
            void visitClass(Class<?> fromClass) {
                String string;
                if (this.val$to instanceof WildcardType) {
                    return;
                }
                string = String.valueOf(string);
                String string2 = String.valueOf(this.val$to);
                throw new IllegalArgumentException(new StringBuilder(25 + String.valueOf(string).length() + String.valueOf(string2).length()).append("No type mapping from ").append(string).append(" to ").append(string2).toString());
            }
        }.visit(new Type[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public final Type resolveType(Type type) {
        void var1_1;
        Preconditions.checkNotNull(type);
        if (type instanceof TypeVariable) {
            return this.typeTable.resolve((TypeVariable)type);
        }
        if (type instanceof ParameterizedType) {
            return this.resolveParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.resolveGenericArrayType((GenericArrayType)type);
        }
        if (type instanceof WildcardType) {
            return this.resolveWildcardType((WildcardType)type);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final Type[] resolveTypesInPlace(Type[] types) {
        void var1_1;
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.resolveType(types[i]);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Type[] resolveTypes(Type[] types) {
        void var2_2;
        Type[] result = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = this.resolveType(types[i]);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private WildcardType resolveWildcardType(WildcardType type) {
        void var1_1;
        void var2_2;
        Type[] lowerBounds = type.getLowerBounds();
        Type[] upperBounds = type.getUpperBounds();
        return new Types.WildcardTypeImpl(this.resolveTypes((Type[])var2_2), this.resolveTypes((Type[])var1_1));
    }

    private Type resolveGenericArrayType(GenericArrayType type) {
        Type type2;
        Type componentType = type.getGenericComponentType();
        type2 = this.resolveType(type2);
        return Types.newArrayType(type2);
    }

    /*
     * WARNING - void declaration
     */
    private ParameterizedType resolveParameterizedType(ParameterizedType type) {
        void var1_1;
        void var3_3;
        void var2_2;
        Type owner = type.getOwnerType();
        Type resolvedOwner = owner == null ? null : this.resolveType(owner);
        Type resolvedRawType = this.resolveType(type.getRawType());
        Type[] args = type.getActualTypeArguments();
        Type[] resolvedArgs = this.resolveTypes(args);
        return Types.newParameterizedTypeWithOwner((Type)var2_2, (Class)var3_3, (Type[])var1_1);
    }

    private static <T> T expectArgument(Class<T> type, Object arg) {
        try {
            return type.cast(arg);
        }
        catch (ClassCastException classCastException) {
            String string;
            String string2;
            string2 = String.valueOf(string2);
            string = ((Class)((Object)string)).getSimpleName();
            throw new IllegalArgumentException(new StringBuilder(10 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(" is not a ").append(string).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Map x0, Type x1, Type x2) {
        void var2_2;
        void var1_1;
        TypeResolver.populateTypeMappings(x0, (Type)var1_1, (Type)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$100(Class x0, Object x1) {
        void var1_1;
        return TypeResolver.expectArgument(x0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Type[] access$300(TypeResolver x0, Type[] x1) {
        void var1_1;
        return x0.resolveTypes((Type[])var1_1);
    }

    static final class TypeVariableKey {
        private final TypeVariable<?> var;

        /*
         * WARNING - void declaration
         */
        TypeVariableKey(TypeVariable<?> var) {
            void var1_1;
            this.var = (TypeVariable)Preconditions.checkNotNull(var1_1);
        }

        public final int hashCode() {
            return Objects.hashCode(this.var.getGenericDeclaration(), this.var.getName());
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            if (obj instanceof TypeVariableKey) {
                void var1_1;
                TypeVariableKey that = (TypeVariableKey)obj;
                return this.equalsTypeVariable(var1_1.var);
            }
            return false;
        }

        public final String toString() {
            return this.var.toString();
        }

        static TypeVariableKey forLookup(Type t) {
            if (t instanceof TypeVariable) {
                Type type;
                return new TypeVariableKey((TypeVariable)type);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        final boolean equalsType(Type type) {
            if (type instanceof TypeVariable) {
                void var1_1;
                return this.equalsTypeVariable((TypeVariable)var1_1);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private boolean equalsTypeVariable(TypeVariable<?> that) {
            void var1_1;
            return this.var.getGenericDeclaration().equals(that.getGenericDeclaration()) && this.var.getName().equals(var1_1.getName());
        }
    }

    private static class WildcardCapturer {
        static final WildcardCapturer INSTANCE = new WildcardCapturer();
        private final AtomicInteger id;

        private WildcardCapturer() {
            this(new AtomicInteger());
        }

        /*
         * WARNING - void declaration
         */
        private WildcardCapturer(AtomicInteger id) {
            void var1_1;
            this.id = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final Type capture(Type type) {
            void var1_1;
            Preconditions.checkNotNull(type);
            if (type instanceof Class) {
                return type;
            }
            if (type instanceof TypeVariable) {
                return type;
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type;
                return Types.newArrayType(this.notForTypeVariable().capture(arrayType.getGenericComponentType()));
            }
            if (type instanceof ParameterizedType) {
                void var3_5;
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class rawType = (Class)parameterizedType.getRawType();
                TypeVariable<Class<T>>[] typeVars = rawType.getTypeParameters();
                Type[] typeArgs = parameterizedType.getActualTypeArguments();
                for (int i = 0; i < typeArgs.length; ++i) {
                    typeArgs[i] = this.forTypeVariable(typeVars[i]).capture(typeArgs[i]);
                }
                return Types.newParameterizedTypeWithOwner(this.notForTypeVariable().captureNullable(parameterizedType.getOwnerType()), var3_5, typeArgs);
            }
            if (var1_1 instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)var1_1;
                Type[] typeArray = wildcardType.getLowerBounds();
                if (typeArray.length == 0) {
                    void var2_4;
                    return this.captureAsTypeVariable(var2_4.getUpperBounds());
                }
                return var1_1;
            }
            throw new AssertionError((Object)"must have been one of the known types");
        }

        /*
         * WARNING - void declaration
         */
        TypeVariable<?> captureAsTypeVariable(Type[] upperBounds) {
            void var1_1;
            void var2_3;
            int n = this.id.incrementAndGet();
            String string = Joiner.on('&').join(upperBounds);
            String name = new StringBuilder(33 + String.valueOf(string).length()).append("capture#").append(n).append("-of ? extends ").append(string).toString();
            return Types.newArtificialTypeVariable(WildcardCapturer.class, (String)var2_3, (Type[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private WildcardCapturer forTypeVariable(TypeVariable<?> typeParam) {
            void var1_1;
            WildcardCapturer wildcardCapturer = this;
            return new WildcardCapturer(wildcardCapturer, wildcardCapturer.id, (TypeVariable)var1_1){
                final /* synthetic */ TypeVariable val$typeParam;
                {
                    void var2_2;
                    this.val$typeParam = typeVariable;
                    super((AtomicInteger)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                TypeVariable<?> captureAsTypeVariable(Type[] upperBounds) {
                    void var1_1;
                    LinkedHashSet<Type> combined = new LinkedHashSet<Type>(Arrays.asList(upperBounds));
                    combined.addAll(Arrays.asList(this.val$typeParam.getBounds()));
                    if (combined.size() > 1) {
                        combined.remove(Object.class);
                    }
                    return super.captureAsTypeVariable(var1_1.toArray(new Type[0]));
                }
            };
        }

        private WildcardCapturer notForTypeVariable() {
            return new WildcardCapturer(this.id);
        }

        /*
         * WARNING - void declaration
         */
        private Type captureNullable(Type type) {
            void var1_1;
            if (type == null) {
                return null;
            }
            return this.capture((Type)var1_1);
        }
    }

    private static final class TypeMappingIntrospector
    extends TypeVisitor {
        private final Map<TypeVariableKey, Type> mappings = Maps.newHashMap();

        private TypeMappingIntrospector() {
        }

        /*
         * WARNING - void declaration
         */
        static ImmutableMap<TypeVariableKey, Type> getTypeMappings(Type contextType) {
            void var1_1;
            Type type;
            Preconditions.checkNotNull(contextType);
            TypeMappingIntrospector introspector = new TypeMappingIntrospector();
            introspector.visit(type);
            return ImmutableMap.copyOf(var1_1.mappings);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void visitClass(Class<?> clazz) {
            void var1_1;
            this.visit(clazz.getGenericSuperclass());
            this.visit(var1_1.getGenericInterfaces());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void visitParameterizedType(ParameterizedType parameterizedType) {
            void var1_1;
            void var2_2;
            Type[] typeArgs;
            Class rawClass = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] vars = rawClass.getTypeParameters();
            Preconditions.checkState(vars.length == (typeArgs = parameterizedType.getActualTypeArguments()).length);
            for (int i = 0; i < vars.length; ++i) {
                this.map(new TypeVariableKey(vars[i]), typeArgs[i]);
            }
            this.visit(new Type[]{var2_2});
            this.visit(var1_1.getOwnerType());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void visitTypeVariable(TypeVariable<?> t) {
            void var1_1;
            this.visit(var1_1.getBounds());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final void visitWildcardType(WildcardType t) {
            void var1_1;
            this.visit(var1_1.getUpperBounds());
        }

        /*
         * WARNING - void declaration
         */
        private void map(TypeVariableKey var, Type arg) {
            void var2_2;
            void var1_1;
            if (this.mappings.containsKey(var)) {
                return;
            }
            Type t = arg;
            while (t != null) {
                if (var.equalsType(t)) {
                    Type x = arg;
                    while (x != null) {
                        x = this.mappings.remove(TypeVariableKey.forLookup(x));
                    }
                    return;
                }
                t = this.mappings.get(TypeVariableKey.forLookup(t));
            }
            this.mappings.put((TypeVariableKey)var1_1, (Type)var2_2);
        }
    }

    private static class TypeTable {
        private final ImmutableMap<TypeVariableKey, Type> map;

        TypeTable() {
            this.map = ImmutableMap.of();
        }

        /*
         * WARNING - void declaration
         */
        private TypeTable(ImmutableMap<TypeVariableKey, Type> map) {
            void var1_1;
            this.map = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final TypeTable where(Map<TypeVariableKey, ? extends Type> mappings) {
            void var2_2;
            Iterator iterator;
            ImmutableMap.Builder<TypeVariableKey, Object> builder = ImmutableMap.builder();
            builder.putAll(this.map);
            for (Map.Entry mapping : iterator.entrySet()) {
                void var3_3;
                Type type;
                TypeVariableKey variable = (TypeVariableKey)mapping.getKey();
                Preconditions.checkArgument(!variable.equalsType(type = (Type)mapping.getValue()), "Type variable %s bound to itself", (Object)variable);
                builder.put(variable, var3_3);
            }
            return new TypeTable(var2_2.buildOrThrow());
        }

        /*
         * WARNING - void declaration
         */
        final Type resolve(final TypeVariable<?> var) {
            void var2_2;
            void var1_1;
            final TypeTable unguarded = this;
            TypeTable guarded = new TypeTable(this){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Type resolveInternal(TypeVariable<?> intermediateVar, TypeTable forDependent) {
                    void var2_2;
                    void var1_1;
                    if (intermediateVar.getGenericDeclaration().equals(var.getGenericDeclaration())) {
                        return intermediateVar;
                    }
                    return unguarded.resolveInternal((TypeVariable<?>)var1_1, (TypeTable)var2_2);
                }
            };
            return this.resolveInternal((TypeVariable<?>)var1_1, (TypeTable)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        Type resolveInternal(TypeVariable<?> var, TypeTable forDependants) {
            void var2_2;
            void var3_3;
            Type type = this.map.get(new TypeVariableKey(var));
            if (type == null) {
                void var1_1;
                Type[] bounds = var.getBounds();
                if (bounds.length == 0) {
                    return var;
                }
                Object[] resolvedBounds = TypeResolver.access$300(new TypeResolver(forDependants), bounds);
                if (Types.NativeTypeVariableEquals.NATIVE_TYPE_VARIABLE_ONLY && Arrays.equals((Object[])var3_3, resolvedBounds)) {
                    return var;
                }
                return Types.newArtificialTypeVariable(var.getGenericDeclaration(), var1_1.getName(), (Type[])var2_2);
            }
            return new TypeResolver((TypeTable)var2_2).resolveType((Type)var3_3);
        }
    }
}

