/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.ElementTypesAreNonnullByDefault;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;

@ElementTypesAreNonnullByDefault
@Beta
public final class Parameter
implements AnnotatedElement {
    private final Invokable<?, ?> declaration;
    private final int position;
    private final TypeToken<?> type;
    private final ImmutableList<Annotation> annotations;
    private final AnnotatedType annotatedType;

    /*
     * WARNING - void declaration
     */
    Parameter(Invokable<?, ?> declaration, int position, TypeToken<?> type, Annotation[] annotations, AnnotatedType annotatedType) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.declaration = var1_1;
        this.position = var2_2;
        this.type = var3_3;
        this.annotations = ImmutableList.copyOf(annotations);
        this.annotatedType = annotatedType;
    }

    public final TypeToken<?> getType() {
        return this.type;
    }

    public final Invokable<?, ?> getDeclaringInvokable() {
        return this.declaration;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        void var1_1;
        return this.getAnnotation((Class)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public final <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        Preconditions.checkNotNull(annotationType);
        for (Annotation annotation : this.annotations) {
            void var3_3;
            if (!annotationType.isInstance(annotation)) continue;
            return (A)((Annotation)annotationType.cast(var3_3));
        }
        return null;
    }

    @Override
    public final Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    /*
     * WARNING - void declaration
     */
    public final <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        void var1_1;
        return this.getDeclaredAnnotationsByType((Class)var1_1);
    }

    @Override
    public final Annotation[] getDeclaredAnnotations() {
        return this.annotations.toArray(new Annotation[0]);
    }

    /*
     * WARNING - void declaration
     */
    public final <A extends Annotation> A getDeclaredAnnotation(Class<A> annotationType) {
        void var1_1;
        Preconditions.checkNotNull(annotationType);
        return (A)((Annotation)FluentIterable.from(this.annotations).filter(var1_1).first().orNull());
    }

    public final <A extends Annotation> A[] getDeclaredAnnotationsByType(Class<A> annotationType) {
        Annotation[] annotationArray;
        Annotation[] annotationArray2 = (Annotation[])FluentIterable.from(this.annotations).filter(annotationType).toArray((Class<A>)annotationArray);
        annotationArray = annotationArray2;
        annotationArray = annotationArray2;
        return annotationArray2;
    }

    public final AnnotatedType getAnnotatedType() {
        return this.annotatedType;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        if (obj instanceof Parameter) {
            void var1_1;
            Parameter that = (Parameter)obj;
            return this.position == that.position && this.declaration.equals(var1_1.declaration);
        }
        return false;
    }

    public final int hashCode() {
        return this.position;
    }

    public final String toString() {
        String string = String.valueOf(this.type);
        int n = this.position;
        return new StringBuilder(15 + String.valueOf(string).length()).append(string).append(" arg").append(n).toString();
    }
}

