/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.reflect.ElementTypesAreNonnullByDefault;
import com.google.common.reflect.TypeToInstanceMap;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
public final class MutableTypeToInstanceMap<B>
extends ForwardingMap<TypeToken<? extends B>, B>
implements TypeToInstanceMap<B> {
    private final Map<TypeToken<? extends B>, B> backingMap = Maps.newHashMap();

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T extends B> T getInstance(Class<T> type) {
        void var1_1;
        return this.trustedGet(TypeToken.of(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T extends B> T getInstance(TypeToken<T> type) {
        void var1_1;
        return this.trustedGet(var1_1.rejectTypeVariables());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T extends B> T putInstance(Class<T> type, T value) {
        void var2_2;
        void var1_1;
        return this.trustedPut(TypeToken.of(var1_1), var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T extends B> T putInstance(TypeToken<T> type, T value) {
        void var2_2;
        void var1_1;
        return this.trustedPut(var1_1.rejectTypeVariables(), var2_2);
    }

    @Override
    @Deprecated
    public final B put(TypeToken<? extends B> key, B value) {
        throw new UnsupportedOperationException("Please use putInstance() instead.");
    }

    @Override
    @Deprecated
    public final void putAll(Map<? extends TypeToken<? extends B>, ? extends B> map) {
        throw new UnsupportedOperationException("Please use putInstance() instead.");
    }

    @Override
    public final Set<Map.Entry<TypeToken<? extends B>, B>> entrySet() {
        return UnmodifiableEntry.transformEntries(super.entrySet());
    }

    @Override
    protected final Map<TypeToken<? extends B>, B> delegate() {
        return this.backingMap;
    }

    /*
     * WARNING - void declaration
     */
    private <T extends B> T trustedPut(TypeToken<T> type, T value) {
        void var2_2;
        void var1_1;
        return this.backingMap.put((TypeToken<B>)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private <T extends B> T trustedGet(TypeToken<T> type) {
        void var1_1;
        return (T)this.backingMap.get(var1_1);
    }

    private static final class UnmodifiableEntry<K, V>
    extends ForwardingMapEntry<K, V> {
        private final Map.Entry<K, V> delegate;

        static <K, V> Set<Map.Entry<K, V>> transformEntries(Set<Map.Entry<K, V>> entries) {
            Set<Map.Entry<K, V>> set;
            return new ForwardingSet<Map.Entry<K, V>>(){

                @Override
                protected Set<Map.Entry<K, V>> delegate() {
                    return set;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return UnmodifiableEntry.transformEntries(super.iterator());
                }

                @Override
                public Object[] toArray() {
                    Object[] objectArray = this.standardToArray();
                    return objectArray;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public <T> T[] toArray(T[] array) {
                    void var1_1;
                    return this.standardToArray((T[])var1_1);
                }
            };
        }

        private static <K, V> Iterator<Map.Entry<K, V>> transformEntries(Iterator<Map.Entry<K, V>> entries) {
            return Iterators.transform(entries, UnmodifiableEntry::new);
        }

        /*
         * WARNING - void declaration
         */
        private UnmodifiableEntry(Map.Entry<K, V> delegate) {
            void var1_1;
            this.delegate = (Map.Entry)Preconditions.checkNotNull(var1_1);
        }

        @Override
        protected final Map.Entry<K, V> delegate() {
            return this.delegate;
        }

        @Override
        public final V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

