/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.ElementTypesAreNonnullByDefault;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.TypeToken;
import com.google.common.reflect.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;

@ElementTypesAreNonnullByDefault
@Beta
public abstract class Invokable<T, R>
implements AnnotatedElement,
Member {
    private final AccessibleObject accessibleObject;
    private final Member member;

    /*
     * WARNING - void declaration
     */
    <M extends AccessibleObject> Invokable(M member) {
        void var1_1;
        Preconditions.checkNotNull(member);
        this.accessibleObject = member;
        this.member = (Member)var1_1;
    }

    public static Invokable<?, Object> from(Method method) {
        Method method2;
        return new MethodInvokable(method2);
    }

    public static <T> Invokable<T, T> from(Constructor<T> constructor) {
        Constructor<T> constructor2;
        return new ConstructorInvokable(constructor2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        void var1_1;
        return this.accessibleObject.isAnnotationPresent((Class<? extends Annotation>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        void var1_1;
        return (A)this.accessibleObject.getAnnotation(var1_1);
    }

    @Override
    public final Annotation[] getAnnotations() {
        return this.accessibleObject.getAnnotations();
    }

    @Override
    public final Annotation[] getDeclaredAnnotations() {
        return this.accessibleObject.getDeclaredAnnotations();
    }

    public abstract TypeVariable<?>[] getTypeParameters();

    /*
     * WARNING - void declaration
     */
    public final void setAccessible(boolean flag) {
        void var1_1;
        this.accessibleObject.setAccessible((boolean)var1_1);
    }

    public final boolean trySetAccessible() {
        try {
            this.accessibleObject.setAccessible(true);
            return true;
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public final boolean isAccessible() {
        return this.accessibleObject.isAccessible();
    }

    @Override
    public final String getName() {
        return this.member.getName();
    }

    @Override
    public final int getModifiers() {
        return this.member.getModifiers();
    }

    @Override
    public final boolean isSynthetic() {
        return this.member.isSynthetic();
    }

    public final boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public final boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public final boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isPublic() && !this.isProtected();
    }

    public final boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public final boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public final boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public final boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    public final boolean isNative() {
        return Modifier.isNative(this.getModifiers());
    }

    public final boolean isSynchronized() {
        return Modifier.isSynchronized(this.getModifiers());
    }

    final boolean isVolatile() {
        return Modifier.isVolatile(this.getModifiers());
    }

    final boolean isTransient() {
        return Modifier.isTransient(this.getModifiers());
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        if (obj instanceof Invokable) {
            void var1_1;
            Invokable that = (Invokable)obj;
            return this.getOwnerType().equals(that.getOwnerType()) && this.member.equals(var1_1.member);
        }
        return false;
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public String toString() {
        return this.member.toString();
    }

    public abstract boolean isOverridable();

    public abstract boolean isVarArgs();

    /*
     * WARNING - void declaration
     */
    public final R invoke(T receiver, Object ... args) throws InvocationTargetException, IllegalAccessException {
        void var2_2;
        void var1_1;
        return (R)this.invokeInternal(var1_1, (Object[])Preconditions.checkNotNull(var2_2));
    }

    public final TypeToken<? extends R> getReturnType() {
        return TypeToken.of(this.getGenericReturnType());
    }

    public final ImmutableList<Parameter> getParameters() {
        Type[] parameterTypes = this.getGenericParameterTypes();
        Annotation[][] annotations = this.getParameterAnnotations();
        AnnotatedType[] annotatedTypes = this.getAnnotatedParameterTypes();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < parameterTypes.length; ++i) {
            builder.add(new Parameter(this, i, TypeToken.of(parameterTypes[i]), annotations[i], annotatedTypes[i]));
        }
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableList<TypeToken<? extends Throwable>> getExceptionTypes() {
        void var1_1;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Type type : this.getGenericExceptionTypes()) {
            TypeToken<?> exceptionType = TypeToken.of(type);
            builder.add(exceptionType);
        }
        return var1_1.build();
    }

    /*
     * WARNING - void declaration
     */
    public final <R1 extends R> Invokable<T, R1> returning(Class<R1> returnType) {
        void var1_1;
        return this.returning(TypeToken.of(var1_1));
    }

    public final <R1 extends R> Invokable<T, R1> returning(TypeToken<R1> returnType) {
        if (!returnType.isSupertypeOf(this.getReturnType())) {
            String string;
            String string2 = String.valueOf(this.getReturnType());
            string = String.valueOf(string);
            throw new IllegalArgumentException(new StringBuilder(35 + String.valueOf(string2).length() + String.valueOf(string).length()).append("Invokable is known to return ").append(string2).append(", not ").append(string).toString());
        }
        Invokable invokable = this;
        return invokable;
    }

    public final Class<? super T> getDeclaringClass() {
        return this.member.getDeclaringClass();
    }

    public TypeToken<T> getOwnerType() {
        return TypeToken.of(this.getDeclaringClass());
    }

    abstract Object invokeInternal(Object var1, Object[] var2) throws InvocationTargetException, IllegalAccessException;

    abstract Type[] getGenericParameterTypes();

    abstract AnnotatedType[] getAnnotatedParameterTypes();

    abstract Type[] getGenericExceptionTypes();

    abstract Annotation[][] getParameterAnnotations();

    abstract Type getGenericReturnType();

    public abstract AnnotatedType getAnnotatedReturnType();

    static class ConstructorInvokable<T>
    extends Invokable<T, T> {
        final Constructor<?> constructor;

        /*
         * WARNING - void declaration
         */
        ConstructorInvokable(Constructor<?> constructor) {
            super(constructor);
            void var1_1;
            this.constructor = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Object invokeInternal(Object receiver, Object[] args) throws InvocationTargetException, IllegalAccessException {
            String string;
            try {
                return this.constructor.newInstance((Object[])string);
            }
            catch (InstantiationException e) {
                void var1_2;
                string = String.valueOf(this.constructor);
                throw new RuntimeException(new StringBuilder(8 + String.valueOf(string).length()).append(string).append(" failed.").toString(), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Type getGenericReturnType() {
            void var1_1;
            Class declaringClass = this.getDeclaringClass();
            TypeVariable<Class<T>>[] typeParams = declaringClass.getTypeParameters();
            if (typeParams.length > 0) {
                void var2_2;
                return Types.newParameterizedType(declaringClass, (Type[])var2_2);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Type[] getGenericParameterTypes() {
            void var1_1;
            void var2_2;
            Class<?>[] rawParamTypes;
            Type[] types = this.constructor.getGenericParameterTypes();
            if (types.length > 0 && this.mayNeedHiddenThis() && types.length == (rawParamTypes = this.constructor.getParameterTypes()).length && var2_2[0] == this.getDeclaringClass().getEnclosingClass()) {
                return Arrays.copyOfRange(types, 1, types.length);
            }
            return var1_1;
        }

        @Override
        AnnotatedType[] getAnnotatedParameterTypes() {
            return this.constructor.getAnnotatedParameterTypes();
        }

        @Override
        public AnnotatedType getAnnotatedReturnType() {
            return this.constructor.getAnnotatedReturnType();
        }

        @Override
        Type[] getGenericExceptionTypes() {
            return this.constructor.getGenericExceptionTypes();
        }

        @Override
        final Annotation[][] getParameterAnnotations() {
            return this.constructor.getParameterAnnotations();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final TypeVariable<?>[] getTypeParameters() {
            void var3_3;
            void var2_2;
            void var1_1;
            TypeVariable<Class<T>>[] declaredByClass = this.getDeclaringClass().getTypeParameters();
            TypeVariable<Constructor<?>>[] declaredByConstructor = this.constructor.getTypeParameters();
            TypeVariable[] result = new TypeVariable[declaredByClass.length + declaredByConstructor.length];
            System.arraycopy(declaredByClass, 0, result, 0, declaredByClass.length);
            System.arraycopy(declaredByConstructor, 0, result, ((void)var1_1).length, ((void)var2_2).length);
            return var3_3;
        }

        @Override
        public final boolean isOverridable() {
            return false;
        }

        @Override
        public final boolean isVarArgs() {
            return this.constructor.isVarArgs();
        }

        /*
         * WARNING - void declaration
         */
        private boolean mayNeedHiddenThis() {
            void var1_1;
            Class<?> declaringClass = this.constructor.getDeclaringClass();
            if (declaringClass.getEnclosingConstructor() != null) {
                return true;
            }
            Method enclosingMethod = declaringClass.getEnclosingMethod();
            if (enclosingMethod != null) {
                void var2_2;
                return !Modifier.isStatic(var2_2.getModifiers());
            }
            return declaringClass.getEnclosingClass() != null && !Modifier.isStatic(var1_1.getModifiers());
        }
    }

    static class MethodInvokable<T>
    extends Invokable<T, Object> {
        final Method method;

        /*
         * WARNING - void declaration
         */
        MethodInvokable(Method method) {
            super(method);
            void var1_1;
            this.method = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Object invokeInternal(Object receiver, Object[] args) throws InvocationTargetException, IllegalAccessException {
            void var2_2;
            void var1_1;
            return this.method.invoke((Object)var1_1, (Object[])var2_2);
        }

        @Override
        Type getGenericReturnType() {
            return this.method.getGenericReturnType();
        }

        @Override
        Type[] getGenericParameterTypes() {
            return this.method.getGenericParameterTypes();
        }

        @Override
        AnnotatedType[] getAnnotatedParameterTypes() {
            return this.method.getAnnotatedParameterTypes();
        }

        @Override
        public AnnotatedType getAnnotatedReturnType() {
            return this.method.getAnnotatedReturnType();
        }

        @Override
        Type[] getGenericExceptionTypes() {
            return this.method.getGenericExceptionTypes();
        }

        @Override
        final Annotation[][] getParameterAnnotations() {
            return this.method.getParameterAnnotations();
        }

        @Override
        public final TypeVariable<?>[] getTypeParameters() {
            return this.method.getTypeParameters();
        }

        @Override
        public final boolean isOverridable() {
            return !this.isFinal() && !this.isPrivate() && !this.isStatic() && !Modifier.isFinal(this.getDeclaringClass().getModifiers());
        }

        @Override
        public final boolean isVarArgs() {
            return this.method.isVarArgs();
        }
    }
}

