/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.Resources;
import com.google.common.reflect.ElementTypesAreNonnullByDefault;
import com.google.common.reflect.Reflection;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

@ElementTypesAreNonnullByDefault
public final class ClassPath {
    private static final Logger logger = Logger.getLogger(ClassPath.class.getName());
    private static final Splitter CLASS_PATH_ATTRIBUTE_SEPARATOR = Splitter.on(" ").omitEmptyStrings();
    private static final String CLASS_FILE_NAME_EXTENSION = ".class";
    private final ImmutableSet<ResourceInfo> resources;

    /*
     * WARNING - void declaration
     */
    private ClassPath(ImmutableSet<ResourceInfo> resources) {
        void var1_1;
        this.resources = var1_1;
    }

    public static ClassPath from(ClassLoader classloader) throws IOException {
        Iterator iterator;
        ImmutableSet<LocationInfo> locations = ClassPath.locationsFrom(classloader);
        HashSet<File> scanned = new HashSet<File>();
        Iterator iterator2 = ((ImmutableCollection)locations).iterator();
        while (iterator2.hasNext()) {
            LocationInfo location = (LocationInfo)iterator2.next();
            scanned.add(((LocationInfo)((Object)iterator)).file());
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        iterator = ((ImmutableCollection)locations).iterator();
        while (iterator.hasNext()) {
            ImmutableSet<LocationInfo> immutableSet;
            ImmutableSet<LocationInfo> location = (LocationInfo)iterator.next();
            builder.addAll(((LocationInfo)((Object)immutableSet)).scanResources(scanned));
        }
        return new ClassPath((ImmutableSet<ResourceInfo>)((ImmutableSet.Builder)((Object)iterator2)).build());
    }

    public final ImmutableSet<ResourceInfo> getResources() {
        return this.resources;
    }

    public final ImmutableSet<ClassInfo> getAllClasses() {
        return FluentIterable.from(this.resources).filter(ClassInfo.class).toSet();
    }

    public final ImmutableSet<ClassInfo> getTopLevelClasses() {
        return FluentIterable.from(this.resources).filter(ClassInfo.class).filter(ClassInfo::isTopLevel).toSet();
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableSet<ClassInfo> getTopLevelClasses(String packageName) {
        void var2_2;
        Preconditions.checkNotNull(packageName);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ClassInfo classInfo : this.getTopLevelClasses()) {
            if (!classInfo.getPackageName().equals(packageName)) continue;
            builder.add(classInfo);
        }
        return var2_2.build();
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableSet<ClassInfo> getTopLevelClassesRecursive(String packageName) {
        void var2_2;
        Preconditions.checkNotNull(packageName);
        String packagePrefix = new StringBuilder(1 + String.valueOf(packageName).length()).append(packageName).append('.').toString();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ClassInfo classInfo : this.getTopLevelClasses()) {
            if (!classInfo.getName().startsWith(packagePrefix)) continue;
            builder.add(classInfo);
        }
        return var2_2.build();
    }

    /*
     * WARNING - void declaration
     */
    static ImmutableSet<LocationInfo> locationsFrom(ClassLoader classloader) {
        void var1_1;
        Object object;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Map.Entry entry : ClassPath.getClassPathEntries((ClassLoader)object).entrySet()) {
            void var2_2;
            builder.add(new LocationInfo((File)entry.getKey(), (ClassLoader)var2_2.getValue()));
        }
        return var1_1.build();
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static ImmutableSet<File> getClassPathFromManifest(File jarFile, Manifest manifest) {
        void var2_2;
        if (manifest == null) {
            return ImmutableSet.of();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        String classpathAttribute = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH.toString());
        if (classpathAttribute != null) {
            Iterator<String> iterator;
            for (String path : CLASS_PATH_ATTRIBUTE_SEPARATOR.split((CharSequence)((Object)iterator))) {
                URL url;
                try {
                    url = ClassPath.getClassPathEntry(jarFile, path);
                }
                catch (MalformedURLException malformedURLException) {
                    void var3_3;
                    String string = String.valueOf(var3_3);
                    logger.warning(string.length() != 0 ? "Invalid Class-Path entry: ".concat(string) : new String("Invalid Class-Path entry: "));
                    continue;
                }
                if (!url.getProtocol().equals("file")) continue;
                builder.add(ClassPath.toFile(url));
            }
        }
        return var2_2.build();
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static ImmutableMap<File, ClassLoader> getClassPathEntries(ClassLoader classloader) {
        void var1_1;
        LinkedHashMap<Object, ClassLoader> entries = Maps.newLinkedHashMap();
        ClassLoader parent = classloader.getParent();
        if (parent != null) {
            Iterator iterator;
            entries.putAll(ClassPath.getClassPathEntries((ClassLoader)((Object)iterator)));
        }
        for (URL url : ClassPath.getClassLoaderUrls(classloader)) {
            void var3_3;
            File file;
            if (!url.getProtocol().equals("file") || entries.containsKey(file = ClassPath.toFile(url))) continue;
            entries.put(var3_3, classloader);
        }
        return ImmutableMap.copyOf(var1_1);
    }

    private static ImmutableList<URL> getClassLoaderUrls(ClassLoader classloader) {
        ClassLoader classLoader;
        if (classloader instanceof URLClassLoader) {
            return ImmutableList.copyOf(((URLClassLoader)classloader).getURLs());
        }
        if (classLoader.equals(ClassLoader.getSystemClassLoader())) {
            return ClassPath.parseJavaClassPath();
        }
        return ImmutableList.of();
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static ImmutableList<URL> parseJavaClassPath() {
        void var0;
        ImmutableList.Builder urls = ImmutableList.builder();
        for (String entry : Splitter.on(StandardSystemProperty.PATH_SEPARATOR.value()).split(StandardSystemProperty.JAVA_CLASS_PATH.value())) {
            try {
                try {
                    urls.add(new File(entry).toURI().toURL());
                }
                catch (SecurityException securityException) {
                    urls.add(new URL("file", null, new File(entry).getAbsolutePath()));
                }
            }
            catch (MalformedURLException e) {
                void var3_3;
                void var2_2;
                String string = String.valueOf(var2_2);
                logger.log(Level.WARNING, string.length() != 0 ? "malformed classpath entry: ".concat(string) : new String("malformed classpath entry: "), (Throwable)var3_3);
            }
        }
        return var0.build();
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static URL getClassPathEntry(File jarFile, String path) throws MalformedURLException {
        void var1_1;
        File file;
        return new URL(file.toURI().toURL(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static String getClassName(String filename) {
        void var1_1;
        String string;
        int classNameEnd = filename.length() - 6;
        return string.substring(0, (int)var1_1).replace('/', '.');
    }

    @VisibleForTesting
    static File toFile(URL url) {
        Preconditions.checkArgument(url.getProtocol().equals("file"));
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            URL uRL;
            return new File(uRL.getPath());
        }
    }

    static final class LocationInfo {
        final File home;
        private final ClassLoader classloader;

        /*
         * WARNING - void declaration
         */
        LocationInfo(File home, ClassLoader classloader) {
            void var2_2;
            void var1_1;
            this.home = (File)Preconditions.checkNotNull(var1_1);
            this.classloader = (ClassLoader)Preconditions.checkNotNull(var2_2);
        }

        public final File file() {
            return this.home;
        }

        public final ImmutableSet<ResourceInfo> scanResources() throws IOException {
            return this.scanResources(new HashSet<File>());
        }

        /*
         * WARNING - void declaration
         */
        public final ImmutableSet<ResourceInfo> scanResources(Set<File> scannedFiles) throws IOException {
            void var2_2;
            void var1_1;
            ImmutableSet.Builder<ResourceInfo> builder = ImmutableSet.builder();
            scannedFiles.add(this.home);
            LocationInfo locationInfo = this;
            locationInfo.scan(locationInfo.home, (Set<File>)var1_1, builder);
            return var2_2.build();
        }

        /*
         * WARNING - void declaration
         */
        private void scan(File file, Set<File> scannedUris, ImmutableSet.Builder<ResourceInfo> builder) throws IOException {
            void var3_5;
            void var2_2;
            void var1_1;
            try {
                if (!((File)file).exists()) {
                    return;
                }
            }
            catch (SecurityException e) {
                void var2_3;
                file = String.valueOf(file);
                String string = String.valueOf(var2_3);
                logger.warning(new StringBuilder(16 + String.valueOf(file).length() + String.valueOf(string).length()).append("Cannot access ").append((String)file).append(": ").append(string).toString());
                return;
            }
            if (((File)file).isDirectory()) {
                this.scanDirectory((File)file, builder);
                return;
            }
            this.scanJar((File)var1_1, (Set<File>)var2_2, (ImmutableSet.Builder<ResourceInfo>)var3_5);
        }

        /*
         * WARNING - void declaration
         */
        private void scanJar(File file, Set<File> scannedUris, ImmutableSet.Builder<ResourceInfo> builder) throws IOException {
            JarFile jarFile;
            try {
                jarFile = new JarFile(file);
            }
            catch (IOException iOException) {
                return;
            }
            try {
                void var3_4;
                Iterator iterator;
                for (File path : ClassPath.getClassPathFromManifest((File)((Object)iterator), jarFile.getManifest())) {
                    if (!scannedUris.add(path.getCanonicalFile())) continue;
                    this.scan(path, scannedUris, builder);
                }
                this.scanJarFile(jarFile, (ImmutableSet.Builder<ResourceInfo>)var3_4);
            }
            catch (Throwable throwable) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                jarFile.close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        private void scanJarFile(JarFile file, ImmutableSet.Builder<ResourceInfo> builder) {
            Enumeration<JarEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                builder.add((Object)ResourceInfo.of(new File(file.getName()), entry.getName(), this.classloader));
            }
        }

        /*
         * WARNING - void declaration
         */
        private void scanDirectory(File directory, ImmutableSet.Builder<ResourceInfo> builder) throws IOException {
            void var2_2;
            void var3_3;
            void var1_1;
            HashSet<File> currentPath = new HashSet<File>();
            currentPath.add(directory.getCanonicalFile());
            this.scanDirectory((File)var1_1, "", (Set<File>)var3_3, (ImmutableSet.Builder<ResourceInfo>)var2_2);
        }

        private void scanDirectory(File directory, String packagePrefix, Set<File> currentPath, ImmutableSet.Builder<ResourceInfo> builder) throws IOException {
            Object object;
            File[] files = directory.listFiles();
            if (files == null) {
                object = String.valueOf(object);
                logger.warning(new StringBuilder(22 + String.valueOf(object).length()).append("Cannot read directory ").append((String)object).toString());
                return;
            }
            object = files;
            int n = files.length;
            for (int i = 0; i < n; ++i) {
                File f = object[i];
                String name = f.getName();
                if (f.isDirectory()) {
                    File deref = f.getCanonicalFile();
                    if (!currentPath.add(deref)) continue;
                    this.scanDirectory(deref, new StringBuilder(1 + String.valueOf(packagePrefix).length() + String.valueOf(name).length()).append(packagePrefix).append(name).append("/").toString(), currentPath, builder);
                    currentPath.remove(deref);
                    continue;
                }
                String string = String.valueOf(packagePrefix);
                String string2 = String.valueOf(name);
                String resourceName = string2.length() != 0 ? string.concat(string2) : new String(string);
                if (resourceName.equals("META-INF/MANIFEST.MF")) continue;
                builder.add((Object)ResourceInfo.of(f, resourceName, this.classloader));
            }
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object obj) {
            if (obj instanceof LocationInfo) {
                void var1_1;
                LocationInfo that = (LocationInfo)obj;
                return this.home.equals(that.home) && this.classloader.equals(var1_1.classloader);
            }
            return false;
        }

        public final int hashCode() {
            return this.home.hashCode();
        }

        public final String toString() {
            return this.home.toString();
        }
    }

    public static final class ClassInfo
    extends ResourceInfo {
        private final String className;

        /*
         * WARNING - void declaration
         */
        ClassInfo(File file, String resourceName, ClassLoader loader) {
            super((File)var1_1, resourceName, (ClassLoader)var3_3);
            void var2_2;
            void var3_3;
            void var1_1;
            this.className = ClassPath.getClassName((String)var2_2);
        }

        public final String getPackageName() {
            return Reflection.getPackageName(this.className);
        }

        /*
         * WARNING - void declaration
         */
        public final String getSimpleName() {
            void var1_3;
            int lastDollarSign = this.className.lastIndexOf(36);
            if (lastDollarSign != -1) {
                String innerClassName = this.className.substring(lastDollarSign + 1);
                return CharMatcher.inRange('0', '9').trimLeadingFrom(innerClassName);
            }
            String packageName = this.getPackageName();
            if (packageName.isEmpty()) {
                return this.className;
            }
            return this.className.substring(var1_3.length() + 1);
        }

        public final String getName() {
            return this.className;
        }

        public final boolean isTopLevel() {
            return this.className.indexOf(36) == -1;
        }

        /*
         * WARNING - void declaration
         */
        public final Class<?> load() {
            try {
                return this.loader.loadClass(this.className);
            }
            catch (ClassNotFoundException e) {
                void var1_1;
                throw new IllegalStateException((Throwable)var1_1);
            }
        }

        @Override
        public final String toString() {
            return this.className;
        }
    }

    public static class ResourceInfo {
        private final File file;
        private final String resourceName;
        final ClassLoader loader;

        /*
         * WARNING - void declaration
         */
        static ResourceInfo of(File file, String resourceName, ClassLoader loader) {
            void var2_2;
            void var1_1;
            File file2;
            if (resourceName.endsWith(ClassPath.CLASS_FILE_NAME_EXTENSION)) {
                return new ClassInfo(file, resourceName, loader);
            }
            return new ResourceInfo(file2, (String)var1_1, (ClassLoader)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        ResourceInfo(File file, String resourceName, ClassLoader loader) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.file = (File)Preconditions.checkNotNull(var1_1);
            this.resourceName = (String)Preconditions.checkNotNull(var2_2);
            this.loader = (ClassLoader)Preconditions.checkNotNull(var3_3);
        }

        /*
         * WARNING - void declaration
         */
        public final URL url() {
            void var1_1;
            URL url = this.loader.getResource(this.resourceName);
            if (url == null) {
                throw new NoSuchElementException(this.resourceName);
            }
            return var1_1;
        }

        public final ByteSource asByteSource() {
            return Resources.asByteSource(this.url());
        }

        /*
         * WARNING - void declaration
         */
        public final CharSource asCharSource(Charset charset) {
            void var1_1;
            return Resources.asCharSource(this.url(), (Charset)var1_1);
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        final File getFile() {
            return this.file;
        }

        public int hashCode() {
            return this.resourceName.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            if (obj instanceof ResourceInfo) {
                void var1_1;
                ResourceInfo that = (ResourceInfo)obj;
                return this.resourceName.equals(that.resourceName) && this.loader == var1_1.loader;
            }
            return false;
        }

        public String toString() {
            return this.resourceName;
        }
    }
}

