/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Longs;
import com.google.common.primitives.ParseRequest;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible
public final class UnsignedLongs {
    public static final long MAX_VALUE = -1L;

    private UnsignedLongs() {
    }

    private static long flip(long a) {
        return a ^ Long.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static int compare(long a, long b) {
        void var2_1;
        return Longs.compare(UnsignedLongs.flip(a), UnsignedLongs.flip((long)var2_1));
    }

    /*
     * WARNING - void declaration
     */
    public static long min(long ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        long min = UnsignedLongs.flip(array[0]);
        for (int i = 1; i < array.length; ++i) {
            long next = UnsignedLongs.flip(array[i]);
            if (next >= min) continue;
            min = next;
        }
        return UnsignedLongs.flip((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long max(long ... array) {
        void var1_1;
        Preconditions.checkArgument(array.length > 0);
        long max = UnsignedLongs.flip(array[0]);
        for (int i = 1; i < array.length; ++i) {
            long next = UnsignedLongs.flip(array[i]);
            if (next <= max) continue;
            max = next;
        }
        return UnsignedLongs.flip((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(String separator, long ... array) {
        void var2_2;
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(UnsignedLongs.toString(array[0]));
        for (int i = 1; i < array.length; ++i) {
            builder.append(separator).append(UnsignedLongs.toString(array[i]));
        }
        return var2_2.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static void sort(long[] array) {
        long[] lArray;
        Preconditions.checkNotNull(array);
        UnsignedLongs.sort(array, 0, lArray.length);
    }

    public static void sort(long[] array, int fromIndex, int toIndex) {
        int i;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        for (i = fromIndex; i < toIndex; ++i) {
            array[i] = UnsignedLongs.flip(array[i]);
        }
        Arrays.sort(array, fromIndex, toIndex);
        for (i = var1_1; i < toIndex; ++i) {
            array[i] = UnsignedLongs.flip(array[i]);
        }
    }

    public static void sortDescending(long[] array) {
        long[] lArray;
        Preconditions.checkNotNull(array);
        UnsignedLongs.sortDescending(array, 0, lArray.length);
    }

    /*
     * WARNING - void declaration
     */
    public static void sortDescending(long[] array, int fromIndex, int toIndex) {
        void var1_1;
        Preconditions.checkNotNull(array);
        Preconditions.checkPositionIndexes(fromIndex, toIndex, array.length);
        int i = fromIndex;
        while (i < toIndex) {
            int n = i++;
            array[n] = array[n] ^ Long.MAX_VALUE;
        }
        Arrays.sort(array, fromIndex, toIndex);
        i = var1_1;
        while (i < toIndex) {
            int n = i++;
            array[n] = array[n] ^ Long.MAX_VALUE;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static long divide(long dividend, long divisor) {
        void var2_1;
        long quotient;
        long l;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem = l - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(UnsignedLongs.compare(rem, (long)var2_1) >= 0 ? 1 : 0);
    }

    public static long remainder(long dividend, long divisor) {
        long l;
        long l2;
        long rem;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return dividend;
            }
            return dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        return rem - (UnsignedLongs.compare(rem = l2 - quotient * divisor, divisor) >= 0 ? l : 0L);
    }

    public static long parseUnsignedLong(String string) {
        return UnsignedLongs.parseUnsignedLong(string, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static long parseUnsignedLong(String string, int radix) {
        void var3_3;
        Preconditions.checkNotNull(string);
        if (string.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException(new StringBuilder(26).append("illegal radix: ").append(radix).toString());
        }
        int maxSafePos = ParseOverflowDetection.maxSafeDigits[radix] - 1;
        long value = 0L;
        for (int pos = 0; pos < string.length(); ++pos) {
            int digit = Character.digit(string.charAt(pos), radix);
            if (digit == -1) {
                throw new NumberFormatException(string);
            }
            if (pos > maxSafePos && ParseOverflowDetection.overflowInParse(value, digit, radix)) {
                String string2 = String.valueOf(string);
                throw new NumberFormatException(string2.length() != 0 ? "Too large for unsigned long: ".concat(string2) : new String("Too large for unsigned long: "));
            }
            value = value * (long)radix + (long)digit;
        }
        return (long)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static long decode(String stringValue) {
        ParseRequest request = ParseRequest.fromString(stringValue);
        try {
            return UnsignedLongs.parseUnsignedLong(request.rawValue, request.radix);
        }
        catch (NumberFormatException e) {
            NumberFormatException numberFormatException;
            void var1_2;
            String string = String.valueOf(stringValue);
            NumberFormatException decodeException = new NumberFormatException(string.length() != 0 ? "Error parsing value: ".concat(string) : new String("Error parsing value: "));
            decodeException.initCause((Throwable)var1_2);
            throw numberFormatException;
        }
    }

    public static String toString(long x) {
        return UnsignedLongs.toString(x, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(long x, int radix) {
        void var3_2;
        Preconditions.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        if (x == 0L) {
            return "0";
        }
        if (x > 0L) {
            return Long.toString(x, radix);
        }
        char[] buf = new char[64];
        int i = buf.length;
        int n = radix;
        if ((n & n - 1) == 0) {
            int shift = Integer.numberOfTrailingZeros(radix);
            int mask = radix - 1;
            do {
                buf[--i] = Character.forDigit((int)x & mask, radix);
            } while ((x >>>= shift) != 0L);
        } else {
            long quotient = (radix & 1) == 0 ? (x >>> 1) / (long)(radix >>> 1) : UnsignedLongs.divide(x, radix);
            long rem = x - quotient * (long)radix;
            --i;
            buf[63] = Character.forDigit((int)rem, radix);
            for (x = quotient; x > 0L; x /= (long)radix) {
                buf[--i] = Character.forDigit((int)(x % (long)radix), radix);
            }
        }
        return new String(buf, i, ((void)var3_2).length - i);
    }

    private static final class ParseOverflowDetection {
        static final long[] maxValueDivs = new long[37];
        static final int[] maxValueMods = new int[37];
        static final int[] maxSafeDigits = new int[37];

        private ParseOverflowDetection() {
        }

        /*
         * WARNING - void declaration
         */
        static boolean overflowInParse(long current, int digit, int radix) {
            if (current >= 0L) {
                void var3_2;
                void var2_1;
                long l;
                if (current < maxValueDivs[radix]) {
                    return false;
                }
                if (l > maxValueDivs[radix]) {
                    return true;
                }
                return var2_1 > maxValueMods[var3_2];
            }
            return true;
        }

        static {
            BigInteger overflow = new BigInteger("10000000000000000", 16);
            for (int i = 2; i <= 36; ++i) {
                ParseOverflowDetection.maxValueDivs[i] = UnsignedLongs.divide(-1L, i);
                ParseOverflowDetection.maxValueMods[i] = (int)UnsignedLongs.remainder(-1L, i);
                ParseOverflowDetection.maxSafeDigits[i] = overflow.toString(i).length() - 1;
            }
        }
    }

    static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        /*
         * WARNING - void declaration
         */
        @Override
        public final int compare(long[] left, long[] right) {
            void var2_2;
            void var1_1;
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                if (left[i] == right[i]) continue;
                return UnsignedLongs.compare(left[i], right[i]);
            }
            return ((void)var1_1).length - ((void)var2_2).length;
        }

        public final String toString() {
            return "UnsignedLongs.lexicographicalComparator()";
        }
    }
}

