/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.ElementTypesAreNonnullByDefault;
import com.google.common.primitives.Longs;
import com.google.common.primitives.UnsignedLongs;
import java.io.Serializable;
import java.math.BigInteger;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
public final class UnsignedLong
extends Number
implements Serializable,
Comparable<UnsignedLong> {
    private static final long UNSIGNED_MASK = Long.MAX_VALUE;
    public static final UnsignedLong ZERO = new UnsignedLong(0L);
    public static final UnsignedLong ONE = new UnsignedLong(1L);
    public static final UnsignedLong MAX_VALUE = new UnsignedLong(-1L);
    private final long value;

    /*
     * WARNING - void declaration
     */
    private UnsignedLong(long value) {
        void var1_1;
        this.value = var1_1;
    }

    public static UnsignedLong fromLongBits(long bits) {
        long l;
        return new UnsignedLong(l);
    }

    public static UnsignedLong valueOf(long value) {
        long l;
        Preconditions.checkArgument(value >= 0L, "value (%s) is outside the range for an unsigned long value", value);
        return UnsignedLong.fromLongBits(l);
    }

    public static UnsignedLong valueOf(BigInteger value) {
        BigInteger bigInteger;
        Preconditions.checkNotNull(value);
        Preconditions.checkArgument(value.signum() >= 0 && value.bitLength() <= 64, "value (%s) is outside the range for an unsigned long value", (Object)value);
        return UnsignedLong.fromLongBits(bigInteger.longValue());
    }

    public static UnsignedLong valueOf(String string) {
        return UnsignedLong.valueOf(string, 10);
    }

    /*
     * WARNING - void declaration
     */
    public static UnsignedLong valueOf(String string, int radix) {
        void var1_1;
        return UnsignedLong.fromLongBits(UnsignedLongs.parseUnsignedLong(string, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final UnsignedLong plus(UnsignedLong val) {
        void var1_1;
        return UnsignedLong.fromLongBits(this.value + ((UnsignedLong)Preconditions.checkNotNull(var1_1)).value);
    }

    /*
     * WARNING - void declaration
     */
    public final UnsignedLong minus(UnsignedLong val) {
        void var1_1;
        return UnsignedLong.fromLongBits(this.value - ((UnsignedLong)Preconditions.checkNotNull(var1_1)).value);
    }

    /*
     * WARNING - void declaration
     */
    public final UnsignedLong times(UnsignedLong val) {
        void var1_1;
        return UnsignedLong.fromLongBits(this.value * ((UnsignedLong)Preconditions.checkNotNull(var1_1)).value);
    }

    /*
     * WARNING - void declaration
     */
    public final UnsignedLong dividedBy(UnsignedLong val) {
        void var1_1;
        return UnsignedLong.fromLongBits(UnsignedLongs.divide(this.value, ((UnsignedLong)Preconditions.checkNotNull(var1_1)).value));
    }

    /*
     * WARNING - void declaration
     */
    public final UnsignedLong mod(UnsignedLong val) {
        void var1_1;
        return UnsignedLong.fromLongBits(UnsignedLongs.remainder(this.value, ((UnsignedLong)Preconditions.checkNotNull(var1_1)).value));
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        if (this.value >= 0L) {
            return this.value;
        }
        return (float)(this.value >>> 1 | this.value & 1L) * 2.0f;
    }

    @Override
    public final double doubleValue() {
        if (this.value >= 0L) {
            return this.value;
        }
        return (double)(this.value >>> 1 | this.value & 1L) * 2.0;
    }

    /*
     * WARNING - void declaration
     */
    public final BigInteger bigIntegerValue() {
        void var1_1;
        BigInteger bigInt = BigInteger.valueOf(this.value & Long.MAX_VALUE);
        if (this.value < 0L) {
            bigInt = bigInt.setBit(63);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(UnsignedLong o) {
        void var1_1;
        Preconditions.checkNotNull(o);
        return UnsignedLongs.compare(this.value, var1_1.value);
    }

    public final int hashCode() {
        return Longs.hashCode(this.value);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        if (obj instanceof UnsignedLong) {
            void var1_1;
            UnsignedLong other = (UnsignedLong)obj;
            return this.value == var1_1.value;
        }
        return false;
    }

    public final String toString() {
        return UnsignedLongs.toString(this.value);
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(int radix) {
        void var1_1;
        return UnsignedLongs.toString(this.value, (int)var1_1);
    }
}

